/*
 * Decompiled with CFR 0.152.
 */
package io.matthewnelson.kmp.tor.common.address;

import io.matthewnelson.component.parcelize.Parcelable;
import io.matthewnelson.kmp.tor.common.address.OnionAddress;
import io.matthewnelson.kmp.tor.common.address.OnionAddressV3;
import io.matthewnelson.kmp.tor.common.address.Port;
import io.matthewnelson.kmp.tor.common.address.Scheme;
import java.util.List;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Deprecated(message="\n        This class was initially offered as a convenience, but has many\n        issues related to parsing and building of URLs (which is beyond the\n        scope of kmp-tor). As it is not utilized by inheriting module APIs,\n        it was deemed unnecessary to maintain and should not be used.\n        \n        For more info, see: https://github.com/05nelsonm/kmp-tor/issues/232\n    ")
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0087\b\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\r\u001a\u0004\u0018\u00010\u0007H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\tH\u00c6\u0003J3\u0010\u000f\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\u0010\u001a\u00020\u00112\b\u0010\u0012\u001a\u0004\u0018\u00010\u0013H\u00d6\u0003J\t\u0010\u0014\u001a\u00020\u0015H\u00d6\u0001J\b\u0010\u0016\u001a\u00020\u0005H\u0016R\u0010\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0006\u001a\u0004\u0018\u00010\u00078\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u00020\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0018"}, d2={"Lio/matthewnelson/kmp/tor/common/address/OnionUrl;", "Lio/matthewnelson/component/parcelize/Parcelable;", "address", "Lio/matthewnelson/kmp/tor/common/address/OnionAddress;", "path", "", "port", "Lio/matthewnelson/kmp/tor/common/address/Port;", "scheme", "Lio/matthewnelson/kmp/tor/common/address/Scheme;", "(Lio/matthewnelson/kmp/tor/common/address/OnionAddress;Ljava/lang/String;Lio/matthewnelson/kmp/tor/common/address/Port;Lio/matthewnelson/kmp/tor/common/address/Scheme;)V", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "", "hashCode", "", "toString", "Companion", "kmp-tor-common"})
public final class OnionUrl
implements Parcelable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    public final OnionAddress address;
    @JvmField
    @NotNull
    public final String path;
    @JvmField
    @Nullable
    public final Port port;
    @JvmField
    @NotNull
    public final Scheme scheme;

    public OnionUrl(@NotNull OnionAddress address, @NotNull String path, @Nullable Port port, @NotNull Scheme scheme) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)((Object)scheme), (String)"scheme");
        this.address = address;
        this.path = path;
        this.port = port;
        this.scheme = scheme;
    }

    public /* synthetic */ OnionUrl(OnionAddress onionAddress, String string, Port port, Scheme scheme, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            string = "";
        }
        if ((n & 4) != 0) {
            port = null;
        }
        if ((n & 8) != 0) {
            scheme = Scheme.HTTP;
        }
        this(onionAddress, string, port, scheme);
    }

    @NotNull
    public String toString() {
        StringBuilder sb = new StringBuilder();
        boolean bl = false;
        sb.append((Object)this.scheme);
        sb.append(this.address.canonicalHostname());
        if (this.port != null) {
            sb.append(':').append(this.port.getValue());
        }
        if (((CharSequence)this.path).length() > 0 && StringsKt.first((CharSequence)this.path) != '/') {
            sb.append('/');
        }
        sb.append(this.path);
        String string = sb.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"StringBuilder().let { sb\u2026  sb.toString()\n        }");
        return string;
    }

    @NotNull
    public final OnionAddress component1() {
        return this.address;
    }

    @NotNull
    public final String component2() {
        return this.path;
    }

    @Nullable
    public final Port component3() {
        return this.port;
    }

    @NotNull
    public final Scheme component4() {
        return this.scheme;
    }

    @NotNull
    public final OnionUrl copy(@NotNull OnionAddress address, @NotNull String path, @Nullable Port port, @NotNull Scheme scheme) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)((Object)scheme), (String)"scheme");
        return new OnionUrl(address, path, port, scheme);
    }

    public static /* synthetic */ OnionUrl copy$default(OnionUrl onionUrl, OnionAddress onionAddress, String string, Port port, Scheme scheme, int n, Object object) {
        if ((n & 1) != 0) {
            onionAddress = onionUrl.address;
        }
        if ((n & 2) != 0) {
            string = onionUrl.path;
        }
        if ((n & 4) != 0) {
            port = onionUrl.port;
        }
        if ((n & 8) != 0) {
            scheme = onionUrl.scheme;
        }
        return onionUrl.copy(onionAddress, string, port, scheme);
    }

    public int hashCode() {
        int result = this.address.hashCode();
        result = result * 31 + this.path.hashCode();
        result = result * 31 + (this.port == null ? 0 : this.port.hashCode());
        result = result * 31 + this.scheme.hashCode();
        return result;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof OnionUrl)) {
            return false;
        }
        OnionUrl onionUrl = (OnionUrl)other;
        if (!Intrinsics.areEqual((Object)this.address, (Object)onionUrl.address)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.path, (Object)onionUrl.path)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.port, (Object)onionUrl.port)) {
            return false;
        }
        return this.scheme == onionUrl.scheme;
    }

    @JvmStatic
    @NotNull
    public static final OnionUrl fromString(@NotNull String url) throws IllegalArgumentException {
        return Companion.fromString(url);
    }

    @JvmStatic
    @Nullable
    public static final OnionUrl fromStringOrNull(@NotNull String url) {
        return Companion.fromStringOrNull(url);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007J\u001a\u0010\b\u001a\u0010\u0012\u0006\u0012\u0004\u0018\u00010\n\u0012\u0004\u0012\u00020\u00060\t*\u00020\u0006H\u0002\u00a8\u0006\u000b"}, d2={"Lio/matthewnelson/kmp/tor/common/address/OnionUrl$Companion;", "", "()V", "fromString", "Lio/matthewnelson/kmp/tor/common/address/OnionUrl;", "url", "", "fromStringOrNull", "separateSchemeFromAddress", "Lkotlin/Pair;", "Lio/matthewnelson/kmp/tor/common/address/Scheme;", "kmp-tor-common"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final OnionUrl fromString(@NotNull String url) throws IllegalArgumentException {
            String string;
            Port port;
            OnionAddressV3 oAddress;
            Scheme scheme;
            block15: {
                block14: {
                    String string2;
                    Port port2;
                    Intrinsics.checkNotNullParameter((Object)url, (String)"url");
                    Pair<Scheme, String> pair = this.separateSchemeFromAddress(url);
                    scheme = (Scheme)((Object)pair.component1());
                    String substring = (String)pair.component2();
                    String[] stringArray = new String[]{".onion"};
                    List splits = StringsKt.split$default((CharSequence)substring, (String[])stringArray, (boolean)false, (int)0, (int)6, null);
                    if (splits.isEmpty()) {
                        throw new IllegalArgumentException("Failed to parse url");
                    }
                    oAddress = OnionAddressV3.Companion.invoke((String)splits.get(0));
                    String string3 = (String)CollectionsKt.getOrNull((List)splits, (int)1);
                    if (string3 != null) {
                        String split = string3;
                        boolean bl = false;
                        if (StringsKt.startsWith$default((CharSequence)split, (char)':', (boolean)false, (int)2, null)) {
                            Port port3;
                            String portString = StringsKt.drop((String)StringsKt.substringBefore$default((String)split, (char)'/', null, (int)2, null), (int)1);
                            try {
                                port3 = Port.Companion.invoke(Integer.parseInt(portString));
                            }
                            catch (NumberFormatException e) {
                                throw new IllegalArgumentException("Port expressed in url (" + portString + ") malformed", e);
                            }
                            port2 = port3;
                        } else {
                            port2 = null;
                        }
                    } else {
                        port2 = port = null;
                    }
                    if ((string = (String)CollectionsKt.getOrNull((List)splits, (int)1)) == null) break block14;
                    String split = string;
                    boolean bl = false;
                    if (StringsKt.contains$default((CharSequence)split, (char)'/', (boolean)false, (int)2, null)) {
                        char c = '/';
                        String string4 = StringsKt.substringAfter$default((String)split, (char)'/', null, (int)2, null);
                        string2 = c + string4;
                    } else {
                        string2 = "";
                    }
                    string = string2;
                    if (string2 != null) break block15;
                }
                string = "";
            }
            String path = string;
            OnionAddress onionAddress = oAddress;
            Scheme scheme2 = scheme;
            if (scheme2 == null) {
                scheme2 = Scheme.HTTP;
            }
            return new OnionUrl(onionAddress, path, port, scheme2);
        }

        private final Pair<Scheme, String> separateSchemeFromAddress(String $this$separateSchemeFromAddress) {
            String string;
            String trimmed = ((Object)StringsKt.trim((CharSequence)$this$separateSchemeFromAddress)).toString();
            Scheme scheme = Scheme.Companion.fromString(trimmed, false);
            if (scheme != null) {
                String string2 = trimmed.substring(scheme.toString().length());
                string = string2;
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"this as java.lang.String).substring(startIndex)");
            } else {
                string = trimmed;
            }
            return new Pair((Object)scheme, (Object)string);
        }

        @JvmStatic
        @Nullable
        public final OnionUrl fromStringOrNull(@NotNull String url) {
            OnionUrl onionUrl;
            Intrinsics.checkNotNullParameter((Object)url, (String)"url");
            try {
                onionUrl = this.fromString(url);
            }
            catch (IllegalArgumentException _) {
                onionUrl = null;
            }
            return onionUrl;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

