/*
 * Decompiled with CFR 0.152.
 */
package io.matthewnelson.kmp.tor.common.address;

import io.matthewnelson.component.parcelize.Parcelable;
import io.matthewnelson.kmp.tor.common.address.IPAddress;
import io.matthewnelson.kmp.tor.common.address.Port;
import kotlin.Deprecated;
import kotlin.DeprecationLevel;
import kotlin.Metadata;
import kotlin.ReplaceWith;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0017\b\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u0015\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\tJ\b\u0010\f\u001a\u00020\u0003H\u0007J\b\u0010\r\u001a\u00020\u0005H\u0007J\u0006\u0010\u000e\u001a\u00020\u0000J\u000e\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u0007\u001a\u00020\bJ\u000e\u0010\u000e\u001a\u00020\u00002\u0006\u0010\u0004\u001a\u00020\u0005J\u001c\u0010\u000e\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u0007J\u0013\u0010\u000f\u001a\u00020\u00102\b\u0010\u0011\u001a\u0004\u0018\u00010\u0012H\u0096\u0002J\b\u0010\u0013\u001a\u00020\u0014H\u0016J\b\u0010\u0015\u001a\u00020\u0003H\u0016R\u0010\u0010\u0007\u001a\u00020\b8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0002\u001a\u00020\u00038\u0006X\u0087\u0004\u00a2\u0006\b\n\u0000\u0012\u0004\b\n\u0010\u000bR\u0010\u0010\u0004\u001a\u00020\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lio/matthewnelson/kmp/tor/common/address/ProxyAddress;", "Lio/matthewnelson/component/parcelize/Parcelable;", "ipAddress", "", "port", "Lio/matthewnelson/kmp/tor/common/address/Port;", "(Ljava/lang/String;Lio/matthewnelson/kmp/tor/common/address/Port;)V", "address", "Lio/matthewnelson/kmp/tor/common/address/IPAddress;", "(Lio/matthewnelson/kmp/tor/common/address/IPAddress;Lio/matthewnelson/kmp/tor/common/address/Port;)V", "getIpAddress$annotations", "()V", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "", "toString", "Companion", "kmp-tor-common"})
public final class ProxyAddress
implements Parcelable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    public final IPAddress address;
    @JvmField
    @NotNull
    public final Port port;
    @JvmField
    @NotNull
    public final String ipAddress;

    public ProxyAddress(@NotNull IPAddress address, @NotNull Port port) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        Intrinsics.checkNotNullParameter((Object)port, (String)"port");
        this.address = address;
        this.port = port;
        this.ipAddress = this.address.getValue();
    }

    @NotNull
    public final ProxyAddress copy() {
        return new ProxyAddress(this.address, this.port);
    }

    @NotNull
    public final ProxyAddress copy(@NotNull IPAddress address) {
        Intrinsics.checkNotNullParameter((Object)address, (String)"address");
        return new ProxyAddress(address, this.port);
    }

    @NotNull
    public final ProxyAddress copy(@NotNull Port port) {
        Intrinsics.checkNotNullParameter((Object)port, (String)"port");
        return new ProxyAddress(this.address, port);
    }

    public boolean equals(@Nullable Object other) {
        return other instanceof ProxyAddress && Intrinsics.areEqual((Object)((ProxyAddress)other).address, (Object)this.address) && Intrinsics.areEqual((Object)((ProxyAddress)other).port, (Object)this.port);
    }

    public int hashCode() {
        int result = 17;
        result = result * 31 + this.address.hashCode();
        result = result * 31 + this.port.hashCode();
        return result;
    }

    @NotNull
    public String toString() {
        return this.address.canonicalHostname() + ':' + this.port.getValue();
    }

    @Deprecated(message="Use ProxyAddress(IPAddress.fromString(...), Port(...))")
    public ProxyAddress(@NotNull String ipAddress, @NotNull Port port) throws IllegalArgumentException {
        Intrinsics.checkNotNullParameter((Object)ipAddress, (String)"ipAddress");
        Intrinsics.checkNotNullParameter((Object)port, (String)"port");
        this(IPAddress.Companion.fromString(ipAddress), port);
    }

    @Deprecated(message="Use address.value", replaceWith=@ReplaceWith(expression="address.value", imports={}), level=DeprecationLevel.WARNING)
    @NotNull
    public final String component1() {
        return this.address.getValue();
    }

    @Deprecated(message="Use port", replaceWith=@ReplaceWith(expression="port", imports={}), level=DeprecationLevel.WARNING)
    @NotNull
    public final Port component2() {
        return this.port;
    }

    @Deprecated(message="Use copy(address = IPAddress.fromString(...), port = Port(...))")
    @NotNull
    public final ProxyAddress copy(@NotNull String ipAddress, @NotNull Port port) throws IllegalArgumentException {
        Intrinsics.checkNotNullParameter((Object)ipAddress, (String)"ipAddress");
        Intrinsics.checkNotNullParameter((Object)port, (String)"port");
        return new ProxyAddress(IPAddress.Companion.fromString(ipAddress), port);
    }

    public static /* synthetic */ ProxyAddress copy$default(ProxyAddress proxyAddress, String string, Port port, int n, Object object) throws IllegalArgumentException {
        if ((n & 1) != 0) {
            string = proxyAddress.address.getValue();
        }
        if ((n & 2) != 0) {
            port = proxyAddress.port;
        }
        return proxyAddress.copy(string, port);
    }

    @Deprecated(message="Use address.value", replaceWith=@ReplaceWith(expression="address.value", imports={}), level=DeprecationLevel.WARNING)
    public static /* synthetic */ void getIpAddress$annotations() {
    }

    @JvmStatic
    @NotNull
    public static final ProxyAddress fromString(@NotNull String address) throws IllegalArgumentException {
        return Companion.fromString(address);
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0010\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006H\u0007\u00a8\u0006\u0007"}, d2={"Lio/matthewnelson/kmp/tor/common/address/ProxyAddress$Companion;", "", "()V", "fromString", "Lio/matthewnelson/kmp/tor/common/address/ProxyAddress;", "address", "", "kmp-tor-common"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final ProxyAddress fromString(@NotNull String address) throws IllegalArgumentException {
            Intrinsics.checkNotNullParameter((Object)address, (String)"address");
            try {
                String portString = StringsKt.substringAfterLast$default((String)address, (char)':', null, (int)2, null);
                Port port = Port.Companion.invoke(Integer.parseInt(portString));
                String ipAddress = StringsKt.substringBeforeLast$default((String)address, (String)(':' + portString), null, (int)2, null);
                return new ProxyAddress(IPAddress.Companion.fromString(ipAddress), port);
            }
            catch (IllegalArgumentException e) {
                throw e;
            }
            catch (Exception e) {
                throw new IllegalArgumentException("Failed to parse " + address + " for an ipAddress and port");
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

