/*
 * Decompiled with CFR 0.152.
 */
package io.mcarle.strix;

import javax.persistence.EntityManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class PersistenceManager {
    private static final Logger LOG = LoggerFactory.getLogger(PersistenceManager.class);
    private static final ThreadLocal<String> ENTITY_MANAGER_PERSISTENCE_UNIT_STORE = new ThreadLocal();
    private static final ThreadLocal<EntityManager> ENTITY_MANAGER_STORE = new ThreadLocal();

    PersistenceManager() {
    }

    static void setEntityManager(String persistenceUnit, EntityManager entityManager) {
        LOG.trace("Bind entity manager and persistence unit ({}) to current thread", (Object)persistenceUnit);
        ENTITY_MANAGER_PERSISTENCE_UNIT_STORE.set(persistenceUnit);
        ENTITY_MANAGER_STORE.set(entityManager);
    }

    static void clearEntityManager() {
        LOG.trace("Unbind entity manager and persistence unit from current thread");
        ENTITY_MANAGER_PERSISTENCE_UNIT_STORE.remove();
        ENTITY_MANAGER_STORE.remove();
    }

    static boolean isEntityManagerPresent() {
        return ENTITY_MANAGER_STORE.get() != null;
    }

    static boolean isEntityManagerFromPU(String persistenceUnit) {
        return persistenceUnit.equals(ENTITY_MANAGER_PERSISTENCE_UNIT_STORE.get());
    }

    static EntityManager getEntityManager() {
        return ENTITY_MANAGER_STORE.get();
    }
}

