/*
 * Decompiled with CFR 0.152.
 */
package io.mcarle.strix;

import io.mcarle.strix.PersistenceManager;
import io.mcarle.strix.TransactionalAspect;
import io.mcarle.strix.annotation.Transactional;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.EntityTransaction;
import javax.persistence.Persistence;
import org.aspectj.lang.ProceedingJoinPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import pl.touk.throwing.ThrowingFunction;

final class StrixManager {
    private static final Logger LOG = LoggerFactory.getLogger(TransactionalAspect.class);
    private static final Map<String, EntityManagerFactory> SESSION_FACTORY_STORE = new ConcurrentHashMap<String, EntityManagerFactory>();
    private static final Map<String, Map<String, String>> PERSISTENCE_PROPERTIES = new ConcurrentHashMap<String, Map<String, String>>();
    private static final String STRIX_DEFAULT_PERSISTENCE_UNIT = "DUMMY_VALUE";
    static boolean STARTED = false;
    private static String DEFAULT_PERSISTENCE_UNIT = "DUMMY_VALUE";

    StrixManager() {
    }

    static void startup(Map<String, Map<String, String>> persistenceProperties, String defaultPersistenceUnit) {
        LOG.trace("Startup strix");
        if (STARTED) {
            LOG.trace("Strix already running, shutdown");
            StrixManager.shutdown();
        }
        LOG.trace("Set default persistence unit to '{}'", (Object)defaultPersistenceUnit);
        DEFAULT_PERSISTENCE_UNIT = defaultPersistenceUnit;
        if (persistenceProperties != null) {
            LOG.trace("Save persistence properties");
            persistenceProperties.keySet().forEach(key -> {
                Map map2 = PERSISTENCE_PROPERTIES.put((String)key, Collections.unmodifiableMap((Map)persistenceProperties.get(key)));
            });
        }
        STARTED = true;
        LOG.info("Strix started");
    }

    static void shutdown() {
        LOG.trace("Shutdown strix");
        STARTED = false;
        LOG.info("Close all open EntityManagerFactories.");
        SESSION_FACTORY_STORE.values().forEach(EntityManagerFactory::close);
        SESSION_FACTORY_STORE.clear();
        LOG.debug("Restore initial default values");
        DEFAULT_PERSISTENCE_UNIT = STRIX_DEFAULT_PERSISTENCE_UNIT;
        PERSISTENCE_PROPERTIES.clear();
    }

    static Object handleTransactionalMethodExecution(ProceedingJoinPoint joinPoint, Transactional transactional) throws Throwable {
        LOG.trace("Handle @Transactional method execution");
        String persistenceUnit = transactional.persistenceUnit();
        if (!PersistenceManager.isEntityManagerPresent()) {
            LOG.debug("No transaction active in current thread");
            Class<? extends Throwable>[] noRollbackFor = transactional.noRollbackFor();
            boolean readOnly = transactional.readOnly();
            int timeoutTime = transactional.timeout();
            return StrixManager.executeWithTransaction((ThrowingFunction<EntityManager, Object, Throwable>)((ThrowingFunction)em -> joinPoint.proceed()), persistenceUnit, timeoutTime, noRollbackFor, readOnly);
        }
        if (!PersistenceManager.isEntityManagerFromPU(persistenceUnit) || transactional.requiresNew()) {
            LOG.debug("New EntityManager needed, as requiresNew ({}) or different peristence unit ({}) defined.", (Object)transactional.requiresNew(), (Object)persistenceUnit);
            FutureTask<Object> future = new FutureTask<Object>(() -> {
                try {
                    return StrixManager.handleTransactionalMethodExecution(joinPoint, transactional);
                }
                catch (Exception ex) {
                    throw ex;
                }
                catch (Throwable ex) {
                    throw new TransactionalExecutionException(ex);
                }
            });
            try {
                LOG.trace("Start execution in own thread");
                Thread thread = new Thread(future);
                thread.start();
                return future.get();
            }
            catch (ExecutionException ee) {
                if (ee.getCause() instanceof TransactionalExecutionException) {
                    throw ee.getCause().getCause();
                }
                throw ee.getCause();
            }
        }
        LOG.trace("Already inside a transactional context, proceed method execution");
        return joinPoint.proceed();
    }

    static Thread startTimeoutChecker(int timeoutTime, EntityManager em, EntityTransaction transaction) {
        LOG.trace("Starts the timeout thread with {}ms", (Object)timeoutTime);
        Thread thread = new Thread(() -> {
            try {
                Thread.currentThread().setName("STRIX-TT");
                Thread.sleep(timeoutTime);
                LOG.trace("Timeout thread reached timeout time ({}ms)", (Object)timeoutTime);
                if (em.isOpen()) {
                    if (transaction.isActive()) {
                        LOG.trace("Mark the transaction to rollbackOnly");
                        transaction.setRollbackOnly();
                    }
                    LOG.trace("Close EntityManager");
                    em.close();
                }
            }
            catch (InterruptedException interruptedException) {}
        });
        thread.start();
        return thread;
    }

    private static boolean checkNeedForRollback(Class<? extends Throwable>[] noRollbackFor, Throwable t) {
        Class<? extends Throwable>[] classArray = noRollbackFor;
        int n = noRollbackFor.length;
        int n2 = 0;
        while (n2 < n) {
            Class<? extends Throwable> exceptionClass = classArray[n2];
            if (exceptionClass.isAssignableFrom(t.getClass())) {
                LOG.trace("Exception {} is expected, i.e. no rollback is needed", t.getClass());
                return false;
            }
            ++n2;
        }
        return true;
    }

    private static Object executeWithSession(ThrowingFunction<EntityManager, Object, Throwable> function, String persistenceUnit) throws Throwable {
        LOG.trace("Create new EntityManager from persistence unit {}", (Object)persistenceUnit);
        EntityManager em = StrixManager.getEntityManagerFactory(persistenceUnit).createEntityManager();
        try {
            PersistenceManager.setEntityManager(persistenceUnit, em);
            Object object = function.apply((Object)em);
            return object;
        }
        finally {
            PersistenceManager.clearEntityManager();
            if (em.isOpen()) {
                LOG.trace("Close EntityManager");
                em.close();
            }
        }
    }

    private static Object executeWithTransaction(ThrowingFunction<EntityManager, Object, Throwable> function, String persistenceUnit, int timeoutTime, Class<? extends Throwable>[] noRollbackFor, boolean readOnly) throws Throwable {
        return StrixManager.executeWithSession((ThrowingFunction<EntityManager, Object, Throwable>)((ThrowingFunction)em -> {
            EntityTransaction transaction = em.getTransaction();
            boolean rollback = false;
            Thread timeoutThread = null;
            try {
                LOG.trace("Start a new transaction");
                transaction.begin();
                if (readOnly) {
                    LOG.trace("Set transaction to be read-only");
                    transaction.setRollbackOnly();
                }
                if (timeoutTime > 0) {
                    timeoutThread = StrixManager.startTimeoutChecker(timeoutTime, em, transaction);
                }
                Object object = function.apply(em);
                return object;
            }
            catch (Throwable t) {
                rollback = StrixManager.checkNeedForRollback(noRollbackFor, t);
                throw t;
            }
            finally {
                if (timeoutThread != null && timeoutThread.isAlive()) {
                    LOG.trace("Interrupt timeout thread");
                    timeoutThread.interrupt();
                }
                if (em.isOpen() && transaction.isActive()) {
                    if (rollback || transaction.getRollbackOnly()) {
                        LOG.trace("Rollback transaction because of unexpected exception ({}) or marked as read-only ({})", (Object)rollback, (Object)transaction.getRollbackOnly());
                        transaction.rollback();
                    } else {
                        LOG.trace("Commit transaction");
                        transaction.commit();
                    }
                }
            }
        }), persistenceUnit);
    }

    private static synchronized EntityManagerFactory getEntityManagerFactory(String persistenceUnit) {
        if (persistenceUnit.isEmpty() && DEFAULT_PERSISTENCE_UNIT != null) {
            persistenceUnit = DEFAULT_PERSISTENCE_UNIT;
        }
        if (!SESSION_FACTORY_STORE.containsKey(persistenceUnit)) {
            LOG.debug("Create new EntityManagerFactory for persistence unit {}", (Object)persistenceUnit);
            SESSION_FACTORY_STORE.put(persistenceUnit, Persistence.createEntityManagerFactory((String)(persistenceUnit.isEmpty() ? null : persistenceUnit), PERSISTENCE_PROPERTIES.get(persistenceUnit)));
        }
        return SESSION_FACTORY_STORE.get(persistenceUnit);
    }

    private static class TransactionalExecutionException
    extends RuntimeException {
        private TransactionalExecutionException(Throwable cause) {
            super(cause);
        }
    }
}

