/*
 * Decompiled with CFR 0.152.
 */
package io.mdsl.apiDescription;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum ChannelType implements Enumerator
{
    POINT_TO_POINT(0, "POINT_TO_POINT", "POINT_TO_POINT"),
    PUBLISH_SUBSCRIBE(1, "PUBLISH_SUBSCRIBE", "PUBLISH_SUBSCRIBE"),
    DATA_TYPE(2, "DATA_TYPE", "DATA_TYPE"),
    INVALID_MESSAGE(3, "INVALID_MESSAGE", "INVALID_MESSAGE"),
    DEAD_LETTER(4, "DEAD_LETTER", "DEAD_LETTER"),
    GUARANTEED_DELIVERY(5, "GUARANTEED_DELIVERY", "GUARANTEED_DELIVERY");

    public static final int POINT_TO_POINT_VALUE = 0;
    public static final int PUBLISH_SUBSCRIBE_VALUE = 1;
    public static final int DATA_TYPE_VALUE = 2;
    public static final int INVALID_MESSAGE_VALUE = 3;
    public static final int DEAD_LETTER_VALUE = 4;
    public static final int GUARANTEED_DELIVERY_VALUE = 5;
    private static final ChannelType[] VALUES_ARRAY;
    public static final List<ChannelType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    public static ChannelType get(String literal) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            ChannelType result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static ChannelType getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            ChannelType result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static ChannelType get(int value) {
        switch (value) {
            case 0: {
                return POINT_TO_POINT;
            }
            case 1: {
                return PUBLISH_SUBSCRIBE;
            }
            case 2: {
                return DATA_TYPE;
            }
            case 3: {
                return INVALID_MESSAGE;
            }
            case 4: {
                return DEAD_LETTER;
            }
            case 5: {
                return GUARANTEED_DELIVERY;
            }
        }
        return null;
    }

    private ChannelType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    static {
        VALUES_ARRAY = new ChannelType[]{POINT_TO_POINT, PUBLISH_SUBSCRIBE, DATA_TYPE, INVALID_MESSAGE, DEAD_LETTER, GUARANTEED_DELIVERY};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }
}

