/*
 * Decompiled with CFR 0.152.
 */
package io.mdsl.apiDescription;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum EvolutionStrategy implements Enumerator
{
    ETERNAL_LIFETIME(0, "ETERNAL_LIFETIME", "ETERNAL_LIFETIME"),
    LIMITED_GUARANTEED_LIFETIME(1, "LIMITED_GUARANTEED_LIFETIME", "LIMITED_GUARANTEED_LIFETIME"),
    TWO_IN_PRODUCTION(2, "TWO_IN_PRODUCTION", "TWO_IN_PRODUCTION"),
    AGGRESSIVE_OBSOLESCENCE(3, "AGGRESSIVE_OBSOLESCENCE", "AGGRESSIVE_OBSOLESCENCE"),
    EXPERIMENTAL_PREVIEW(4, "EXPERIMENTAL_PREVIEW", "EXPERIMENTAL_PREVIEW"),
    OTHER_STRATEGY(5, "OTHER_STRATEGY", "OTHER_STRATEGY"),
    UNDISCLOSED(6, "UNDISCLOSED", "UNDISCLOSED");

    public static final int ETERNAL_LIFETIME_VALUE = 0;
    public static final int LIMITED_GUARANTEED_LIFETIME_VALUE = 1;
    public static final int TWO_IN_PRODUCTION_VALUE = 2;
    public static final int AGGRESSIVE_OBSOLESCENCE_VALUE = 3;
    public static final int EXPERIMENTAL_PREVIEW_VALUE = 4;
    public static final int OTHER_STRATEGY_VALUE = 5;
    public static final int UNDISCLOSED_VALUE = 6;
    private static final EvolutionStrategy[] VALUES_ARRAY;
    public static final List<EvolutionStrategy> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    public static EvolutionStrategy get(String literal) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            EvolutionStrategy result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static EvolutionStrategy getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            EvolutionStrategy result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static EvolutionStrategy get(int value) {
        switch (value) {
            case 0: {
                return ETERNAL_LIFETIME;
            }
            case 1: {
                return LIMITED_GUARANTEED_LIFETIME;
            }
            case 2: {
                return TWO_IN_PRODUCTION;
            }
            case 3: {
                return AGGRESSIVE_OBSOLESCENCE;
            }
            case 4: {
                return EXPERIMENTAL_PREVIEW;
            }
            case 5: {
                return OTHER_STRATEGY;
            }
            case 6: {
                return UNDISCLOSED;
            }
        }
        return null;
    }

    private EvolutionStrategy(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    static {
        VALUES_ARRAY = new EvolutionStrategy[]{ETERNAL_LIFETIME, LIMITED_GUARANTEED_LIFETIME, TWO_IN_PRODUCTION, AGGRESSIVE_OBSOLESCENCE, EXPERIMENTAL_PREVIEW, OTHER_STRATEGY, UNDISCLOSED};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }
}

