/*
 * Decompiled with CFR 0.152.
 */
package io.mdsl.apiDescription;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum JavaParameter implements Enumerator
{
    BYTE(0, "byte", "byte"),
    SHORT(1, "short", "short"),
    INT(2, "int", "int"),
    LONG(3, "long", "long"),
    FLOAT(4, "float", "float"),
    DOUBLE(5, "double", "double"),
    BOOLEAN(6, "boolean", "boolean"),
    CHAR(7, "char", "char"),
    STRING(8, "String", "String");

    public static final int BYTE_VALUE = 0;
    public static final int SHORT_VALUE = 1;
    public static final int INT_VALUE = 2;
    public static final int LONG_VALUE = 3;
    public static final int FLOAT_VALUE = 4;
    public static final int DOUBLE_VALUE = 5;
    public static final int BOOLEAN_VALUE = 6;
    public static final int CHAR_VALUE = 7;
    public static final int STRING_VALUE = 8;
    private static final JavaParameter[] VALUES_ARRAY;
    public static final List<JavaParameter> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    public static JavaParameter get(String literal) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            JavaParameter result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static JavaParameter getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            JavaParameter result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static JavaParameter get(int value) {
        switch (value) {
            case 0: {
                return BYTE;
            }
            case 1: {
                return SHORT;
            }
            case 2: {
                return INT;
            }
            case 3: {
                return LONG;
            }
            case 4: {
                return FLOAT;
            }
            case 5: {
                return DOUBLE;
            }
            case 6: {
                return BOOLEAN;
            }
            case 7: {
                return CHAR;
            }
            case 8: {
                return STRING;
            }
        }
        return null;
    }

    private JavaParameter(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    static {
        VALUES_ARRAY = new JavaParameter[]{BYTE, SHORT, INT, LONG, FLOAT, DOUBLE, BOOLEAN, CHAR, STRING};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }
}

