/*
 * Decompiled with CFR 0.152.
 */
package io.mdsl.apiDescription;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.Enumerator;

public enum StoryType implements Enumerator
{
    USER_STORY(0, "USER_STORY", "USER_STORY"),
    JOB_STORY(1, "JOB_STORY", "JOB_STORY"),
    TEST_CASE(2, "TEST_CASE", "TEST_CASE"),
    API_MOCK(3, "API_MOCK", "API_MOCK");

    public static final int USER_STORY_VALUE = 0;
    public static final int JOB_STORY_VALUE = 1;
    public static final int TEST_CASE_VALUE = 2;
    public static final int API_MOCK_VALUE = 3;
    private static final StoryType[] VALUES_ARRAY;
    public static final List<StoryType> VALUES;
    private final int value;
    private final String name;
    private final String literal;

    public static StoryType get(String literal) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            StoryType result = VALUES_ARRAY[i];
            if (!result.toString().equals(literal)) continue;
            return result;
        }
        return null;
    }

    public static StoryType getByName(String name) {
        for (int i = 0; i < VALUES_ARRAY.length; ++i) {
            StoryType result = VALUES_ARRAY[i];
            if (!result.getName().equals(name)) continue;
            return result;
        }
        return null;
    }

    public static StoryType get(int value) {
        switch (value) {
            case 0: {
                return USER_STORY;
            }
            case 1: {
                return JOB_STORY;
            }
            case 2: {
                return TEST_CASE;
            }
            case 3: {
                return API_MOCK;
            }
        }
        return null;
    }

    private StoryType(int value, String name, String literal) {
        this.value = value;
        this.name = name;
        this.literal = literal;
    }

    public int getValue() {
        return this.value;
    }

    public String getName() {
        return this.name;
    }

    public String getLiteral() {
        return this.literal;
    }

    public String toString() {
        return this.literal;
    }

    static {
        VALUES_ARRAY = new StoryType[]{USER_STORY, JOB_STORY, TEST_CASE, API_MOCK};
        VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));
    }
}

