/*
 * Decompiled with CFR 0.152.
 */
package io.mdsl.formatting2;

import io.mdsl.apiDescription.AtomicParameter;
import io.mdsl.apiDescription.AtomicParameterList;
import io.mdsl.apiDescription.Cardinality;
import io.mdsl.apiDescription.ChannelContract;
import io.mdsl.apiDescription.Client;
import io.mdsl.apiDescription.CommandInvokationStep;
import io.mdsl.apiDescription.CommandType;
import io.mdsl.apiDescription.CommandTypes;
import io.mdsl.apiDescription.DataContract;
import io.mdsl.apiDescription.DataTransferRepresentation;
import io.mdsl.apiDescription.ElementStructure;
import io.mdsl.apiDescription.EndpointContract;
import io.mdsl.apiDescription.EndpointInstance;
import io.mdsl.apiDescription.EndpointList;
import io.mdsl.apiDescription.EventType;
import io.mdsl.apiDescription.EventTypes;
import io.mdsl.apiDescription.FlowStep;
import io.mdsl.apiDescription.Gateway;
import io.mdsl.apiDescription.GenericParameter;
import io.mdsl.apiDescription.HTTPBinding;
import io.mdsl.apiDescription.HTTPOperationBinding;
import io.mdsl.apiDescription.HTTPResourceBinding;
import io.mdsl.apiDescription.IntegrationScenario;
import io.mdsl.apiDescription.IntegrationStory;
import io.mdsl.apiDescription.Operation;
import io.mdsl.apiDescription.Orchestration;
import io.mdsl.apiDescription.ParameterTree;
import io.mdsl.apiDescription.PatternStereotype;
import io.mdsl.apiDescription.Payload;
import io.mdsl.apiDescription.ProtocolBinding;
import io.mdsl.apiDescription.Provider;
import io.mdsl.apiDescription.ReplyChannel;
import io.mdsl.apiDescription.RequestChannel;
import io.mdsl.apiDescription.RequestReplyChannel;
import io.mdsl.apiDescription.RoleAndType;
import io.mdsl.apiDescription.SecurityPolicies;
import io.mdsl.apiDescription.SecurityPolicy;
import io.mdsl.apiDescription.ServiceSpecification;
import io.mdsl.apiDescription.SingleParameterNode;
import io.mdsl.apiDescription.StatusReport;
import io.mdsl.apiDescription.StatusReports;
import io.mdsl.apiDescription.TechnologyBinding;
import io.mdsl.apiDescription.TreeNode;
import io.mdsl.apiDescription.TypeReference;
import java.util.Arrays;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.formatting2.AbstractFormatter2;
import org.eclipse.xtext.formatting2.IFormattableDocument;
import org.eclipse.xtext.resource.XtextResource;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Procedures;

public class APIDescriptionFormatter
extends AbstractFormatter2 {
    protected void _format(ServiceSpecification serviceSpecification, @Extension IFormattableDocument document) {
        EList<DataContract> _types = serviceSpecification.getTypes();
        for (Object dataContract : _types) {
            document.format(dataContract);
            Procedures.Procedure1 _function = it -> it.newLine();
            document.prepend((EObject)dataContract, _function);
        }
        EList<EventTypes> _events = serviceSpecification.getEvents();
        for (Object events : _events) {
            document.format(events);
            Procedures.Procedure1 _function = it -> it.newLine();
            document.prepend((EObject)events, _function);
        }
        EList<CommandTypes> _commands = serviceSpecification.getCommands();
        for (Object commands : _commands) {
            document.format(commands);
            Procedures.Procedure1 _function = it -> it.newLine();
            document.prepend((EObject)commands, _function);
        }
        EList<EObject> _contracts = serviceSpecification.getContracts();
        for (Object eObject : _contracts) {
            document.format(eObject);
        }
        EList<EObject> _providers = serviceSpecification.getProviders();
        for (Object eObject_1 : _providers) {
            document.format(eObject_1);
        }
        EList<EObject> _clients = serviceSpecification.getClients();
        for (Object eObject_2 : _clients) {
            document.format(eObject_2);
        }
        EList<Gateway> _gateways = serviceSpecification.getGateways();
        for (Object gateway : _gateways) {
            document.format(gateway);
        }
        EList<Orchestration> _orchestrations = serviceSpecification.getOrchestrations();
        for (Orchestration flows : _orchestrations) {
            document.format((Object)flows);
        }
        EList<IntegrationScenario> _scenarios = serviceSpecification.getScenarios();
        for (IntegrationScenario scenario : _scenarios) {
            document.format((Object)scenario);
        }
    }

    protected void _format(DataContract dc, @Extension IFormattableDocument document) {
        Procedures.Procedure1 _function = it -> it.newLine();
        document.prepend((EObject)dc, _function);
        document.format((Object)dc.getStructure());
    }

    protected void _format(EventTypes events, @Extension IFormattableDocument document) {
        Procedures.Procedure1 _function = it -> it.newLine();
        document.prepend((EObject)events, _function);
        EList<EventType> _events = events.getEvents();
        for (EventType event : _events) {
            document.format((Object)event);
        }
    }

    protected void _format(EventType event, @Extension IFormattableDocument document) {
        document.format((Object)event.getContent());
    }

    protected void _format(CommandTypes commands, @Extension IFormattableDocument document) {
        Procedures.Procedure1 _function = it -> it.newLine();
        document.prepend((EObject)commands, _function);
        EList<CommandType> _commands = commands.getCommands();
        for (CommandType command : _commands) {
            document.format((Object)command);
        }
    }

    protected void _format(CommandType command, @Extension IFormattableDocument document) {
        document.format((Object)command.getSubject());
    }

    protected void _format(DataTransferRepresentation dtr, @Extension IFormattableDocument document) {
        Procedures.Procedure1 _function = it -> it.indent();
        document.prepend((EObject)dtr, _function);
        document.format((Object)dtr.getPayload());
    }

    protected void _format(ElementStructure dStruct, @Extension IFormattableDocument document) {
        document.format((Object)dStruct.getPf());
        document.format((Object)dStruct.getPt());
        document.format((Object)dStruct.getApl());
        document.format((Object)dStruct.getNp());
    }

    protected void _format(ParameterTree pt, @Extension IFormattableDocument document) {
        document.format((Object)pt.getClassifier());
        Procedures.Procedure1 _function = it -> it.noSpace();
        document.surround(this.textRegionExtensions.regionFor((EObject)pt).keyword(":"), _function);
        Procedures.Procedure1 _function_1 = it -> it.noSpace();
        document.append(this.textRegionExtensions.regionFor((EObject)pt).keyword("{"), _function_1);
        document.format((Object)pt.getFirst());
        EList<TreeNode> _nexttn = pt.getNexttn();
        for (TreeNode tn : _nexttn) {
            document.format((Object)tn);
        }
        document.format((Object)pt.getCard());
        Procedures.Procedure1 _function_2 = it -> it.noSpace();
        document.prepend(this.textRegionExtensions.regionFor((EObject)pt).keyword("}"), _function_2);
    }

    protected void _format(TreeNode tn, @Extension IFormattableDocument document) {
        document.format((Object)tn.getPn());
        document.format((Object)tn.getApl());
        document.format((Object)tn.getChildren());
    }

    protected void _format(SingleParameterNode spn, @Extension IFormattableDocument document) {
        document.format((Object)spn.getGenP());
        document.format((Object)spn.getAtomP());
        document.format((Object)spn.getTr());
    }

    protected void _format(GenericParameter gp, @Extension IFormattableDocument document) {
        Procedures.Procedure1 _function = it -> it.noSpace();
        document.append(this.textRegionExtensions.regionFor((EObject)gp).keyword(":"), _function);
    }

    protected void _format(TypeReference tr, @Extension IFormattableDocument document) {
        document.format((Object)tr.getClassifier());
        Procedures.Procedure1 _function = it -> it.noSpace();
        document.surround(this.textRegionExtensions.regionFor((EObject)tr).keyword(":"), _function);
        document.format((Object)tr.getCard());
    }

    protected void _format(AtomicParameterList apl, @Extension IFormattableDocument document) {
        document.format((Object)apl.getFirst());
        EList<AtomicParameter> _nextap = apl.getNextap();
        for (AtomicParameter ap : _nextap) {
            document.format((Object)ap);
        }
        document.format((Object)apl.getCard());
    }

    protected void _format(AtomicParameter ap, @Extension IFormattableDocument document) {
        document.format((Object)ap.getClassifier());
        document.format((Object)ap.getRat());
        document.format((Object)ap.getCard());
    }

    protected void _format(RoleAndType rat, @Extension IFormattableDocument document) {
        Procedures.Procedure1 _function = it -> it.noSpace();
        document.surround(this.textRegionExtensions.regionFor((EObject)rat).keyword(":"), _function);
        Procedures.Procedure1 _function_1 = it -> it.noSpace();
        document.surround(this.textRegionExtensions.regionFor((EObject)rat).keyword("<"), _function_1);
        Procedures.Procedure1 _function_2 = it -> it.noSpace();
        document.prepend(this.textRegionExtensions.regionFor((EObject)rat).keyword(">"), _function_2);
    }

    protected void _format(Cardinality c, @Extension IFormattableDocument document) {
        Procedures.Procedure1 _function = it -> it.noSpace();
        document.prepend(this.textRegionExtensions.regionFor((EObject)c).keyword("!"), _function);
        Procedures.Procedure1 _function_1 = it -> it.noSpace();
        document.prepend(this.textRegionExtensions.regionFor((EObject)c).keyword("+"), _function_1);
        Procedures.Procedure1 _function_2 = it -> it.noSpace();
        document.prepend(this.textRegionExtensions.regionFor((EObject)c).keyword("?"), _function_2);
        Procedures.Procedure1 _function_3 = it -> it.noSpace();
        document.prepend(this.textRegionExtensions.regionFor((EObject)c).keyword("*"), _function_3);
    }

    protected void _format(PatternStereotype classifier, @Extension IFormattableDocument document) {
        Procedures.Procedure1 _function = it -> it.noSpace();
        document.append(this.textRegionExtensions.regionFor((EObject)classifier).keyword("<<"), _function);
        Procedures.Procedure1 _function_1 = it -> it.noSpace();
        document.prepend(this.textRegionExtensions.regionFor((EObject)classifier).keyword(">>"), _function_1);
    }

    protected void _format(EndpointContract ec, @Extension IFormattableDocument document) {
        Procedures.Procedure1 _function = it -> it.setNewLines(2);
        document.prepend((EObject)ec, _function);
        Procedures.Procedure1 _function_1 = it -> it.setNewLines(1);
        document.prepend(this.textRegionExtensions.regionFor((EObject)ec).keyword("exposes"), _function_1);
        EList<Operation> _ops = ec.getOps();
        for (Operation operations : _ops) {
            document.format((Object)operations);
        }
        Procedures.Procedure1 _function_2 = it -> it.setNewLines(1);
        document.prepend(this.textRegionExtensions.regionFor((EObject)ec).keyword("receives"), _function_2);
    }

    protected void _format(ChannelContract cc, @Extension IFormattableDocument document) {
        document.format((Object)cc.getConversationType());
        Procedures.Procedure1 _function = it -> it.setNewLines(2);
        document.prepend((EObject)cc, _function);
    }

    protected void _format(RequestReplyChannel channels, @Extension IFormattableDocument document) {
        Procedures.Procedure1 _function = it -> it.newLine();
        document.prepend((EObject)channels, _function);
        Procedures.Procedure1 _function_1 = it -> it.indent();
        document.interior(this.textRegionExtensions.regionFor((EObject)channels).keyword("request"), this.textRegionExtensions.regionFor((EObject)channels).keyword("reply"), _function_1);
        document.format((Object)channels.getRequest());
        document.format((Object)channels.getReply());
    }

    protected void _format(RequestChannel channel, @Extension IFormattableDocument document) {
        Procedures.Procedure1 _function = it -> it.newLine();
        document.prepend((EObject)channel, _function);
        Procedures.Procedure1 _function_1 = it -> it.indent();
        document.interior(this.textRegionExtensions.regionFor((EObject)channel).keyword("request"), null, _function_1);
        document.format((Object)channel.getPayload());
    }

    protected void _format(ReplyChannel channel, @Extension IFormattableDocument document) {
        Procedures.Procedure1 _function = it -> it.newLine();
        document.prepend((EObject)channel, _function);
        Procedures.Procedure1 _function_1 = it -> it.indent();
        document.interior(this.textRegionExtensions.regionFor((EObject)channel).keyword("request"), this.textRegionExtensions.regionFor((EObject)channel).keyword("message"), _function_1);
        document.format((Object)channel.getPayload());
    }

    protected void _format(Payload body, @Extension IFormattableDocument document) {
        document.format((Object)body.getSchema());
    }

    protected void _format(Operation operation, @Extension IFormattableDocument document) {
        Procedures.Procedure1 _function = it -> it.newLine();
        document.prepend((EObject)operation, _function);
        document.format((Object)operation.getRequestMessage());
        document.format((Object)operation.getResponseMessage());
        document.format((Object)operation.getReports());
        document.format((Object)operation.getPolicies());
        document.format((Object)operation.getUndo());
    }

    protected void _format(StatusReports reports, @Extension IFormattableDocument document) {
        EList<StatusReport> _reportList = reports.getReportList();
        for (StatusReport report : _reportList) {
            document.format((Object)report);
        }
    }

    protected void _format(StatusReport report, @Extension IFormattableDocument document) {
        document.format((Object)report.getReportData());
    }

    protected void _format(SecurityPolicies policies, @Extension IFormattableDocument document) {
        EList<SecurityPolicy> _policyList = policies.getPolicyList();
        for (SecurityPolicy policy : _policyList) {
            document.format((Object)policy);
        }
    }

    protected void _format(SecurityPolicy policy, @Extension IFormattableDocument document) {
        document.format((Object)policy.getSecurityObject());
    }

    protected void _format(Provider p, @Extension IFormattableDocument document) {
        Procedures.Procedure1 _function = it -> it.setNewLines(2);
        document.prepend((EObject)p, _function);
        EList<EndpointList> _epl = p.getEpl();
        for (EndpointList el : _epl) {
            document.format((Object)el);
        }
    }

    protected void _format(EndpointList el, @Extension IFormattableDocument document) {
        EList<EndpointInstance> _endpoints = el.getEndpoints();
        for (EndpointInstance ei : _endpoints) {
            document.format((Object)ei);
        }
    }

    protected void _format(EndpointInstance ei, @Extension IFormattableDocument document) {
        EList<TechnologyBinding> _pb = ei.getPb();
        for (TechnologyBinding tpb : _pb) {
            document.format((Object)tpb);
        }
    }

    protected void _format(TechnologyBinding tp, @Extension IFormattableDocument document) {
        Procedures.Procedure1 _function = it -> it.newLine();
        document.prepend((EObject)tp, _function);
        document.format((Object)tp.getProtBinding());
    }

    protected void _format(ProtocolBinding pb, @Extension IFormattableDocument document) {
        document.format((Object)pb.getHttp());
    }

    protected void _format(HTTPBinding httpb, @Extension IFormattableDocument document) {
        EList<HTTPResourceBinding> _eb = httpb.getEb();
        for (HTTPResourceBinding rb : _eb) {
            document.format((Object)rb);
        }
    }

    protected void _format(HTTPResourceBinding httprb, @Extension IFormattableDocument document) {
        Procedures.Procedure1 _function = it -> it.newLine();
        document.prepend((EObject)httprb, _function);
        EList<HTTPOperationBinding> _opsB = httprb.getOpsB();
        for (HTTPOperationBinding ob : _opsB) {
            document.format((Object)ob);
        }
        document.format(httprb.getOpsB());
    }

    protected void _format(HTTPOperationBinding hopb, @Extension IFormattableDocument document) {
        Procedures.Procedure1 _function = it -> it.newLine();
        document.prepend((EObject)hopb, _function);
    }

    protected void _format(Client c, @Extension IFormattableDocument document) {
        Procedures.Procedure1 _function = it -> it.setNewLines(2);
        document.prepend((EObject)c, _function);
    }

    protected void _format(Orchestration flow, @Extension IFormattableDocument document) {
        Procedures.Procedure1 _function = it -> it.setNewLines(2);
        document.prepend((EObject)flow, _function);
        EList<FlowStep> _steps = flow.getSteps();
        for (FlowStep flowStep : _steps) {
            document.format((Object)flowStep);
        }
    }

    protected void _format(FlowStep flowStep, @Extension IFormattableDocument document) {
        Procedures.Procedure1 _function = it -> it.newLine();
        document.prepend((EObject)flowStep, _function);
        document.format((Object)flowStep.getCisStep());
    }

    protected void _format(CommandInvokationStep cisStep, @Extension IFormattableDocument document) {
        Procedures.Procedure1 _function = it -> it.indent();
        document.interior(this.textRegionExtensions.regionFor((EObject)cisStep).keyword("event"), this.textRegionExtensions.regionFor((EObject)cisStep).keyword("triggers"), _function);
    }

    protected void _format(IntegrationScenario scenario, @Extension IFormattableDocument document) {
        Procedures.Procedure1 _function = it -> it.setNewLines(2);
        document.prepend((EObject)scenario, _function);
        EList<IntegrationStory> _stories = scenario.getStories();
        for (IntegrationStory story : _stories) {
            document.format((Object)story);
        }
    }

    protected void _format(IntegrationStory story, @Extension IFormattableDocument document) {
        Procedures.Procedure1 _function = it -> it.newLine();
        document.prepend((EObject)story, _function);
    }

    public void format(Object cc, IFormattableDocument document) {
        if (cc instanceof XtextResource) {
            this._format((XtextResource)cc, document);
            return;
        }
        if (cc instanceof ChannelContract) {
            this._format((ChannelContract)cc, document);
            return;
        }
        if (cc instanceof ReplyChannel) {
            this._format((ReplyChannel)cc, document);
            return;
        }
        if (cc instanceof RequestChannel) {
            this._format((RequestChannel)cc, document);
            return;
        }
        if (cc instanceof AtomicParameter) {
            this._format((AtomicParameter)cc, document);
            return;
        }
        if (cc instanceof AtomicParameterList) {
            this._format((AtomicParameterList)cc, document);
            return;
        }
        if (cc instanceof Cardinality) {
            this._format((Cardinality)cc, document);
            return;
        }
        if (cc instanceof Client) {
            this._format((Client)cc, document);
            return;
        }
        if (cc instanceof CommandInvokationStep) {
            this._format((CommandInvokationStep)cc, document);
            return;
        }
        if (cc instanceof CommandType) {
            this._format((CommandType)cc, document);
            return;
        }
        if (cc instanceof CommandTypes) {
            this._format((CommandTypes)cc, document);
            return;
        }
        if (cc instanceof DataContract) {
            this._format((DataContract)cc, document);
            return;
        }
        if (cc instanceof DataTransferRepresentation) {
            this._format((DataTransferRepresentation)cc, document);
            return;
        }
        if (cc instanceof ElementStructure) {
            this._format((ElementStructure)cc, document);
            return;
        }
        if (cc instanceof EndpointContract) {
            this._format((EndpointContract)cc, document);
            return;
        }
        if (cc instanceof EndpointInstance) {
            this._format((EndpointInstance)cc, document);
            return;
        }
        if (cc instanceof EndpointList) {
            this._format((EndpointList)cc, document);
            return;
        }
        if (cc instanceof EventType) {
            this._format((EventType)cc, document);
            return;
        }
        if (cc instanceof EventTypes) {
            this._format((EventTypes)cc, document);
            return;
        }
        if (cc instanceof FlowStep) {
            this._format((FlowStep)cc, document);
            return;
        }
        if (cc instanceof GenericParameter) {
            this._format((GenericParameter)cc, document);
            return;
        }
        if (cc instanceof HTTPBinding) {
            this._format((HTTPBinding)cc, document);
            return;
        }
        if (cc instanceof HTTPOperationBinding) {
            this._format((HTTPOperationBinding)cc, document);
            return;
        }
        if (cc instanceof HTTPResourceBinding) {
            this._format((HTTPResourceBinding)cc, document);
            return;
        }
        if (cc instanceof IntegrationScenario) {
            this._format((IntegrationScenario)cc, document);
            return;
        }
        if (cc instanceof IntegrationStory) {
            this._format((IntegrationStory)cc, document);
            return;
        }
        if (cc instanceof Operation) {
            this._format((Operation)cc, document);
            return;
        }
        if (cc instanceof Orchestration) {
            this._format((Orchestration)cc, document);
            return;
        }
        if (cc instanceof ParameterTree) {
            this._format((ParameterTree)cc, document);
            return;
        }
        if (cc instanceof PatternStereotype) {
            this._format((PatternStereotype)cc, document);
            return;
        }
        if (cc instanceof Payload) {
            this._format((Payload)cc, document);
            return;
        }
        if (cc instanceof ProtocolBinding) {
            this._format((ProtocolBinding)cc, document);
            return;
        }
        if (cc instanceof Provider) {
            this._format((Provider)cc, document);
            return;
        }
        if (cc instanceof RequestReplyChannel) {
            this._format((RequestReplyChannel)cc, document);
            return;
        }
        if (cc instanceof RoleAndType) {
            this._format((RoleAndType)cc, document);
            return;
        }
        if (cc instanceof SecurityPolicies) {
            this._format((SecurityPolicies)cc, document);
            return;
        }
        if (cc instanceof SecurityPolicy) {
            this._format((SecurityPolicy)cc, document);
            return;
        }
        if (cc instanceof ServiceSpecification) {
            this._format((ServiceSpecification)cc, document);
            return;
        }
        if (cc instanceof SingleParameterNode) {
            this._format((SingleParameterNode)cc, document);
            return;
        }
        if (cc instanceof StatusReport) {
            this._format((StatusReport)cc, document);
            return;
        }
        if (cc instanceof StatusReports) {
            this._format((StatusReports)cc, document);
            return;
        }
        if (cc instanceof TechnologyBinding) {
            this._format((TechnologyBinding)cc, document);
            return;
        }
        if (cc instanceof TreeNode) {
            this._format((TreeNode)cc, document);
            return;
        }
        if (cc instanceof TypeReference) {
            this._format((TypeReference)cc, document);
            return;
        }
        if (cc instanceof EObject) {
            this._format((EObject)cc, document);
            return;
        }
        if (cc == null) {
            this._format(null, document);
            return;
        }
        if (cc != null) {
            this._format(cc, document);
            return;
        }
        throw new IllegalArgumentException("Unhandled parameter types: " + Arrays.asList(cc, document).toString());
    }
}

