/*
 * Decompiled with CFR 0.152.
 */
package io.mdsl.generator;

import io.mdsl.apiDescription.ServiceSpecification;
import io.mdsl.generator.AbstractMDSLGenerator;
import io.mdsl.generator.freemarker.FreemarkerEngineWrapper;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.generator.IFileSystemAccess2;

public class ALPSGenerator
extends AbstractMDSLGenerator {
    private Map<String, Object> customDataMap = new HashMap<String, Object>();

    public void registerCustomModelProperty(String propertyName, Object object) {
        this.customDataMap.put(propertyName, object);
    }

    @Override
    protected void generateFromServiceSpecification(ServiceSpecification mdslSpecification, IFileSystemAccess2 fsa, URI inputFileURI) {
        String outputFilePrefix = inputFileURI.trimFileExtension().lastSegment();
        this.registerCustomModelProperty("timeStamp", new SimpleDateFormat("dd.MM.YYYY HH:mm:ss z").format(new Date()));
        this.registerCustomModelProperty("fileName", mdslSpecification.eResource().getURI().lastSegment().toString());
        this.registerCustomModelProperty("apiName", mdslSpecification.getName());
        FreemarkerEngineWrapper freemarkerWrapper = new FreemarkerEngineWrapper(ALPSGenerator.class, "MDSLEndpointTypeToALPS.yaml.ftl");
        for (Map.Entry<String, Object> customDataEntry : this.customDataMap.entrySet()) {
            freemarkerWrapper.registerCustomData(customDataEntry.getKey(), customDataEntry.getValue());
        }
        String filledOutTemplate = freemarkerWrapper.generate(mdslSpecification);
        fsa.generateFile(outputFilePrefix + "-alps.yaml", (CharSequence)filledOutTemplate);
    }
}

