/*
 * Decompiled with CFR 0.152.
 */
package io.mdsl.generator;

import freemarker.template.Configuration;
import freemarker.template.DefaultObjectWrapper;
import freemarker.template.DefaultObjectWrapperBuilder;
import freemarker.template.ObjectWrapper;
import freemarker.template.SimpleHash;
import io.mdsl.apiDescription.ServiceSpecification;
import io.mdsl.generator.AbstractMDSLGenerator;
import io.mdsl.generator.freemarker.FreemarkerEngineWrapper;
import io.mdsl.generator.jolie.converter.MDSL2JolieConverter;
import io.mdsl.generator.jolie.converter.OperationModel;
import io.mdsl.generator.jolie.converter.TypeModel;
import java.util.HashMap;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.generator.IFileSystemAccess2;

public class JolieGenerator
extends AbstractMDSLGenerator {
    @Override
    protected void generateFromServiceSpecification(ServiceSpecification mdslSpecification, IFileSystemAccess2 fsa, URI inputFileURI) {
        MDSL2JolieConverter jolConv = new MDSL2JolieConverter(mdslSpecification);
        HashMap<String, OperationModel> targetModelEndpoints = jolConv.convertEndpoints();
        DefaultObjectWrapperBuilder dowb = new DefaultObjectWrapperBuilder(Configuration.VERSION_2_3_27);
        DefaultObjectWrapper ow = dowb.build();
        SimpleHash sh = new SimpleHash((ObjectWrapper)ow);
        sh.put("operations", targetModelEndpoints);
        HashMap<String, TypeModel> targetModelTypes = jolConv.convertDataTypes();
        sh.put("types", targetModelTypes);
        String outputFilePrefix = inputFileURI.trimFileExtension().lastSegment();
        sh.put("specificationFilename", (Object)outputFilePrefix);
        FreemarkerEngineWrapper fmew = new FreemarkerEngineWrapper(JolieGenerator.class, "MDSL2JolieTemplate.ol.ftl");
        fmew.registerCustomData("jolieModel", sh);
        String filledOutTemplate = fmew.generate(mdslSpecification);
        fsa.generateFile(outputFilePrefix + ".ol", (CharSequence)filledOutTemplate);
    }
}

