/*
 * Decompiled with CFR 0.152.
 */
package io.mdsl.generator.asyncapi;

import com.google.common.base.CaseFormat;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.inject.Inject;
import io.mdsl.apiDescription.BasicParameterWithDescription;
import io.mdsl.apiDescription.BindingParameter;
import io.mdsl.apiDescription.BindingParams;
import io.mdsl.apiDescription.BindingValue;
import io.mdsl.apiDescription.ChannelContract;
import io.mdsl.apiDescription.ChannelPathWithParams;
import io.mdsl.apiDescription.CorrelationIdWhereClause;
import io.mdsl.apiDescription.DataContract;
import io.mdsl.apiDescription.DeliveryGuarantee;
import io.mdsl.apiDescription.ElementStructure;
import io.mdsl.apiDescription.Message;
import io.mdsl.apiDescription.MessageBroker;
import io.mdsl.apiDescription.OneWayChannel;
import io.mdsl.apiDescription.ProtocolBinding;
import io.mdsl.apiDescription.RequestReplyChannel;
import io.mdsl.apiDescription.ServiceSpecification;
import io.mdsl.apiDescription.WhereClauses;
import io.mdsl.generator.AbstractMDSLGenerator;
import io.mdsl.generator.asyncapi.AsyncApiDataTypeGenerator;
import io.mdsl.generator.asyncapi.helpers.AsyncApiGeneratorHelper;
import io.mdsl.generator.asyncapi.models.MessageBrokerDto;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import org.apache.commons.lang3.StringUtils;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtend2.lib.StringConcatenation;
import org.eclipse.xtext.generator.IFileSystemAccess2;
import org.eclipse.xtext.naming.IQualifiedNameProvider;
import org.eclipse.xtext.naming.QualifiedName;
import org.eclipse.xtext.nodemodel.util.NodeModelUtils;
import org.eclipse.xtext.xbase.lib.Conversions;
import org.eclipse.xtext.xbase.lib.Extension;
import org.eclipse.xtext.xbase.lib.Functions;
import org.eclipse.xtext.xbase.lib.IterableExtensions;
import org.eclipse.xtext.xbase.lib.IteratorExtensions;
import org.eclipse.xtext.xbase.lib.MapExtensions;
import org.eclipse.xtext.xbase.lib.Procedures;

public class AsyncApiGenerator
extends AbstractMDSLGenerator {
    @Inject
    @Extension
    private IQualifiedNameProvider _iQualifiedNameProvider;
    @Inject
    private AsyncApiDataTypeGenerator dataTypeGenerator;

    @Override
    protected void generateFromServiceSpecification(ServiceSpecification mdslSpecification, IFileSystemAccess2 fsa, URI inputFileURI) {
        boolean _greaterThan;
        boolean _equals;
        int _length = ((Object[])Conversions.unwrapArray((Object)Iterables.filter(mdslSpecification.getContracts(), ChannelContract.class), Object.class)).length;
        boolean bl = _equals = _length == 0;
        if (_equals) {
            return;
        }
        MessageBroker[] brokers = (MessageBroker[])((MessageBroker[])Conversions.unwrapArray((Object)Iterables.filter(mdslSpecification.getProviders(), MessageBroker.class), MessageBroker.class)).clone();
        int _length_1 = brokers.length;
        boolean bl2 = _greaterThan = _length_1 > 0;
        if (_greaterThan) {
            HashMap brokersChannels = new HashMap();
            Consumer<MessageBroker> _function = broker -> {
                Functions.Function1 _function_1 = ep -> ep.getContracts();
                Functions.Function1 _function_2 = channel -> channel.getName();
                brokersChannels.put(broker, IterableExtensions.sortBy((Iterable)IterableExtensions.toList((Iterable)IterableExtensions.flatMap(broker.getEpl(), (Functions.Function1)_function_1)), (Functions.Function1)_function_2));
            };
            ((List)Conversions.doWrapArray((Object)brokers)).forEach(_function);
            LinkedList alreadyUsedBrokers = new LinkedList();
            Procedures.Procedure3 _function_1 = (broker, channels, index) -> {
                boolean _not;
                boolean _contains = alreadyUsedBrokers.contains(broker);
                boolean bl = _not = !_contains;
                if (_not) {
                    LinkedList<MessageBroker> brokersThatExposeSameChannels = this.getBrokersThatExposeSameChannels((MessageBroker)broker, brokersChannels);
                    alreadyUsedBrokers.add(broker);
                    alreadyUsedBrokers.addAll(brokersThatExposeSameChannels);
                    mdslSpecification.getProviders().clear();
                    mdslSpecification.getProviders().addAll(brokersThatExposeSameChannels);
                    mdslSpecification.getContracts().clear();
                    mdslSpecification.getContracts().addAll((Collection)channels);
                    String yamlWithNoTabs = this.compile(mdslSpecification).toString().replaceAll("\t", "  ");
                    String _lastSegment = inputFileURI.trimFileExtension().lastSegment();
                    String _plus = _lastSegment + "-group-";
                    String _plus_1 = _plus + index;
                    String fileName = _plus_1 + "-asyncapi.yaml";
                    fsa.generateFile(fileName, (CharSequence)yamlWithNoTabs);
                }
            };
            MapExtensions.forEach(brokersChannels, (Procedures.Procedure3)_function_1);
        } else {
            String yamlWithNoTabs = this.compile(mdslSpecification).toString().replaceAll("\t", "  ");
            String _lastSegment = inputFileURI.trimFileExtension().lastSegment();
            String fileName = _lastSegment + "-asyncapi.yaml";
            fsa.generateFile(fileName, (CharSequence)yamlWithNoTabs);
        }
    }

    private LinkedList<MessageBroker> getBrokersThatExposeSameChannels(MessageBroker source, Map<MessageBroker, List<ChannelContract>> context) {
        Functions.Function1 _function = ep -> ep.getContracts();
        Functions.Function1 _function_1 = channel -> channel.getName();
        List sourceChannels = IterableExtensions.sortBy((Iterable)IterableExtensions.toList((Iterable)IterableExtensions.flatMap(source.getEpl(), (Functions.Function1)_function)), (Functions.Function1)_function_1);
        LinkedList<MessageBroker> brokersThatExposeSameChannelsOfSource = new LinkedList<MessageBroker>();
        BiConsumer<MessageBroker, List> _function_2 = (broker, channelsThatBrokerExposes) -> {
            boolean _equals = sourceChannels.equals(channelsThatBrokerExposes);
            if (_equals) {
                brokersThatExposeSameChannelsOfSource.add((MessageBroker)broker);
            }
        };
        context.forEach(_function_2);
        return brokersThatExposeSameChannelsOfSource;
    }

    private CharSequence compile(ServiceSpecification serviceSpecificationInstance) {
        boolean _greaterThan_1;
        int _length;
        boolean _greaterThan;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("asyncapi: '2.0.0'");
        _builder.newLine();
        _builder.append("info:");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("title: ");
        QualifiedName _fullyQualifiedName = this._iQualifiedNameProvider.getFullyQualifiedName((EObject)serviceSpecificationInstance);
        _builder.append((Object)_fullyQualifiedName, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("version: ");
        String _valueOrDefault = this.getValueOrDefault(serviceSpecificationInstance.getSvi(), "Not defined");
        _builder.append(_valueOrDefault, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("description: |");
        _builder.newLine();
        _builder.append("\t\t");
        String _valueOrDefault_1 = this.getValueOrDefault(serviceSpecificationInstance.getDescription(), "No description specified");
        _builder.append(_valueOrDefault_1, "\t\t");
        _builder.newLineIfNotEmpty();
        EList<EObject> _providers = serviceSpecificationInstance.getProviders();
        Iterator _filter = null;
        if (_providers != null) {
            _filter = Iterables.filter(_providers, MessageBroker.class);
        }
        boolean bl = _greaterThan = (_length = ((Object[])Conversions.unwrapArray(_filter, Object.class)).length) > 0;
        if (_greaterThan) {
            _builder.append("servers:");
            _builder.newLine();
            List<MessageBrokerDto> _brokers = AsyncApiGeneratorHelper.getBrokers(serviceSpecificationInstance);
            for (MessageBrokerDto broker : _brokers) {
                _builder.append("\t");
                String _name = broker.getName();
                _builder.append(_name, "\t");
                _builder.append(":");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("url: ");
                String _url = broker.getUrl();
                _builder.append(_url, "\t\t");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("protocol: ");
                String _protocol = broker.getProtocol();
                _builder.append(_protocol, "\t\t");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("description: ");
                String _description = broker.getDescription();
                _builder.append(_description, "\t\t");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("\t");
                CharSequence _insertBinding = this.insertBinding(broker.getBindings(), broker.getProtocol());
                _builder.append((Object)_insertBinding, "\t\t");
                _builder.newLineIfNotEmpty();
            }
        }
        _builder.append("channels:");
        _builder.newLine();
        Iterable _filter_1 = Iterables.filter(serviceSpecificationInstance.getContracts(), ChannelContract.class);
        for (ChannelContract contract : _filter_1) {
            _builder.append("\t");
            CharSequence _compile = this.compile(contract);
            _builder.append((Object)_compile, "\t");
            _builder.newLineIfNotEmpty();
        }
        _builder.append("components:");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("messages:");
        _builder.newLine();
        Iterable _iterable = IteratorExtensions.toIterable((Iterator)Iterators.filter((Iterator)serviceSpecificationInstance.eAllContents(), Message.class));
        for (Message message : _iterable) {
            _builder.append("\t\t");
            String _name_1 = message.getName();
            _builder.append(_name_1, "\t\t");
            _builder.append(":");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("\t");
            _builder.append("name: ");
            String _name_2 = message.getName();
            _builder.append(_name_2, "\t\t\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("\t");
            _builder.append("title: ");
            String _spaceBreak = this.toSpaceBreak(message.getName());
            _builder.append(_spaceBreak, "\t\t\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("\t");
            _builder.append("description: |");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("\t\t");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("\t\t");
            String _valueOrDefault_2 = this.getValueOrDefault(message.getDescription(), "No description specified");
            _builder.append(_valueOrDefault_2, "\t\t\t\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("\t\t");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("\t\t");
            CharSequence _rootCardinalityInfo = this.getRootCardinalityInfo(message.getPayload().getSchema().getPayload());
            _builder.append((Object)_rootCardinalityInfo, "\t\t\t\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("\t\t");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("\t");
            EObject _eContainer = message.eContainer();
            CharSequence _correlationId = this.getCorrelationId((List<WhereClauses>)((OneWayChannel)_eContainer).getWhereClauses());
            _builder.append((Object)_correlationId, "\t\t\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("\t");
            _builder.append("payload:");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("\t\t");
            CharSequence _compileElementStructureTypeReferenceNoName = this.compileElementStructureTypeReferenceNoName(message.getPayload().getSchema().getPayload());
            _builder.append((Object)_compileElementStructureTypeReferenceNoName, "\t\t\t\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("\t");
            CharSequence _headers = this.getHeaders(message.getPayload().getSchema().getHeaders());
            _builder.append((Object)_headers, "\t\t\t");
            _builder.newLineIfNotEmpty();
        }
        Iterable _iterable_1 = IteratorExtensions.toIterable((Iterator)Iterators.filter((Iterator)serviceSpecificationInstance.eAllContents(), RequestReplyChannel.class));
        for (RequestReplyChannel reqReplyChannel : _iterable_1) {
            _builder.append("\t\t");
            String _name_3 = reqReplyChannel.getRequest().getName();
            _builder.append(_name_3, "\t\t");
            _builder.append(":");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("\t");
            _builder.append("name: ");
            String _name_4 = reqReplyChannel.getRequest().getName();
            _builder.append(_name_4, "\t\t\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("\t");
            _builder.append("title: ");
            String _spaceBreak_1 = this.toSpaceBreak(reqReplyChannel.getRequest().getName());
            _builder.append(_spaceBreak_1, "\t\t\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("\t");
            _builder.append("description: |");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("\t\t");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("\t\t");
            String _valueOrDefault_3 = this.getValueOrDefault(reqReplyChannel.getRequest().getDescription(), "No description specified");
            _builder.append(_valueOrDefault_3, "\t\t\t\t");
            _builder.newLineIfNotEmpty();
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("\t\t");
            CharSequence _rootCardinalityInfo_1 = this.getRootCardinalityInfo(reqReplyChannel.getRequest().getPayload().getSchema().getPayload());
            _builder.append((Object)_rootCardinalityInfo_1, "\t\t\t\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("\t\t");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("\t\t");
            _builder.append("Request message. Reply message is *");
            String _name_5 = reqReplyChannel.getReply().getName();
            _builder.append(_name_5, "\t\t\t\t");
            _builder.append("*. ");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("\t");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("\t");
            CharSequence _correlationId_1 = this.getCorrelationId((List<WhereClauses>)reqReplyChannel.getRequest().getWhereClauses());
            _builder.append((Object)_correlationId_1, "\t\t\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("\t");
            _builder.append("payload:");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("\t\t");
            CharSequence _compileElementStructureTypeReferenceNoName_1 = this.compileElementStructureTypeReferenceNoName(reqReplyChannel.getRequest().getPayload().getSchema().getPayload());
            _builder.append((Object)_compileElementStructureTypeReferenceNoName_1, "\t\t\t\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("\t");
            CharSequence _headers_1 = this.getHeaders(reqReplyChannel.getRequest().getPayload().getSchema().getHeaders());
            _builder.append((Object)_headers_1, "\t\t\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            String _name_6 = reqReplyChannel.getReply().getName();
            _builder.append(_name_6, "\t\t");
            _builder.append(":");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("\t");
            _builder.append("name: ");
            String _name_7 = reqReplyChannel.getReply().getName();
            _builder.append(_name_7, "\t\t\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("\t");
            _builder.append("title: ");
            String _spaceBreak_2 = this.toSpaceBreak(reqReplyChannel.getReply().getName());
            _builder.append(_spaceBreak_2, "\t\t\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("\t");
            _builder.append("description: |");
            _builder.newLine();
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("\t\t");
            String _valueOrDefault_4 = this.getValueOrDefault(reqReplyChannel.getReply().getDescription(), "No description specified");
            _builder.append(_valueOrDefault_4, "\t\t\t\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("\t\t");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("\t\t");
            CharSequence _rootCardinalityInfo_2 = this.getRootCardinalityInfo(reqReplyChannel.getReply().getPayload().getSchema().getPayload());
            _builder.append((Object)_rootCardinalityInfo_2, "\t\t\t\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("\t\t");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("\t\t");
            _builder.append("Reply message. Request message is *");
            String _name_8 = reqReplyChannel.getRequest().getName();
            _builder.append(_name_8, "\t\t\t\t");
            _builder.append("*. ");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("\t\t");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("\t");
            CharSequence _correlationId_2 = this.getCorrelationId((List<WhereClauses>)reqReplyChannel.getReply().getWhereClauses());
            _builder.append((Object)_correlationId_2, "\t\t\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("\t");
            _builder.append("payload:");
            _builder.newLine();
            _builder.append("\t\t");
            _builder.append("\t\t");
            CharSequence _compileElementStructureTypeReferenceNoName_2 = this.compileElementStructureTypeReferenceNoName(reqReplyChannel.getReply().getPayload().getSchema().getPayload());
            _builder.append((Object)_compileElementStructureTypeReferenceNoName_2, "\t\t\t\t");
            _builder.newLineIfNotEmpty();
            _builder.append("\t\t");
            _builder.append("\t");
            CharSequence _headers_2 = this.getHeaders(reqReplyChannel.getReply().getPayload().getSchema().getHeaders());
            _builder.append((Object)_headers_2, "\t\t\t");
            _builder.newLineIfNotEmpty();
        }
        int _size = IteratorExtensions.size((Iterator)Iterators.filter((Iterator)serviceSpecificationInstance.eAllContents(), DataContract.class));
        boolean bl2 = _greaterThan_1 = _size > 0;
        if (_greaterThan_1) {
            _builder.append("\t");
            _builder.append("schemas:");
            _builder.newLine();
            Iterable _iterable_2 = IteratorExtensions.toIterable((Iterator)Iterators.filter((Iterator)serviceSpecificationInstance.eAllContents(), DataContract.class));
            for (DataContract dc : _iterable_2) {
                ElementStructure _structure = dc.getStructure();
                boolean _tripleNotEquals = _structure != null;
                if (!_tripleNotEquals) continue;
                _builder.append("\t");
                _builder.append("\t");
                String _name_9 = dc.getName();
                _builder.append(_name_9, "\t\t");
                _builder.append(":");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("\t");
                CharSequence _compileElementStructureTypeReferenceNoName_3 = this.compileElementStructureTypeReferenceNoName(dc.getStructure());
                _builder.append((Object)_compileElementStructureTypeReferenceNoName_3, "\t\t\t");
                _builder.newLineIfNotEmpty();
            }
        }
        return _builder;
    }

    private CharSequence getCorrelationId(List<WhereClauses> whereClauses) {
        boolean _tripleNotEquals;
        StringConcatenation _builder = new StringConcatenation();
        CorrelationIdWhereClause _correlationId = AsyncApiGeneratorHelper.getCorrelationId(whereClauses);
        boolean bl = _tripleNotEquals = _correlationId != null;
        if (_tripleNotEquals) {
            _builder.append("correlationId:");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("location: '");
            String _source = AsyncApiGeneratorHelper.getCorrelationId(whereClauses).getSource();
            _builder.append(_source, "\t");
            _builder.append("'");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    private CharSequence getHeaders(ElementStructure headers) {
        StringConcatenation _builder = new StringConcatenation();
        if (headers != null) {
            _builder.append("headers:");
            _builder.newLine();
            _builder.append("\t ");
            CharSequence _compile = this.compile(headers);
            _builder.append((Object)_compile, "\t ");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    private String getValueOrDefault(String str, String defaultValue) {
        if (str != null && str.length() > 0) {
            return str.trim();
        }
        return defaultValue;
    }

    private String toSpaceBreak(String str) {
        String[] _split;
        String title = CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_UNDERSCORE, str);
        ArrayList<String> capitalizedTitle = new ArrayList<String>();
        for (String s : _split = title.split("_")) {
            capitalizedTitle.add(StringUtils.capitalize((String)s));
        }
        return IterableExtensions.join(capitalizedTitle, (CharSequence)" ");
    }

    private CharSequence getClausoles(List<WhereClauses> whereClausoles) {
        StringConcatenation _builder = new StringConcatenation();
        if (whereClausoles != null && ((Object[])Conversions.unwrapArray(whereClausoles, Object.class)).length > 0) {
            _builder.append("Where:");
            _builder.newLine();
            for (WhereClauses c : whereClausoles) {
                _builder.append("- ");
                String _trim = NodeModelUtils.findActualNodeFor((EObject)c).getText().trim();
                _builder.append(_trim);
                _builder.newLineIfNotEmpty();
            }
        }
        return _builder;
    }

    private CharSequence getRootCardinalityInfo(ElementStructure root) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _isArray = this.dataTypeGenerator.getRootPayloadCardinality(root).isArray();
        if (_isArray) {
            _builder.append("Payload cardinality: ");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("- contains always at least one element: ");
            boolean _isAtLeastOne = this.dataTypeGenerator.getRootPayloadCardinality(root).isAtLeastOne();
            _builder.append((Object)_isAtLeastOne, "\t");
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    private CharSequence compile(ChannelContract contract) {
        EObject _conversationType_2;
        StringConcatenation _builder = new StringConcatenation();
        EObject _conversationType = contract.getConversationType();
        if (_conversationType instanceof OneWayChannel) {
            EObject _conversationType_1 = contract.getConversationType();
            CharSequence _compile = this.compile((OneWayChannel)_conversationType_1);
            _builder.append((Object)_compile);
            _builder.newLineIfNotEmpty();
        }
        if ((_conversationType_2 = contract.getConversationType()) instanceof RequestReplyChannel) {
            EObject _conversationType_3 = contract.getConversationType();
            CharSequence _compile_1 = this.compile((RequestReplyChannel)_conversationType_3);
            _builder.append((Object)_compile_1);
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    private CharSequence insertBinding(BindingParams binding, ProtocolBinding protocol) {
        if (binding != null && protocol != null) {
            return this.insertBinding(binding, AsyncApiGeneratorHelper.getProtocolBindingPropertyName(protocol));
        }
        return null;
    }

    private CharSequence insertBinding(BindingParams binding, String protocol) {
        StringConcatenation _builder = new StringConcatenation();
        if (binding != null && protocol != null) {
            _builder.append("bindings:");
            _builder.newLine();
            _builder.append("\t");
            String _protocolBindingPropertyName = AsyncApiGeneratorHelper.getProtocolBindingPropertyName(protocol);
            _builder.append(_protocolBindingPropertyName, "\t");
            _builder.append(":");
            _builder.newLineIfNotEmpty();
            EList<BindingParameter> _params = binding.getParams();
            for (BindingParameter p : _params) {
                _builder.append("\t\t");
                CharSequence _compile = this.compile(p);
                _builder.append((Object)_compile, "\t\t");
                _builder.newLineIfNotEmpty();
            }
        }
        return _builder;
    }

    private CharSequence compile(BindingParameter param) {
        StringConcatenation _builder = new StringConcatenation();
        EObject _value = param.getValue();
        if (_value instanceof BindingParams) {
            String _name = param.getName();
            _builder.append(_name);
            _builder.append(":");
            _builder.newLineIfNotEmpty();
            EObject _value_1 = param.getValue();
            EList<BindingParameter> _params = ((BindingParams)_value_1).getParams();
            for (BindingParameter p : _params) {
                _builder.append("\t");
                CharSequence _compile = this.compile(p);
                _builder.append((Object)_compile, "\t");
                _builder.newLineIfNotEmpty();
            }
        } else {
            boolean _tripleNotEquals;
            String _name_1 = param.getName();
            _builder.append(_name_1);
            _builder.append(":");
            _builder.newLineIfNotEmpty();
            EObject _value_2 = param.getValue();
            String _str = null;
            if ((BindingValue)_value_2 != null) {
                _str = ((BindingValue)_value_2).getStr();
            }
            boolean bl = _tripleNotEquals = _str != null;
            if (_tripleNotEquals) {
                _builder.append("\t");
                EObject _value_3 = param.getValue();
                String _str_1 = null;
                if ((BindingValue)_value_3 != null) {
                    _str_1 = ((BindingValue)_value_3).getStr();
                }
                _builder.append(_str_1, "\t");
                _builder.newLineIfNotEmpty();
            } else {
                boolean _tripleNotEquals_1;
                EObject _value_4 = param.getValue();
                String _bool = null;
                if ((BindingValue)_value_4 != null) {
                    _bool = ((BindingValue)_value_4).getBool();
                }
                boolean bl2 = _tripleNotEquals_1 = _bool != null;
                if (_tripleNotEquals_1) {
                    _builder.append("\t");
                    EObject _value_5 = param.getValue();
                    String _bool_1 = null;
                    if ((BindingValue)_value_5 != null) {
                        _bool_1 = ((BindingValue)_value_5).getBool();
                    }
                    _builder.append(_bool_1, "\t");
                    _builder.newLineIfNotEmpty();
                } else {
                    boolean _notEquals;
                    EObject _value_6 = param.getValue();
                    int _number = ((BindingValue)_value_6).getNumber();
                    boolean bl3 = _notEquals = _number != 0;
                    if (_notEquals) {
                        _builder.append("\t");
                        EObject _value_7 = param.getValue();
                        int _number_1 = ((BindingValue)_value_7).getNumber();
                        _builder.append((Object)_number_1, "\t");
                        _builder.newLineIfNotEmpty();
                    }
                }
            }
        }
        return _builder;
    }

    private CharSequence insertChannelQuality(ChannelContract contract) {
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("Delivering guarantee: ");
        DeliveryGuarantee _quality = contract.getQuality();
        _builder.append((Object)_quality);
        _builder.append(".");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    private CharSequence compile(OneWayChannel channel) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _compile = this.compile(channel.getPath());
        _builder.append((Object)_compile);
        _builder.newLineIfNotEmpty();
        boolean _isPublish = channel.isPublish();
        if (_isPublish) {
            _builder.append("\t");
            _builder.append("publish:");
            _builder.newLine();
            _builder.append("\t");
            _builder.append("\t");
            CharSequence _insertOperation = this.insertOperation(channel, "Publish");
            _builder.append((Object)_insertOperation, "\t\t");
            _builder.newLineIfNotEmpty();
        } else {
            boolean _isSubscribe = channel.isSubscribe();
            if (_isSubscribe) {
                _builder.append("\t");
                _builder.append("subscribe:");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                CharSequence _insertOperation_1 = this.insertOperation(channel, "Subscribe");
                _builder.append((Object)_insertOperation_1, "\t\t");
                _builder.newLineIfNotEmpty();
            } else {
                _builder.append("\t");
                _builder.append("publish:");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                CharSequence _insertOperation_2 = this.insertOperation(channel, "Publish");
                _builder.append((Object)_insertOperation_2, "\t\t");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("subscribe:");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                CharSequence _insertOperation_3 = this.insertOperation(channel, "Subscribe");
                _builder.append((Object)_insertOperation_3, "\t\t");
                _builder.newLineIfNotEmpty();
            }
        }
        return _builder;
    }

    private CharSequence insertOperation(OneWayChannel channel, String operation) {
        boolean _tripleNotEquals;
        StringConcatenation _builder = new StringConcatenation();
        _builder.append("description: | ");
        _builder.newLine();
        _builder.newLine();
        _builder.append("\t");
        String _valueOrDefault = this.getValueOrDefault(channel.getDescription(), "No description specified");
        _builder.append(_valueOrDefault, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        EObject _eContainer = channel.eContainer();
        CharSequence _insertChannelQuality = this.insertChannelQuality((ChannelContract)_eContainer);
        _builder.append((Object)_insertChannelQuality, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        CharSequence _clausoles = this.getClausoles((List<WhereClauses>)channel.getWhereClauses());
        _builder.append((Object)_clausoles, "\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("One way channel (does not expect reply).");
        _builder.newLine();
        _builder.append("\t");
        _builder.newLine();
        String _acceptsAndProduces = channel.getAcceptsAndProduces();
        boolean bl = _tripleNotEquals = _acceptsAndProduces != null;
        if (_tripleNotEquals) {
            _builder.append("\t");
            _builder.append("This channel allows message publications and message consumptions.");
            _builder.newLine();
        }
        _builder.append("\t");
        _builder.newLine();
        _builder.append("operationId: ");
        String _camelCase = this.toCamelCase(channel.getMessage().getName());
        _builder.append(_camelCase);
        _builder.append(operation);
        _builder.newLineIfNotEmpty();
        _builder.append("message: ");
        _builder.newLine();
        _builder.append("\t");
        _builder.append("$ref: '#/components/messages/");
        String _name = channel.getMessage().getName();
        _builder.append(_name, "\t");
        _builder.append("'");
        _builder.newLineIfNotEmpty();
        CharSequence _insertBinding = this.insertBinding(channel.getBindings(), channel.getProtocol());
        _builder.append((Object)_insertBinding);
        _builder.newLineIfNotEmpty();
        _builder.newLine();
        return _builder;
    }

    private CharSequence compile(RequestReplyChannel channel) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _compile = this.compile(channel.getRequest().getPath());
        _builder.append((Object)_compile);
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("subscribe:");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("description: |");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.newLine();
        _builder.append("\t\t\t");
        String _valueOrDefault = this.getValueOrDefault(channel.getRequest().getDescription(), "No description specified");
        _builder.append(_valueOrDefault, "\t\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t");
        _builder.newLine();
        _builder.append("\t\t\t");
        EObject _eContainer = channel.eContainer();
        CharSequence _insertChannelQuality = this.insertChannelQuality((ChannelContract)_eContainer);
        _builder.append((Object)_insertChannelQuality, "\t\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t    \t");
        CharSequence _clausoles = this.getClausoles((List<WhereClauses>)channel.getRequest().getWhereClauses());
        _builder.append((Object)_clausoles, "\t    \t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("Request channel. Reply channel is [");
        String _name = channel.getReply().getName();
        _builder.append(_name, "\t\t\t");
        _builder.append("](#operation-publish-");
        String _path = channel.getReply().getPath().getPath();
        _builder.append(_path, "\t\t\t");
        _builder.append(")");
        _builder.newLineIfNotEmpty();
        _builder.append("\t    \t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("operationId: ");
        String _camelCase = this.toCamelCase(channel.getRequest().getName());
        _builder.append(_camelCase, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("message: ");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("$ref: '#/components/messages/");
        String _name_1 = channel.getRequest().getName();
        _builder.append(_name_1, "\t\t\t");
        _builder.append("'");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        CharSequence _insertBinding = this.insertBinding(channel.getRequest().getBindings(), channel.getRequest().getProtocol());
        _builder.append((Object)_insertBinding, "\t\t");
        _builder.newLineIfNotEmpty();
        CharSequence _compile_1 = this.compile(channel.getReply().getPath());
        _builder.append((Object)_compile_1);
        _builder.newLineIfNotEmpty();
        _builder.append("\t");
        _builder.append("publish:");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("description: |");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.newLine();
        _builder.append("\t\t\t");
        String _valueOrDefault_1 = this.getValueOrDefault(channel.getReply().getDescription(), "No description specified");
        _builder.append(_valueOrDefault_1, "\t\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t");
        _builder.newLine();
        _builder.append("\t    \t");
        CharSequence _clausoles_1 = this.getClausoles((List<WhereClauses>)channel.getReply().getWhereClauses());
        _builder.append((Object)_clausoles_1, "\t    \t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t    \t");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("Reply channel. Request channel is [");
        String _name_2 = channel.getRequest().getName();
        _builder.append(_name_2, "\t\t\t");
        _builder.append("](#operation-subscribe-");
        String _path_1 = channel.getRequest().getPath().getPath();
        _builder.append(_path_1, "\t\t\t");
        _builder.append(")");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t\t");
        _builder.newLine();
        _builder.append("\t\t");
        _builder.append("operationId: ");
        String _camelCase_1 = this.toCamelCase(channel.getReply().getName());
        _builder.append(_camelCase_1, "\t\t");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        _builder.append("message: ");
        _builder.newLine();
        _builder.append("\t\t\t");
        _builder.append("$ref: '#/components/messages/");
        String _name_3 = channel.getReply().getName();
        _builder.append(_name_3, "\t\t\t");
        _builder.append("'");
        _builder.newLineIfNotEmpty();
        _builder.append("\t\t");
        CharSequence _insertBinding_1 = this.insertBinding(channel.getReply().getBindings(), channel.getReply().getProtocol());
        _builder.append((Object)_insertBinding_1, "\t\t");
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    private CharSequence compile(ChannelPathWithParams channelPath) {
        StringConcatenation _builder = new StringConcatenation();
        String _path = channelPath.getPath();
        _builder.append(_path);
        _builder.append(":");
        _builder.newLineIfNotEmpty();
        if (channelPath.getParams() != null && ((Object[])Conversions.unwrapArray(channelPath.getParams(), Object.class)).length > 0) {
            _builder.append("\t");
            _builder.append("parameters:");
            _builder.newLine();
            EList<BasicParameterWithDescription> _params = channelPath.getParams();
            for (BasicParameterWithDescription p : _params) {
                _builder.append("\t");
                _builder.append("\t");
                String _paramName = p.getParamName();
                _builder.append(_paramName, "\t\t");
                _builder.append(":");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("description: ");
                String _description = p.getDescription();
                _builder.append(_description, "\t\t\t");
                _builder.newLineIfNotEmpty();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("schema:");
                _builder.newLine();
                _builder.append("\t");
                _builder.append("\t");
                _builder.append("\t\t");
                _builder.append("type: ");
                String _type = this.dataTypeGenerator.getType(p.getType());
                _builder.append(_type, "\t\t\t\t");
                _builder.newLineIfNotEmpty();
            }
        }
        return _builder;
    }

    private CharSequence compile(ElementStructure dto) {
        StringConcatenation _builder = new StringConcatenation();
        CharSequence _compile = this.dataTypeGenerator.compile(dto);
        _builder.append((Object)_compile);
        _builder.newLineIfNotEmpty();
        return _builder;
    }

    private CharSequence compileElementStructureTypeReferenceNoName(ElementStructure elem) {
        StringConcatenation _builder = new StringConcatenation();
        boolean _isRootTypeReference = AsyncApiGeneratorHelper.isRootTypeReference(elem);
        if (_isRootTypeReference) {
            CharSequence _compile = this.dataTypeGenerator.compile(elem.getNp().getTr(), false);
            _builder.append((Object)_compile);
            _builder.newLineIfNotEmpty();
        } else {
            CharSequence _compile_1 = this.dataTypeGenerator.compile(elem);
            _builder.append((Object)_compile_1);
            _builder.newLineIfNotEmpty();
        }
        return _builder;
    }

    private String toCamelCase(String text) {
        return CaseFormat.UPPER_CAMEL.to(CaseFormat.LOWER_CAMEL, text);
    }
}

