/*
 * Decompiled with CFR 0.152.
 */
package io.mdsl.generator.freemarker;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateExceptionHandler;
import io.mdsl.apiDescription.ServiceSpecification;
import io.mdsl.exception.MDSLException;
import io.mdsl.generator.model.converter.MDSL2GeneratorModelConverter;
import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;

public class FreemarkerEngineWrapper {
    private File templateFile;
    private Class<?> templateLoadingClass;
    private String templateName;
    private Map<String, Object> inputData = new HashMap<String, Object>();

    private FreemarkerEngineWrapper() {
    }

    public FreemarkerEngineWrapper(File templateFile) {
        this();
        this.templateFile = templateFile;
        this.templateName = templateFile.getName();
    }

    public FreemarkerEngineWrapper(Class<?> templateLoadingClass, String templateName) {
        this();
        this.templateLoadingClass = templateLoadingClass;
        this.templateName = templateName;
    }

    public String generate(ServiceSpecification mdslSpecification) {
        try {
            Configuration configuration = this.configureFreemarker();
            Template template = configuration.getTemplate(this.templateName);
            this.inputData.put("serviceSpecification", mdslSpecification);
            this.inputData.put("genModel", new MDSL2GeneratorModelConverter(mdslSpecification).convert());
            StringWriter writer = new StringWriter();
            template.process(this.inputData, (Writer)writer);
            return writer.toString();
        }
        catch (Exception e) {
            throw new MDSLException("Freemarker generation exception occured: " + e.getMessage(), e);
        }
    }

    public void registerCustomData(String propertyName, Object object) {
        this.inputData.put(propertyName, object);
    }

    private Configuration configureFreemarker() throws IOException {
        Configuration configuration = new Configuration(Configuration.VERSION_2_3_30);
        if (this.templateFile != null) {
            configuration.setDirectoryForTemplateLoading(this.templateFile.getParentFile());
        } else {
            configuration.setClassForTemplateLoading(this.templateLoadingClass, "");
        }
        configuration.setDefaultEncoding("UTF-8");
        configuration.setTemplateExceptionHandler(TemplateExceptionHandler.RETHROW_HANDLER);
        return configuration;
    }
}

