/*
 * Decompiled with CFR 0.152.
 */
package io.mdsl.generator.model;

import io.mdsl.generator.model.MDSLType;
import java.util.regex.Matcher;

public enum BasicType implements MDSLType
{
    STRING("string"),
    BOOLEAN("bool"),
    INTEGER("int"),
    LONG("long"),
    DOUBLE("double"),
    RAW("raw"),
    VOID("void");

    private String name;
    private static final BasicType DEFAULT_BASIC_TYPE;

    private BasicType(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public static BasicType byName(String basicTypeName) {
        if (basicTypeName == null) {
            return DEFAULT_BASIC_TYPE;
        }
        for (BasicType basicType : BasicType.values()) {
            if (!basicType.getName().equals(basicTypeName)) continue;
            return basicType;
        }
        return DEFAULT_BASIC_TYPE;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public boolean isAtomic() {
        return true;
    }

    @Override
    public String sampleJSON(int levelOfDetail) {
        return this.sampleValue(levelOfDetail);
    }

    @Override
    public String sampleJSONWithEscapedQuotes(int levelOfDetail) {
        String result = this.sampleJSON(levelOfDetail);
        return result.toString().replaceAll("\"", Matcher.quoteReplacement("\\\""));
    }

    String sampleValue(int levelOfDetail) {
        switch (this.name) {
            case "string": {
                return "\"someText\"";
            }
            case "int": {
                return "\"42\"";
            }
            case "bool": {
                return "\"true\"";
            }
            case "long": {
                return "\"1.0\"";
            }
            case "raw": {
                return "\"TWFueSBoYW5kcyBtYWtlIGxpZ2h0IHdvcmsu\"";
            }
            case "void": {
                return "\"null\"";
            }
        }
        return "";
    }

    static {
        DEFAULT_BASIC_TYPE = VOID;
    }
}

