/*
 * Decompiled with CFR 0.152.
 */
package io.mdsl.generator.model;

import io.mdsl.exception.MDSLException;
import io.mdsl.generator.model.MDSLType;

public class DataTypeField {
    private static final String ANONYMOUS_KEY = "akey";
    private String name;
    private MDSLType type;
    private boolean list = false;
    private boolean nullable = false;

    public DataTypeField(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public MDSLType getType() {
        return this.type;
    }

    public String getTypeAsString() {
        return this.type.getName();
    }

    public boolean isList() {
        return this.list;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public void setType(MDSLType type) {
        this.type = type;
    }

    public void isList(boolean list) {
        this.list = list;
    }

    public void isNullable(boolean nullable) {
        this.nullable = nullable;
    }

    public String sampleJSON(int levelOfDetail) {
        switch (levelOfDetail) {
            case 0: {
                if (this.list) {
                    return ", \"" + this.name + "\": []";
                }
                if (this.nullable) {
                    return ", \"" + this.name + "\": {}";
                }
            }
            case 1: {
                if (this.list) {
                    return ", \"" + this.name + "\": [" + this.type.sampleJSON(levelOfDetail) + "]";
                }
                return ", \"" + this.name + "\":" + this.type.sampleJSON(levelOfDetail);
            }
            case 2: {
                if (this.list) {
                    return ", \"" + this.name + "\": [" + this.type.sampleJSON(levelOfDetail) + ", " + this.type.sampleJSON(levelOfDetail) + " ]";
                }
                return ", \"" + this.name + "\":" + this.type.sampleJSON(levelOfDetail);
            }
        }
        throw new MDSLException("Unsupported level of detail, try 0 or 1 or 2.");
    }
}

