/*
 * Decompiled with CFR 0.152.
 */
package io.mdsl.generator.model;

import com.google.common.collect.Lists;
import io.mdsl.generator.model.Operation;
import io.mdsl.generator.model.ProtocolBinding;
import io.mdsl.generator.model.StateTransition;
import io.mdsl.generator.model.UndefinedProtocol;
import java.util.List;

public class EndpointContract {
    private String name;
    private List<Operation> operations;
    private ProtocolBinding protocolBinding;
    private List<String> states;
    private List<StateTransition> transitions;

    public EndpointContract(String name) {
        this.name = name;
        this.operations = Lists.newLinkedList();
        this.protocolBinding = new UndefinedProtocol();
        this.states = Lists.newLinkedList();
        this.transitions = Lists.newLinkedList();
    }

    public String getName() {
        return this.name;
    }

    public List<Operation> getOperations() {
        return Lists.newLinkedList(this.operations);
    }

    public void addOperation(Operation operation) {
        this.operations.add(operation);
    }

    public void setProtocolBinding(ProtocolBinding protocolBinding) {
        if (protocolBinding != null) {
            this.protocolBinding = protocolBinding;
        }
    }

    public ProtocolBinding getProtocolBinding() {
        return this.protocolBinding;
    }

    public List<String> getStates() {
        return Lists.newLinkedList(this.states);
    }

    public void addState(String state) {
        this.states.add(state);
    }

    public List<StateTransition> getTransitions() {
        return Lists.newLinkedList(this.transitions);
    }

    public void addStateTransition(StateTransition transition) {
        this.transitions.add(transition);
    }
}

