/*
 * Decompiled with CFR 0.152.
 */
package io.mdsl.generator.model.composition;

import io.mdsl.generator.model.composition.CompositeCommand;
import io.mdsl.generator.model.composition.CompositeEvent;
import io.mdsl.generator.model.composition.Event;
import java.util.ArrayList;
import java.util.List;

public class Command {
    private static final String COMMA_SEPARATOR = ", ";
    private static final String CHOICE = "choiceOf";
    protected String name;
    private List<Event> emittedAlternativeEvents = new ArrayList<Event>();

    public Command(String name) {
        if (name == null || name.equals("")) {
            throw new IllegalArgumentException("Command name must not be null or empty.");
        }
        this.name = name;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Command)) {
            return false;
        }
        Command cmd = (Command)object;
        return this.name.equals(cmd.getName());
    }

    public String getType() {
        return "SIMPLE";
    }

    public String getName() {
        return this.name;
    }

    public void addEmittedEvents(List<Event> sinks, String operator) {
        this.emittedAlternativeEvents.addAll(sinks);
    }

    public String firstEmittedEventName() {
        if (this.emittedAlternativeEvents.size() > 0) {
            return this.emittedAlternativeEvents.get(0).getName();
        }
        throw new IllegalStateException("No emitted events present");
    }

    public boolean emitsSingleEvent() {
        return this.emittedAlternativeEvents.size() == 1;
    }

    public List<Event> getEmits() {
        return this.emittedAlternativeEvents;
    }

    public boolean emitsMultipleAlternativeEvents() {
        return this.emittedAlternativeEvents.size() > 1;
    }

    public boolean isComposite() {
        return this instanceof CompositeCommand;
    }

    public List<Command> getContainedCommands() {
        return new ArrayList<Command>();
    }

    public String getContainedCommandsAsCommaSeparatedList(String prefix) {
        return "";
    }

    public boolean emitsSingleCompositeEvent() {
        return this.emittedAlternativeEvents.size() == 1 && this.emittedAlternativeEvents.get(0) instanceof CompositeEvent;
    }

    public boolean emitsSingleSimpleEvent() {
        return this.emittedAlternativeEvents.size() == 1 && !(this.emittedAlternativeEvents.get(0) instanceof CompositeEvent);
    }

    public Event getSingleSimpleEvent() {
        if (this.emitsSingleSimpleEvent()) {
            return this.emittedAlternativeEvents.get(0);
        }
        throw new IllegalStateException("Expected command to emit single simple event.");
    }

    public Event getSingleCompositeEvent() {
        if (this.emitsSingleCompositeEvent()) {
            CompositeEvent ce = (CompositeEvent)this.emittedAlternativeEvents.get(0);
            return ce.getComposedEvents().get(0);
        }
        throw new IllegalStateException("Emitted event is not a composite.");
    }

    public String multipleAlternativeEventsAsCommaSeparatedList(String prefix) {
        List<Event> eventList = this.emittedAlternativeEvents;
        String result = this.prepareEventList(prefix, eventList);
        return result;
    }

    private String prepareEventList(String prefix, List<Event> eventList) {
        boolean isFirst = true;
        String result = "";
        for (Event event : eventList) {
            if (isFirst) {
                isFirst = false;
            } else {
                result = result + COMMA_SEPARATOR;
            }
            result = result + prefix + event.getName();
        }
        return result;
    }

    public String multipleConcurrentEventsAsCommaSeparatedList(String prefix) {
        Event joinEvent = this.getSingleCompositeEvent();
        return this.prepareEventList(prefix, joinEvent.getJoinedEvents());
    }

    public String getOptionValue() {
        return CHOICE + this.name;
    }

    public String toString() {
        StringBuffer result = new StringBuffer(" Command " + this.name);
        result.append(" emits " + this.emittedAlternativeEvents.size() + " event(s): ");
        this.emittedAlternativeEvents.forEach(event -> result.append(event.getName() + " (" + event.getClass().getSimpleName() + ") "));
        return result.toString() + "\n";
    }
}

