/*
 * Decompiled with CFR 0.152.
 */
package io.mdsl.generator.model.composition;

import io.mdsl.exception.MDSLException;
import io.mdsl.generator.model.composition.Command;
import io.mdsl.generator.model.composition.CompositeEvent;
import io.mdsl.generator.model.composition.Event;
import io.mdsl.generator.model.composition.JoinEvent;
import io.mdsl.generator.model.composition.views.Process;
import io.mdsl.transformations.TransformationHelpers;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class Flow {
    public static final String XOR_OPERATOR = "XOR";
    public static final String OR_OPERATOR = "OR";
    public static final String AND_OPERATOR = "AND";
    public static final String NO_OPERATOR = "SIMPLE";
    private String name;
    private ArrayList<Command> commands;
    private HashMap<String, Event> events;
    private Process processView = null;

    public Flow(String name) {
        this.name = name;
        this.commands = new ArrayList();
        this.events = new LinkedHashMap<String, Event>();
    }

    public String getName() {
        return this.name;
    }

    public List<Command> getCommands() {
        return this.commands;
    }

    public Process getProcessView() {
        if (this.processView == null) {
            this.processView = new Process(this);
        }
        return this.processView;
    }

    public HashMap<String, Event> getEvents() {
        return this.events;
    }

    public Collection<Event> getEventSet() {
        return this.events.values();
    }

    public List<Command> getInitCommands() {
        ArrayList<Command> emittedCommands = new ArrayList<Command>();
        for (Map.Entry<String, Event> eventEntry : this.events.entrySet()) {
            Event event = eventEntry.getValue();
            event.getTriggeredCommands().forEach(command -> emittedCommands.add((Command)command));
        }
        for (Command command2 : this.commands) {
            if (!command2.isComposite()) continue;
            emittedCommands.add(command2);
            command2.getContainedCommands().forEach(containedCommand -> emittedCommands.add((Command)containedCommand));
        }
        List result = (List)this.commands.clone();
        emittedCommands.forEach(command -> result.remove(command));
        return result;
    }

    public HashMap<String, Event> getInitEvents() {
        HashMap<String, Event> eventsComingFromCommands = new HashMap<String, Event>();
        for (Command command : this.commands) {
            for (Event emittedEvent : command.getEmits()) {
                eventsComingFromCommands.put(emittedEvent.getName(), emittedEvent);
                if (!(emittedEvent instanceof CompositeEvent)) continue;
                CompositeEvent andEvent = (CompositeEvent)emittedEvent;
                if (andEvent.getComposedEvents() == null || andEvent.getComposedEvents().size() != 1) {
                    throw new MDSLException("Unexpected structure/size of composite event " + emittedEvent.getName());
                }
                Event innerEvent = andEvent.getComposedEvents().get(0);
                if (innerEvent.getJoinedEvents() == null) {
                    throw new MDSLException("Unexpected structure/size of inner join event " + emittedEvent.getName());
                }
                innerEvent.getJoinedEvents().forEach(event -> eventsComingFromCommands.put(event.getName(), (Event)event));
            }
        }
        for (Map.Entry entry : this.events.entrySet()) {
            if (!(entry.getValue() instanceof JoinEvent)) continue;
            eventsComingFromCommands.put((String)entry.getKey(), (Event)entry.getValue());
        }
        HashMap result = (HashMap)this.events.clone();
        eventsComingFromCommands.entrySet().forEach(event -> result.remove(event.getKey()));
        return result;
    }

    public HashMap<String, Event> getTerminationEvents() {
        HashMap<String, Event> result = new HashMap<String, Event>();
        for (Map.Entry<String, Event> eventEntry : this.events.entrySet()) {
            if (eventEntry.getValue().getTriggeredCommands().size() != 0 || eventEntry.getValue() instanceof CompositeEvent || eventEntry.getValue() instanceof JoinEvent) continue;
            result.put(eventEntry.getKey(), eventEntry.getValue());
        }
        for (Map.Entry<String, Event> eventEntry : this.events.entrySet()) {
            if (!(eventEntry.getValue() instanceof JoinEvent)) continue;
            JoinEvent je = (JoinEvent)eventEntry.getValue();
            List<Event> jes = je.getJoinedEvents();
            for (Event event : jes) {
                result.remove(event.getName());
            }
        }
        return result;
    }

    public void addCommand(Command cmd) {
        if (cmd == null) {
            TransformationHelpers.reportWarning("Trying to add a null command to flow");
            return;
        }
        if (this.commandAlreadyPresent(cmd.getName())) {
            throw new IllegalArgumentException("Command has already been added");
        }
        this.commands.add(cmd);
    }

    public boolean commandAlreadyPresent(String commandName) {
        for (Command existingCommand : this.commands) {
            if (!existingCommand.getName().equals(commandName)) continue;
            return true;
        }
        return false;
    }

    public Command getCommand(String commandName) {
        for (Command existingCommand : this.commands) {
            if (!existingCommand.getName().equals(commandName)) continue;
            return existingCommand;
        }
        return null;
    }

    public void addEvent(Event ev) {
        if (!this.events.containsKey(ev.getName())) {
            this.events.put(ev.getName(), ev);
        } else {
            this.events.put(ev.getName(), ev);
            TransformationHelpers.reportWarning("Adding an event that has already been added: " + ev.name);
        }
    }

    public String toString() {
        StringBuffer result = new StringBuffer("Flow " + this.name + "\n");
        result.append("Number of events: " + this.events.size() + "\n");
        result.append("Number of commands: " + this.commands.size() + "\n");
        this.events.entrySet().forEach(event -> result.append(((Event)event.getValue()).toString()));
        this.commands.forEach(command -> result.append(command.toString()));
        return result.toString();
    }

    public String getCamelHeaderPrefix() {
        return "${header.";
    }
}

