/*
 * Decompiled with CFR 0.152.
 */
package io.mdsl.generator.model.composition.views;

import io.mdsl.exception.MDSLException;
import io.mdsl.generator.model.composition.Command;
import io.mdsl.generator.model.composition.Event;
import io.mdsl.generator.model.composition.Flow;
import io.mdsl.generator.model.composition.views.Path;
import io.mdsl.generator.model.composition.views.PathCollection;
import io.mdsl.generator.model.composition.views.PathElement;
import io.mdsl.transformations.TransformationHelpers;
import io.mdsl.utils.MDSLLogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Process {
    private static final String LOOP_INDICATOR = "-REPEAT";
    private static final String TERMINATION_STEP = "done";
    private Flow flow;
    HashMap<String, PathCollection> partialPathRepositoryForEvents = new HashMap();
    HashMap<String, PathCollection> rememberPathsStartingAtEvent = null;

    public Process(Flow flow) {
        this.flow = flow;
    }

    public int numberOfNodes() {
        return this.flow.getCommands().size() + this.flow.getEvents().size();
    }

    public int numberOfEdges() {
        return this.getAllPaths().numberOfInvocations();
    }

    public Path deepestPath() {
        PathCollection paths = new PathCollection();
        Path deepestPath = null;
        for (int i = 0; i < paths.size(); ++i) {
            Path path = paths.getPath(i);
            if (path.length() <= deepestPath.length()) continue;
            deepestPath = path;
        }
        return deepestPath;
    }

    public int deepestPathLength() {
        PathCollection paths = new PathCollection();
        int maxPathLengthSoFar = 0;
        for (int i = 0; i < paths.size(); ++i) {
            Path path = paths.getPath(i);
            if (path.length() <= maxPathLengthSoFar) continue;
            maxPathLengthSoFar = path.length();
        }
        return maxPathLengthSoFar;
    }

    private Collection<Event> getInitEvents() {
        return this.flow.getInitEvents().values();
    }

    public boolean initiatesFlow(Event event) {
        return this.flow.getInitEvents().get(event.getName()) != null;
    }

    public boolean initiatesFlow(Command command) {
        return this.flow.getInitCommands().contains(command);
    }

    public boolean terminatesFlow(Event event) {
        HashMap<String, Event> terminationEvents = this.flow.getTerminationEvents();
        return terminationEvents.get(event.getName()) != null;
    }

    public boolean terminatesFlow(Command command) {
        return command.getEmits().size() == 0 && !command.isComposite();
    }

    public List<Command> getTerminationCommands() {
        ArrayList<Command> terminators = new ArrayList<Command>();
        for (Command nextCommand : this.flow.getCommands()) {
            if (!this.terminatesFlow(nextCommand)) continue;
            terminators.add(nextCommand);
        }
        return terminators;
    }

    public boolean isNeitherInitiatingNorTerminatingFlow(Event event) {
        HashMap<String, Event> initEvents = this.flow.getInitEvents();
        if (initEvents == null || event == null || event.getName() == null) {
            throw new MDSLException("Cannot check event status, invalid event input");
        }
        if (initEvents.get(event.getName()) != null) {
            return false;
        }
        HashMap<String, Event> terminationEvents = this.flow.getTerminationEvents();
        return terminationEvents.get(event.getName()) == null;
    }

    public Collection<Event> triggeredBy(Command command) {
        ArrayList<Event> result = new ArrayList<Event>();
        for (Event event : this.flow.getEventSet()) {
            if (event.isJoin()) {
                List<Event> joinedEvents = event.getJoinedEvents();
                for (Event nextJoinedEvent : joinedEvents) {
                    if (!nextJoinedEvent.getTriggeredCommands().contains(command)) continue;
                    result.add(event);
                }
            }
            if (event.isComposite()) {
                List<Event> composedEvents = event.getComposedEvents();
                for (Event nextComposedEvent : composedEvents) {
                    if (!nextComposedEvent.getTriggeredCommands().contains(command)) continue;
                    result.add(event);
                }
            }
            if (!event.getTriggeredCommands().contains(command)) continue;
            result.add(event);
        }
        return result;
    }

    public boolean participatesInJoin(Event event) {
        return this.getAllJoinEventsWith(event).size() > 0;
    }

    private List<Event> getAllJoinEventsWith(Event event) {
        ArrayList<Event> result = new ArrayList<Event>();
        for (Map.Entry<String, Event> nextEvent : this.flow.getEvents().entrySet()) {
            if (!nextEvent.getValue().isJoin() || !nextEvent.getValue().getJoinedEvents().contains(event)) continue;
            result.add(nextEvent.getValue());
        }
        return result;
    }

    public String dumpAllPaths() {
        MDSLLogger.reportInformation("(dAP) Finding all paths.");
        PathCollection paths = this.getAllPaths();
        MDSLLogger.reportInformation("(dAP) Dump found paths.\n");
        if (paths != null) {
            return "Dumping flow \"" + this.flow.getName() + "\": \n\n" + paths.toString();
        }
        TransformationHelpers.reportWarning("Path collection is null/empty.");
        return null;
    }

    public PathCollection getAllPaths() {
        PathCollection result = new PathCollection();
        Collection<Event> initEvents = this.getInitEvents();
        for (Event initEvent : initEvents) {
            PathCollection nextSetOfEndToEndPaths = this.getDownstreamPathsOf(initEvent);
            result.mergeWithPathCollection(nextSetOfEndToEndPaths);
        }
        return result;
    }

    public static PathCollection createFreshPathCollection() {
        PathCollection newPathCollection = new PathCollection();
        Path initialPath = new Path();
        newPathCollection.addPath(initialPath);
        return newPathCollection;
    }

    public PathCollection getDownstreamPathsOf(Event event) {
        PathElement andTransition;
        PathCollection pathsFromCommand;
        MDSLLogger.reportInformation("(gDPoE) processing: " + event.getName());
        boolean alreadyVisited = this.partialPathRepositoryForEvents.containsKey(event.getName());
        PathCollection pathsForEvent = this.partialPathRepositoryForEvents.get(event.getName());
        if (alreadyVisited && pathsForEvent != null) {
            MDSLLogger.reportInformation("(gDPoE) path for: " + event.getName() + " already followed:" + pathsForEvent.dump(true));
            return pathsForEvent.cloneDeeply();
        }
        MDSLLogger.reportInformation("(gDPoE) path for: " + event.getName() + " creating empty alreadyVisited entry (null)");
        this.partialPathRepositoryForEvents.put(event.getName(), null);
        MDSLLogger.reportInformation("(gDPoE) continue processing: " + event.getName());
        PathCollection result = null;
        if (this.terminatesFlow(event)) {
            result = this.getSingleOneStepPathForTerminationEvent(event);
        } else if (event.triggersSingleSimpleCommand()) {
            MDSLLogger.reportInformation("(gDPoE) single simple command trigger found: " + event.getName());
            Command triggeredCommand = event.getSingleCommand();
            Iterator<Command> emission = new PathElement(event.getName(), triggeredCommand.getName());
            result = this.getDownstreamPathsOf(triggeredCommand);
            MDSLLogger.reportInformation("(gDPoE) (!!!) adding emission path element: " + event.getName() + " -> " + triggeredCommand.getName());
            result.insertAtStartOfAllPaths((PathElement)((Object)emission));
            MDSLLogger.reportInformation("(gDPoE) (???) addes emission path element: " + result.dump(true));
        } else if (event.triggersAndCommandComposition()) {
            MDSLLogger.reportInformation("(gDPoE) composed command trigger found (and): " + event.getName());
            List<Command> compositeCommands = event.getAndComposedCommands();
            result = Process.createFreshPathCollection();
            for (Command nextComposedCommand : compositeCommands) {
                pathsFromCommand = this.getDownstreamPathsOf(nextComposedCommand);
                andTransition = new PathElement(event.getName(), nextComposedCommand.getName());
                pathsFromCommand.addEmissionAtStartOfAllPaths(andTransition);
                result.mergeWithPathCollection(pathsFromCommand);
            }
        } else if (event.triggersOrCommandComposition()) {
            MDSLLogger.reportInformation("(gDPoE) alternative command trigger found (or, xor): " + event.getName());
            List<Command> triggeredCommands = event.getTriggeredCommands();
            result = Process.createFreshPathCollection();
            for (Command nextTriggeredCommand : triggeredCommands) {
                pathsFromCommand = this.getDownstreamPathsOf(nextTriggeredCommand);
                andTransition = new PathElement(event.getName(), nextTriggeredCommand.getName());
                pathsFromCommand.addEmissionAtStartOfAllPaths(andTransition);
                result.mergeWithPathCollection(pathsFromCommand);
            }
        } else if (event.getTriggeredCommands().size() == 0) {
            MDSLLogger.reportInformation(event.getName() + "(gDPoE) does not trigger any commands.");
            result = Process.createFreshPathCollection();
        } else {
            throw new MDSLException("Unknown or unsupported event type: " + event.getName());
        }
        if (this.participatesInJoin(event)) {
            MDSLLogger.reportInformation(event.getName() + " participates in one or more join events.");
            List<Event> joinEvents = this.getAllJoinEventsWith(event);
            PathCollection resultSoFar = result.cloneDeeply();
            result.clear();
            for (Event nextJoinEvent : joinEvents) {
                PathCollection nextPartialResult = this.combineAndClonePathsForJoinEventAggregation(resultSoFar, event, nextJoinEvent);
                result.mergeWithPathCollection(nextPartialResult);
            }
        }
        this.partialPathRepositoryForEvents.put(event.getName(), result.cloneDeeply());
        MDSLLogger.reportInformation("(gDPoE) path for: " + event.getName() + " updated in partialPathRepositoryForEvents" + result.dumpSizeInfo());
        return result;
    }

    private PathCollection combineAndClonePathsForJoinEventAggregation(PathCollection pathsUpToHere, Event launchingEvent, Event joinEvent) {
        PathCollection nextPaths;
        if (!this.alreadyVisitedBefore(joinEvent)) {
            MDSLLogger.reportInformation("(gDPoC) First time join event is visited: " + joinEvent.getName());
            nextPaths = this.getDownstreamPathsOf(joinEvent);
        } else {
            MDSLLogger.reportInformation("(gDPoC) Revisiting join event: " + joinEvent.getName());
            MDSLLogger.reportInformation(pathsUpToHere.dump(true));
            nextPaths = this.alreadyFoundsPathFor(joinEvent).cloneDeeply();
            MDSLLogger.reportInformation("(gDPoC) Found: " + nextPaths.dump(true));
        }
        PathElement aggregation = new PathElement(launchingEvent.getName(), joinEvent.getName());
        nextPaths.addEmissionAtStartOfAllPaths(aggregation);
        return nextPaths;
    }

    public PathCollection getDownstreamPathsOf(Command command) {
        if (command.isComposite()) {
            MDSLLogger.reportInformation("(gDPoC) processing composite command " + command.getName());
            List<Command> composedCommands = command.getContainedCommands();
            PathCollection pathStartingHere = Process.createFreshPathCollection();
            for (Command nextComposedCommand : composedCommands) {
                PathCollection pathsFromCommand = this.getDownstreamPathsOf(nextComposedCommand);
                pathStartingHere.mergeWithPathCollection(pathsFromCommand);
            }
            return pathStartingHere;
        }
        if (command.emitsSingleSimpleEvent()) {
            MDSLLogger.reportInformation("(gDPoC) processing single simple even emission in command " + command.getName());
            Event emittedEvent = command.getSingleSimpleEvent();
            PathCollection pathStartingAtEmittedEvent = this.visitIfNotAlreadyDoneOrGoingOn(emittedEvent, command.getName());
            return pathStartingAtEmittedEvent;
        }
        if (command.emitsSingleCompositeEvent()) {
            MDSLLogger.reportInformation("(gDPoC) processing single composite event emission (and) in command " + command.getName());
            Event joinEvent = command.getSingleCompositeEvent();
            List<Event> emittedEvents = joinEvent.getJoinedEvents();
            PathCollection pathStartingHere = Process.createFreshPathCollection();
            for (Event emittedEvent : emittedEvents) {
                PathCollection pathStartingAtEmittedEvent = this.visitIfNotAlreadyDoneOrGoingOn(emittedEvent, command.getName());
                pathStartingHere.mergeWithPathCollection(pathStartingAtEmittedEvent);
            }
            return pathStartingHere;
        }
        if (command.emitsMultipleAlternativeEvents()) {
            MDSLLogger.reportInformation("(gDPoC) processing multiple event emission (or, xor) in command " + command.getName());
            List<Event> emittedEvents = command.getEmits();
            PathCollection pathsStartingHere = Process.createFreshPathCollection();
            for (Event emittedEvent : emittedEvents) {
                PathCollection pathStartingAtEmittedEvent = this.visitIfNotAlreadyDoneOrGoingOn(emittedEvent, command.getName());
                PathCollection copy = pathStartingAtEmittedEvent.cloneDeeply();
                pathsStartingHere.mergeWithPathCollection(copy);
                pathStartingAtEmittedEvent.clear();
            }
            return pathsStartingHere;
        }
        if (this.terminatesFlow(command)) {
            MDSLLogger.reportInformation("(gDPoC) command that terminates flow reached, noop: " + command.getName());
            return Process.createFreshPathCollection();
        }
        throw new MDSLException("Unknown or unsupported command type: " + command.getName());
    }

    private PathCollection getSingleOneStepPathForTerminationEvent(Event event) {
        PathCollection result = Process.createFreshPathCollection();
        PathElement flowEnds = new PathElement(event.getName(), TERMINATION_STEP);
        result.addEmissionToAllPaths(flowEnds);
        PathCollection flowEndPC = new PathCollection();
        Path flowEndPath = new Path();
        flowEndPath.addEmission(flowEnds);
        flowEndPC.addPath(flowEndPath);
        return result;
    }

    private PathCollection visitIfNotAlreadyDoneOrGoingOn(Event emittedEvent, String originatingNode) {
        PathCollection pathStartingAtEmittedEvent;
        if (!this.alreadyBeingVisited(emittedEvent)) {
            MDSLLogger.reportInformation("(gDPoC) processing event is ongoing already: " + emittedEvent.getName());
            pathStartingAtEmittedEvent = this.getDownstreamPathsOf(emittedEvent);
        } else if (!this.alreadyVisitedBefore(emittedEvent)) {
            MDSLLogger.reportInformation("(gDPoC) not processing event again, has been done already: " + emittedEvent.getName());
            pathStartingAtEmittedEvent = this.alreadyFoundsPathFor(emittedEvent);
            pathStartingAtEmittedEvent = pathStartingAtEmittedEvent == null ? Process.createFreshPathCollection() : pathStartingAtEmittedEvent.cloneDeeply();
            PathElement continuationMarker = new PathElement(originatingNode, "GOTO-" + emittedEvent.getName());
            pathStartingAtEmittedEvent.addEmissionAtStartOfAllPaths(continuationMarker);
        } else {
            MDSLLogger.reportInformation("(gDPoC) not been there before, so will process event now: " + emittedEvent.getName());
            pathStartingAtEmittedEvent = this.getDownstreamPathsOf(emittedEvent);
        }
        return pathStartingAtEmittedEvent;
    }

    public boolean alreadyBeingVisited(Event event) {
        return this.partialPathRepositoryForEvents.containsKey(event.getName()) && this.partialPathRepositoryForEvents.get(event.getName()) == null;
    }

    public boolean alreadyVisitedBefore(Event event) {
        return this.partialPathRepositoryForEvents.containsKey(event.getName()) && this.partialPathRepositoryForEvents.get(event.getName()) != null;
    }

    private PathCollection alreadyFoundsPathFor(Event event) {
        return this.partialPathRepositoryForEvents.get(event.getName());
    }
}

