/*
 * Decompiled with CFR 0.152.
 */
package io.mdsl.generator.model.converter;

import io.mdsl.apiDescription.Consumption;
import io.mdsl.exception.MDSLException;
import io.mdsl.generator.model.Client;
import io.mdsl.generator.model.EndpointContract;
import io.mdsl.generator.model.MDSLGeneratorModel;
import java.util.List;
import java.util.Optional;

public class ClientConverter {
    private MDSLGeneratorModel genModel;

    public ClientConverter(MDSLGeneratorModel genModel) {
        this.genModel = genModel;
    }

    public Client convert(io.mdsl.apiDescription.Client mdslClient) {
        Client client = new Client(mdslClient.getName());
        this.mapEndpoints(client, (List<Consumption>)mdslClient.getCons());
        return client;
    }

    private void mapEndpoints(Client client, List<Consumption> consumptions) {
        for (Consumption consumption : consumptions) {
            Optional<EndpointContract> correspondingEndpoint = this.genModel.getEndpoints().stream().filter(e -> e.getName().equals(consumption.getContract().getName())).findFirst();
            if (correspondingEndpoint.isEmpty()) {
                throw new MDSLException("MDSL error: a client consumes an endpoint that does not exist!");
            }
            client.addEndpoint(correspondingEndpoint.get());
        }
    }
}

