/*
 * Decompiled with CFR 0.152.
 */
package io.mdsl.generator.model.converter;

import io.mdsl.apiDescription.CombinedInvocationStep;
import io.mdsl.apiDescription.CommandInvokation;
import io.mdsl.apiDescription.CommandInvokationStep;
import io.mdsl.apiDescription.CommandType;
import io.mdsl.apiDescription.DomainEventProductionStep;
import io.mdsl.apiDescription.EventProduction;
import io.mdsl.apiDescription.EventType;
import io.mdsl.apiDescription.FlowStep;
import io.mdsl.apiDescription.Orchestration;
import io.mdsl.exception.MDSLException;
import io.mdsl.generator.model.MDSLGeneratorModel;
import io.mdsl.generator.model.composition.Command;
import io.mdsl.generator.model.composition.CompositeEvent;
import io.mdsl.generator.model.composition.Event;
import io.mdsl.generator.model.composition.Flow;
import io.mdsl.generator.model.composition.JoinEvent;
import io.mdsl.transformations.TransformationHelpers;
import io.mdsl.utils.MDSLLogger;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;

public class OrchestrationConverter {
    public OrchestrationConverter(MDSLGeneratorModel genModel) {
    }

    public Flow convert(Orchestration mdslOrchestrationFlow) {
        Flow oflow = this.mapSteps(mdslOrchestrationFlow);
        return oflow;
    }

    private Flow mapSteps(Orchestration mdslOrchestrationFlow) {
        EList<FlowStep> steps = mdslOrchestrationFlow.getSteps();
        Flow oflow = new Flow(mdslOrchestrationFlow.getName());
        for (FlowStep flowStep : steps) {
            CombinedInvocationStep ece;
            DomainEventProductionStep dep;
            CommandInvokationStep cis = flowStep.getCisStep();
            if (cis != null) {
                this.mapCommandInvocationStep(oflow, cis);
            }
            if ((dep = flowStep.getDepStep()) != null) {
                this.mapDomainEventProductionStep(oflow, dep);
            }
            if ((ece = flowStep.getEceStep()) == null) continue;
            cis = ece.getCisStep();
            this.mapCommandInvocationStep(oflow, cis);
            EventProduction ep = ece.getEventProduction();
            ArrayList cmdTypes = new ArrayList();
            CommandInvokation ci = cis.getAction().getCi();
            if (ci != null) {
                EList<CommandType> commandList = null;
                if (ci.getSci() != null) {
                    commandList = ci.getSci().getCommands();
                    for (CommandType command : commandList) {
                        this.mapEventProductionStep(oflow, command, ep);
                    }
                    continue;
                }
                TransformationHelpers.reportWarning("Combined invocation steps must have one and only one command.");
                continue;
            }
            TransformationHelpers.reportWarning("Combined invocation step: subprocess not supported.");
        }
        return oflow;
    }

    private void mapDomainEventProductionStep(Flow oflow, DomainEventProductionStep dep) {
        this.mapEventProductionStep(oflow, dep.getAction().getCommand(), dep.getEventProduction());
    }

    private void mapEventProductionStep(Flow oflow, CommandType mdslCommand, EventProduction ep) {
        if (ep == null) {
            return;
        }
        EList<EventType> events = null;
        String operator = null;
        if (ep.getSep() != null) {
            events = ep.getSep().getEvents();
            operator = "SIMPLE";
        } else if (ep.getMep() != null) {
            events = ep.getMep().getEvents();
            operator = "AND";
        } else if (ep.getEaep() != null) {
            events = ep.getEaep().getEvents();
            operator = "XOR";
        } else if (ep.getIaep() != null) {
            events = ep.getIaep().getEvents();
            operator = "OR";
        } else {
            throw new IllegalArgumentException("mapCombinedEventProduction: Unsupported event production option");
        }
        ArrayList<Event> sinks = new ArrayList<Event>();
        if (events.size() > 1) {
            if (operator.equals("AND")) {
                String compositeEventName = JoinEvent.joinEventNameFor(events, operator);
                Event genModelEvent = this.findEvent(oflow, compositeEventName);
                if (genModelEvent == null) {
                    ArrayList<Event> genModelEvents = new ArrayList<Event>();
                    events.forEach(mdslEvent -> genModelEvents.add(this.findOrCreateSingleEvent(oflow, (EventType)mdslEvent)));
                    JoinEvent joinEvent = new JoinEvent((String)compositeEventName + "InnerJoinEvent", genModelEvents, operator);
                    ArrayList<Event> glueList = new ArrayList<Event>();
                    glueList.add(joinEvent);
                    genModelEvent = new CompositeEvent(compositeEventName, glueList, operator);
                    oflow.addEvent(genModelEvent);
                }
                sinks.add(genModelEvent);
            } else if (operator.equals("OR") || operator.equals("XOR")) {
                for (EventType event : events) {
                    Event genModelEvent = this.findOrCreateSingleEvent(oflow, event);
                    sinks.add(genModelEvent);
                }
            }
        } else if (events.size() == 1) {
            Event genModelEvent = this.findOrCreateSingleEvent(oflow, (EventType)events.get(0));
            sinks.add(genModelEvent);
        } else {
            throw new IllegalAccessError("Size of events is " + events.size());
        }
        Command cmd = this.findOrCreateCommand(oflow, mdslCommand);
        cmd.addEmittedEvents(sinks, operator);
    }

    private Event findOrCreateSingleEvent(Flow oflow, EventType event) {
        Event genModelEvent = this.findEvent(oflow, event.getName());
        if (genModelEvent == null) {
            genModelEvent = new Event(event.getName());
            oflow.addEvent(genModelEvent);
        }
        return genModelEvent;
    }

    private List<Command> mapCommandInvocationStep(Flow oflow, CommandInvokationStep cis) {
        Event joinEvent;
        String commandOperator = "tbd";
        String eventOperator = "SIMPLE";
        ArrayList<Command> genModelCommands = new ArrayList<Command>();
        EList<EventType> triggeringEvents = cis.getEvents();
        EList<CommandType> invokedCommands = null;
        if (cis.getAction().getCi().getSci() != null) {
            invokedCommands = cis.getAction().getCi().getSci().getCommands();
            commandOperator = "SIMPLE";
        } else if (cis.getAction().getCi().getCci() != null) {
            invokedCommands = cis.getAction().getCi().getCci().getCommands();
            commandOperator = "AND";
        } else if (cis.getAction().getCi().getEaci() != null) {
            invokedCommands = cis.getAction().getCi().getEaci().getCommands();
            commandOperator = "XOR";
        } else if (cis.getAction().getCi().getIaci() != null) {
            invokedCommands = cis.getAction().getCi().getIaci().getCommands();
            commandOperator = "OR";
        } else if (cis.getAction().getSpi() != null) {
            MDSLLogger.reportWarning("Subprocesses are not supported in the generator model, but direct grammar access is available.");
        } else {
            throw new MDSLException("Unknown/unsupported type of command invocation step");
        }
        for (CommandType mdslCommand : invokedCommands) {
            Command command = this.findOrCreateCommand(oflow, mdslCommand);
            genModelCommands.add(command);
        }
        if (triggeringEvents.size() == 1) {
            joinEvent = this.findEvent(oflow, ((EventType)triggeringEvents.get(0)).getName());
            Command command = null;
            if (joinEvent == null) {
                joinEvent = new Event(((EventType)triggeringEvents.get(0)).getName());
                command = joinEvent.addTriggeredCommands(genModelCommands, commandOperator);
                oflow.addEvent(joinEvent);
            } else {
                command = joinEvent.addTriggeredCommands(genModelCommands, commandOperator);
            }
            if (command != null && !oflow.commandAlreadyPresent(command.getName())) {
                oflow.addCommand(command);
            }
        } else if (triggeringEvents.size() >= 1) {
            eventOperator = "AND";
            String eventName = JoinEvent.joinEventNameFor(triggeringEvents, eventOperator);
            joinEvent = this.findEvent(oflow, eventName);
            if (joinEvent == null) {
                ArrayList<Event> genModelEvents = new ArrayList<Event>();
                for (EventType trigger : triggeringEvents) {
                    genModelEvents.add(new Event(trigger.getName()));
                }
                joinEvent = new JoinEvent(eventName, genModelEvents, eventOperator);
                Command andCommand = joinEvent.addTriggeredCommands(genModelCommands, commandOperator);
                oflow.addCommand(andCommand);
                oflow.addEvent(joinEvent);
            } else {
                joinEvent.addTriggeredCommands(genModelCommands, commandOperator);
            }
        } else {
            throw new MDSLException("Unexpected number of triggering events: " + triggeringEvents.size());
        }
        return genModelCommands;
    }

    private Command findOrCreateCommand(Flow oflow, CommandType command) {
        Command result;
        if (oflow.commandAlreadyPresent(command.getName())) {
            result = oflow.getCommand(command.getName());
        } else {
            Command genModelCommand = new Command(command.getName());
            oflow.addCommand(genModelCommand);
            result = genModelCommand;
        }
        return result;
    }

    private Event findEvent(Flow oflow, String eventName) {
        if (oflow.getEvents().containsKey(eventName)) {
            return oflow.getEvents().get(eventName);
        }
        return null;
    }
}

