/*
 * Decompiled with CFR 0.152.
 */
package io.mdsl.generator.openapi.converter;

import com.google.common.collect.Lists;
import io.mdsl.apiDescription.AtomicParameter;
import io.mdsl.apiDescription.Cardinality;
import io.mdsl.apiDescription.ElementStructure;
import io.mdsl.apiDescription.GenericParameter;
import io.mdsl.apiDescription.HTTPParameter;
import io.mdsl.apiDescription.ParameterTree;
import io.mdsl.apiDescription.PatternStereotype;
import io.mdsl.apiDescription.RoleAndType;
import io.mdsl.apiDescription.SingleParameterNode;
import io.mdsl.apiDescription.TypeReference;
import io.mdsl.dsl.ServiceSpecificationAdapter;
import io.mdsl.exception.MDSLException;
import io.mdsl.generator.openapi.converter.DataType2SchemaConverter;
import io.mdsl.utils.MDSLLogger;
import io.mdsl.utils.MDSLSpecificationWrapper;
import io.swagger.v3.oas.models.media.ArraySchema;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;

public class DataType2ParameterConverter {
    private static final String PARAMETER_PREFIX = "Parameter";
    private static final String ANONYMOUS_TREE_IDENTIFIER = "anonymousTree";
    private int anonymousParameterCounter = 1;
    private DataType2SchemaConverter schemaConverter = new DataType2SchemaConverter();
    private MDSLSpecificationWrapper mdslResolver;

    public DataType2ParameterConverter(ServiceSpecificationAdapter mdslSpecification) {
        this.mdslResolver = new MDSLSpecificationWrapper(mdslSpecification);
    }

    public Parameter convertParameterTree(ParameterTree pt, HTTPParameter boundParameter, boolean externalCardinality) {
        if (pt == null) {
            return null;
        }
        Schema treeSchema = this.schemaConverter.convertAndCreateSchema4ParameterTreeAndItsNodes(pt, externalCardinality);
        String treeName = pt.getName() != null ? pt.getName() : ANONYMOUS_TREE_IDENTIFIER;
        Parameter deepObjectForTree = new Parameter().name(treeName).in(this.convertParameterTypeToOpenAPIValue(boundParameter));
        deepObjectForTree.schema(treeSchema);
        if (boundParameter == HTTPParameter.QUERY) {
            deepObjectForTree.style(Parameter.StyleEnum.DEEPOBJECT);
        } else if (boundParameter == HTTPParameter.PATH) {
            MDSLLogger.reportWarning("Mapping a PATH parameter to a deep object: " + pt.getName());
            deepObjectForTree.style(Parameter.StyleEnum.DEEPOBJECT);
        } else if (boundParameter == HTTPParameter.COOKIE) {
            deepObjectForTree.style(Parameter.StyleEnum.FORM);
        } else if (boundParameter == HTTPParameter.HEADER) {
            MDSLLogger.reportWarning("Mapping a HEADER parameter to to a deep object: " + pt.getName());
            deepObjectForTree.style(Parameter.StyleEnum.DEEPOBJECT);
        } else if (boundParameter == HTTPParameter.BODY) {
            MDSLLogger.reportError("Mapping a BODY parameter to style MATRIX: " + pt.getName());
            deepObjectForTree.style(Parameter.StyleEnum.MATRIX);
        } else {
            MDSLLogger.reportError("Unexpected parameter type: " + (Object)((Object)boundParameter));
        }
        deepObjectForTree.explode(Boolean.valueOf(true));
        return deepObjectForTree;
    }

    private List<Parameter> convertAtomicParameterList(List<AtomicParameter> atomicParameters, HTTPParameter boundParameter) {
        return atomicParameters.stream().map(ap -> this.convertAtomicParameter((AtomicParameter)ap, boundParameter)).collect(Collectors.toList());
    }

    private Parameter convertAtomicParameter(AtomicParameter atomicParameter, HTTPParameter parameterType) {
        RoleAndType roleAndType = atomicParameter.getRat();
        PatternStereotype classifier = atomicParameter.getClassifier();
        String parameterDescription = MDSLSpecificationWrapper.getClassifierAndElementStereotype(classifier, roleAndType);
        boolean required = this.findOutWhetherParameterIsRequired(atomicParameter);
        String inValue = this.convertParameterTypeToOpenAPIValue(parameterType);
        Parameter result = null;
        Cardinality card = atomicParameter.getCard();
        if (card != null && (card.getZeroOrOne() != null || card.getAtLeastOne() != null)) {
            ArraySchema arraySchema = new ArraySchema();
            Schema schema = this.schemaConverter.convert(atomicParameter);
            if (schema != null) {
                arraySchema.items(schema);
                result = new Parameter().name(this.getUniqueName(roleAndType.getName())).in(inValue).description(parameterDescription).required(Boolean.valueOf(required)).schema((Schema)arraySchema);
            }
        } else {
            Schema schema = this.schemaConverter.convert(atomicParameter);
            if (schema != null) {
                result = new Parameter().name(this.getUniqueName(roleAndType.getName())).in(inValue).description(parameterDescription).required(Boolean.valueOf(required)).schema(schema);
            }
        }
        return result;
    }

    private boolean findOutWhetherParameterIsRequired(AtomicParameter atomicParameter) {
        boolean required = true;
        Cardinality card = atomicParameter.getCard();
        if (card != null && (card.getZeroOrOne() != null || card.getZeroOrMore() != null)) {
            required = false;
        }
        return required;
    }

    public Parameter convertGenericParameter(GenericParameter genP, HTTPParameter paramType) {
        String parameterDescription = "Generic Parameter " + genP.getName();
        String inValue = this.convertParameterTypeToOpenAPIValue(paramType);
        Parameter result = null;
        Schema<?> schema = this.schemaConverter.convert(genP);
        if (schema != null) {
            result = new Parameter().name(this.getUniqueName(genP.getName())).in(inValue).description(parameterDescription).schema(schema);
            result.setDescription(parameterDescription);
        }
        return result;
    }

    private Parameter convertTypeReference(TypeReference tr, HTTPParameter parameterBinding) {
        PatternStereotype classifier = tr.getClassifier();
        String parameterDescription = "Type reference " + tr.getName();
        String inValue = this.convertParameterTypeToOpenAPIValue(parameterBinding);
        Parameter result = null;
        Schema schema = this.schemaConverter.createSchemaForTypeReference(tr);
        if (schema != null) {
            result = new Parameter().name(this.getUniqueName(tr.getName())).in(inValue).description(parameterDescription).schema(schema);
            result.setDescription(parameterDescription);
        }
        return result;
    }

    public String convertParameterTypeToOpenAPIValue(HTTPParameter parameter) {
        if (parameter == null) {
            MDSLLogger.reportWarning("Returning a parameter in value of 'query' although parameter is not bound (null value of parameter)");
            return "query";
        }
        if (parameter == HTTPParameter.QUERY) {
            return "query";
        }
        if (parameter == HTTPParameter.HEADER) {
            return "header";
        }
        if (parameter == HTTPParameter.PATH) {
            return "path";
        }
        if (parameter == HTTPParameter.COOKIE) {
            return "cookie";
        }
        if (parameter == HTTPParameter.BODY) {
            throw new MDSLException("BODY is an unsupported mapping type");
        }
        throw new MDSLException("Unsupported mapping type " + parameter.getLiteral());
    }

    private String getUniqueName(String originalName) {
        if (originalName != null && !"".equals(originalName)) {
            return originalName;
        }
        String anonymousName = PARAMETER_PREFIX + this.anonymousParameterCounter;
        ++this.anonymousParameterCounter;
        return anonymousName;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<Parameter> convertSingleRepresentationElementToOneOrMoreParameters(ElementStructure structure, HTTPParameter boundParameter) {
        LinkedList atomicParameterList = Lists.newLinkedList();
        if (structure.getApl() != null) {
            atomicParameterList.add(structure.getApl().getFirst());
            atomicParameterList.addAll(structure.getApl().getNextap());
            return this.convertAtomicParameterList(atomicParameterList, boundParameter);
        } else if (structure.getNp() != null && structure.getNp().getAtomP() != null) {
            atomicParameterList.add(structure.getNp().getAtomP());
            return this.convertAtomicParameterList(atomicParameterList, boundParameter);
        } else {
            if (structure.getNp() != null && structure.getNp().getTr() != null) {
                return this.convertSingleRepresentationElementToOneOrMoreParameters(structure.getNp().getTr().getDcref().getStructure(), boundParameter);
            }
            if (structure.getPt() == null) throw new MDSLException("Parameter cannot be mapped, please simplify or extend it.");
            if (this.mdslResolver.isParameterTreeAtomic(structure.getPt())) {
                atomicParameterList.addAll(this.mdslResolver.collectAtomicParameters(structure.getPt()));
                return this.convertAtomicParameterList(atomicParameterList, boundParameter);
            } else {
                ArrayList<Parameter> pl = new ArrayList<Parameter>();
                pl.add(this.convertParameterTree(structure.getPt(), boundParameter, false));
                return pl;
            }
        }
    }

    public List<Parameter> convertAtomicParameterToOneParameter(AtomicParameter ap, HTTPParameter parameterBinding) {
        ArrayList<Parameter> result = new ArrayList<Parameter>();
        Parameter convertedAtom = this.convertAtomicParameter(ap, parameterBinding);
        if (convertedAtom != null) {
            result.add(convertedAtom);
        }
        return result;
    }

    public List<Parameter> convertSingleParameterNodeToOneParameter(SingleParameterNode spn, HTTPParameter parameterBinding) {
        ArrayList<Parameter> result = new ArrayList<Parameter>();
        if (spn.getAtomP() != null) {
            Parameter convertedAtom = this.convertAtomicParameter(spn.getAtomP(), parameterBinding);
            if (convertedAtom != null) {
                result.add(convertedAtom);
            }
            return result;
        }
        if (spn.getGenP() != null) {
            Parameter convertedAtom = this.convertGenericParameter(spn.getGenP(), parameterBinding);
            if (convertedAtom != null) {
                result.add(convertedAtom);
            }
            return result;
        }
        if (spn.getTr() != null) {
            Parameter convertedAtom = this.convertTypeReference(spn.getTr(), parameterBinding);
            result.add(convertedAtom);
            return result;
        }
        return null;
    }
}

