/*
 * Decompiled with CFR 0.152.
 */
package io.mdsl.generator.openapi.converter;

import io.mdsl.apiDescription.ApiDescriptionFactory;
import io.mdsl.apiDescription.AtomicParameter;
import io.mdsl.apiDescription.ElementStructure;
import io.mdsl.apiDescription.EndpointContract;
import io.mdsl.apiDescription.Event;
import io.mdsl.apiDescription.GenericParameter;
import io.mdsl.apiDescription.HTTPOperationBinding;
import io.mdsl.apiDescription.HTTPParameter;
import io.mdsl.apiDescription.HTTPResourceBinding;
import io.mdsl.apiDescription.ParameterTree;
import io.mdsl.apiDescription.SecurityBinding;
import io.mdsl.apiDescription.SecurityPolicies;
import io.mdsl.apiDescription.SecurityPolicy;
import io.mdsl.apiDescription.SingleParameterNode;
import io.mdsl.apiDescription.StatusReport;
import io.mdsl.apiDescription.StatusReports;
import io.mdsl.apiDescription.TreeNode;
import io.mdsl.apiDescription.TypeReference;
import io.mdsl.dsl.ServiceSpecificationAdapter;
import io.mdsl.exception.MDSLException;
import io.mdsl.generator.openapi.converter.DataType2ParameterConverter;
import io.mdsl.generator.openapi.converter.DataType2SchemaConverter;
import io.mdsl.generator.openapi.converter.HTTPBindingConverterHelpers;
import io.mdsl.generator.openapi.converter.MDSL2OpenAPIConverter;
import io.mdsl.utils.MAPLinkResolver;
import io.mdsl.utils.MDSLLogger;
import io.mdsl.utils.MDSLSpecificationWrapper;
import io.swagger.v3.oas.models.Operation;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.media.Content;
import io.swagger.v3.oas.models.media.MediaType;
import io.swagger.v3.oas.models.media.Schema;
import io.swagger.v3.oas.models.parameters.Parameter;
import io.swagger.v3.oas.models.parameters.RequestBody;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.responses.ApiResponses;
import io.swagger.v3.oas.models.security.SecurityRequirement;
import io.swagger.v3.oas.models.tags.Tag;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.emf.common.util.EList;

public class Endpoint2PathConverter {
    private static final String CORRECTIVE_ACTION_TEXT = ". Rename operation to start with 'create', 'read', 'update', 'delete', add decorators (MAP responsibilities or HTTP verbs), assign MAP decorator, or bind to multiple resources.";
    private static final String METHOD_SUFFIX = " method)";
    private static final String DEFAULT_RESPONSE_NAME = "200";
    private static final String NO_RETURN_VALUE = "no return value";
    private static final String SUCCESSFUL_EXECUTION = " successful execution";
    private static final String X_999_CODE = "x-999";
    private static final String TBD_TEXT = "tbd";
    private DataType2SchemaConverter dataType2SchemaConverter = new DataType2SchemaConverter();
    private DataType2ParameterConverter dataType2ParameterConverter;
    private MDSL2OpenAPIConverter mdsl2OpenAPIConverter;
    private MDSLSpecificationWrapper mdslWrapper;
    private EndpointContract endpointType;
    private io.mdsl.apiDescription.Operation mdslOperation;
    private HTTPResourceBinding httpBinding;
    private PathItem.HttpMethod httpVerb;
    private List<String> mediaTypes = null;
    private Operation oasOperation;
    private boolean eventMappingEnabled = false;

    public Endpoint2PathConverter(ServiceSpecificationAdapter apiDescriptionToBeConverted, MDSL2OpenAPIConverter mdsl2OpenAPIConverter) {
        this.dataType2ParameterConverter = new DataType2ParameterConverter(apiDescriptionToBeConverted);
        this.mdslWrapper = new MDSLSpecificationWrapper(apiDescriptionToBeConverted);
        this.mdsl2OpenAPIConverter = mdsl2OpenAPIConverter;
    }

    public PathItem convertMetadataAndOperations(EndpointContract endpointType, HTTPResourceBinding binding) {
        PathItem pathItemForResource;
        block7: {
            HashMap<PathItem.HttpMethod, String> alreadyUsedVerbs;
            block6: {
                this.endpointType = endpointType;
                this.httpBinding = binding;
                pathItemForResource = new PathItem();
                pathItemForResource.setSummary(MAPLinkResolver.explainRolePattern(endpointType));
                alreadyUsedVerbs = new HashMap<PathItem.HttpMethod, String>();
                if (this.httpBinding != null) break block6;
                for (io.mdsl.apiDescription.Operation operation : endpointType.getOps()) {
                    this.httpVerb = HTTPBindingConverterHelpers.mapMethod(operation, this.httpBinding);
                    if (alreadyUsedVerbs.containsKey(this.httpVerb)) {
                        throw new MDSLException("Mapping conflict in default resource  (" + operation.getName() + "): operation " + (String)alreadyUsedVerbs.get(this.httpVerb) + " already maps to " + this.httpVerb.toString() + CORRECTIVE_ACTION_TEXT);
                    }
                    alreadyUsedVerbs.put(this.httpVerb, operation.getName());
                    pathItemForResource.operation(this.httpVerb, this.convertOperation(operation));
                }
                if (!this.eventMappingEnabled) break block7;
                for (Event event : endpointType.getEvents()) {
                    this.addEventToDescription(pathItemForResource, event);
                    pathItemForResource.operation(PathItem.HttpMethod.POST, this.convertEvent(event, PathItem.HttpMethod.POST));
                }
                break block7;
            }
            for (io.mdsl.apiDescription.Operation operation : endpointType.getOps()) {
                this.httpVerb = HTTPBindingConverterHelpers.mapMethod(operation, this.httpBinding);
                HTTPOperationBinding opb = HTTPBindingConverterHelpers.findOperationBindingFor(operation.getName(), this.httpBinding);
                if (opb == null) {
                    MDSLLogger.reportInformation("Operation " + operation.getName() + " not bound in resource " + binding.getName());
                    continue;
                }
                MDSLLogger.reportInformation("Operation " + operation.getName() + " bound in resource " + binding.getName());
                PathItem.HttpMethod verb = HTTPBindingConverterHelpers.mapMethod(operation, binding);
                if (alreadyUsedVerbs.containsKey(verb)) {
                    throw new MDSLException("Mapping conflict in resource " + binding.getName() + " (" + operation.getName() + "): operation " + (String)alreadyUsedVerbs.get(verb) + " already maps to " + verb.toString() + CORRECTIVE_ACTION_TEXT);
                }
                alreadyUsedVerbs.put(verb, operation.getName());
                pathItemForResource.operation(verb, this.convertOperation(operation));
            }
        }
        return pathItemForResource;
    }

    private Operation convertOperation(io.mdsl.apiDescription.Operation mdslOperation) {
        this.mdslOperation = mdslOperation;
        this.oasOperation = new Operation();
        if (this.httpBinding != null) {
            this.oasOperation.setOperationId(this.httpBinding.getName() + '-' + mdslOperation.getName());
        } else {
            this.oasOperation.setOperationId(mdslOperation.getName());
        }
        String stateImpactText = MAPLinkResolver.explainResponsibilityPattern(mdslOperation);
        if (stateImpactText != null && !stateImpactText.equals("")) {
            this.oasOperation.setSummary(mdslOperation.getName() + " (" + MAPLinkResolver.explainResponsibilityPattern(mdslOperation) + METHOD_SUFFIX);
        } else {
            this.oasOperation.setSummary(mdslOperation.getName());
        }
        this.oasOperation.setDescription(MAPLinkResolver.specifyResponsibilityWithMAPLinkIfPossible(mdslOperation));
        ArrayList<String> tags = new ArrayList<String>();
        Tag rtag = this.mdsl2OpenAPIConverter.createTag(this.endpointType, this.httpBinding, false);
        tags.add(rtag.getName());
        this.oasOperation.setTags(tags);
        this.convertRequestMessage();
        this.convertResponseMessages();
        List<SecurityRequirement> securityRequrementList = this.handleSecurity();
        if (securityRequrementList != null) {
            securityRequrementList.forEach(requirement -> this.oasOperation.addSecurityItem(requirement));
        }
        return this.oasOperation;
    }

    private void addEventToDescription(PathItem resource, Event event) {
        if (resource.getDescription() == null) {
            resource.setDescription("Receiving event(s): " + event.getType().getName());
        } else {
            resource.setDescription(resource.getDescription() + ", " + event.getType().getName());
        }
    }

    private Operation convertEvent(Event event, PathItem.HttpMethod verb) {
        Operation operation = new Operation();
        ArrayList<String> tags = new ArrayList<String>();
        Tag rtag = this.mdsl2OpenAPIConverter.createTag(this.endpointType, this.httpBinding, false);
        tags.add(rtag.getName());
        operation.setTags(tags);
        return operation;
    }

    private void convertRequestMessage() {
        ArrayList<Parameter> parameterList = new ArrayList<Parameter>();
        this.mediaTypes = HTTPBindingConverterHelpers.findMediaTypeForRequest(this.mdslOperation, this.httpBinding);
        if (this.mdslWrapper.operationHasHeader(this.mdslOperation)) {
            this.convertHeaders(parameterList, this.mediaTypes);
        }
        if (this.mdslWrapper.operationHasPayload(this.mdslOperation)) {
            ElementStructure operationPayload = this.mdslOperation.getRequestMessage().getPayload();
            this.convertElementStructure(operationPayload, parameterList);
        }
    }

    private void convertHeaders(List<Parameter> parameterList, List<String> mediaTypes) {
        ElementStructure headerSpecification = this.mdslOperation.getRequestMessage().getHeaders();
        if (headerSpecification == null) {
            return;
        }
        List<AtomicParameter> headers = this.mdslWrapper.extractAtomicElements(headerSpecification);
        headers.forEach(header -> this.convertRoleAndTypeAtom((AtomicParameter)header, HTTPParameter.HEADER, parameterList, mediaTypes));
    }

    private void convertElementStructure(ElementStructure content, List<Parameter> parameterList) {
        if (content == null) {
            MDSLLogger.reportWarning("Skipping empty or  payload structure in " + this.mdslOperation.getName() + " in " + this.endpointType.getName());
        }
        if (this.mdslWrapper.isSimplePayload(content)) {
            MDSLLogger.reportInformation(this.mdslOperation.getName() + " has atomic parameters only (embedded or type referenced).");
            this.convertSimplePayload(content, parameterList);
            if (parameterList.size() > 0) {
                this.oasOperation.parameters(parameterList);
            }
            return;
        }
        MDSLLogger.reportInformation("Converting a nested parameter tree or forest (or flat one, e.g., with '*' or '+' cardinality or type reference).");
        this.convertComplexPayload(content, parameterList, false);
    }

    private void convertSimplePayload(ElementStructure content, List<Parameter> parameterList) {
        if (content.getNp() != null) {
            this.convertSingleParameterNodeInElementStructure(content, parameterList);
        } else if (content.getApl() != null) {
            this.convertAtomicParameterListInElementStructure(content, parameterList);
        } else if (content.getPt() != null) {
            this.convertAtomicParameterListInElementStructure(content, parameterList);
        } else {
            MDSLLogger.reportError("Payload is not as simple as expected.");
        }
    }

    private void convertSingleParameterNodeInElementStructure(ElementStructure content, List<Parameter> parameterList) throws MDSLException {
        if (content.getNp().getTr() != null) {
            MDSLLogger.reportInformation(this.mdslOperation.getName() + ": binding type reference payload " + content.getNp().getTr().getName());
            this.convertTopLevelTypeReference(content, parameterList);
        } else {
            String parameterName = this.nameOfAtom(content);
            HTTPParameter parameterBinding = this.bindParameterUseDefaultIfNoExplicitBindingExists(parameterName);
            if (parameterBinding.equals((Object)HTTPParameter.BODY)) {
                MDSLLogger.reportInformation(this.mdslOperation.getName() + ": converting simple payload to request body");
                this.checkAndPerformBodyMappingOfTopLevelPayload(this.mediaTypes, parameterBinding);
            } else {
                MDSLLogger.reportInformation(this.mdslOperation.getName() + ": converting simple payload to request parameter(s)");
                List<Parameter> pl = this.dataType2ParameterConverter.convertSingleParameterNodeToOneParameter(content.getNp(), parameterBinding);
                parameterList.addAll(pl);
            }
        }
    }

    private void convertTopLevelTypeReference(ElementStructure content, List<Parameter> parameterList) {
        String parameterName = content.getNp().getTr().getName();
        HTTPParameter parameterBinding = this.findLevel0Binding(parameterName);
        if (parameterBinding != null) {
            MDSLLogger.reportInformation("Binding type reference payload on level 0 explicitly");
            this.handleLevel0TypeReferenceBinding(content, parameterList, this.mediaTypes, parameterBinding);
            return;
        }
        boolean hasAtLeastOneLevel1Binding = this.hasLevel1Binding(parameterName, content.getNp().getTr());
        if (hasAtLeastOneLevel1Binding) {
            MDSLLogger.reportInformation("Binding type reference payload on level 1 explicitly");
            this.convertComplexPayload(content, parameterList, false);
            return;
        }
        MDSLLogger.reportInformation("Binding type reference payload on level 0 (default)?");
        parameterBinding = HTTPBindingConverterHelpers.defaultBindingFor(this.httpVerb);
        this.handleLevel0TypeReferenceBinding(content, parameterList, this.mediaTypes, parameterBinding);
    }

    private void handleLevel0TypeReferenceBinding(ElementStructure content, List<Parameter> parameterList, List<String> mediaTypes, HTTPParameter parameterBinding) {
        if (parameterBinding == HTTPParameter.BODY) {
            RequestBody requestBody = this.createRequestBodyForSingleParameterNode(content.getNp(), mediaTypes);
            this.oasOperation.setRequestBody(requestBody);
        } else {
            List<Parameter> parameters = this.dataType2ParameterConverter.convertSingleParameterNodeToOneParameter(content.getNp(), parameterBinding);
            parameterList.addAll(parameters);
        }
    }

    private HTTPParameter findLevel0Binding(String parameterName) {
        return HTTPBindingConverterHelpers.findParameterBindingFor(this.mdslOperation.getName(), parameterName, this.httpBinding);
    }

    private boolean hasLevel1Binding(String parameterName, TypeReference typeReference) {
        boolean foundAtLeastOneBindingForTreeElement = false;
        ElementStructure es = typeReference.getDcref().getStructure();
        ParameterTree pt = es.getPt();
        if (pt == null) {
            return false;
        }
        if (pt.getFirst().getPn() == null) {
            return false;
        }
        if (pt.getFirst().getPn().getAtomP() != null) {
            parameterName = pt.getFirst().getPn().getAtomP().getRat().getName();
        } else if (pt.getFirst().getPn().getGenP() != null) {
            parameterName = pt.getFirst().getPn().getGenP().getName();
        } else if (pt.getFirst().getPn().getTr() != null) {
            parameterName = pt.getFirst().getPn().getTr().getName();
        }
        HTTPParameter pb = HTTPBindingConverterHelpers.findParameterBindingFor(this.mdslOperation.getName(), parameterName, this.httpBinding);
        if (pb != null) {
            foundAtLeastOneBindingForTreeElement = true;
        } else {
            MDSLLogger.reportWarning("Checked first tree node only to decide whether level 1 binding should be performed.");
        }
        return foundAtLeastOneBindingForTreeElement;
    }

    private void convertAtomicParameterListInElementStructure(ElementStructure operationPayload, List<Parameter> parameterList) {
        ParameterTree bodyElements = ApiDescriptionFactory.eINSTANCE.createParameterTree();
        bodyElements.setName("request body elements for " + this.mdslOperation.getName());
        HTTPParameter boundParameter = null;
        List<AtomicParameter> apsInOp = this.mdslWrapper.extractAtomicElements(operationPayload);
        MDSLLogger.reportDetailedInformation("Converting simple payload, operating on a generated pseudo-APL: " + apsInOp.size());
        for (int i = 0; i < apsInOp.size(); ++i) {
            AtomicParameter nextParameter = apsInOp.get(i);
            boundParameter = nextParameter.getRat().getName() == null ? HTTPBindingConverterHelpers.defaultBindingFor(this.httpVerb) : this.bindParameterUseDefaultIfNoExplicitBindingExists(nextParameter.getRat().getName());
            this.logMapping(this.mdslOperation, this.httpVerb, nextParameter.getRat().getName(), boundParameter);
            if (boundParameter.equals((Object)HTTPParameter.BODY)) {
                if (!HTTPBindingConverterHelpers.verbIsAllowedToHaveRequestBody(this.httpVerb)) {
                    throw new MDSLException("Unsupported verb-parameterType combination for operation " + this.mdslOperation.getName() + ": " + this.httpVerb.name() + " and " + boundParameter.getLiteral() + " cannot be used together.");
                }
                HTTPBindingConverterHelpers.addToNewParameterTree(bodyElements, nextParameter);
                continue;
            }
            List<Parameter> pl = this.dataType2ParameterConverter.convertAtomicParameterToOneParameter(nextParameter, boundParameter);
            parameterList.addAll(pl);
        }
        if (parameterList.size() > 0) {
            this.oasOperation.parameters(parameterList);
        }
        this.schemaForCollectedBodyElements(bodyElements, this.oasOperation, this.mediaTypes);
    }

    private String nameOfAtom(ElementStructure operationPayload) {
        if (operationPayload.getNp() == null) {
            throw new MDSLException("Can only name atoms that appear in single parameter nodes.");
        }
        if (operationPayload.getNp().getAtomP() != null) {
            return operationPayload.getNp().getAtomP().getRat().getName();
        }
        if (operationPayload.getNp().getGenP() != null) {
            return operationPayload.getNp().getGenP().getName();
        }
        if (operationPayload.getNp().getTr() != null) {
            return this.nameOfAtom(operationPayload.getNp().getTr().getDcref().getStructure());
        }
        return null;
    }

    private void convertRoleAndTypeAtom(AtomicParameter ap, HTTPParameter parameterBinding, List<Parameter> parameterList, List<String> mediaTypes) throws MDSLException {
        if (parameterBinding.equals((Object)HTTPParameter.BODY)) {
            this.checkAndPerformBodyMappingOfTopLevelPayload(mediaTypes, parameterBinding);
        } else {
            List<Parameter> pl = this.dataType2ParameterConverter.convertAtomicParameterToOneParameter(ap, parameterBinding);
            parameterList.addAll(pl);
        }
    }

    private void convertGenericAtom(GenericParameter genP, HTTPParameter parameterBinding, List<Parameter> parameterList, List<String> mediaTypes) throws MDSLException {
        if (parameterBinding.equals((Object)HTTPParameter.BODY)) {
            this.checkAndPerformBodyMappingOfTopLevelPayload(mediaTypes, parameterBinding);
        } else {
            Parameter p = this.dataType2ParameterConverter.convertGenericParameter(genP, parameterBinding);
            parameterList.add(p);
        }
    }

    private void checkAndPerformBodyMappingOfTopLevelPayload(List<String> mediaTypes, HTTPParameter parameterBinding) throws MDSLException {
        if (!HTTPBindingConverterHelpers.verbIsAllowedToHaveRequestBody(this.httpVerb)) {
            throw new MDSLException("Unsupported verb-parameterType combination for operation " + this.mdslOperation.getName() + ": " + this.httpVerb.name() + " and " + parameterBinding.getLiteral() + " cannot be used together.");
        }
        ElementStructure requestPayload = this.mdslOperation.getRequestMessage().getPayload();
        this.oasOperation.requestBody(this.createRequestBodyForTopLevelPayload(requestPayload, mediaTypes));
    }

    private void convertComplexPayload(ElementStructure operationPayload, List<Parameter> parameterList, boolean externalCardinality) {
        if (operationPayload.getPt() != null) {
            this.convertParameterTree(operationPayload.getPt(), this.mediaTypes, externalCardinality);
        } else if (operationPayload.getPf() != null) {
            this.convertParameterForest(this.mediaTypes);
        } else if (operationPayload.getNp() != null && operationPayload.getNp().getTr() != null) {
            this.convertTypeReferenceInElementStructure(operationPayload, parameterList);
        } else if (operationPayload.getNp() != null && operationPayload.getNp().getAtomP() != null) {
            this.convertAtomicParameterInElementStructure(operationPayload, parameterList);
        } else if (operationPayload.getNp() != null && operationPayload.getNp().getGenP() != null) {
            this.convertGenericParameterInElementStructure(operationPayload, parameterList);
        } else if (operationPayload.getApl() != null) {
            this.convertAtomicParameterListInElementStructure(operationPayload, parameterList);
        } else {
            throw new MDSLException("Unexpected (complex) element structure in operation " + this.mdslOperation.getName());
        }
    }

    private void convertGenericParameterInElementStructure(ElementStructure operationPayload, List<Parameter> parameterList) {
        HTTPParameter parameterBinding = this.bindParameterUseDefaultIfNoExplicitBindingExists(operationPayload.getNp().getGenP().getName());
        this.convertGenericAtom(operationPayload.getNp().getGenP(), parameterBinding, parameterList, this.mediaTypes);
        for (Parameter parameterItem : parameterList) {
            this.oasOperation.addParametersItem(parameterItem);
        }
    }

    private void convertAtomicParameterInElementStructure(ElementStructure operationPayload, List<Parameter> parameterList) throws MDSLException {
        HTTPParameter parameterBinding = this.bindParameterUseDefaultIfNoExplicitBindingExists(operationPayload.getNp().getAtomP().getRat().getName());
        this.convertRoleAndTypeAtom(operationPayload.getNp().getAtomP(), parameterBinding, parameterList, this.mediaTypes);
        for (Parameter parameterItem : parameterList) {
            this.oasOperation.addParametersItem(parameterItem);
        }
    }

    private void convertTypeReferenceInElementStructure(ElementStructure messageElement, List<Parameter> parameterList) throws MDSLException {
        HTTPParameter parameterBinding = HTTPBindingConverterHelpers.findParameterBindingFor(this.mdslOperation.getName(), messageElement.getNp().getTr().getName(), this.httpBinding);
        MDSLLogger.reportInformation(this.mdslOperation.getName() + ": convertTypeReferenceInElementStructure converting type reference " + messageElement.getNp().getTr().getName());
        if (parameterBinding != null) {
            MDSLLogger.reportInformation("Binding entire type reference: " + parameterBinding.getLiteral());
            this.convertTypeReferenceAndSetEntireRequestBody(messageElement.getNp().getTr(), parameterBinding, parameterList, this.mediaTypes);
        } else {
            ElementStructure referencedType = messageElement.getNp().getTr().getDcref().getStructure();
            if (referencedType.getPt() != null) {
                MDSLLogger.reportInformation("Following type reference to locate binding (is PT), reference name is " + messageElement.getNp().getTr().getName());
                this.convertParameterTree(referencedType.getPt(), this.mediaTypes, false);
                return;
            }
            if (referencedType.getNp() != null) {
                MDSLLogger.reportInformation("Following type reference to locate binding (is SPN), reference name is " + messageElement.getNp().getTr().getName());
                this.convertSimplePayload(referencedType, parameterList);
                return;
            }
            if (referencedType.getApl() != null) {
                MDSLLogger.reportInformation("Following type reference to locate binding (is APL), reference name is " + messageElement.getNp().getTr().getName());
                this.convertAtomicParameterListInElementStructure(messageElement, parameterList);
                return;
            }
        }
    }

    private void convertTypeReferenceAndSetEntireRequestBody(TypeReference referencedType, HTTPParameter parameterBinding, List<Parameter> parameterList, List<String> mediaTypes) {
        boolean extCard = false;
        if (this.mdslWrapper.referenceHasMultiplicity(referencedType)) {
            extCard = true;
        }
        if (parameterBinding.equals((Object)HTTPParameter.BODY)) {
            if (!HTTPBindingConverterHelpers.verbIsAllowedToHaveRequestBody(this.httpVerb)) {
                throw new MDSLException("Unsupported verb-parameterType combination for operation " + this.mdslOperation.getName() + ": " + this.httpVerb.name() + " and " + parameterBinding.getLiteral() + " cannot be used together.");
            }
            MDSLLogger.reportInformation(this.mdslOperation.getName() + " creating scheme reference for " + referencedType.getName() + " -> " + referencedType.getDcref().getName());
            Schema requestPayload = this.dataType2SchemaConverter.createSchemaForTypeReference(referencedType);
            Content c = this.createContentFromSchemaAndMediaTypes(mediaTypes, requestPayload);
            RequestBody rb = new RequestBody();
            rb.setContent(c);
            rb.setDescription("Request body for type " + referencedType.getName());
            this.oasOperation.requestBody(rb);
        } else {
            ElementStructure referencedStructure = referencedType.getDcref().getStructure();
            this.convertComplexPayload(referencedStructure, parameterList, extCard);
        }
    }

    private void convertParameterTree(ParameterTree pt, List<String> mediaTypes, boolean externalCardinality) throws MDSLException {
        HTTPParameter parameterBinding;
        String treeName = pt.getName();
        if (this.mdslWrapper.treeHasMultiplicity(pt)) {
            externalCardinality = true;
        }
        if ((parameterBinding = HTTPBindingConverterHelpers.findParameterBindingFor(this.mdslOperation.getName(), treeName, this.httpBinding)) != null) {
            MDSLLogger.reportInformation(this.mdslOperation.getName() + " in " + this.endpointType.getName() + ": binding entire tree as DTO in payload.");
            this.convertParameterTreeAsSingleBoundParameter(pt, parameterBinding, mediaTypes, externalCardinality);
        } else {
            MDSLLogger.reportInformation(this.mdslOperation.getName() + " in " + this.endpointType.getName() + ": binding via level 1 tree nodes in payload.");
            this.convertParameterTreeViaLevel1TreeNodeTraversal(pt, parameterBinding, mediaTypes);
        }
    }

    private void convertParameterForest(List<String> mediaTypes) throws MDSLException {
        MDSLLogger.reportWarning(this.httpVerb.name() + ": parameter forest bound to body");
        if (!HTTPBindingConverterHelpers.verbIsAllowedToHaveRequestBody(this.httpVerb)) {
            throw new MDSLException("Known limitation: Parameter Forests can only be mapped to BODY at present, which is not possible for " + this.mdslOperation.getName() + " and " + this.httpVerb);
        }
        this.oasOperation.requestBody(this.createRequestBodyForTopLevelPayload(this.mdslOperation.getRequestMessage().getPayload(), mediaTypes));
    }

    private void convertParameterTreeViaLevel1TreeNodeTraversal(ParameterTree pt, HTTPParameter parameterBinding, List<String> mediaTypes) {
        MDSLLogger.reportDetailedInformation(this.mdslOperation.getName() + " in convertParameterTreeViaLevel1TreeNodeTraversal");
        ArrayList<Parameter> parameterList = new ArrayList<Parameter>();
        List<TreeNode> treeNodes = this.mdslWrapper.collectTreeNodes(pt);
        ParameterTree parameterTreeForBody = ApiDescriptionFactory.eINSTANCE.createParameterTree();
        parameterTreeForBody.setName("request body elements for " + this.mdslOperation.getName());
        for (TreeNode nextNode : treeNodes) {
            if (nextNode.getPn() != null) {
                MDSLLogger.reportDetailedInformation(this.mdslOperation.getName() + " is SPN");
                parameterBinding = this.handleInnerSingleParameterNodeInComplexPayload(parameterBinding, parameterList, parameterTreeForBody, nextNode);
                continue;
            }
            if (nextNode.getChildren() != null) {
                MDSLLogger.reportDetailedInformation(this.mdslOperation.getName() + " is PT, calling handleInnerParameterTreeInComplexPayload for " + nextNode.getChildren().getName() + " while processing " + pt.getName());
                parameterBinding = this.handleInnerParameterTreeInComplexPayload(nextNode.getChildren(), parameterList, parameterTreeForBody);
                continue;
            }
            if (nextNode.getApl() == null) continue;
            MDSLLogger.reportWarning("Not supported: mapping of APL in " + this.mdslOperation.getName());
        }
        if (parameterList.size() > 0) {
            this.oasOperation.parameters(parameterList);
        }
        this.schemaForCollectedBodyElements(parameterTreeForBody, this.oasOperation, mediaTypes);
    }

    private void schemaForCollectedBodyElements(ParameterTree parameterTreeForBody, Operation oasOperation, List<String> mediaTypes) {
        RequestBody ptSchema = this.createRequestBodyForParameterTree(parameterTreeForBody, mediaTypes);
        if (ptSchema != null) {
            ptSchema.setDescription("Message payload (content)");
            oasOperation.requestBody(ptSchema);
        }
    }

    private HTTPParameter handleInnerParameterTreeInComplexPayload(ParameterTree treeNode, List<Parameter> parameterList, ParameterTree parameterTreeForBody) {
        MDSLLogger.reportDetailedInformation("Entering handleInnerParameterTreeInComplexPayload");
        boolean treeCardinality = false;
        if (this.mdslWrapper.treeHasMultiplicity(treeNode)) {
            treeCardinality = true;
        }
        HTTPParameter parameterBinding = this.bindParameterUseDefaultIfNoExplicitBindingExists(treeNode.getName());
        MDSLLogger.reportInformation(this.mdslOperation.getName() + ": adding to " + (Object)((Object)parameterBinding) + " payload/parameter " + treeNode.getName());
        if (parameterBinding == HTTPParameter.BODY) {
            HTTPBindingConverterHelpers.addToNewParameterTree(parameterTreeForBody, treeNode);
        } else {
            parameterList.add(this.dataType2ParameterConverter.convertParameterTree(treeNode, parameterBinding, treeCardinality));
        }
        return parameterBinding;
    }

    private HTTPParameter handleInnerSingleParameterNodeInComplexPayload(HTTPParameter parameterBinding, List<Parameter> parameterList, ParameterTree parameterTreeForBody, TreeNode nextNode) {
        MDSLLogger.reportDetailedInformation(this.mdslOperation.getName() + " in handleInnerSingleParameterNodeInComplexPayload");
        if (nextNode.getPn().getAtomP() != null) {
            parameterBinding = this.handleInnerAtomicParameterInComplexPayload(parameterList, parameterTreeForBody, nextNode);
        } else if (nextNode.getPn().getGenP() != null) {
            parameterBinding = this.handleGenericParameterInComplexPayload(parameterList, parameterTreeForBody, nextNode);
        } else if (nextNode.getPn().getTr() != null) {
            String trName = nextNode.getPn().getTr().getName();
            MDSLLogger.reportDetailedInformation(this.mdslOperation.getName() + " in handleInnerSingleParameterNodeInComplexPayload, next node is TR " + trName);
            parameterBinding = this.bindParameterUseDefaultIfNoExplicitBindingExists(trName);
            this.logMapping(this.mdslOperation, this.httpVerb, trName, parameterBinding);
            if (HTTPParameter.BODY.equals((Object)parameterBinding)) {
                MDSLLogger.reportDetailedInformation(this.mdslOperation.getName() + " in handleInnerSingleParameterNodeInComplexPayload, body mapping");
                HTTPBindingConverterHelpers.addToNewParameterTree(parameterTreeForBody, nextNode.getPn().getTr());
            } else {
                parameterList.addAll(this.dataType2ParameterConverter.convertSingleParameterNodeToOneParameter(nextNode.getPn(), parameterBinding));
            }
        }
        return parameterBinding;
    }

    private HTTPParameter handleGenericParameterInComplexPayload(List<Parameter> parameterList, ParameterTree parameterTreeForBody, TreeNode nextNode) {
        HTTPParameter parameterBinding = HTTPBindingConverterHelpers.findParameterBindingFor(this.mdslOperation.getName(), nextNode.getPn().getGenP().getName(), this.httpBinding);
        if (parameterBinding == null) {
            parameterBinding = HTTPBindingConverterHelpers.defaultBindingFor(this.httpVerb);
        }
        if (HTTPParameter.BODY.equals((Object)parameterBinding)) {
            HTTPBindingConverterHelpers.addToNewParameterTree(parameterTreeForBody, nextNode.getPn().getAtomP());
            this.logMapping(this.mdslOperation, this.httpVerb, nextNode.getPn().getGenP().getName(), parameterBinding);
        } else {
            this.logMapping(this.mdslOperation, this.httpVerb, nextNode.getPn().getAtomP().getRat().getName(), parameterBinding);
            parameterList.addAll(this.dataType2ParameterConverter.convertSingleParameterNodeToOneParameter(nextNode.getPn(), parameterBinding));
        }
        return parameterBinding;
    }

    private HTTPParameter handleInnerAtomicParameterInComplexPayload(List<Parameter> parameterList, ParameterTree parameterTreeForBody, TreeNode nextNode) {
        HTTPParameter parameterBinding = HTTPBindingConverterHelpers.findParameterBindingFor(this.mdslOperation.getName(), nextNode.getPn().getAtomP().getRat().getName(), this.httpBinding);
        if (parameterBinding == null) {
            parameterBinding = HTTPBindingConverterHelpers.defaultBindingFor(this.httpVerb);
        }
        if (HTTPParameter.BODY.equals((Object)parameterBinding)) {
            this.logMapping(this.mdslOperation, this.httpVerb, nextNode.getPn().getAtomP().getRat().getName(), parameterBinding);
            HTTPBindingConverterHelpers.addToNewParameterTree(parameterTreeForBody, nextNode.getPn().getAtomP());
        } else {
            this.logMapping(this.mdslOperation, this.httpVerb, nextNode.getPn().getAtomP().getRat().getName(), parameterBinding);
            parameterList.addAll(this.dataType2ParameterConverter.convertSingleParameterNodeToOneParameter(nextNode.getPn(), parameterBinding));
        }
        return parameterBinding;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void convertParameterTreeAsSingleBoundParameter(ParameterTree pt, HTTPParameter parameterBinding, List<String> mediaTypes, boolean externalCardinality) throws MDSLException {
        if (parameterBinding != HTTPParameter.BODY) {
            Parameter parameter = this.dataType2ParameterConverter.convertParameterTree(pt, parameterBinding, externalCardinality);
            this.oasOperation.addParametersItem(parameter);
            return;
        }
        if (HTTPBindingConverterHelpers.verbIsAllowedToHaveRequestBody(this.httpVerb)) {
            this.oasOperation.requestBody(this.createRequestBodyForTopLevelPayload(this.mdslOperation.getRequestMessage().getPayload(), mediaTypes));
            return;
        }
        String ptName = pt.getName();
        if (ptName != null) throw new MDSLException("Unsupported HTTPVerb-HTTPParameterType combination in " + this.mdslOperation.getName() + ", parameter: " + ptName + ": " + this.httpVerb.name() + " and " + parameterBinding.getLiteral() + " cannot be used together.");
        ptName = "unnamed";
        throw new MDSLException("Unsupported HTTPVerb-HTTPParameterType combination in " + this.mdslOperation.getName() + ", parameter: " + ptName + ": " + this.httpVerb.name() + " and " + parameterBinding.getLiteral() + " cannot be used together.");
    }

    private RequestBody createRequestBodyForSingleParameterNode(SingleParameterNode spn, List<String> mediaTypes) {
        if (spn == null) {
            throw new MDSLException("Invalid operation invocation: expected a non-empty parameter tree node.");
        }
        if (mediaTypes == null) {
            MDSLLogger.reportError("At least one media type must be defined.");
        }
        MDSLLogger.reportDetailedInformation("Entering createRequestBodyForSingleParameterNode");
        RequestBody result = new RequestBody();
        Content requestBodyContent = new Content();
        Schema schema = this.dataType2SchemaConverter.createSchema4SingleParameterNode(spn);
        MediaType item = new MediaType().schema(schema);
        for (int i = 0; i < mediaTypes.size(); ++i) {
            requestBodyContent.addMediaType(mediaTypes.get(i), item);
        }
        result.setContent(requestBodyContent);
        return result;
    }

    private RequestBody createRequestBodyForTopLevelPayload(ElementStructure messageRepresentation, List<String> mediaTypes) {
        if (messageRepresentation != null) {
            if (mediaTypes != null) {
                RequestBody result = new RequestBody();
                Schema newSchema = this.dataType2SchemaConverter.getSchema4RequestOrResponseStructure(messageRepresentation);
                Content c = this.createContentFromSchemaAndMediaTypes(mediaTypes, newSchema);
                result.setContent(c);
                return result;
            }
            MDSLLogger.reportWarning("At least one media type must be defined.");
            return null;
        }
        return null;
    }

    private RequestBody createRequestBodyForParameterTree(ParameterTree parameterTree, List<String> mediaTypes) {
        if (parameterTree != null) {
            if (mediaTypes != null) {
                if (HTTPBindingConverterHelpers.hasAtLeastOneNode(parameterTree)) {
                    RequestBody result = new RequestBody();
                    Schema newSchema = this.dataType2SchemaConverter.convertAndCreateSchema4ParameterTreeAndItsNodes(parameterTree, this.mdslWrapper.treeHasMultiplicity(parameterTree));
                    newSchema.setDescription(parameterTree.getName());
                    Content c = this.createContentFromSchemaAndMediaTypes(mediaTypes, newSchema);
                    result.setContent(c);
                    return result;
                }
                return null;
            }
            MDSLLogger.reportWarning("At least one media type must be defined.");
            return null;
        }
        return null;
    }

    private void convertResponseMessages() {
        if (this.mdslWrapper.operationHasReturnValue(this.mdslOperation)) {
            List<String> mediaTypes = HTTPBindingConverterHelpers.findMediaTypeForResponse(this.mdslOperation, this.httpBinding);
            ApiResponse apiResponse = this.createAPIResponse(this.mdslOperation.getResponseMessage().getPayload(), this.mdslOperation.getName() + SUCCESSFUL_EXECUTION, mediaTypes);
            ApiResponses responseList = new ApiResponses().addApiResponse(DEFAULT_RESPONSE_NAME, apiResponse);
            HTTPBindingConverterHelpers.handleLinks(this.mdslOperation, this.httpBinding, apiResponse);
            if (this.mdslWrapper.operationHasReturnValueWithReports(this.mdslOperation)) {
                StatusReports reports = this.mdslOperation.getReports();
                EList<StatusReport> rl = reports.getReportList();
                for (int i = 0; i < rl.size(); ++i) {
                    ApiResponse reportResponse = null;
                    String code = X_999_CODE;
                    String reportText = TBD_TEXT;
                    StatusReport report = (StatusReport)rl.get(i);
                    String reportNameInEndpointType = report.getName();
                    ElementStructure reportDataForResponse = report.getReportData();
                    if (reportDataForResponse == null) continue;
                    reportResponse = this.createAPIResponse(reportDataForResponse, this.mdslOperation.getName() + ": " + reportText, mediaTypes);
                    code = this.mdslWrapper.findReportCodeInBinding(this.mdslOperation.getName(), reportNameInEndpointType, this.httpBinding);
                    reportText = this.mdslWrapper.findReportTextInBinding(this.mdslOperation.getName(), reportNameInEndpointType, this.httpBinding);
                    reportResponse.description(reportText);
                    responseList.addApiResponse(code, reportResponse);
                }
            }
            this.oasOperation.responses(responseList);
        } else {
            this.oasOperation.responses(new ApiResponses().addApiResponse(DEFAULT_RESPONSE_NAME, new ApiResponse().description(NO_RETURN_VALUE).content(new Content())));
        }
    }

    private ApiResponse createAPIResponse(ElementStructure responsePayload, String description, List<String> mediaTypes) {
        Content c = new Content();
        mediaTypes.forEach(mediaType -> c.addMediaType(mediaType, new MediaType().schema(this.dataType2SchemaConverter.getSchema4RequestOrResponseStructure(responsePayload))));
        return new ApiResponse().description(description).content(c);
    }

    private Content createContentFromSchemaAndMediaTypes(List<String> mediaTypes, Schema<?> newSchema) {
        Content c = new Content();
        MediaType item = new MediaType().schema(newSchema);
        for (int i = 0; i < mediaTypes.size(); ++i) {
            c.addMediaType(mediaTypes.get(i), item);
        }
        return c;
    }

    private List<SecurityRequirement> handleSecurity() {
        ArrayList<SecurityRequirement> ss = new ArrayList<SecurityRequirement>();
        SecurityPolicies securityPolicies = this.mdslOperation.getPolicies();
        if (securityPolicies == null) {
            return null;
        }
        EList<SecurityPolicy> secPols = securityPolicies.getPolicyList();
        for (int i = 0; i < secPols.size(); ++i) {
            SecurityPolicy securityPolicy = (SecurityPolicy)secPols.get(i);
            String spName = securityPolicy.getName();
            SecurityBinding boundPolicy = this.mdslWrapper.findPolicyInBinding(this.mdslOperation.getName(), spName, this.httpBinding);
            this.mdsl2OpenAPIConverter.convertPolicy2SecurityScheme(securityPolicy, boundPolicy);
            if (boundPolicy != null) {
                MDSLLogger.reportInformation("Found a security policy " + spName + " for " + this.mdslOperation.getName());
                SecurityRequirement sr = new SecurityRequirement();
                sr.addList(spName);
                ss.add(sr);
                continue;
            }
            MDSLLogger.reportWarning("Found a security policy (but no binding)" + spName + " for " + this.mdslOperation.getName() + ". Skipping it so that the generated OpenAPI validates.");
        }
        return ss;
    }

    private HTTPParameter bindParameterUseDefaultIfNoExplicitBindingExists(String parameterName) {
        HTTPParameter parameterBinding = HTTPBindingConverterHelpers.findParameterBindingFor(this.mdslOperation.getName(), parameterName, this.httpBinding);
        if (parameterBinding == null) {
            parameterBinding = HTTPBindingConverterHelpers.defaultBindingFor(this.httpVerb);
        }
        this.logMapping(this.mdslOperation, this.httpVerb, parameterName, parameterBinding);
        return parameterBinding;
    }

    private void logMapping(io.mdsl.apiDescription.Operation mdslOperation, PathItem.HttpMethod httpVerb, String nextParameterName, HTTPParameter boundParameter) {
        if (mdslOperation == null) {
            MDSLLogger.reportError("MDSL operation not defined yet.");
            return;
        }
        if (httpVerb == null) {
            MDSLLogger.reportWarning(mdslOperation.getName() + " does not map to an HTTP verb yet.");
            return;
        }
        String nextParameterNameForLog = nextParameterName == null ? "anonymous" : nextParameterName;
        if (boundParameter == null) {
            MDSLLogger.reportInformation(mdslOperation.getName() + " (" + httpVerb.name() + "): " + nextParameterNameForLog + " not bound");
            return;
        }
        MDSLLogger.reportInformation(mdslOperation.getName() + " (" + httpVerb.name() + "): " + nextParameterNameForLog + " bound to: " + boundParameter.getLiteral());
    }
}

