/*
 * Decompiled with CFR 0.152.
 */
package io.mdsl.generator.openapi.converter;

import io.mdsl.apiDescription.ApiDescriptionFactory;
import io.mdsl.apiDescription.AtomicParameter;
import io.mdsl.apiDescription.CustomMediaType;
import io.mdsl.apiDescription.GenericParameter;
import io.mdsl.apiDescription.HTTPOperationBinding;
import io.mdsl.apiDescription.HTTPParameter;
import io.mdsl.apiDescription.HTTPParameterBinding;
import io.mdsl.apiDescription.HTTPResourceBinding;
import io.mdsl.apiDescription.HTTPTypeBinding;
import io.mdsl.apiDescription.HTTPVerb;
import io.mdsl.apiDescription.LinkContract;
import io.mdsl.apiDescription.MediaTypeList;
import io.mdsl.apiDescription.Operation;
import io.mdsl.apiDescription.OperationResponsibility;
import io.mdsl.apiDescription.ParameterTree;
import io.mdsl.apiDescription.RelationshipLink;
import io.mdsl.apiDescription.SingleParameterNode;
import io.mdsl.apiDescription.StandardMediaType;
import io.mdsl.apiDescription.TreeNode;
import io.mdsl.apiDescription.TypeReference;
import io.mdsl.utils.MDSLLogger;
import io.mdsl.utils.MDSLSpecificationWrapper;
import io.swagger.v3.oas.models.PathItem;
import io.swagger.v3.oas.models.links.Link;
import io.swagger.v3.oas.models.responses.ApiResponse;
import io.swagger.v3.oas.models.servers.Server;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.WordUtils;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class HTTPBindingConverterHelpers {
    private static final String DEFAULT_MEDIA_TYPE = "application/json";

    public static List<String> findMediaTypeForRequest(Operation mdslOperation, HTTPResourceBinding binding) {
        HTTPOperationBinding opB = HTTPBindingConverterHelpers.findOperationBindingFor(mdslOperation.getName(), binding);
        if (opB == null || opB.getInContentTypes() == null) {
            ArrayList<String> defaultTypeList = new ArrayList<String>();
            defaultTypeList.add(DEFAULT_MEDIA_TYPE);
            return defaultTypeList;
        }
        return HTTPBindingConverterHelpers.findMediaTypes(opB.getInContentTypes());
    }

    public static List<String> findMediaTypeForResponse(Operation mdslOperation, HTTPResourceBinding binding) {
        HTTPOperationBinding opB = HTTPBindingConverterHelpers.findOperationBindingFor(mdslOperation.getName(), binding);
        if (opB == null || opB.getOutContentTypes() == null) {
            ArrayList<String> defaultTypeList = new ArrayList<String>();
            defaultTypeList.add(DEFAULT_MEDIA_TYPE);
            return defaultTypeList;
        }
        return HTTPBindingConverterHelpers.findMediaTypes(opB.getOutContentTypes());
    }

    private static List<String> findMediaTypes(MediaTypeList mimeTypes) {
        EList<StandardMediaType> smtl;
        EList<CustomMediaType> cmtl;
        ArrayList<String> result = new ArrayList<String>();
        if (mimeTypes.getCmt() != null && (cmtl = mimeTypes.getCmt()) != null) {
            cmtl.forEach(cmt -> result.add(cmt.getValue()));
        }
        if (mimeTypes.getSmt() != null && (smtl = mimeTypes.getSmt()) != null && smtl.size() > 0) {
            smtl.forEach(smt -> result.add(smt.getIanaName()));
        }
        return result;
    }

    public static HTTPParameter defaultBindingFor(PathItem.HttpMethod verb) {
        if (HTTPBindingConverterHelpers.verbIsAllowedToHaveRequestBody(verb)) {
            return HTTPParameter.BODY;
        }
        return HTTPParameter.QUERY;
    }

    public static PathItem.HttpMethod mapMethod(Operation operation, HTTPResourceBinding binding) {
        PathItem.HttpMethod result = null;
        HTTPVerb verb = HTTPBindingConverterHelpers.findVerbBindingFor(operation.getName(), binding);
        if (verb != null) {
            return HTTPBindingConverterHelpers.mapMethodViaBinding(verb);
        }
        OperationResponsibility reponsibility = operation.getResponsibility();
        if (reponsibility != null && (result = HTTPBindingConverterHelpers.mapMethodViaDecorator(reponsibility)) != null) {
            return result;
        }
        return HTTPBindingConverterHelpers.mapMethodByName(operation);
    }

    public static HTTPVerb findVerbBindingFor(String operation, HTTPResourceBinding binding) {
        HTTPOperationBinding opB = HTTPBindingConverterHelpers.findOperationBindingFor(operation, binding);
        if (opB != null) {
            return opB.getMethod();
        }
        return null;
    }

    public static HTTPOperationBinding findOperationBindingFor(String operation, HTTPResourceBinding binding) {
        if (binding == null) {
            return null;
        }
        EList<HTTPOperationBinding> operationBindings = binding.getOpsB();
        for (int i = 0; i < operationBindings.size(); ++i) {
            HTTPOperationBinding opB = (HTTPOperationBinding)operationBindings.get(i);
            if (!opB.getBoundOperation().equals(operation)) continue;
            return opB;
        }
        return null;
    }

    public static HTTPParameter findParameterBindingFor(String operation, String parameterName, HTTPResourceBinding binding) {
        if (binding == null) {
            return null;
        }
        HTTPOperationBinding opB = HTTPBindingConverterHelpers.findOperationBindingFor(operation, binding);
        if (opB == null) {
            return null;
        }
        if (opB.getGlobalBinding() != null) {
            return opB.getGlobalBinding().getParameterMapping();
        }
        EList<HTTPParameterBinding> parameterBindings = opB.getParameterBindings();
        for (int i = 0; i < parameterBindings.size(); ++i) {
            HTTPParameterBinding pB = (HTTPParameterBinding)parameterBindings.get(i);
            if (!pB.getBoundParameter().equals(parameterName)) continue;
            return pB.getParameterMapping();
        }
        if (parameterName == null) {
            MDSLLogger.reportInformation("No element binding for anonymous parameter found in binding " + binding.getName());
        } else {
            MDSLLogger.reportInformation("No element binding of \"" + parameterName + "\" found in binding " + binding.getName());
        }
        return null;
    }

    public static void handleLinks(Operation mdslOperation, HTTPResourceBinding binding, ApiResponse httpResponse) {
        EList<RelationshipLink> hypermediaRelations = mdslOperation.getRelations();
        for (int j = 0; j < hypermediaRelations.size(); ++j) {
            MDSLLogger.reportInformation("Processing link relations in " + mdslOperation.getName());
            RelationshipLink nextLink = (RelationshipLink)hypermediaRelations.get(j);
            HTTPTypeBinding ltb = HTTPBindingConverterHelpers.findLinkTypeBindingFor(nextLink.getLcref().getName(), binding);
            if (ltb == null) {
                MDSLLogger.reportWarning("No binding found for " + nextLink.getName() + ", skipping this link.");
                continue;
            }
            HTTPBindingConverterHelpers.handleSingleLink(nextLink, ltb, httpResponse);
        }
        Operation compensatingOperation = mdslOperation.getUndo();
        if (compensatingOperation != null) {
            Link link = new Link().operationId(compensatingOperation.getName());
            httpResponse.link("compensatingOperation", link);
        }
    }

    public static HTTPTypeBinding findLinkTypeBindingFor(String name, HTTPResourceBinding binding) {
        EList<HTTPTypeBinding> tps = binding.getTB();
        for (HTTPTypeBinding tb : tps) {
            if (tb.getLt() == null || !tb.getLt().getName().equals(name)) continue;
            return tb;
        }
        return null;
    }

    public static void handleSingleLink(RelationshipLink mdslLink, HTTPTypeBinding linkBinding, ApiResponse httpResponse) {
        String opId = "";
        if (linkBinding != null) {
            opId = ((HTTPResourceBinding)linkBinding.eContainer()).getName() + "-";
        }
        opId = mdslLink.getLcref().getOperation() != null ? opId + mdslLink.getLcref().getOperation() : "unknownOperation";
        Link oasLink = new Link().operationId(opId);
        LinkContract refedLinkType = mdslLink.getLcref();
        if (refedLinkType != null && refedLinkType.getDataType() != null && refedLinkType.getDataType().getName() != null) {
            oasLink.parameters(WordUtils.uncapitalize((String)mdslLink.getName()), refedLinkType.getDataType().getName());
            if (refedLinkType.getOperation() != null) {
                oasLink.description("Targeted operation: " + refedLinkType.getOperation());
            } else {
                oasLink.description("Unknown target.");
            }
        }
        if (linkBinding.getHml().getLocal() != null) {
            oasLink.parameters("resource", linkBinding.getHml().getLocal().getName());
        } else if (linkBinding.getHml().getExternal() != null) {
            oasLink.parameters("resource", linkBinding.getHml().getExternal());
        }
        if (linkBinding.getHml().getVerb() != null) {
            oasLink.parameters("verb", linkBinding.getHml().getVerb().getName());
        }
        if (linkBinding.getHml().getCmt() != null) {
            oasLink.parameters("cmt", linkBinding.getHml().getCmt().getName());
        }
        Server server = new Server();
        String targetAddress = null;
        if (mdslLink.getLcref().getUrn() != null) {
            targetAddress = mdslLink.getLcref().getUrn();
        }
        if (linkBinding.getHml() != null && linkBinding.getHml().getExternal() != null) {
            targetAddress = linkBinding.getHml().getExternal();
        }
        if (targetAddress != null) {
            server.url(targetAddress);
            oasLink.server(server);
        }
        httpResponse.link(WordUtils.uncapitalize((String)mdslLink.getName()), oasLink);
    }

    public static PathItem.HttpMethod mapMethodViaDecorator(OperationResponsibility responsibility) {
        if (responsibility == null) {
            return null;
        }
        if (responsibility.getCf() != null) {
            return PathItem.HttpMethod.POST;
        }
        if (responsibility.getSco() != null) {
            return PathItem.HttpMethod.PUT;
        }
        if (responsibility.getRo() != null) {
            return PathItem.HttpMethod.GET;
        }
        if (responsibility.getSto() != null) {
            return PathItem.HttpMethod.PATCH;
        }
        if (responsibility.getSro() != null) {
            return PathItem.HttpMethod.PUT;
        }
        if (responsibility.getSdo() != null) {
            return PathItem.HttpMethod.DELETE;
        }
        if (responsibility.getOther() != null && responsibility.getOther().equals("POST")) {
            return PathItem.HttpMethod.POST;
        }
        if (responsibility.getOther() != null && responsibility.getOther().equals("PUT")) {
            return PathItem.HttpMethod.PUT;
        }
        if (responsibility.getOther() != null && responsibility.getOther().equals("PATCH")) {
            return PathItem.HttpMethod.PATCH;
        }
        if (responsibility.getOther() != null && responsibility.getOther().equals("GET")) {
            return PathItem.HttpMethod.GET;
        }
        if (responsibility.getOther() != null && responsibility.getOther().equals("DELETE")) {
            return PathItem.HttpMethod.DELETE;
        }
        if (responsibility.getOther() != null && responsibility.getOther().equals("OPTIONS")) {
            return PathItem.HttpMethod.OPTIONS;
        }
        if (responsibility.getOther() != null && responsibility.getOther().equals("HEAD")) {
            return PathItem.HttpMethod.HEAD;
        }
        if (responsibility.getOther() != null && responsibility.getOther().equals("TRACE")) {
            return PathItem.HttpMethod.TRACE;
        }
        return null;
    }

    public static PathItem.HttpMethod mapMethodViaBinding(HTTPVerb verb) {
        if (verb != null && verb == HTTPVerb.GET) {
            return PathItem.HttpMethod.GET;
        }
        if (verb != null && verb == HTTPVerb.PUT) {
            return PathItem.HttpMethod.PUT;
        }
        if (verb != null && verb == HTTPVerb.POST) {
            return PathItem.HttpMethod.POST;
        }
        if (verb != null && verb == HTTPVerb.PATCH) {
            return PathItem.HttpMethod.PATCH;
        }
        if (verb != null && verb == HTTPVerb.OPTIONS) {
            return PathItem.HttpMethod.OPTIONS;
        }
        if (verb != null && verb == HTTPVerb.HEAD) {
            return PathItem.HttpMethod.HEAD;
        }
        if (verb != null && verb == HTTPVerb.TRACE) {
            return PathItem.HttpMethod.TRACE;
        }
        if (verb != null && verb == HTTPVerb.DELETE) {
            return PathItem.HttpMethod.DELETE;
        }
        return null;
    }

    public static PathItem.HttpMethod mapMethodByName(Operation operation) {
        if (operation.getName().startsWith("create")) {
            return PathItem.HttpMethod.POST;
        }
        if (operation.getName().startsWith("addTo") || operation.getName().startsWith("add_to")) {
            return PathItem.HttpMethod.POST;
        }
        if (operation.getName().startsWith("get") || operation.getName().startsWith("read") || operation.getName().startsWith("retrieve") || operation.getName().startsWith("search")) {
            return PathItem.HttpMethod.GET;
        }
        if (operation.getName().startsWith("put") || operation.getName().startsWith("replace")) {
            return PathItem.HttpMethod.PUT;
        }
        if (operation.getName().startsWith("patch") || operation.getName().startsWith("update") || operation.getName().startsWith("modify")) {
            return PathItem.HttpMethod.PATCH;
        }
        if (operation.getName().startsWith("delete") || operation.getName().startsWith("remove")) {
            return PathItem.HttpMethod.DELETE;
        }
        MDSLSpecificationWrapper.logInformation("No verb mapping heuristic found for " + operation.getName());
        return PathItem.HttpMethod.POST;
    }

    public static boolean verbIsAllowedToHaveRequestBody(PathItem.HttpMethod verb) {
        return verb != PathItem.HttpMethod.GET && verb != PathItem.HttpMethod.DELETE;
    }

    public static void addToNewParameterTree(ParameterTree newParameterTree, ParameterTree children) {
        TreeNode newTreeNode = ApiDescriptionFactory.eINSTANCE.createTreeNode();
        newTreeNode.setChildren((ParameterTree)EcoreUtil.copy((EObject)children));
        if (newParameterTree.getFirst() == null) {
            newParameterTree.setFirst(newTreeNode);
        } else {
            newParameterTree.getNexttn().add((Object)newTreeNode);
        }
    }

    public static void addToNewParameterTree(ParameterTree newParameterTree, GenericParameter genP) {
        TreeNode newTreeNode = ApiDescriptionFactory.eINSTANCE.createTreeNode();
        SingleParameterNode spn = ApiDescriptionFactory.eINSTANCE.createSingleParameterNode();
        spn.setGenP((GenericParameter)EcoreUtil.copy((EObject)genP));
        newTreeNode.setPn(spn);
        if (newParameterTree.getFirst() == null) {
            newParameterTree.setFirst(newTreeNode);
        } else {
            newParameterTree.getNexttn().add((Object)newTreeNode);
        }
    }

    public static void addToNewParameterTree(ParameterTree newParameterTree, AtomicParameter atomP) {
        TreeNode newTreeNode = ApiDescriptionFactory.eINSTANCE.createTreeNode();
        SingleParameterNode spn = ApiDescriptionFactory.eINSTANCE.createSingleParameterNode();
        spn.setAtomP((AtomicParameter)EcoreUtil.copy((EObject)atomP));
        newTreeNode.setPn(spn);
        if (newParameterTree.getFirst() == null) {
            newParameterTree.setFirst(newTreeNode);
        } else {
            newParameterTree.getNexttn().add((Object)newTreeNode);
        }
    }

    public static boolean hasAtLeastOneNode(ParameterTree parameterTree) {
        return parameterTree.getFirst() != null;
    }

    public static void addToNewParameterTree(ParameterTree newParameterTree, TypeReference tr) {
        TreeNode newTreeNode = ApiDescriptionFactory.eINSTANCE.createTreeNode();
        SingleParameterNode spn = ApiDescriptionFactory.eINSTANCE.createSingleParameterNode();
        spn.setTr((TypeReference)EcoreUtil.copy((EObject)tr));
        newTreeNode.setPn(spn);
        if (newParameterTree.getFirst() == null) {
            newParameterTree.setFirst(newTreeNode);
        } else {
            newParameterTree.getNexttn().add((Object)newTreeNode);
        }
    }
}

