/*
 * Decompiled with CFR 0.152.
 */
package io.mdsl.generator.protobuf.converter;

import com.google.common.collect.Lists;
import io.github.microserviceapipatterns.protobufgen.model.Message;
import io.github.microserviceapipatterns.protobufgen.model.ProtoSpec;
import io.github.microserviceapipatterns.protobufgen.model.Service;
import io.mdsl.apiDescription.DataContract;
import io.mdsl.apiDescription.EndpointContract;
import io.mdsl.apiDescription.ServiceSpecification;
import io.mdsl.dsl.ServiceSpecificationAdapter;
import io.mdsl.generator.protobuf.converter.DataType2MessageConverter;
import io.mdsl.generator.protobuf.converter.Endpoint2ServiceConverter;
import java.util.LinkedList;
import java.util.List;

public class MDSL2ProtobufConverter {
    private ServiceSpecificationAdapter mdslSpecification;
    private ProtoSpec.Builder proto;
    private DataType2MessageConverter dataContractConverter;
    private Endpoint2ServiceConverter endpointConverter;

    public MDSL2ProtobufConverter(ServiceSpecification mdslSpecification) {
        this.mdslSpecification = new ServiceSpecificationAdapter(mdslSpecification);
        this.proto = new ProtoSpec.Builder();
        this.dataContractConverter = new DataType2MessageConverter(this.proto);
        this.endpointConverter = new Endpoint2ServiceConverter(this.proto, this.dataContractConverter);
    }

    public ProtoSpec convert() {
        for (Message message : this.convertDataTypesToMessages()) {
            this.proto.withMessage(message);
        }
        for (Service service : this.convertEndpointsToServices(this.proto)) {
            this.proto.withService(service);
        }
        return this.proto.withPackage(this.mdslSpecification.getName()).build();
    }

    public List<Message> convertDataTypesToMessages() {
        LinkedList messages = Lists.newLinkedList();
        for (DataContract contract : this.mdslSpecification.getTypes()) {
            messages.add(this.dataContractConverter.convert(contract));
        }
        return messages;
    }

    public List<Service> convertEndpointsToServices(ProtoSpec.Builder protoSpec) {
        LinkedList services = Lists.newLinkedList();
        for (EndpointContract endpoint : this.mdslSpecification.getEndpointContracts()) {
            services.add(this.endpointConverter.convert(endpoint));
        }
        return services;
    }
}

