/*
 * Decompiled with CFR 0.152.
 */
package io.mdsl.generator.refactorings;

import io.mdsl.apiDescription.EndpointContract;
import io.mdsl.apiDescription.ServiceSpecification;
import io.mdsl.dsl.ServiceSpecificationAdapter;
import io.mdsl.generator.AbstractMDSLGenerator;
import io.mdsl.generator.refactorings.RefactoringHelpers;
import io.mdsl.transformations.HTTPBindingTransformations;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.generator.IFileSystemAccess2;

public class AddHttpBindingRefactoring
extends AbstractMDSLGenerator {
    private String sourceEndpoint;

    public AddHttpBindingRefactoring(String sourceEndpoint) {
        this.sourceEndpoint = sourceEndpoint;
    }

    @Override
    protected void generateFromServiceSpecification(ServiceSpecification mdslSpecification, IFileSystemAccess2 fsa, URI inputFileURI) {
        for (EndpointContract endpoint : new ServiceSpecificationAdapter(mdslSpecification).getEndpointContracts()) {
            if (!endpoint.getName().equals(this.sourceEndpoint)) continue;
            HTTPBindingTransformations hbts = new HTTPBindingTransformations();
            hbts.addBinding(endpoint);
            String result = "// Interface refactoring 'Add HTTP Binding' applied.\n";
            RefactoringHelpers.generateRefactoringOutput(mdslSpecification, fsa, inputFileURI, endpoint, result);
            return;
        }
        System.err.println("[W] Endpoint " + this.sourceEndpoint + " not found in input file.");
    }
}

