/*
 * Decompiled with CFR 0.152.
 */
package io.mdsl.generator.refactorings;

import io.mdsl.apiDescription.EndpointContract;
import io.mdsl.apiDescription.ServiceSpecification;
import io.mdsl.dsl.ServiceSpecificationAdapter;
import io.mdsl.generator.AbstractMDSLGenerator;
import io.mdsl.generator.refactorings.RefactoringHelpers;
import io.mdsl.transformations.OperationTransformations;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.generator.IFileSystemAccess2;

public class AddOperationsForRoleRefactoring
extends AbstractMDSLGenerator {
    private String sourceEndpoint = "TestName";

    public AddOperationsForRoleRefactoring(String sourceEndpoint) {
        this.sourceEndpoint = sourceEndpoint;
    }

    @Override
    protected void generateFromServiceSpecification(ServiceSpecification mdslSpecification, IFileSystemAccess2 fsa, URI inputFileURI) {
        for (EndpointContract endpoint : new ServiceSpecificationAdapter(mdslSpecification).getEndpointContracts()) {
            if (!endpoint.getName().equals(this.sourceEndpoint)) continue;
            String result = "// Interface refactoring 'Add Operations for MAP Decorator' applied.\n";
            OperationTransformations ot = new OperationTransformations();
            ot.addOperationsForRole(endpoint);
            RefactoringHelpers.generateRefactoringOutput(mdslSpecification, fsa, inputFileURI, endpoint, result);
            return;
        }
        System.err.println("[W] Endpoint " + this.sourceEndpoint + " not found in input file.");
    }
}

