/*
 * Decompiled with CFR 0.152.
 */
package io.mdsl.generator.refactorings;

import io.mdsl.apiDescription.EndpointContract;
import io.mdsl.apiDescription.Operation;
import io.mdsl.apiDescription.ServiceSpecification;
import io.mdsl.apiDescription.SingleParameterNode;
import io.mdsl.dsl.ServiceSpecificationAdapter;
import io.mdsl.generator.AbstractMDSLGenerator;
import io.mdsl.generator.refactorings.RefactoringHelpers;
import io.mdsl.transformations.DataTypeTransformations;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.generator.IFileSystemAccess2;

public class CompleteDataTypesRefactoring
extends AbstractMDSLGenerator {
    private String sourceEndpoint = "TestName";
    private String sourceOperation = "testOp";
    private String type = "string";
    private boolean applyToRequest = true;
    private boolean applyToResponse = true;

    public CompleteDataTypesRefactoring(String sourceEndpoint, String sourceOperation, String type, boolean applyToRequest, boolean applyToResponse) {
        this.sourceEndpoint = sourceEndpoint;
        this.sourceOperation = sourceOperation;
        this.type = type;
        this.applyToRequest = applyToRequest;
        this.applyToResponse = applyToResponse;
    }

    @Override
    protected void generateFromServiceSpecification(ServiceSpecification mdslSpecification, IFileSystemAccess2 fsa, URI inputFileURI) {
        for (EndpointContract endpoint : new ServiceSpecificationAdapter(mdslSpecification).getEndpointContracts()) {
            if (!endpoint.getName().equals(this.sourceEndpoint)) continue;
            for (Operation operation : endpoint.getOps()) {
                if (!operation.getName().equals(this.sourceOperation)) continue;
                String result = "";
                this.applyToRequestAndOrResponse(mdslSpecification, fsa, inputFileURI, operation, result);
                return;
            }
        }
        System.err.println("[W] Endpoint " + this.sourceEndpoint + " and/or operation " + this.sourceOperation + " not found in input file.");
    }

    private void applyToRequestAndOrResponse(ServiceSpecification mdslSpecification, IFileSystemAccess2 fsa, URI inputFileURI, Operation operation, CharSequence result) {
        SingleParameterNode spn;
        if (this.applyToRequest) {
            if (operation.getRequestMessage().getPayload().getNp() == null) {
                System.err.println("[W] Can not complete PTs");
                return;
            }
            spn = operation.getRequestMessage().getPayload().getNp();
            if (spn.getAtomP() != null) {
                DataTypeTransformations.completeDataType(spn.getAtomP().getRat(), this.type);
                result = "// Interface refactoring 'Complete Data Types' applied.\n";
                RefactoringHelpers.generateRefactoringOutput(mdslSpecification, fsa, inputFileURI, spn, result);
            } else if (spn.getGenP() != null) {
                DataTypeTransformations.convertToStringType(spn.getGenP());
                result = "// Interface refactoring 'Complete Data Types' applied.\n";
                RefactoringHelpers.generateRefactoringOutput(mdslSpecification, fsa, inputFileURI, spn, result);
            } else {
                System.err.println("[W] Can only complete APs and genPs at present");
            }
        }
        if (this.applyToResponse) {
            if (operation.getResponseMessage().getPayload().getNp() == null) {
                System.err.println("[W] Can not complete PTs");
                return;
            }
            spn = operation.getResponseMessage().getPayload().getNp();
            if (spn.getAtomP() != null) {
                DataTypeTransformations.completeDataType(spn.getAtomP().getRat(), this.type);
                result = "// Interface refactoring 'Complete Data Types' applied (request).\n";
                RefactoringHelpers.generateRefactoringOutput(mdslSpecification, fsa, inputFileURI, spn, result);
            } else if (spn.getGenP() != null) {
                DataTypeTransformations.convertToStringType(spn.getGenP());
                result = "// Interface refactoring 'Complete Data Types' applied (response).\n";
                RefactoringHelpers.generateRefactoringOutput(mdslSpecification, fsa, inputFileURI, spn, result);
            } else {
                System.err.println("Can only complete APs and genPs at present");
            }
        }
    }
}

