/*
 * Decompiled with CFR 0.152.
 */
package io.mdsl.generator.refactorings;

import io.mdsl.apiDescription.EndpointContract;
import io.mdsl.apiDescription.Operation;
import io.mdsl.apiDescription.ServiceSpecification;
import io.mdsl.dsl.ServiceSpecificationAdapter;
import io.mdsl.generator.AbstractMDSLGenerator;
import io.mdsl.generator.refactorings.RefactoringHelpers;
import io.mdsl.transformations.DataTypeTransformations;
import org.eclipse.emf.common.util.URI;
import org.eclipse.xtext.generator.IFileSystemAccess2;

public class ConvertInlinedTypeToTypeReferenceRefactorer
extends AbstractMDSLGenerator {
    private String sourceEndpoint = "TestName";
    private String sourceOperation = "testOp";
    private String typeName = "MessagePayload";

    public ConvertInlinedTypeToTypeReferenceRefactorer(String sourceEndpoint, String sourceOperation, String typeName) {
        this.sourceEndpoint = sourceEndpoint;
        this.sourceOperation = sourceOperation;
        this.typeName = typeName;
    }

    @Override
    protected void generateFromServiceSpecification(ServiceSpecification mdslSpecification, IFileSystemAccess2 fsa, URI inputFileURI) {
        for (EndpointContract endpoint : new ServiceSpecificationAdapter(mdslSpecification).getEndpointContracts()) {
            if (!endpoint.getName().equals(this.sourceEndpoint)) continue;
            for (Operation operation : endpoint.getOps()) {
                String result;
                if (!operation.getName().equals(this.sourceOperation)) continue;
                if (operation.getRequestMessage() != null) {
                    String requestTypeName = this.typeName != null ? operation.getName() + "Request" + this.typeName + "Type" : operation.getName() + "RequestType";
                    DataTypeTransformations.convertInlineTypeToTypeReference(operation.getRequestMessage(), requestTypeName);
                    result = "// Interface refactoring 'Convert Inlined Type to Type Reference' applied to a request payload.\n";
                    RefactoringHelpers.generateRefactoringOutput(mdslSpecification, fsa, inputFileURI, operation, result);
                }
                if (operation.getResponseMessage() != null) {
                    String responseTypeName = this.typeName != null ? operation.getName() + "Response" + this.typeName + "Type" : operation.getName() + "ResponseType";
                    DataTypeTransformations.convertInlineTypeToTypeReference(operation.getRequestMessage(), responseTypeName);
                    result = "// Interface refactoring 'Convert Inlined Type to Type Reference' applied to a response payload.\n";
                    RefactoringHelpers.generateRefactoringOutput(mdslSpecification, fsa, inputFileURI, operation, result);
                }
                return;
            }
        }
        System.err.println("[W] Endpoint " + this.sourceEndpoint + " and/or operation " + this.sourceOperation + " not found in input file.");
    }
}

