/*
 * Decompiled with CFR 0.152.
 */
package io.mdsl.generator.refactorings;

import io.mdsl.MDSLResource;
import io.mdsl.apiDescription.ElementStructure;
import io.mdsl.apiDescription.EndpointInstance;
import io.mdsl.apiDescription.HTTPResourceBinding;
import io.mdsl.apiDescription.Operation;
import io.mdsl.apiDescription.ServiceSpecification;
import io.mdsl.apiDescription.SingleParameterNode;
import io.mdsl.apiDescription.TechnologyBinding;
import io.mdsl.exception.MDSLException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.generator.IFileSystemAccess2;

public class RefactoringHelpers {
    public static void generateRefactoringOutput(ServiceSpecification mdslSpecification, IFileSystemAccess2 fsa, URI inputFileURI, EObject refactoringSubject, CharSequence result) {
        MDSLResource targetResource = new MDSLResource(refactoringSubject.eResource());
        result = result + targetResource.getXtextResource().getSerializer().serialize((EObject)mdslSpecification);
        fsa.generateFile(inputFileURI.trimFileExtension().lastSegment() + "_ref.mdsl", result);
    }

    public static HTTPResourceBinding getFirstOnlyResourceBinding(EndpointInstance httpb) {
        if (httpb == null) {
            throw new MDSLException("HTTP endpoint instance is null");
        }
        if (httpb.getPb() == null) {
            throw new MDSLException("No provider binding found at " + httpb.getLocation());
        }
        if (httpb.getPb().size() != 1) {
            throw new MDSLException("There should be one and only one provider binding under " + httpb.getLocation());
        }
        if (((TechnologyBinding)httpb.getPb().get(0)).getProtBinding().getHttp().getEb().size() != 1) {
            throw new MDSLException("There should be one and only one eb instance under " + httpb.getLocation());
        }
        HTTPResourceBinding binding = (HTTPResourceBinding)((TechnologyBinding)httpb.getPb().get(0)).getProtBinding().getHttp().getEb().get(0);
        return binding;
    }

    public static ElementStructure getRequestPayload(Operation operation) {
        return operation.getRequestMessage().getPayload();
    }

    public static ElementStructure getResponsePayload(Operation operation) {
        return operation.getResponseMessage().getPayload();
    }

    public static SingleParameterNode findWrappingTargetInRequest(Operation operation) {
        if (operation.getRequestMessage() == null) {
            return null;
        }
        if (operation.getRequestMessage().getPayload() == null) {
            return null;
        }
        return operation.getRequestMessage().getPayload().getNp();
    }

    public static SingleParameterNode findWrappingTargetInResponse(Operation operation) {
        if (operation.getResponseMessage() == null) {
            return null;
        }
        if (operation.getResponseMessage().getPayload() == null) {
            return null;
        }
        return operation.getResponseMessage().getPayload().getNp();
    }
}

