/*
 * Decompiled with CFR 0.152.
 */
package io.mdsl.transformations;

import io.mdsl.apiDescription.DataContract;
import io.mdsl.apiDescription.ServiceSpecification;
import io.mdsl.apiDescription.SingleParameterNode;
import io.mdsl.apiDescription.TreeNode;
import org.apache.commons.lang.WordUtils;

public class DataTypeTransformationHelpers {
    static final String VOID = "void";
    static final String DOUBLE = "double";
    static final String LONG = "long";
    static final String RAW = "raw";
    static final String BOOL = "bool";
    static final String STRING = "string";
    static final String INT = "int";
    static final String ID_ROLE = "ID";
    static final String METADATA_ROLE = "MD";
    static final String DATA_ROLE = "D";
    static final String LINK_ROLE = "L";
    static final String ANONYMOUS_ID = "anonymousNode";
    static final String ANONYMOUS = "anonymous";
    static final String ANONYMOUS_TYPE = "AnonymousTypeReference";
    static final String DTO_SUFFIX = "DTO";

    static boolean isValidTypeRole(String role) {
        if (role == null) {
            return false;
        }
        return role.equals(DATA_ROLE) || role.equals(METADATA_ROLE) || role.equals(ID_ROLE) || role.equals(LINK_ROLE);
    }

    static boolean isValidBaseType(String dataType) {
        if (dataType == null || dataType.equals("")) {
            return true;
        }
        if (dataType.equals(INT)) {
            return true;
        }
        if (dataType.equals(STRING)) {
            return true;
        }
        if (dataType.equals(BOOL)) {
            return true;
        }
        if (dataType.equals(RAW)) {
            return true;
        }
        if (dataType.equals(LONG)) {
            return true;
        }
        if (dataType.equals(DOUBLE)) {
            return true;
        }
        return dataType.equals(VOID);
    }

    static boolean addIfNotPresent(ServiceSpecification ss, DataContract dt) {
        for (DataContract type : ss.getTypes()) {
            if (!type.getName().equals(dt.getName())) continue;
            return false;
        }
        ss.getTypes().add((Object)dt);
        return true;
    }

    public static String nameOf(TreeNode tn) {
        String result = null;
        if (tn.getPn() != null) {
            result = DataTypeTransformationHelpers.nameOf(tn.getPn());
        } else if (tn.getApl() != null) {
            result = tn.getApl().getName();
        } else if (tn.getChildren() != null) {
            result = tn.getChildren().getName();
        }
        if (result == null || result.isEmpty()) {
            result = ANONYMOUS_ID;
        }
        return result;
    }

    public static String nameForElement(String name, String suffix) {
        if (name == null || name.isEmpty()) {
            return ANONYMOUS + suffix;
        }
        return name + suffix;
    }

    public static String nameOf(SingleParameterNode spn) {
        String result = null;
        if (spn.getAtomP() != null) {
            result = spn.getAtomP().getRat().getName();
        } else if (spn.getGenP() != null) {
            result = spn.getGenP().getName();
        } else if (spn.getTr() != null) {
            result = spn.getTr().getName();
        }
        if (result == null || result.isEmpty()) {
            result = ANONYMOUS_ID;
        }
        return result;
    }

    public static String replaceSpacesWithUnderscores(String name) {
        return name.replace(" ", "_");
    }

    public static String decapitalizeName(String name) {
        return WordUtils.uncapitalize((String)name);
    }

    public static String capitalizeName(String name) {
        return WordUtils.capitalize((String)name);
    }
}

