/*
 * Decompiled with CFR 0.152.
 */
package io.mdsl.transformations;

import io.mdsl.apiDescription.ApiDescriptionFactory;
import io.mdsl.apiDescription.CombinedInvocationStep;
import io.mdsl.apiDescription.CommandInvokation;
import io.mdsl.apiDescription.CommandInvokationStep;
import io.mdsl.apiDescription.CommandType;
import io.mdsl.apiDescription.DomainEventProductionStep;
import io.mdsl.apiDescription.EndpointContract;
import io.mdsl.apiDescription.Event;
import io.mdsl.apiDescription.EventProduction;
import io.mdsl.apiDescription.EventType;
import io.mdsl.apiDescription.FlowStep;
import io.mdsl.apiDescription.Operation;
import io.mdsl.apiDescription.Orchestration;
import io.mdsl.apiDescription.ServiceSpecification;
import io.mdsl.apiDescription.StateTransition;
import io.mdsl.transformations.DataTypeTransformationHelpers;
import io.mdsl.transformations.OperationTransformationHelpers;
import io.mdsl.transformations.TransformationHelpers;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;

public class FlowTransformationHelpers {
    public static final String ENDPOINT_NAME_SUFFIX = "Endpoint";
    private static final String OPERATION_EXECUTED_SUFFIX = "Executed";
    private static final String OPERATION_TRIGGERED_SUFFIX = "Triggered";
    private static final String FLOW_START_EVENT_SUFFIX = "Initiated";
    private static final String EVENT_EMISSION_PREFIX = "emit";
    private static final String DEFAULT_OPERATION_NAME = "defaultOperationName";

    public static void createStateTransitionOperationForCommand(CommandInvokationStep cmdis) {
        CommandInvokation ci = cmdis.getAction().getCi();
        EList<EventType> events = cmdis.getEvents();
        EndpointContract ec = FlowTransformationHelpers.findOrCreateEndpointContract(cmdis);
        events.forEach(event -> FlowTransformationHelpers.addReceivingEventToEndpointContract(event, ec));
        EList<CommandType> commandList = FlowTransformationHelpers.getCommandListOfStep(ci);
        commandList.forEach(command -> FlowTransformationHelpers.createCommandOperationIfPossible(ec, command.getName()));
    }

    public static void createCommandOperationIfPossible(EndpointContract ec, String opName) {
        if (TransformationHelpers.findOperationInContract(ec, DataTypeTransformationHelpers.decapitalizeName(opName)) == null) {
            Operation operation = OperationTransformationHelpers.createStateManipulatingOperation(opName);
            StateTransition stateTransition = ApiDescriptionFactory.eINSTANCE.createStateTransition();
            stateTransition.setFrom(opName + OPERATION_TRIGGERED_SUFFIX);
            stateTransition.setTo(opName + OPERATION_EXECUTED_SUFFIX);
            operation.setSt(stateTransition);
            ec.getOps().add((Object)operation);
        } else {
            TransformationHelpers.reportWarning("Not creating command invocation operation, name " + DataTypeTransformationHelpers.decapitalizeName(opName) + " already taken");
        }
    }

    public static void addReceivingEventToEndpointContract(EventType receivedEventType, EndpointContract ec) {
        Event eventReference = ApiDescriptionFactory.eINSTANCE.createEvent();
        eventReference.setType(receivedEventType);
        ec.getEvents().add((Object)eventReference);
    }

    public static void createEventProcessorOperationForEventProduction(EventProduction ep) {
        ServiceSpecification ss = (ServiceSpecification)ep.eContainer().eContainer().eContainer().eContainer();
        EndpointContract ec = TransformationHelpers.findOrCreateEndpointType(ss, FlowTransformationHelpers.endpointNameForFlow((Orchestration)ep.eContainer().eContainer().eContainer()));
        if (ep.getSep() != null) {
            String opName = FlowTransformationHelpers.turnEventNameIntoOperationName((EventType)ep.getSep().getEvents().get(0));
            if (TransformationHelpers.findOperationInContract(ec, DataTypeTransformationHelpers.decapitalizeName(opName)) != null) {
                TransformationHelpers.reportWarning("Not creating event processor operation, name " + DataTypeTransformationHelpers.decapitalizeName(opName) + " already taken.");
            } else {
                Operation eventEmissionOperation = OperationTransformationHelpers.createEventProductionOperation(opName);
                ec.getOps().add((Object)eventEmissionOperation);
                EventType de = (EventType)ep.getSep().getEvents().get(0);
                FlowTransformationHelpers.createAndAddEvent(opName, eventEmissionOperation, de);
            }
        } else if (ep.getMep() != null) {
            for (EventType event : ep.getMep().getEvents()) {
                String opName = FlowTransformationHelpers.turnEventNameIntoOperationName(event);
                if (TransformationHelpers.findOperationInContract(ec, DataTypeTransformationHelpers.decapitalizeName(opName)) != null) {
                    TransformationHelpers.reportWarning("Not creating event processor operation, name " + DataTypeTransformationHelpers.decapitalizeName(opName) + " already taken.");
                    continue;
                }
                Operation eventEmissionOperation = OperationTransformationHelpers.createEventProductionOperation(opName);
                ec.getOps().add((Object)eventEmissionOperation);
                FlowTransformationHelpers.createAndAddEvent(opName, eventEmissionOperation, event);
            }
        } else if (ep.getIaep() != null) {
            for (EventType event : ep.getIaep().getEvents()) {
                String opName = FlowTransformationHelpers.turnEventNameIntoOperationName(event);
                if (TransformationHelpers.findOperationInContract(ec, DataTypeTransformationHelpers.decapitalizeName(opName)) != null) {
                    TransformationHelpers.reportWarning("Not creating event processor operation, name " + DataTypeTransformationHelpers.decapitalizeName(opName) + " already taken");
                    continue;
                }
                Operation eventEmissionOperation = OperationTransformationHelpers.createEventProductionOperation(opName);
                ec.getOps().add((Object)eventEmissionOperation);
                FlowTransformationHelpers.createAndAddEvent(opName, eventEmissionOperation, event);
            }
        } else if (ep.getEaep() != null) {
            for (EventType event : ep.getEaep().getEvents()) {
                String opName = FlowTransformationHelpers.turnEventNameIntoOperationName(event);
                if (TransformationHelpers.findOperationInContract(ec, DataTypeTransformationHelpers.decapitalizeName(opName)) != null) {
                    TransformationHelpers.reportWarning("Not creating event processor operation, name " + DataTypeTransformationHelpers.decapitalizeName(opName) + " already taken");
                    continue;
                }
                Operation eventEmissionOperation = OperationTransformationHelpers.createEventProductionOperation(opName);
                ec.getOps().add((Object)eventEmissionOperation);
                FlowTransformationHelpers.createAndAddEvent(opName, eventEmissionOperation, event);
            }
        } else {
            TransformationHelpers.reportError("Unknown type of ep structure.");
        }
    }

    public static void createAndAddEvent(String opName, Operation eventEmissionOperation, EventType de) {
        if (de != null) {
            Event ev = ApiDescriptionFactory.eINSTANCE.createEvent();
            ev.setType(de);
            eventEmissionOperation.getEvents().add((Object)ev);
        } else {
            System.err.println("Event type not found in flow, not adding event " + opName);
        }
    }

    public static Event createFlowInitiationEvent(ServiceSpecification ss, Orchestration flow) {
        EventType de = TransformationHelpers.findOrCreateEventType(ss, flow.getName() + FLOW_START_EVENT_SUFFIX);
        Event re = ApiDescriptionFactory.eINSTANCE.createEvent();
        re.setType(de);
        return re;
    }

    public static EndpointContract findOrCreateEndpointContract(CommandInvokationStep element) {
        Orchestration flow = null;
        flow = element.eContainer() instanceof CombinedInvocationStep ? (Orchestration)element.eContainer().eContainer().eContainer() : (Orchestration)element.eContainer().eContainer();
        ServiceSpecification ss = (ServiceSpecification)flow.eContainer();
        EndpointContract ec = TransformationHelpers.findOrCreateEndpointType(ss, FlowTransformationHelpers.endpointNameForFlow(flow));
        return ec;
    }

    public static List<FlowStep> findAllPeersOfStep(Orchestration flow, CommandType command) {
        ArrayList<FlowStep> result = new ArrayList<FlowStep>();
        for (FlowStep step : flow.getSteps()) {
            if (step.getDepStep() == null || step.getDepStep().getEventProduction().getSep() == null || !step.getDepStep().getAction().getCommand().getName().equals(command.getName())) continue;
            result.add(step);
        }
        return result;
    }

    public static List<EventType> eventsInSimpleDEPSteps(List<FlowStep> stepsToBeMerged) {
        ArrayList<EventType> result = new ArrayList<EventType>();
        stepsToBeMerged.forEach(eventStep -> result.add((EventType)eventStep.getDepStep().getEventProduction().getSep().getEvents().get(0)));
        return result;
    }

    public static String endpointNameForFlow(Orchestration flow) {
        return flow.getName() + ENDPOINT_NAME_SUFFIX;
    }

    public static String turnEventNameIntoOperationName(EventType event) {
        return EVENT_EMISSION_PREFIX + event.getName();
    }

    public static String getSimpleCommandName(DomainEventProductionStep depStep) {
        String opName = DEFAULT_OPERATION_NAME;
        try {
            opName = DataTypeTransformationHelpers.capitalizeName(((EventType)depStep.getEventProduction().getSep().getEvents().get(0)).getName());
        }
        catch (Exception e) {
            TransformationHelpers.reportError("Unsupported flow syntax. Only simple domain event production steps can be transformed at present.");
        }
        return opName;
    }

    public static EList<CommandType> getCommandListOfStep(CommandInvokation ci) {
        if (ci.getSci() != null) {
            return ci.getSci().getCommands();
        }
        if (ci.getCci() != null) {
            return ci.getCci().getCommands();
        }
        if (ci.getEaci() != null) {
            return ci.getEaci().getCommands();
        }
        if (ci.getIaci() != null) {
            return ci.getIaci().getCommands();
        }
        TransformationHelpers.reportError("Unsupported type of command invocation");
        return null;
    }
}

