/*
 * Decompiled with CFR 0.152.
 */
package io.mdsl.transformations;

import io.mdsl.apiDescription.ApiDescriptionFactory;
import io.mdsl.apiDescription.CombinedInvocationStep;
import io.mdsl.apiDescription.CommandInvokation;
import io.mdsl.apiDescription.CommandInvokationStep;
import io.mdsl.apiDescription.CommandType;
import io.mdsl.apiDescription.ConcurrentCommandInvokation;
import io.mdsl.apiDescription.DomainEventProductionStep;
import io.mdsl.apiDescription.EitherCommandOrOperation;
import io.mdsl.apiDescription.EitherCommandOrOperationInvokation;
import io.mdsl.apiDescription.EndpointContract;
import io.mdsl.apiDescription.Event;
import io.mdsl.apiDescription.EventProduction;
import io.mdsl.apiDescription.EventType;
import io.mdsl.apiDescription.ExclusiveAlternativeEventProduction;
import io.mdsl.apiDescription.FlowStep;
import io.mdsl.apiDescription.InclusiveAlternativeEventProduction;
import io.mdsl.apiDescription.IntegrationScenario;
import io.mdsl.apiDescription.IntegrationStory;
import io.mdsl.apiDescription.Orchestration;
import io.mdsl.apiDescription.ServiceSpecification;
import io.mdsl.apiDescription.SingleCommandInvokation;
import io.mdsl.apiDescription.SingleEventProduction;
import io.mdsl.exception.MDSLException;
import io.mdsl.transformations.DataTypeTransformationHelpers;
import io.mdsl.transformations.FlowTransformationHelpers;
import io.mdsl.transformations.ScenarioTransformationHelpers;
import io.mdsl.transformations.TransformationHelpers;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class FlowTransformations {
    public static final String DEP_STEP = "DEP_STEP";
    public static final String CIS_STEP = "CIS_STEP";
    private static final String FLOW_NAME_SUFFIX = "Flow";
    private static final String COMMAND_NAME_SUFFIX = "Processor";
    private static final String EVENT_NAME_SUFFIX = "Trigger";
    private static final String COMPLETED_SUFFIX = "Completed";

    public void addApplicationFlowForScenario(IntegrationScenario scenario) {
        ServiceSpecification ss = (ServiceSpecification)scenario.eContainer();
        Orchestration flow = this.createFlowIfPossible(ss, scenario);
        for (IntegrationStory story : scenario.getStories()) {
            FlowStep fs = this.stepForStory(ss, story);
            flow.getSteps().add((Object)fs);
        }
        ss.getOrchestrations().add((Object)flow);
    }

    public void consolidateFlowSteps(DomainEventProductionStep depStep, String branchingType) {
        CommandType command = depStep.getAction().getCommand();
        Orchestration flow = (Orchestration)depStep.eContainer().eContainer();
        FlowStep step = (FlowStep)depStep.eContainer();
        List<FlowStep> stepsToBeMerged = FlowTransformationHelpers.findAllPeersOfStep(flow, command);
        if (stepsToBeMerged.size() > 1) {
            int position = flow.getSteps().indexOf((Object)step);
            List<EventType> eventSteps = FlowTransformationHelpers.eventsInSimpleDEPSteps(stepsToBeMerged);
            if (eventSteps.size() > 1) {
                FlowStep mergedDepStep = this.createAlternativeDEPStep(flow, command, eventSteps);
                flow.getSteps().add(position, (Object)mergedDepStep);
                flow.getSteps().removeAll(stepsToBeMerged);
            }
        }
    }

    public void splitCombinedFlowStep(CombinedInvocationStep eceStep) {
        FlowStep step = (FlowStep)eceStep.eContainer();
        Orchestration flow = (Orchestration)step.eContainer();
        CommandInvokationStep cis = eceStep.getCisStep();
        EventProduction ep = eceStep.getEventProduction();
        int position = flow.getSteps().indexOf((Object)step);
        step.setEceStep(null);
        step.setCisStep(cis);
        try {
            CommandType commandInEceStep = (CommandType)cis.getAction().getCi().getSci().getCommands().get(0);
            EitherCommandOrOperation simpleCommand = ApiDescriptionFactory.eINSTANCE.createEitherCommandOrOperation();
            simpleCommand.setCommand(commandInEceStep);
            DomainEventProductionStep depStep = ApiDescriptionFactory.eINSTANCE.createDomainEventProductionStep();
            depStep.setEventProduction((EventProduction)EcoreUtil.copy((EObject)ep));
            depStep.setAction(simpleCommand);
            FlowStep depFlowStep = ApiDescriptionFactory.eINSTANCE.createFlowStep();
            depFlowStep.setDepStep(depStep);
            flow.getSteps().add(position + 1, (Object)depFlowStep);
        }
        catch (Exception e) {
            throw new MDSLException("Split Combined Flow Step is only ssupported for simple commands.");
        }
    }

    public void addBranchesWithMerge(EObject element, String branchingType) {
        if (branchingType.equals("AND")) {
            this.addAndBranchesWithMerge(element);
        } else if (branchingType.equals("OR")) {
            this.addChoiceBranchesWithMerge(element);
        } else {
            throw new MDSLException("Unknown type of transformation: " + branchingType);
        }
    }

    private void addChoiceBranchesWithMerge(EObject element) {
        if (!(element instanceof CommandInvokationStep)) {
            throw new MDSLException("This transformation expects a command invocation step");
        }
        CommandInvokationStep cis = (CommandInvokationStep)element;
        if (cis.eContainer() instanceof CombinedInvocationStep) {
            throw new MDSLException("This transformation cannot be invoked on combined invocation steps.");
        }
        Orchestration flow = (Orchestration)cis.eContainer().eContainer();
        ServiceSpecification ss = (ServiceSpecification)flow.eContainer();
        EList<CommandType> commands = FlowTransformationHelpers.getCommandListOfStep(cis.getAction().getCi());
        if (commands.size() != 1) {
            TransformationHelpers.reportError("Adding choice branches only works if command(s) in this step emit a single command.");
        }
        CommandType trigger = (CommandType)commands.get(0);
        EventType choice1 = TransformationHelpers.findOrCreateUniqueEventType(ss, trigger.getName() + "Choice1");
        EventType choice2 = TransformationHelpers.findOrCreateUniqueEventType(ss, trigger.getName() + "Choice2");
        ArrayList<EventType> choices = new ArrayList<EventType>();
        choices.add(choice1);
        choices.add(choice2);
        this.createExclusiveChoiceDEPStep(flow, trigger, choices);
        this.createAggregator(flow, choices, trigger.getName() + "_Choice1_Choice2_JoinProcessor");
    }

    public void addAndBranchesWithMerge(EObject element) {
        if (!(element instanceof DomainEventProductionStep)) {
            throw new MDSLException("This transformation expects a domain event production step");
        }
        DomainEventProductionStep depStep = (DomainEventProductionStep)element;
        Orchestration flow = (Orchestration)depStep.eContainer().eContainer();
        EList<EventType> events = this.getEventListOfStep(depStep);
        if (events.size() != 1) {
            TransformationHelpers.reportError("Adding parallel branches only works if command(s) in this step emit a single event.");
        }
        EventType event = (EventType)events.get(0);
        FlowStep newStep = this.createCISStepWithTwoConcurrentCommandInvocations(flow, event);
        flow.getSteps().add((Object)newStep);
        try {
            CommandType ct1 = (CommandType)newStep.getCisStep().getAction().getCi().getCci().getCommands().get(0);
            CommandType ct2 = (CommandType)newStep.getCisStep().getAction().getCi().getCci().getCommands().get(1);
            DomainEventProductionStep branch1Done = this.createSimpleDEPStepAndAddItToFlow(flow, ct1);
            DomainEventProductionStep branch2Done = this.createSimpleDEPStepAndAddItToFlow(flow, ct2);
            EventType branchEvent1 = (EventType)branch1Done.getEventProduction().getSep().getEvents().get(0);
            EventType branchEvent2 = (EventType)branch2Done.getEventProduction().getSep().getEvents().get(0);
            ArrayList<EventType> eventList = new ArrayList<EventType>();
            eventList.add(branchEvent1);
            eventList.add(branchEvent2);
            this.createAggregator(flow, eventList, event.getName() + "1_" + event.getName() + "2_JoinProcessor");
        }
        catch (Exception e) {
            TransformationHelpers.reportError("Unexpected flow and flow step structure, cannot apply transformation");
        }
    }

    private FlowStep createCISStepWithTwoConcurrentCommandInvocations(Orchestration flow, EventType event) {
        ServiceSpecification ss = (ServiceSpecification)flow.eContainer();
        CommandInvokationStep cisStep = ApiDescriptionFactory.eINSTANCE.createCommandInvokationStep();
        cisStep.getEvents().add((Object)event);
        String suggestedCommandName = DataTypeTransformationHelpers.replaceSpacesWithUnderscores(event.getName()) + COMMAND_NAME_SUFFIX;
        CommandType ct1 = TransformationHelpers.findOrCreateUniqueCommandType(ss, suggestedCommandName + "1");
        CommandType ct2 = TransformationHelpers.findOrCreateUniqueCommandType(ss, suggestedCommandName + "2");
        EitherCommandOrOperationInvokation ecoi = ApiDescriptionFactory.eINSTANCE.createEitherCommandOrOperationInvokation();
        CommandInvokation ci = ApiDescriptionFactory.eINSTANCE.createCommandInvokation();
        ConcurrentCommandInvokation cci = ApiDescriptionFactory.eINSTANCE.createConcurrentCommandInvokation();
        cci.getCommands().add((Object)ct1);
        cci.getCommands().add((Object)ct2);
        ci.setCci(cci);
        ecoi.setCi(ci);
        cisStep.setAction(ecoi);
        FlowStep fs = ApiDescriptionFactory.eINSTANCE.createFlowStep();
        fs.setCisStep(cisStep);
        return fs;
    }

    public void addCisStep(EObject element) {
        if (!(element instanceof DomainEventProductionStep)) {
            throw new MDSLException("This transformation expects a domain event production step");
        }
        DomainEventProductionStep depStep = (DomainEventProductionStep)element;
        Orchestration flow = (Orchestration)depStep.eContainer().eContainer();
        EList<EventType> events = this.getEventListOfStep(depStep);
        events.forEach(event -> this.createCISStep(flow, (EventType)event, null));
    }

    private CommandInvokationStep createAggregator(Orchestration flow, List<EventType> eventList, String suggestedCommandName) {
        ServiceSpecification ss = (ServiceSpecification)flow.eContainer();
        CommandInvokationStep cisStep = ApiDescriptionFactory.eINSTANCE.createCommandInvokationStep();
        eventList.forEach(event -> cisStep.getEvents().add(event));
        CommandType ct = TransformationHelpers.findOrCreateUniqueCommandType(ss, suggestedCommandName);
        EitherCommandOrOperationInvokation ecoi = ApiDescriptionFactory.eINSTANCE.createEitherCommandOrOperationInvokation();
        CommandInvokation ci = ApiDescriptionFactory.eINSTANCE.createCommandInvokation();
        SingleCommandInvokation sci = ApiDescriptionFactory.eINSTANCE.createSingleCommandInvokation();
        sci.getCommands().add((Object)ct);
        ci.setSci(sci);
        ecoi.setCi(ci);
        cisStep.setAction(ecoi);
        FlowStep fs = ApiDescriptionFactory.eINSTANCE.createFlowStep();
        fs.setCisStep(cisStep);
        flow.getSteps().add((Object)fs);
        return cisStep;
    }

    private CommandInvokationStep createCISStep(Orchestration flow, EventType event, String suggestedCommandName) {
        ServiceSpecification ss = (ServiceSpecification)flow.eContainer();
        CommandInvokationStep cisStep = ApiDescriptionFactory.eINSTANCE.createCommandInvokationStep();
        cisStep.getEvents().add((Object)event);
        if (suggestedCommandName == null || suggestedCommandName.equals("")) {
            suggestedCommandName = DataTypeTransformationHelpers.replaceSpacesWithUnderscores(event.getName()) + COMMAND_NAME_SUFFIX;
        }
        CommandType ct = TransformationHelpers.findOrCreateUniqueCommandType(ss, suggestedCommandName);
        EitherCommandOrOperationInvokation ecoi = ApiDescriptionFactory.eINSTANCE.createEitherCommandOrOperationInvokation();
        CommandInvokation ci = ApiDescriptionFactory.eINSTANCE.createCommandInvokation();
        SingleCommandInvokation sci = ApiDescriptionFactory.eINSTANCE.createSingleCommandInvokation();
        sci.getCommands().add((Object)ct);
        ci.setSci(sci);
        ecoi.setCi(ci);
        cisStep.setAction(ecoi);
        FlowStep fs = ApiDescriptionFactory.eINSTANCE.createFlowStep();
        fs.setCisStep(cisStep);
        flow.getSteps().add((Object)fs);
        return cisStep;
    }

    public void addDepStep(EObject element) {
        if (!(element instanceof CommandInvokationStep)) {
            throw new MDSLException("This transformation expects a domain event production step");
        }
        CommandInvokationStep ciStep = (CommandInvokationStep)element;
        if (ciStep.eContainer() instanceof CombinedInvocationStep) {
            throw new MDSLException("This transformation cannot be invoked on combined invocation steps.");
        }
        Orchestration flow = (Orchestration)ciStep.eContainer().eContainer();
        CommandInvokation ci = ciStep.getAction().getCi();
        EList<CommandType> commands = this.getCommandsOfStep(ci);
        commands.forEach(command -> this.createSimpleDEPStepAndAddItToFlow(flow, (CommandType)command));
    }

    private DomainEventProductionStep createExclusiveChoiceDEPStep(Orchestration flow, CommandType command, List<EventType> events) {
        DomainEventProductionStep depStep = ApiDescriptionFactory.eINSTANCE.createDomainEventProductionStep();
        EventProduction ep = ApiDescriptionFactory.eINSTANCE.createEventProduction();
        depStep.setEventProduction(ep);
        EitherCommandOrOperation coo = ApiDescriptionFactory.eINSTANCE.createEitherCommandOrOperation();
        coo.setCommand(command);
        depStep.setAction(coo);
        ExclusiveAlternativeEventProduction orChoices = ApiDescriptionFactory.eINSTANCE.createExclusiveAlternativeEventProduction();
        events.forEach(event -> orChoices.getEvents().add(event));
        ep.setEaep(orChoices);
        this.createAndAddFlowStep(flow, depStep);
        return depStep;
    }

    private DomainEventProductionStep createSimpleDEPStepAndAddItToFlow(Orchestration flow, CommandType ct) {
        DomainEventProductionStep depStep = ApiDescriptionFactory.eINSTANCE.createDomainEventProductionStep();
        EitherCommandOrOperation coo = ApiDescriptionFactory.eINSTANCE.createEitherCommandOrOperation();
        coo.setCommand(ct);
        depStep.setAction(coo);
        ServiceSpecification ss = (ServiceSpecification)flow.eContainer();
        String suggestedEventName = DataTypeTransformationHelpers.replaceSpacesWithUnderscores(ct.getName()) + COMPLETED_SUFFIX;
        EventType de = TransformationHelpers.findOrCreateUniqueEventType(ss, suggestedEventName);
        this.createAndAddSingleEventReference(depStep, de);
        this.createAndAddFlowStep(flow, depStep);
        return depStep;
    }

    private void createAndAddSingleEventReference(DomainEventProductionStep depStep, EventType de) {
        EventProduction ep = ApiDescriptionFactory.eINSTANCE.createEventProduction();
        SingleEventProduction sep = ApiDescriptionFactory.eINSTANCE.createSingleEventProduction();
        sep.getEvents().add((Object)de);
        ep.setSep(sep);
        depStep.setEventProduction(ep);
        depStep.getEventProduction().getSep().getEvents().add((Object)de);
    }

    private void createAndAddFlowStep(Orchestration flow, DomainEventProductionStep depStep) {
        FlowStep fs = ApiDescriptionFactory.eINSTANCE.createFlowStep();
        fs.setDepStep(depStep);
        flow.getSteps().add((Object)fs);
    }

    public void addEndpointTypeSupportingFlow(Orchestration flow) {
        ServiceSpecification ss = (ServiceSpecification)flow.eContainer();
        EndpointContract ec = TransformationHelpers.findOrCreateEndpointType(ss, flow.getName() + "Endpoint");
        ec.setFlow(flow);
        ec.setPrimaryRole("PROCESSING_RESOURCE");
        for (FlowStep step : flow.getSteps()) {
            if (step.getCisStep() != null) {
                FlowTransformationHelpers.createStateTransitionOperationForCommand(step.getCisStep());
                continue;
            }
            if (step.getDepStep() != null) {
                FlowTransformationHelpers.createEventProcessorOperationForEventProduction(step.getDepStep().getEventProduction());
                continue;
            }
            if (step.getEceStep() != null) {
                CommandInvokationStep cis = step.getEceStep().getCisStep();
                FlowTransformationHelpers.createStateTransitionOperationForCommand(cis);
                EventProduction ep = step.getEceStep().getEventProduction();
                FlowTransformationHelpers.createEventProcessorOperationForEventProduction(ep);
                continue;
            }
            TransformationHelpers.reportWarning("Unknown type of flow step.");
        }
        Event re = FlowTransformationHelpers.createFlowInitiationEvent(ss, flow);
        ec.getEvents().add((Object)re);
        ss.getContracts().add((Object)ec);
    }

    public void addOperationForFlowStep(EObject element, String stepType) {
        if (stepType.equals(CIS_STEP)) {
            if (element instanceof CommandInvokationStep) {
                FlowTransformationHelpers.createStateTransitionOperationForCommand((CommandInvokationStep)element);
            } else {
                TransformationHelpers.reportError("Unexpected element type: " + element.getClass().getSimpleName());
            }
        } else if (stepType.equals(DEP_STEP)) {
            if (element instanceof DomainEventProductionStep) {
                FlowTransformationHelpers.createEventProcessorOperationForEventProduction(((DomainEventProductionStep)element).getEventProduction());
            } else {
                TransformationHelpers.reportError("Unexpected element type: " + element.getClass().getSimpleName());
            }
        } else {
            TransformationHelpers.reportError("Unknown step type: " + stepType);
        }
    }

    private Orchestration createFlowIfPossible(ServiceSpecification ss, IntegrationScenario scenario) {
        String suggestedName = scenario.getName() + FLOW_NAME_SUFFIX;
        for (Orchestration exflow : ss.getOrchestrations()) {
            if (!exflow.getName().equals(suggestedName)) continue;
            return exflow;
        }
        Orchestration flow = ApiDescriptionFactory.eINSTANCE.createOrchestration();
        flow.setName(suggestedName);
        flow.setScenario(scenario);
        return flow;
    }

    private FlowStep stepForStory(ServiceSpecification ss, IntegrationStory story) {
        FlowStep fs = ApiDescriptionFactory.eINSTANCE.createFlowStep();
        CommandInvokationStep cis = ApiDescriptionFactory.eINSTANCE.createCommandInvokationStep();
        EitherCommandOrOperationInvokation coi = ApiDescriptionFactory.eINSTANCE.createEitherCommandOrOperationInvokation();
        CommandInvokation ci = ApiDescriptionFactory.eINSTANCE.createCommandInvokation();
        SingleCommandInvokation sci = ApiDescriptionFactory.eINSTANCE.createSingleCommandInvokation();
        String storyAction = ScenarioTransformationHelpers.getActionName(story.getAction(), ScenarioTransformationHelpers.getFirstObjectName(story));
        String suggestedEventName = null;
        suggestedEventName = story.getCondition() == null || story.getCondition().isEmpty() ? DataTypeTransformationHelpers.replaceSpacesWithUnderscores(storyAction) + EVENT_NAME_SUFFIX : DataTypeTransformationHelpers.replaceSpacesWithUnderscores(story.getCondition());
        EventType de = TransformationHelpers.findOrCreateUniqueEventType(ss, suggestedEventName);
        cis.getEvents().add((Object)de);
        CommandType ct = TransformationHelpers.findOrCreateUniqueCommandType(ss, DataTypeTransformationHelpers.replaceSpacesWithUnderscores(storyAction));
        sci.getCommands().add((Object)ct);
        ci.setSci(sci);
        coi.setCi(ci);
        cis.setAction(coi);
        fs.setCisStep(cis);
        return fs;
    }

    private EList<EventType> getEventListOfStep(DomainEventProductionStep depStep) {
        if (depStep.getEventProduction().getSep() != null) {
            return depStep.getEventProduction().getSep().getEvents();
        }
        if (depStep.getEventProduction().getMep() != null) {
            return depStep.getEventProduction().getMep().getEvents();
        }
        if (depStep.getEventProduction().getEaep() != null) {
            return depStep.getEventProduction().getEaep().getEvents();
        }
        if (depStep.getEventProduction().getIaep() != null) {
            return depStep.getEventProduction().getIaep().getEvents();
        }
        TransformationHelpers.reportError("Unknown type of domain production step.");
        return null;
    }

    private EList<CommandType> getCommandsOfStep(CommandInvokation ci) {
        if (ci.getSci() != null) {
            return ci.getSci().getCommands();
        }
        if (ci.getCci() != null) {
            return ci.getCci().getCommands();
        }
        if (ci.getEaci() != null) {
            return ci.getEaci().getCommands();
        }
        if (ci.getIaci() != null) {
            return ci.getIaci().getCommands();
        }
        TransformationHelpers.reportError("Unknown type of command invocation step.");
        return null;
    }

    private FlowStep createAlternativeDEPStep(Orchestration flow, CommandType command, List<EventType> events) {
        DomainEventProductionStep depStep = ApiDescriptionFactory.eINSTANCE.createDomainEventProductionStep();
        EitherCommandOrOperation coo = ApiDescriptionFactory.eINSTANCE.createEitherCommandOrOperation();
        coo.setCommand(command);
        depStep.setAction(coo);
        EventProduction ep = ApiDescriptionFactory.eINSTANCE.createEventProduction();
        InclusiveAlternativeEventProduction ieap = ApiDescriptionFactory.eINSTANCE.createInclusiveAlternativeEventProduction();
        events.forEach(event -> ieap.getEvents().add(event));
        ep.setIaep(ieap);
        depStep.setEventProduction(ep);
        FlowStep flowStep = ApiDescriptionFactory.eINSTANCE.createFlowStep();
        flowStep.setDepStep(depStep);
        return flowStep;
    }
}

