/*
 * Decompiled with CFR 0.152.
 */
package io.mdsl.transformations;

import io.mdsl.MDSLResource;
import io.mdsl.apiDescription.ApiDescriptionFactory;
import io.mdsl.apiDescription.ElementStructure;
import io.mdsl.apiDescription.EndpointContract;
import io.mdsl.apiDescription.EndpointInstance;
import io.mdsl.apiDescription.EndpointList;
import io.mdsl.apiDescription.HTTPBinding;
import io.mdsl.apiDescription.HTTPOperationBinding;
import io.mdsl.apiDescription.HTTPParameter;
import io.mdsl.apiDescription.HTTPParameterBinding;
import io.mdsl.apiDescription.HTTPResourceBinding;
import io.mdsl.apiDescription.HTTPVerb;
import io.mdsl.apiDescription.Operation;
import io.mdsl.apiDescription.OperationResponsibility;
import io.mdsl.apiDescription.ParameterTree;
import io.mdsl.apiDescription.ProtocolBinding;
import io.mdsl.apiDescription.Provider;
import io.mdsl.apiDescription.ServiceSpecification;
import io.mdsl.apiDescription.SingleParameterNode;
import io.mdsl.apiDescription.TechnologyBinding;
import io.mdsl.apiDescription.TreeNode;
import io.mdsl.exception.MDSLException;
import io.mdsl.transformations.DataTypeTransformationHelpers;
import io.mdsl.transformations.TransformationHelpers;
import java.util.ArrayList;
import java.util.HashMap;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class HTTPBindingTransformations {
    private static final String DEFAULT_RESOURCE_NAME = "defaultResourceName";
    private static final String PROVIDER_SUFFIX = "Provider";
    private static final String HOME = "Home";
    private static final String DEFAULT_LOCATION = "http://localhost:8080";
    private static final String HTTP_BINDING = "HTTP";
    private static final String IDENTIFIER_ROLE = "Identifier";
    private static final String ID_ROLE = "ID";
    private static int resourceCounter = 1;

    public MDSLResource addBinding(EndpointContract contract) {
        ServiceSpecification ss = (ServiceSpecification)contract.eContainer();
        String contractName = contract.getName();
        Provider httpBindingProvider = ApiDescriptionFactory.eINSTANCE.createProvider();
        httpBindingProvider.setName(contractName + PROVIDER_SUFFIX);
        EndpointList epl = ApiDescriptionFactory.eINSTANCE.createEndpointList();
        epl.setContract(contract);
        httpBindingProvider.getEpl().add((Object)epl);
        EndpointInstance epi = ApiDescriptionFactory.eINSTANCE.createEndpointInstance();
        epi.setLocation(DEFAULT_LOCATION);
        TechnologyBinding tb = ApiDescriptionFactory.eINSTANCE.createTechnologyBinding();
        ProtocolBinding pb = ApiDescriptionFactory.eINSTANCE.createProtocolBinding();
        HTTPBinding httpBinding = HTTPBindingTransformations.createHTTPBindingWithOperations(contractName + HOME, contract.getOps());
        pb.setHttp(httpBinding);
        tb.setProtBinding(pb);
        epi.getPb().add((Object)tb);
        epl.getEndpoints().add((Object)epi);
        HTTPBindingTransformations.addBindingIfNameAvailable(ss, httpBindingProvider);
        return new MDSLResource(ss.eResource());
    }

    public void addHttpResourceDuringBindingSplit(HTTPResourceBinding hrb) {
        HTTPBinding hp = (HTTPBinding)hrb.eContainer();
        String resourceName = DataTypeTransformationHelpers.decapitalizeName(HTTPBindingTransformations.getEndpointTypeName(hp));
        HTTPResourceBinding newHrb = ApiDescriptionFactory.eINSTANCE.createHTTPResourceBinding();
        newHrb.setName(resourceName + resourceCounter++);
        newHrb.setUri(hrb.getUri());
        HashMap<HTTPVerb, Boolean> verbUsage = new HashMap<HTTPVerb, Boolean>();
        ArrayList<HTTPOperationBinding> hobsToBeMoved = new ArrayList<HTTPOperationBinding>();
        for (HTTPOperationBinding hob : hrb.getOpsB()) {
            HTTPVerb verb = hob.getMethod();
            if (verbUsage.get((Object)verb) != null && ((Boolean)verbUsage.get((Object)verb)).booleanValue()) {
                hobsToBeMoved.add(hob);
                continue;
            }
            verbUsage.put(verb, true);
        }
        for (HTTPOperationBinding hob : hobsToBeMoved) {
            hrb.getOpsB().remove((Object)hob);
            newHrb.getOpsB().add((Object)hob);
        }
        hp.getEb().add((Object)newHrb);
    }

    public void addHttpParameterBindingsForElements(HTTPOperationBinding hopb) {
        String opName = hopb.getBoundOperation();
        TechnologyBinding tb = (TechnologyBinding)hopb.eContainer().eContainer().eContainer().eContainer();
        EndpointList el = (EndpointList)tb.eContainer().eContainer();
        Operation op = TransformationHelpers.findOperationInContract(el.getContract(), opName);
        HTTPBindingTransformations.bindElementsOfOperation(hopb, op);
    }

    public void addHttpResourceForURITemplate(HTTPOperationBinding hopb, String relativeUri) {
        HTTPResourceBinding oldResource = (HTTPResourceBinding)hopb.eContainer();
        HTTPBinding hb = (HTTPBinding)hopb.eContainer().eContainer();
        if (hb == null) {
            throw new MDSLException("HTTP binding must not be null.");
        }
        String newResourceName = oldResource.getName() + "_" + hopb.getBoundOperation();
        HTTPResourceBinding newResource = HTTPBindingTransformations.createNewHTTPResource(newResourceName, oldResource.getUri(), relativeUri);
        HTTPOperationBinding hobCopy = (HTTPOperationBinding)EcoreUtil.copy((EObject)hopb);
        oldResource.getOpsB().remove((Object)hopb);
        newResource.getOpsB().add((Object)hobCopy);
        hb.getEb().add((Object)newResource);
    }

    public void addURITemplateToExistingHttpResource(HTTPOperationBinding hobp, String uriTemplate) {
        HTTPResourceBinding hrb = (HTTPResourceBinding)hobp.eContainer();
        hrb.setUri(hrb.getUri() + "/" + uriTemplate);
    }

    private static void addBindingIfNameAvailable(ServiceSpecification ss, Provider httpBindingProvider) {
        for (EObject providerOrBroker : ss.getProviders()) {
            if (!(providerOrBroker instanceof Provider) || !((Provider)providerOrBroker).getName().equals(httpBindingProvider.getName())) continue;
            TransformationHelpers.reportError("A provider with the name " + httpBindingProvider.getName() + " already exists. Not adding binding.");
            return;
        }
        ss.getProviders().add((Object)httpBindingProvider);
    }

    public static HTTPOperationBinding findFirstOperationBindingInEndpointInstance(String opName, EndpointInstance httpb) {
        HTTPOperationBinding opBindingToBeMoved = null;
        try {
            if (httpb.getPb().isEmpty()) {
                return null;
            }
            if (httpb.getPb().size() > 1) {
                TransformationHelpers.reportWarning("More than one protocol binding found at " + httpb.getLocation() + " , using first one.");
            }
            if (((TechnologyBinding)httpb.getPb().get(0)).getProtBinding().getHttp().getEb().isEmpty()) {
                return null;
            }
            if (((TechnologyBinding)httpb.getPb().get(0)).getProtBinding().getHttp().getEb().size() > 1) {
                TransformationHelpers.reportWarning("More than one HTTP binding found under " + httpb.getLocation() + " , using first one.");
            }
            for (HTTPResourceBinding htrb : ((TechnologyBinding)httpb.getPb().get(0)).getProtBinding().getHttp().getEb()) {
                for (HTTPOperationBinding htop : htrb.getOpsB()) {
                    if (!htop.getBoundOperation().equals(opName)) continue;
                    return htop;
                }
            }
        }
        catch (Exception e) {
            TransformationHelpers.reportError(opName + " has an unexpected provider/binding structure.");
        }
        return opBindingToBeMoved;
    }

    private static HTTPBinding createHTTPBindingWithOperations(String homeResourceName, EList<Operation> operations) {
        HTTPBinding result = ApiDescriptionFactory.eINSTANCE.createHTTPBinding();
        result.setHttp(HTTP_BINDING);
        HTTPResourceBinding resource = ApiDescriptionFactory.eINSTANCE.createHTTPResourceBinding();
        resource.setName(homeResourceName);
        resource.setUri("/" + DataTypeTransformationHelpers.decapitalizeName(homeResourceName));
        result.getEb().add((Object)resource);
        for (Operation operation : operations) {
            HTTPOperationBinding opB = ApiDescriptionFactory.eINSTANCE.createHTTPOperationBinding();
            opB.setBoundOperation(operation.getName());
            HTTPVerb verb = HTTPBindingTransformations.mapOperationToMethod(operation);
            opB.setMethod(verb);
            HTTPBindingTransformations.mapElementsToParameters(opB, operation);
            resource.getOpsB().add((Object)opB);
        }
        return result;
    }

    private static void mapElementsToParameters(HTTPOperationBinding opBinding, Operation operation) {
        HTTPBindingTransformations.bindElementsOfOperation(opBinding, operation);
    }

    private static void bindElementsOfOperation(HTTPOperationBinding opBinding, Operation op) {
        ParameterTree pt;
        if (op == null) {
            TransformationHelpers.reportError("AddHttpParameterBinding did not find the bound operation.");
        }
        if (op.getRequestMessage() == null) {
            TransformationHelpers.reportError("The bound operation does not have a request message.");
        }
        if (op.getRequestMessage().getPayload() == null) {
            TransformationHelpers.reportError("The bound operation does not have a request message payload.");
        }
        if ((pt = op.getRequestMessage().getPayload().getPt()) != null) {
            TreeNode tn = pt.getFirst();
            HTTPBindingTransformations.addParameterBindingsForNode(opBinding, tn);
            for (TreeNode child : pt.getNexttn()) {
                HTTPBindingTransformations.addParameterBindingsForNode(opBinding, child);
            }
            opBinding.setGlobalBinding(null);
        } else if (op.getRequestMessage().getPayload().getNp() != null) {
            HTTPBindingTransformations.addParameterBindingForSPN(opBinding, op.getRequestMessage().getPayload().getNp());
            opBinding.setGlobalBinding(null);
        } else {
            TransformationHelpers.reportError("AddHttpParameterBinding only supports Parameter Trees and Atomic Parameters as request structures.");
        }
    }

    private static void addParameterBindingsForNode(HTTPOperationBinding opb, TreeNode tn) {
        SingleParameterNode spn;
        HTTPParameterBinding hpb = ApiDescriptionFactory.eINSTANCE.createHTTPParameterBinding();
        String elementName = DataTypeTransformationHelpers.nameOf(tn);
        hpb.setBoundParameter(elementName);
        HTTPParameter value = HTTPBindingTransformations.defaultParameterMappingFor(opb.getMethod());
        if (tn.getPn() != null && HTTPBindingTransformations.hasIdentifierRole(spn = tn.getPn())) {
            value = HTTPParameter.PATH;
        }
        hpb.setParameterMapping(value);
        opb.getParameterBindings().add((Object)hpb);
    }

    private static void addParameterBindingForSPN(HTTPOperationBinding opb, SingleParameterNode spn) {
        HTTPParameterBinding hpb = ApiDescriptionFactory.eINSTANCE.createHTTPParameterBinding();
        hpb.setBoundParameter(DataTypeTransformationHelpers.nameOf(spn));
        HTTPParameter value = HTTPBindingTransformations.defaultParameterMappingFor(opb.getMethod());
        if (spn.getAtomP() != null && HTTPBindingTransformations.hasIdentifierRole(spn)) {
            value = HTTPParameter.PATH;
        }
        hpb.setParameterMapping(value);
        opb.getParameterBindings().add((Object)hpb);
    }

    private static HTTPResourceBinding createNewHTTPResource(String name, String uri, String relativeUri) {
        HTTPResourceBinding newHrb = ApiDescriptionFactory.eINSTANCE.createHTTPResourceBinding();
        if (name != null) {
            newHrb.setName(name);
        } else {
            newHrb.setName(DEFAULT_RESOURCE_NAME);
        }
        newHrb.setUri(uri + "/" + relativeUri);
        return newHrb;
    }

    private static HTTPVerb mapOperationToMethod(Operation operation) {
        if (operation.getResponsibility() != null) {
            OperationResponsibility opRespo = operation.getResponsibility();
            if (opRespo.getSco() != null) {
                return HTTPVerb.PUT;
            }
            if (opRespo.getRo() != null) {
                return HTTPVerb.GET;
            }
            if (opRespo.getCf() != null) {
                return HTTPVerb.POST;
            }
            if (opRespo.getSro() != null) {
                return HTTPVerb.PATCH;
            }
            if (opRespo.getSdo() != null) {
                return HTTPVerb.DELETE;
            }
            if (opRespo.getOther() != null) {
                if (opRespo.getOther().equals("PUT")) {
                    return HTTPVerb.PUT;
                }
                if (opRespo.getOther().equals("GET")) {
                    return HTTPVerb.GET;
                }
                if (opRespo.getOther().equals("POST")) {
                    return HTTPVerb.POST;
                }
                if (opRespo.getOther().equals("PATCH")) {
                    return HTTPVerb.PATCH;
                }
                if (opRespo.getOther().equals("DELETE")) {
                    return HTTPVerb.DELETE;
                }
            }
        }
        if (operation.getName().startsWith("create")) {
            return HTTPVerb.POST;
        }
        if (operation.getName().startsWith("addTo") || operation.getName().startsWith("add_to")) {
            return HTTPVerb.POST;
        }
        if (operation.getName().startsWith("get") || operation.getName().startsWith("read") || operation.getName().startsWith("retrieve") || operation.getName().startsWith("search")) {
            return HTTPVerb.GET;
        }
        if (operation.getName().startsWith("put") || operation.getName().startsWith("replace")) {
            return HTTPVerb.PUT;
        }
        if (operation.getName().startsWith("patch") || operation.getName().startsWith("update") || operation.getName().startsWith("modify")) {
            return HTTPVerb.PATCH;
        }
        if (operation.getName().startsWith("delete") || operation.getName().startsWith("remove")) {
            return HTTPVerb.DELETE;
        }
        return HTTPVerb.POST;
    }

    private static HTTPParameter defaultParameterMappingFor(HTTPVerb method) {
        switch (method) {
            case POST: 
            case PUT: 
            case PATCH: {
                return HTTPParameter.BODY;
            }
            case DELETE: {
                return HTTPParameter.PATH;
            }
            case GET: {
                return HTTPParameter.QUERY;
            }
        }
        return HTTPParameter.BODY;
    }

    private static boolean hasIdentifierRole(SingleParameterNode spn) {
        if (spn.getAtomP() != null) {
            return spn.getAtomP().getRat().getRole().equals(ID_ROLE) || spn.getAtomP().getRat().getRole().equals(IDENTIFIER_ROLE);
        }
        if (spn.getGenP() != null) {
            return false;
        }
        if (spn.getTr() != null) {
            ElementStructure es = spn.getTr().getDcref().getStructure();
            if (es.getNp() != null) {
                return HTTPBindingTransformations.hasIdentifierRole(es.getNp());
            }
            return false;
        }
        return false;
    }

    private static String getEndpointTypeName(HTTPBinding hp) {
        EndpointList el = (EndpointList)hp.eContainer().eContainer().eContainer().eContainer();
        return el.getContract().getName();
    }
}

