/*
 * Decompiled with CFR 0.152.
 */
package io.mdsl.transformations;

import io.mdsl.apiDescription.ApiDescriptionFactory;
import io.mdsl.apiDescription.AtomicParameter;
import io.mdsl.apiDescription.AtomicParameterList;
import io.mdsl.apiDescription.EndpointContract;
import io.mdsl.apiDescription.GenericParameter;
import io.mdsl.apiDescription.Operation;
import io.mdsl.apiDescription.OperationResponsibility;
import io.mdsl.apiDescription.ParameterTree;
import io.mdsl.apiDescription.PatternStereotype;
import io.mdsl.apiDescription.SingleParameterNode;
import io.mdsl.apiDescription.TreeNode;
import io.mdsl.apiDescription.TypeReference;
import io.mdsl.exception.MDSLException;
import org.eclipse.emf.common.util.EList;

public class MAPDecoratorHelpers {
    public static final String PROCESSING_RESOURCE = "PROCESSING_RESOURCE";
    public static final String INFORMATION_HOLDER_RESOURCE = "INFORMATION_HOLDER_RESOURCE";
    public static final String COLLECTION_RESOURCE = "COLLECTION_RESOURCE";
    public static final String MUTABLE_COLLECTION_RESOURCE = "MUTABLE_COLLECTION_RESOURCE";
    public static final String STATE_CREATION_OPERATION = "STATE_CREATION_OPERATION";
    public static final String EVENT_PROCESSOR = "EVENT_PROCESSOR";
    public static final String RETRIEVAL_OPERATION = "RETRIEVAL_OPERATION";
    public static final String STATE_TRANSITION_OPERATION = "STATE_TRANSITION_OPERATION";
    public static final String BUSINESS_ACTIVITY_PROCESSOR = "BUSINESS_ACTIVITY_PROCESSOR";
    public static final String STATE_REPLACEMENT_OPERATION = "STATE_REPLACEMENT_OPERATION";
    public static final String STATE_DELETION_OPERATION = "STATE_DELETION_OPERATION";
    public static final String COMPUTATION_FUNCTION = "COMPUTATION_FUNCTION";
    private static final String UNSPECIFIED_RESPONSIBILITY = "UnspecifiedResponsibility";
    private static final String COLLECTION_OPERATION = "Collection_Operation";

    public static void setRoleToProcessingResource(EndpointContract etype) {
        etype.setPrimaryRole(PROCESSING_RESOURCE);
    }

    public static void setRoleToInformationHolderResource(EndpointContract etype) {
        etype.setPrimaryRole(INFORMATION_HOLDER_RESOURCE);
    }

    public static void setRoleToCollectionResource(EndpointContract endpoint) {
        MAPDecoratorHelpers.setRole(endpoint, COLLECTION_RESOURCE);
    }

    public static void addRole(EndpointContract ec, String type) {
        if (ec.getPrimaryRole() == null) {
            ec.setPrimaryRole(type);
        } else {
            EList<String> secondaryRoles = ec.getOtherRoles();
            if (!secondaryRoles.contains((Object)type) && !ec.getPrimaryRole().equals(type)) {
                ec.getOtherRoles().add((Object)type);
            }
        }
    }

    public static void setRole(EndpointContract etype, String role) {
        if (etype.getPrimaryRole() != null && !etype.getPrimaryRole().isEmpty()) {
            System.err.println("[W] A primary endpoint role is already defined and will be overwritten.");
        }
        if (role != null && role.equals(COLLECTION_RESOURCE)) {
            etype.setPrimaryRole(INFORMATION_HOLDER_RESOURCE);
            etype.getOtherRoles().add((Object)role);
        } else if (role != null && role.equals(MUTABLE_COLLECTION_RESOURCE)) {
            etype.setPrimaryRole(INFORMATION_HOLDER_RESOURCE);
            etype.getOtherRoles().add((Object)('\"' + role + '\"'));
        } else {
            etype.setPrimaryRole(role);
        }
    }

    public static void deriveResponsibilityFromName(Operation operation, String name) {
        OperationResponsibility or = ApiDescriptionFactory.eINSTANCE.createOperationResponsibility();
        if (name.startsWith("read")) {
            or.setRo(RETRIEVAL_OPERATION);
        } else if (name.startsWith("search")) {
            or.setRo(RETRIEVAL_OPERATION);
        } else if (name.startsWith("lookup")) {
            or.setRo(RETRIEVAL_OPERATION);
        } else if (name.startsWith("performQuery")) {
            or.setRo(RETRIEVAL_OPERATION);
        } else if (name.startsWith("performCommand")) {
            or.setSto(RETRIEVAL_OPERATION);
        } else if (name.startsWith("create")) {
            or.setSco(STATE_CREATION_OPERATION);
        } else if (name.startsWith("update")) {
            or.setSto(STATE_TRANSITION_OPERATION);
        } else if (name.startsWith("modify")) {
            or.setSto(STATE_TRANSITION_OPERATION);
        } else if (name.startsWith("replace")) {
            or.setSro(STATE_REPLACEMENT_OPERATION);
        } else if (name.startsWith("delete")) {
            or.setSdo(STATE_DELETION_OPERATION);
        } else if (name.startsWith("add")) {
            or.setSto(COLLECTION_OPERATION);
        } else if (name.startsWith("remove")) {
            or.setSto(COLLECTION_OPERATION);
        } else {
            or.setOther(UNSPECIFIED_RESPONSIBILITY);
        }
        if (or.getOther() == null) {
            operation.setResponsibility(or);
        }
    }

    public static OperationResponsibility setPrimaryResponsibility(String responsibility) throws MDSLException {
        OperationResponsibility or = ApiDescriptionFactory.eINSTANCE.createOperationResponsibility();
        if (responsibility.equals(EVENT_PROCESSOR)) {
            or.setEp(EVENT_PROCESSOR);
        } else if (responsibility.equals(STATE_CREATION_OPERATION)) {
            or.setSco(STATE_CREATION_OPERATION);
        } else if (responsibility.equals(STATE_REPLACEMENT_OPERATION)) {
            or.setSro(STATE_REPLACEMENT_OPERATION);
        } else if (responsibility.equals(STATE_TRANSITION_OPERATION)) {
            or.setSto(STATE_TRANSITION_OPERATION);
        } else if (responsibility.equals(STATE_DELETION_OPERATION)) {
            or.setSdo(STATE_DELETION_OPERATION);
        } else if (responsibility.equals(RETRIEVAL_OPERATION)) {
            or.setRo(RETRIEVAL_OPERATION);
        } else if (responsibility.equals(COMPUTATION_FUNCTION)) {
            or.setCf(COMPUTATION_FUNCTION);
        } else {
            throw new MDSLException(responsibility + " is not one of the state manipulating operations");
        }
        return or;
    }

    public static OperationResponsibility addStateCreationResponsibility(Operation operation, String details) {
        OperationResponsibility or = ApiDescriptionFactory.eINSTANCE.createOperationResponsibility();
        or.setSco(details);
        operation.setResponsibility(or);
        return or;
    }

    public static OperationResponsibility addStateTransferResponsibility(Operation operation, String details) {
        OperationResponsibility or = ApiDescriptionFactory.eINSTANCE.createOperationResponsibility();
        or.setSto(details);
        operation.setResponsibility(or);
        return or;
    }

    public static OperationResponsibility addStateReplacementResponsibility(Operation operation, String details) {
        OperationResponsibility or = ApiDescriptionFactory.eINSTANCE.createOperationResponsibility();
        or.setSro(details);
        operation.setResponsibility(or);
        return or;
    }

    public static OperationResponsibility addDeletionResponsibility(Operation operation, String details) {
        OperationResponsibility or = ApiDescriptionFactory.eINSTANCE.createOperationResponsibility();
        or.setSdo(details);
        operation.setResponsibility(or);
        return or;
    }

    public static OperationResponsibility addRetrievalOperationResponsibility(Operation operation, String details) {
        OperationResponsibility or = ApiDescriptionFactory.eINSTANCE.createOperationResponsibility();
        or.setRo(details);
        operation.setResponsibility(or);
        return or;
    }

    public static OperationResponsibility addComputationFunctionResponsibility(Operation operation, String details) {
        OperationResponsibility or = ApiDescriptionFactory.eINSTANCE.createOperationResponsibility();
        or.setCf(details);
        operation.setResponsibility(or);
        return or;
    }

    public static boolean alsoServesAs(EList<String> otherDecorators, String roleName) {
        return otherDecorators.contains((Object)roleName);
    }

    public static PatternStereotype createTypeDecorator(String stereotype) {
        PatternStereotype result = ApiDescriptionFactory.eINSTANCE.createPatternStereotype();
        result.setPattern(stereotype);
        return result;
    }

    public static boolean isDecoratedWith(SingleParameterNode spn, String decorator) {
        if (spn == null) {
            return false;
        }
        if (spn.getAtomP() != null) {
            return MAPDecoratorHelpers.isDecoratedWith(spn.getAtomP(), decorator.trim());
        }
        if (spn.getTr() != null) {
            return MAPDecoratorHelpers.isDecoratedWith(spn.getTr(), decorator.trim());
        }
        if (spn.getGenP() != null) {
            return MAPDecoratorHelpers.isDecoratedWith(spn.getGenP(), decorator.trim());
        }
        return false;
    }

    public static boolean isDecoratedWith(TypeReference tr, String patternStereotype) {
        if (tr == null) {
            return false;
        }
        return tr.getClassifier() != null && tr.getClassifier().getPattern() != null && tr.getClassifier().getPattern().equals(patternStereotype);
    }

    public static boolean isDecoratedWith(GenericParameter gp, String patternStereotype) {
        return false;
    }

    public static boolean isDecoratedWith(AtomicParameter ap, String patternStereotype) {
        if (ap == null) {
            return false;
        }
        return ap.getClassifier() != null && ap.getClassifier().getPattern() != null && ap.getClassifier().getPattern().equals(patternStereotype);
    }

    public static boolean isDecoratedWith(AtomicParameterList apl, String patternStereotype) {
        if (apl == null) {
            return false;
        }
        return apl.getClassifier() != null && apl.getClassifier().getPattern() != null && apl.getClassifier().getPattern().equals(patternStereotype);
    }

    public static boolean isDecoratedWith(ParameterTree pt, String patternStereotype) {
        if (pt == null) {
            return false;
        }
        return pt.getClassifier() != null && pt.getClassifier().getPattern() != null && pt.getClassifier().getPattern().equals(patternStereotype);
    }

    public static void setClassifier(TreeNode tn, String stereotype) {
        PatternStereotype ps = ApiDescriptionFactory.eINSTANCE.createPatternStereotype();
        ps.setPattern(stereotype);
        if (tn.getChildren() != null) {
            tn.getChildren().setClassifier(ps);
        } else if (tn.getPn() != null) {
            if (tn.getPn().getAtomP() != null) {
                tn.getPn().getAtomP().setClassifier(ps);
            } else if (tn.getPn().getTr() != null) {
                tn.getPn().getTr().setClassifier(ps);
            }
        }
    }

    public static void unsetClassifier(TreeNode tn) {
        if (tn.getChildren() != null) {
            tn.getChildren().setClassifier(null);
        } else if (tn.getPn() != null) {
            if (tn.getPn().getAtomP() != null) {
                tn.getPn().getAtomP().setClassifier(null);
            } else if (tn.getPn().getTr() != null) {
                tn.getPn().getTr().setClassifier(null);
            }
        }
    }

    public static boolean isRetrievalOperation(Operation operation) {
        if (operation.getResponsibility() == null) {
            return false;
        }
        return operation.getResponsibility().getRo() != null && operation.getResponsibility().getRo().equals(RETRIEVAL_OPERATION);
    }

    public static boolean isDeleteOperation(Operation operation) {
        if (operation.getResponsibility() == null) {
            return false;
        }
        return operation.getResponsibility().getSdo() != null;
    }
}

