/*
 * Decompiled with CFR 0.152.
 */
package io.mdsl.transformations;

import io.mdsl.apiDescription.ApiDescriptionFactory;
import io.mdsl.apiDescription.AtomicParameter;
import io.mdsl.apiDescription.AtomicParameterList;
import io.mdsl.apiDescription.Cardinality;
import io.mdsl.apiDescription.DataContract;
import io.mdsl.apiDescription.DataTransferRepresentation;
import io.mdsl.apiDescription.ElementStructure;
import io.mdsl.apiDescription.EndpointContract;
import io.mdsl.apiDescription.EventType;
import io.mdsl.apiDescription.Operation;
import io.mdsl.apiDescription.ParameterTree;
import io.mdsl.apiDescription.PatternStereotype;
import io.mdsl.apiDescription.RoleAndType;
import io.mdsl.apiDescription.ServiceSpecification;
import io.mdsl.apiDescription.SingleParameterNode;
import io.mdsl.apiDescription.TreeNode;
import io.mdsl.apiDescription.TypeReference;
import io.mdsl.exception.MDSLException;
import io.mdsl.transformations.DataTypeTransformationHelpers;
import io.mdsl.transformations.DataTypeTransformations;
import io.mdsl.transformations.MAPDecoratorHelpers;
import io.mdsl.transformations.MessageTransformationHelpers;
import io.mdsl.transformations.OperationTransformationHelpers;
import io.mdsl.transformations.TransformationHelpers;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class MessageTransformations {
    private static final String QOS_IDENTIFIER = "qos";
    private static final String REQUEST_CONDITION_STEREOTYPE = "Request_Condition";
    private static final String KEY_VALUE_MAP = "KeyValueMap";
    private static final String INLINED_INFORMATION_HOLDER_IDENTIFIER = "inlinedInformationHolder";
    private static final String CONTEXT_REPRESENTATION = "Context_Representation";
    private static final String PARAMETER_TREE_MISSING = "Response message does not contain a parameter tree.";
    public static final String CURSOR_FROM_OPERATION = "cursorFromOperation";
    public static final String OFFSET_FROM_OPERATION = "offsetFromOperation";
    static final String PAGE = "page";
    static final String PAGE_SIZE = "pageSize";
    static final String TOTAL_PAGES = "totalPages";
    static final String OFFSET = "offset";
    static final String LIMIT = "limit";
    static final String SIZE = "size";
    static final String CURSOR = "Cursor";
    static final String SELF = "self";
    static final String NEXT = "next";
    private static final String OUT_PARAMETER_NAME_SUFFIX = "-out";
    private static final String PAGINATION_ERROR_DTR_EXPECTED = "Add Pagination: Internal error, expected a Data Transfer Representation";
    private static final String INT_TYPE = "int";
    private static final String STRING_TYPE = "string";
    private static final String DESIRED_ELEMENTS = "desiredElements";
    private static final String REQUESTED = "requested";

    public static void addPagination(ElementStructure es, String variant) {
        EObject eo = es.eContainer();
        if (!(eo instanceof DataTransferRepresentation)) {
            TransformationHelpers.reportError(PAGINATION_ERROR_DTR_EXPECTED);
        }
        DataTransferRepresentation responsePayload = (DataTransferRepresentation)eo;
        ParameterTree pt = es.getPt();
        if (pt == null) {
            TransformationHelpers.reportError("Known limitation: Add Pagination can only be applied to Parameter Trees at present.");
        }
        MessageTransformations.addPaginationMetadataToRequestPayload(responsePayload, variant);
        MessageTransformations.addPaginationMetadataToResponsePayload(pt, variant);
        PatternStereotype mapDecorator = ApiDescriptionFactory.eINSTANCE.createPatternStereotype();
        mapDecorator.setPattern("Pagination");
        pt.setClassifier(mapDecorator);
    }

    private static void addPaginationMetadataToResponsePayload(ParameterTree pt, String variant) {
        AtomicParameter chunkSize = null;
        AtomicParameter startingPoint = null;
        AtomicParameter chunkAmount = null;
        AtomicParameter nextLink = null;
        if (variant.equals(OFFSET_FROM_OPERATION)) {
            startingPoint = DataTypeTransformations.createMetadataParameter("offset-out", INT_TYPE);
            pt.getNexttn().add((Object)DataTypeTransformations.wrapAtomicParameterAsTreeNode(startingPoint));
            chunkSize = DataTypeTransformations.createMetadataParameter("limit-out", INT_TYPE);
            pt.getNexttn().add((Object)DataTypeTransformations.wrapAtomicParameterAsTreeNode(chunkSize));
            chunkAmount = DataTypeTransformations.createMetadataParameter(SIZE, INT_TYPE);
            pt.getNexttn().add((Object)DataTypeTransformations.wrapAtomicParameterAsTreeNode(chunkAmount));
            nextLink = DataTypeTransformations.createLinkParameter(NEXT);
        } else if (variant.equals(CURSOR_FROM_OPERATION)) {
            chunkSize = DataTypeTransformations.createMetadataParameter(PAGE_SIZE, INT_TYPE);
            pt.getNexttn().add((Object)DataTypeTransformations.wrapAtomicParameterAsTreeNode(chunkSize));
            nextLink = DataTypeTransformations.createLinkParameter("nextCursor");
        } else {
            startingPoint = DataTypeTransformations.createMetadataParameter(PAGE, INT_TYPE);
            pt.getNexttn().add((Object)DataTypeTransformations.wrapAtomicParameterAsTreeNode(startingPoint));
            chunkSize = DataTypeTransformations.createMetadataParameter(PAGE_SIZE, INT_TYPE);
            pt.getNexttn().add((Object)DataTypeTransformations.wrapAtomicParameterAsTreeNode(chunkSize));
            chunkAmount = DataTypeTransformations.createMetadataParameter(TOTAL_PAGES, INT_TYPE);
            pt.getNexttn().add((Object)DataTypeTransformations.wrapAtomicParameterAsTreeNode(chunkAmount));
            nextLink = DataTypeTransformations.createLinkParameter(NEXT);
        }
        AtomicParameter selfLink = DataTypeTransformations.createLinkParameter(SELF);
        pt.getNexttn().add((Object)DataTypeTransformations.wrapAtomicParameterAsTreeNode(selfLink));
        pt.getNexttn().add((Object)DataTypeTransformations.wrapAtomicParameterAsTreeNode(nextLink));
    }

    private static void addPaginationMetadataToRequestPayload(DataTransferRepresentation responsePayload, String variant) {
        DataTransferRepresentation requestPayload = MessageTransformationHelpers.navigateToRequestPayload(responsePayload);
        if (requestPayload == null) {
            TransformationHelpers.reportError("Can't add to non-existing request payload, so refactoring not applied");
        }
        ElementStructure rpl = requestPayload.getPayload();
        ParameterTree rplPt = null;
        if (rpl.getPt() != null) {
            rplPt = rpl.getPt();
        } else if (rpl.getNp() != null) {
            rplPt = MessageTransformationHelpers.createParameterTreeWrapper(rpl.getNp());
            rpl.setNp(null);
            rpl.setPt(rplPt);
        } else {
            TransformationHelpers.reportError("Can't apply this refactoring part to non-PT, non-SPN request payload.");
        }
        AtomicParameter chunkSize = null;
        AtomicParameter startingPoint = null;
        if (variant.equals(OFFSET_FROM_OPERATION)) {
            chunkSize = DataTypeTransformations.createMetadataParameter(LIMIT, INT_TYPE);
            rplPt.getNexttn().add((Object)DataTypeTransformations.wrapAtomicParameterAsTreeNode(chunkSize));
            startingPoint = DataTypeTransformations.createMetadataParameter(OFFSET, INT_TYPE);
            rplPt.getNexttn().add((Object)DataTypeTransformations.wrapAtomicParameterAsTreeNode(startingPoint));
        } else {
            if (!variant.equals(CURSOR_FROM_OPERATION)) {
                startingPoint = DataTypeTransformations.createMetadataParameter(REQUESTED + DataTypeTransformationHelpers.capitalizeName(PAGE), INT_TYPE);
                rplPt.getNexttn().add((Object)DataTypeTransformations.wrapAtomicParameterAsTreeNode(startingPoint));
            }
            chunkSize = DataTypeTransformations.createMetadataParameter(REQUESTED + DataTypeTransformationHelpers.capitalizeName(PAGE_SIZE), INT_TYPE);
            rplPt.getNexttn().add((Object)DataTypeTransformations.wrapAtomicParameterAsTreeNode(chunkSize));
        }
    }

    public static void addWishList(Operation operation) {
        ParameterTree pt;
        if (operation.getRequestMessage() == null || operation.getRequestMessage().getPayload() == null) {
            TransformationHelpers.reportError("Known limitation: Add Wish List can only be applied if request payloas is present.");
        }
        if (operation.getResponseMessage() == null || operation.getResponseMessage().getPayload() == null) {
            TransformationHelpers.reportError("Known limitation: Add Wish List can only be applied if response payloas is present.");
        }
        if ((pt = operation.getRequestMessage().getPayload().getPt()) == null) {
            TransformationHelpers.reportError("Known limitation: Add Wish List can only be applied to Parameter Trees at present.");
        }
        if (!MessageTransformations.allTopLevelTreeElementsAreOptional(operation.getResponseMessage().getPayload(), false)) {
            TransformationHelpers.reportWarning("Wish List will only work if all nodes in response tree are optional.");
        }
        AtomicParameter wl = DataTypeTransformations.createMetadataParameter(DESIRED_ELEMENTS, STRING_TYPE);
        Cardinality card = ApiDescriptionFactory.eINSTANCE.createCardinality();
        card.setZeroOrMore("*");
        wl.setCard(card);
        PatternStereotype mapDecorator = ApiDescriptionFactory.eINSTANCE.createPatternStereotype();
        mapDecorator.setPattern("Wish_List");
        wl.setClassifier(mapDecorator);
        pt.getNexttn().add((Object)DataTypeTransformations.wrapAtomicParameterAsTreeNode(wl));
    }

    private static boolean allTopLevelTreeElementsAreOptional(ElementStructure responseMessage, boolean deepCheck) {
        return true;
    }

    public static void addWishTemplate(ElementStructure requestMessage, ElementStructure responseMessage) {
        TreeNode wltn;
        ParameterTree requestTree = requestMessage.getPt();
        if (requestTree == null) {
            TransformationHelpers.reportError("Wish Template can only be added to parameter tree as request payload.");
        }
        if (!MessageTransformations.allTopLevelTreeElementsAreOptional(responseMessage, true)) {
            TransformationHelpers.reportWarning("Wish Template will only work if all nodes in response tree are optional.");
        }
        if ((wltn = MessageTransformationHelpers.findWishList(requestTree)) != null) {
            ParameterTree responsePT = responseMessage.getPt();
            if (responsePT == null) {
                TransformationHelpers.reportError(PARAMETER_TREE_MISSING);
            } else {
                ParameterTree wishTemplate = MessageTransformationHelpers.createWishTemplate(responsePT);
                wltn.setPn(null);
                wltn.setChildren(wishTemplate);
            }
        } else if (responseMessage.getPt() != null) {
            ParameterTree wishTemplate = MessageTransformationHelpers.createWishTemplate(responseMessage.getPt());
            TreeNode wttn = ApiDescriptionFactory.eINSTANCE.createTreeNode();
            wttn.setChildren(wishTemplate);
            requestTree.getNexttn().add((Object)wttn);
        } else if (responseMessage.getNp() != null) {
            TransformationHelpers.reportError("Response message contain a single parameter node, which is not yet supported in this refactoring.");
        } else {
            TransformationHelpers.reportError(PARAMETER_TREE_MISSING);
        }
    }

    public static ElementStructure addRequestBundle(ElementStructure element, boolean applyToRequest) {
        ParameterTree pt = null;
        if (element.getPt() != null) {
            pt = MessageTransformationHelpers.createParameterTreeWrapper(element.getPt());
        } else if (element.getNp() != null) {
            pt = MessageTransformationHelpers.createParameterTreeWrapper(element.getNp());
        } else {
            System.err.println("Known limitation: Add Request Bundle can only be applied to Parameter Trees (and SPNs) at present.");
            throw new MDSLException("Known limitation: Add Request Bundle can only be applied to Parameter Trees (and SPNs) at present.");
        }
        Cardinality setCard = ApiDescriptionFactory.eINSTANCE.createCardinality();
        setCard.setAtLeastOne("+");
        pt.setCard(setCard);
        PatternStereotype mapDecorator = ApiDescriptionFactory.eINSTANCE.createPatternStereotype();
        if (applyToRequest) {
            mapDecorator.setPattern("Request_Bundle");
        } else {
            mapDecorator.setPattern("Response_Bundle");
        }
        pt.setClassifier(mapDecorator);
        ElementStructure wrapperEs = ApiDescriptionFactory.eINSTANCE.createElementStructure();
        wrapperEs.setPt(pt);
        EObject containingElement = element.eContainer();
        if (containingElement instanceof DataContract) {
            DataContract dt = (DataContract)containingElement;
            dt.setStructure(wrapperEs);
        } else if (containingElement instanceof EventType) {
            EventType de = (EventType)containingElement;
            de.setContent(wrapperEs);
        } else if (containingElement instanceof DataTransferRepresentation) {
            DataTransferRepresentation dtr = (DataTransferRepresentation)containingElement;
            dtr.setPayload(wrapperEs);
        } else {
            System.err.println("Expected Data Type, Event Type or Data Transfer Representation." + containingElement.getClass().toString());
            throw new MDSLException("Expected Data Type, Event Type or Data Transfer Representation.");
        }
        return wrapperEs;
    }

    public static EObject addParameterTreeWrapper(EObject element) {
        TreeNode tn = null;
        EObject containingElement = null;
        ParameterTree pt = ApiDescriptionFactory.eINSTANCE.createParameterTree();
        if (element instanceof AtomicParameterList) {
            AtomicParameterList apl = (AtomicParameterList)element;
            pt.setClassifier((PatternStereotype)EcoreUtil.copy((EObject)apl.getClassifier()));
            pt.setName(apl.getName());
            tn = DataTypeTransformations.turnAtomicParameterIntoTreeNode(apl.getFirst());
            pt.setFirst(tn);
            for (AtomicParameter nextAp : apl.getNextap()) {
                tn = DataTypeTransformations.turnAtomicParameterIntoTreeNode(nextAp);
                pt.getNexttn().add((Object)tn);
            }
            pt.setCard((Cardinality)EcoreUtil.copy((EObject)apl.getCard()));
            containingElement = apl.eContainer();
        } else if (element instanceof AtomicParameter) {
            AtomicParameter ap = (AtomicParameter)element;
            tn = DataTypeTransformations.turnAtomicParameterIntoTreeNode(ap);
            pt.setClassifier((PatternStereotype)EcoreUtil.copy((EObject)ap.getClassifier()));
            pt.setName(DataTypeTransformationHelpers.nameForElement(ap.getRat().getName(), "Wrapper"));
            pt.setFirst(tn);
            pt.setCard((Cardinality)EcoreUtil.copy((EObject)ap.getCard()));
            containingElement = ap.eContainer().eContainer();
        } else if (element instanceof TypeReference) {
            TypeReference tr = (TypeReference)element;
            tn = DataTypeTransformations.turnTypeReferenceIntoTreeNode(tr);
            pt.setClassifier((PatternStereotype)EcoreUtil.copy((EObject)tr.getClassifier()));
            String trName = DataTypeTransformationHelpers.nameForElement(tr.getName(), "Wrapper");
            pt.setName(trName);
            pt.setFirst(tn);
            pt.setCard((Cardinality)EcoreUtil.copy((EObject)tr.getCard()));
            containingElement = tr.eContainer().eContainer();
        } else {
            System.err.println("This Quick Fix can only be applied to Atomic Parameter Lists and Atomic Parameters." + element.getClass().toString());
            throw new MDSLException("This Quick Fix can only be applied to Atomic Parameter Lists and Atomic Parameters.");
        }
        MessageTransformationHelpers.wrapParameterTreeInTreeNodeOrElementStructure(containingElement, pt);
        return containingElement;
    }

    public static EObject addKeyValueMapWrapper(AtomicParameter ap) {
        ParameterTree pt = ApiDescriptionFactory.eINSTANCE.createParameterTree();
        AtomicParameter key = ApiDescriptionFactory.eINSTANCE.createAtomicParameter();
        RoleAndType rat = DataTypeTransformations.createRoleAndType("key", "ID", STRING_TYPE);
        key.setRat(rat);
        TreeNode tn = DataTypeTransformations.turnAtomicParameterIntoTreeNode(key);
        pt.setName(DataTypeTransformationHelpers.nameForElement(ap.getRat().getName(), KEY_VALUE_MAP));
        pt.setFirst(tn);
        TreeNode tn2 = DataTypeTransformations.turnAtomicParameterIntoTreeNode(ap);
        pt.setClassifier((PatternStereotype)EcoreUtil.copy((EObject)ap.getClassifier()));
        pt.setCard((Cardinality)EcoreUtil.copy((EObject)ap.getCard()));
        pt.getNexttn().add((Object)tn2);
        EObject containingElement = ap.eContainer().eContainer();
        MessageTransformationHelpers.wrapParameterTreeInTreeNodeOrElementStructure(containingElement, pt);
        return containingElement;
    }

    public static void extractInformationHolder(Operation operation, boolean fromRequest) {
        TreeNode tn = MessageTransformationHelpers.findEmbeddedEntity(operation, fromRequest);
        if (tn == null) {
            TransformationHelpers.reportError("Can't find any <<Embedded_Entity>> decorator in " + operation.getName());
        }
        MAPDecoratorHelpers.unsetClassifier(tn);
        TreeNode originalTreeNode = (TreeNode)EcoreUtil.copy((EObject)tn);
        ServiceSpecification ss = (ServiceSpecification)operation.eContainer().eContainer();
        String ptName = DataTypeTransformationHelpers.nameOf(tn);
        MessageTransformations.addEndpoint(originalTreeNode, ss, ptName);
        tn.setApl(null);
        tn.setChildren(null);
        tn.setPn(MessageTransformationHelpers.createLink(ptName));
    }

    private static void addEndpoint(TreeNode tn, ServiceSpecification ss, String ptName) {
        ElementStructure es2 = MessageTransformations.wrapInformationHolderNode(tn);
        DataContract dt = DataTypeTransformations.findOrCreateDataType(ss, DataTypeTransformationHelpers.capitalizeName(ptName), es2);
        TypeReference tref = DataTypeTransformations.createTypeReference(dt);
        EndpointContract ec = TransformationHelpers.findOrCreateEndpointType(ss, DataTypeTransformationHelpers.capitalizeName(ptName) + "InformationHolderResource");
        MAPDecoratorHelpers.setRole(ec, "INFORMATION_HOLDER_RESOURCE");
        Operation ro = OperationTransformationHelpers.createLookupOperation(tref);
        if (TransformationHelpers.findOperationInContract(ec, ro.getName()) != null) {
            TransformationHelpers.reportWarning("Endpoint type " + ec.getName() + " already exposes a " + ro.getName() + " operation, not adding another one");
        } else {
            ec.getOps().add((Object)ro);
        }
    }

    private static ElementStructure wrapInformationHolderNode(TreeNode tn) {
        if (tn.getChildren() != null) {
            return DataTypeTransformations.wrapParameterTreeAsElementStructure(tn.getChildren());
        }
        if (tn.getPn() != null) {
            if (tn.getPn().getAtomP() != null) {
                return DataTypeTransformations.wrapAtomicParameterAsElementStructure(tn.getPn().getAtomP());
            }
            if (tn.getPn().getTr() != null) {
                return DataTypeTransformations.wrapTypeReferenceAsElementStructure(tn.getPn().getTr());
            }
            if (tn.getPn().getGenP() != null) {
                return DataTypeTransformations.wrapGenericParameterNodeAsElementStructure(tn.getPn().getGenP());
            }
        }
        return null;
    }

    public static void inlineInformationHolder(Operation op, boolean fromRequest) {
        AtomicParameter ap;
        TreeNode tn = MessageTransformationHelpers.findLinkParameterForInformationHolder(op, fromRequest);
        if (tn == null) {
            TransformationHelpers.reportError("Can't find any <<Linked_Information_Holder>> decorated tn in " + op.getName());
        }
        if (tn.getPn() == null) {
            TransformationHelpers.reportError("Can't find any <<Linked_Information_Holder>> decorated spn in " + op.getName());
        }
        if ((ap = tn.getPn().getAtomP()) == null) {
            TransformationHelpers.reportError("Can't find any <<Linked_Information_Holder>> decorated atomic parameter in " + op.getName());
        }
        String pName = MessageTransformationHelpers.findPName(fromRequest, ap);
        ServiceSpecification ss = (ServiceSpecification)op.eContainer().eContainer();
        ElementStructure es = DataTypeTransformations.wrapAtomicParameterAsElementStructure(DataTypeTransformations.createMetadataParameter(INLINED_INFORMATION_HOLDER_IDENTIFIER, STRING_TYPE));
        DataContract dt = DataTypeTransformations.findOrCreateDataTypeByIdentifier(ss, pName, es);
        TypeReference tr = DataTypeTransformations.createTypeReference(dt);
        String elemName = TransformationHelpers.nameOf(dt.getStructure());
        if (elemName == null || elemName.isEmpty()) {
            tr.setName(INLINED_INFORMATION_HOLDER_IDENTIFIER);
        } else {
            tr.setName(elemName);
        }
        tr.setClassifier(MAPDecoratorHelpers.createTypeDecorator("Embedded_Entity"));
        SingleParameterNode spn = (SingleParameterNode)ap.eContainer();
        spn.setAtomP(null);
        spn.setTr(tr);
    }

    public static void addContextRepresentation(Operation operation, String typeName) {
        ServiceSpecification ss = (ServiceSpecification)operation.eContainer().eContainer();
        AtomicParameter mp = DataTypeTransformations.createMetadataParameter(QOS_IDENTIFIER, INT_TYPE);
        TreeNode tn = DataTypeTransformations.wrapAtomicParameterAsTreeNode(mp);
        ParameterTree pt = ApiDescriptionFactory.eINSTANCE.createParameterTree();
        pt.setFirst(tn);
        ElementStructure es = DataTypeTransformations.wrapParameterTreeAsElementStructure(pt);
        if (typeName == null) {
            typeName = "SampleContext";
        }
        pt.setName(DataTypeTransformationHelpers.decapitalizeName(typeName));
        DataContract contextDTO = DataTypeTransformations.findOrCreateDataType(ss, typeName, es);
        MessageTransformations.addContextRepresentation(operation.getRequestMessage().getPayload(), contextDTO);
    }

    public static void addContextRepresentation(ElementStructure requestMessage, DataContract contextDTO) {
        if (requestMessage == null) {
            TransformationHelpers.reportError("addContextRepresentation expects a request message to be present.");
        }
        if (requestMessage.getPt() == null) {
            TransformationHelpers.reportError("addContextRepresentation can only be applied to request parameter trees.");
        }
        TypeReference tr = DataTypeTransformations.createTypeReference(contextDTO);
        TreeNode tn = DataTypeTransformations.wrapTypeReferenceAsTreeNode(tr);
        PatternStereotype ps = ApiDescriptionFactory.eINSTANCE.createPatternStereotype();
        ps.setPattern(CONTEXT_REPRESENTATION);
        tn.getPn().getTr().setClassifier(ps);
        requestMessage.getPt().getNexttn().add((Object)tn);
    }

    public static void makeRequestConditional(Operation op, String variant) {
        if (op.getRequestMessage() == null || op.getRequestMessage().getPayload() == null || op.getRequestMessage().getPayload().getPt() == null) {
            TransformationHelpers.reportError("This refactoring requires a parameter tree to be present in the request message (if any).");
        }
        TreeNode tn = DataTypeTransformations.wrapAtomicParameterAsTreeNode(DataTypeTransformations.createMetadataParameter(variant, STRING_TYPE));
        MAPDecoratorHelpers.setClassifier(tn, REQUEST_CONDITION_STEREOTYPE);
        op.getRequestMessage().getPayload().getPt().getNexttn().add((Object)tn);
    }
}

