/*
 * Decompiled with CFR 0.152.
 */
package io.mdsl.transformations;

import io.mdsl.apiDescription.ApiDescriptionFactory;
import io.mdsl.apiDescription.AtomicParameter;
import io.mdsl.apiDescription.Cardinality;
import io.mdsl.apiDescription.DataContract;
import io.mdsl.apiDescription.DataTransferRepresentation;
import io.mdsl.apiDescription.ElementStructure;
import io.mdsl.apiDescription.EndpointContract;
import io.mdsl.apiDescription.Operation;
import io.mdsl.apiDescription.OperationResponsibility;
import io.mdsl.apiDescription.ParameterTree;
import io.mdsl.apiDescription.ServiceSpecification;
import io.mdsl.apiDescription.TreeNode;
import io.mdsl.apiDescription.TypeReference;
import io.mdsl.exception.MDSLException;
import io.mdsl.transformations.DataTypeTransformationHelpers;
import io.mdsl.transformations.DataTypeTransformations;
import io.mdsl.transformations.MAPDecoratorHelpers;
import io.mdsl.transformations.TransformationHelpers;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class OperationTransformationHelpers {
    private static final String URI_IDENTIFIER = "uri";
    static final String BOOL_TYPE = "bool";
    static final String INT_TYPE = "int";
    static final String LONG_TYPE = "long";
    static final String STRING_TYPE = "string";
    static final String VOID_TYPE = "void";
    static final String DATA_ROLE = "D";
    private static final String METADATA_ROLE = "MD";
    private static final String ID_ROLE = "ID";
    private static final String CONVERT_OPERATION_NAME = "convert";
    private static final String CHECK_OPERATION_NAME = "check";
    private static final String RUN_OPERATION_NAME = "run";
    private static final String UPDATE_RESULT_TYPE_NAME = "updateResult";
    private static final String CHANGE_REQUEST_TYPE_NAME = "changeRequest";
    private static final String LOOKUP_OPERATION_NAME = "lookup";
    private static final String FIND_BY_ID = "findById";
    private static final String FIND_ALL = "findAll";
    private static final String LOOKUP_RESOURCES_VIA_FILTER_OPNAME = "lookupResourcesViaFilter";
    private static final String LOOKUP_RESOURCE_BY_ID_OPNAME = "lookupResourceById";
    private static final String DATA_IDENTIFIER = "data";
    private static final String RESULT_IDENTIFIER = "result";
    private static final String IN_DTO = "inDTO";
    private static final String IN_PARAMETER_IDENTIFIER = "in";
    private static final String OUT_PARAMETER_IDENTIFIER = "out";
    private static final String ITEM_ID = "itemId";
    private static final String RESOURCE_ID = "resourceId";
    private static final String COLLECTION_ID = "collectionId";
    private static final String COLLECTION_ITEM = "collectionItem";
    private static final String RESULT_SET = "resultSet";
    private static final String QUERY_FILTER = "queryFilter";
    private static final String CURRENT_STATE = "currentState";
    private static final String SUCCESS_FLAG = "success";
    private static final String EMPTY_PAYLOAD = "emptyPayload";

    public static void addProcessingResourceOperations(EndpointContract ec) {
        ServiceSpecification ss = (ServiceSpecification)ec.eContainer();
        String contractName = ec.getName();
        TypeReference tref = OperationTransformationHelpers.createDataTypeReferenceWithAtomicParameter(ss, contractName);
        tref.setName(IN_DTO);
        Operation initOperation = OperationTransformationHelpers.createCreateOperation("initializeResource", tref);
        ec.getOps().add((Object)initOperation);
        TypeReference trefSet = (TypeReference)EcoreUtil.copy((EObject)tref);
        OperationTransformationHelpers.setCardinalityOfTypeReferenceToZeroOrMore(trefSet);
        Operation queryOperation = OperationTransformationHelpers.createReadOperation("getResourceState", RESOURCE_ID, trefSet);
        ec.getOps().add((Object)queryOperation);
        Operation updateOperation = OperationTransformationHelpers.createUpdateOperation("updateResourceState", (TypeReference)EcoreUtil.copy((EObject)tref));
        ec.getOps().add((Object)updateOperation);
        Operation deleteOperation = OperationTransformationHelpers.createDeleteOperation("deleteResourceState");
        ec.getOps().add((Object)deleteOperation);
    }

    public static void addInformationHolderOperations(EndpointContract ec) {
        ServiceSpecification ss = (ServiceSpecification)ec.eContainer();
        String objectName = ec.getName();
        TypeReference tref = OperationTransformationHelpers.createDataTypeReferenceWithAtomicParameter(ss, objectName);
        tref.setName(IN_DTO);
        TypeReference trefSet = (TypeReference)EcoreUtil.copy((EObject)tref);
        OperationTransformationHelpers.setCardinalityOfTypeReferenceToZeroOrMore(trefSet);
        Operation findAllOperation = OperationTransformationHelpers.createRetrievalOperation(FIND_ALL, trefSet);
        MAPDecoratorHelpers.addRetrievalOperationResponsibility(findAllOperation, FIND_ALL);
        ec.getOps().add((Object)findAllOperation);
        Operation findByIdOperation = TransformationHelpers.createOperationWithIDParameterRequestAndTypeReferenceResponse(FIND_BY_ID, RESOURCE_ID, tref);
        MAPDecoratorHelpers.addRetrievalOperationResponsibility(findByIdOperation, FIND_BY_ID);
        ec.getOps().add((Object)findByIdOperation);
    }

    public static void addCollectionOperations(EndpointContract ec, boolean createCollectionMutators) {
        ServiceSpecification ss = (ServiceSpecification)ec.eContainer();
        String objectName = ec.getName();
        DataContract dt = DataTypeTransformations.findOrCreateDataType(ss, objectName, null);
        TypeReference tref = DataTypeTransformations.createTypeReference(dt);
        tref.setName(COLLECTION_ITEM);
        EList<Operation> endpointOperations = ec.getOps();
        if (createCollectionMutators) {
            Operation createCollectionOperation = CollectionHelpers.createCreateCollectionOperation(tref);
            endpointOperations.add((Object)createCollectionOperation);
        }
        endpointOperations.add((Object)CollectionHelpers.createAddItemOperation(tref));
        endpointOperations.add((Object)CollectionHelpers.createItemAtOperation(tref));
        endpointOperations.add((Object)CollectionHelpers.createUpdateItemOperation(tref));
        endpointOperations.add((Object)CollectionHelpers.createRemoveItemOperation());
        if (createCollectionMutators) {
            endpointOperations.add((Object)CollectionHelpers.createDeleteCollectionOperation());
        }
    }

    static void addDataTransferResourceOperations(EndpointContract ec) {
        Operation putOperation = TransformationHelpers.createOperationWithAtomicRequestAndResponse("transferIn", DATA_ROLE, null, true, "");
        TransformationHelpers.setAtomicParameterNames(putOperation, DATA_IDENTIFIER, RESOURCE_ID);
        MAPDecoratorHelpers.addStateCreationResponsibility(putOperation, "put");
        ec.getOps().add((Object)putOperation);
        Operation getOperation = TransformationHelpers.createOperationWithAtomicRequestAndResponse("transferOut", DATA_ROLE, null, true, "");
        TransformationHelpers.setAtomicParameterNames(getOperation, RESOURCE_ID, DATA_IDENTIFIER);
        MAPDecoratorHelpers.addRetrievalOperationResponsibility(getOperation, "RETRIEVAL_OPERATION");
        ec.getOps().add((Object)getOperation);
    }

    static void addLinkLookupOperations(EndpointContract ec) {
        Operation getOperation1 = TransformationHelpers.createOperationWithAtomicParameters(LOOKUP_RESOURCE_BY_ID_OPNAME, ID_ROLE, null, true, ID_ROLE, null);
        TransformationHelpers.setAtomicParameterNames(getOperation1, RESOURCE_ID, URI_IDENTIFIER);
        MAPDecoratorHelpers.addStateCreationResponsibility(getOperation1, "STATE_CREATION_OPERATION");
        ec.getOps().add((Object)getOperation1);
        Operation getOperation2 = TransformationHelpers.createOperationWithAtomicParameters(LOOKUP_RESOURCES_VIA_FILTER_OPNAME, METADATA_ROLE, null, true, ID_ROLE, null);
        TransformationHelpers.setAtomicParameterNames(getOperation2, "criteria", "uriSet");
        Cardinality card = ApiDescriptionFactory.eINSTANCE.createCardinality();
        card.setZeroOrMore("*");
        getOperation2.getResponseMessage().getPayload().getNp().getAtomP().setCard(card);
        MAPDecoratorHelpers.addRetrievalOperationResponsibility(getOperation2, "RETRIEVAL_OPERATION");
        ec.getOps().add((Object)getOperation2);
    }

    static void addRunOperation(EndpointContract ec) {
        Operation runOperation = OperationTransformationHelpers.createComputationOperation(RUN_OPERATION_NAME, IN_PARAMETER_IDENTIFIER, OUT_PARAMETER_IDENTIFIER);
        MAPDecoratorHelpers.addComputationFunctionResponsibility(runOperation, "COMPUTATION_FUNCTION");
        ec.getOps().add((Object)runOperation);
    }

    static void addCheckOperation(EndpointContract ec) {
        Operation checkOperation = OperationTransformationHelpers.createValidationOperation(CHECK_OPERATION_NAME, DATA_IDENTIFIER, RESULT_IDENTIFIER);
        MAPDecoratorHelpers.addComputationFunctionResponsibility(checkOperation, "COMPUTATION_FUNCTION");
        ec.getOps().add((Object)checkOperation);
    }

    static void addTransformationOperation(EndpointContract ec) {
        Operation checkOperation = OperationTransformationHelpers.createTransformationOperation(CONVERT_OPERATION_NAME, DATA_IDENTIFIER, RESULT_IDENTIFIER);
        MAPDecoratorHelpers.addComputationFunctionResponsibility(checkOperation, "COMPUTATION_FUNCTION");
        ec.getOps().add((Object)checkOperation);
    }

    static Operation createEventProductionOperation(String name) {
        return OperationTransformationHelpers.createDecoratedOperationWithGenericParameters(name, "EVENT_PROCESSOR");
    }

    static Operation createStateManipulatingOperation(String name) {
        return OperationTransformationHelpers.createDecoratedOperationWithGenericParameters(name, "STATE_TRANSITION_OPERATION");
    }

    public static Operation createCreateOperation(String opName, TypeReference typeRef) {
        Operation cop = OperationTransformationHelpers.createOperationWithTypeReferenceRequestAndAtomicDataResponse(opName, typeRef);
        MAPDecoratorHelpers.addStateCreationResponsibility(cop, "STATE_CREATION_OPERATION");
        return cop;
    }

    private static Operation createOperationWithTypeReferenceRequestAndAtomicDataResponse(String opName, TypeReference typeRef) {
        AtomicParameter outP = DataTypeTransformations.createIDParameter(RESOURCE_ID);
        Operation result = TransformationHelpers.createOperationWithAtomicParameterResponse(opName, outP);
        DataTransferRepresentation dtrDto = DataTypeTransformations.createDTRFromTypeReference(typeRef);
        result.setRequestMessage(dtrDto);
        return result;
    }

    public static Operation createUpdateOperation(String opName, TypeReference tref) {
        Operation uop = OperationTransformationHelpers.createOperationWithTypeReferenceRequestAndTypeReferenceResponse(opName, tref);
        OperationTransformationHelpers.setResponsibilityOf(uop, "STATE_REPLACEMENT_OPERATION");
        return uop;
    }

    private static Operation createOperationWithTypeReferenceRequestAndTypeReferenceResponse(String opName, TypeReference tref) {
        Operation result = ApiDescriptionFactory.eINSTANCE.createOperation();
        result.setName(opName);
        DataTransferRepresentation inDtr = DataTypeTransformations.createDTRFromTypeReference(tref);
        result.setRequestMessage(inDtr);
        tref.setName(CHANGE_REQUEST_TYPE_NAME);
        DataTransferRepresentation outDtr = (DataTransferRepresentation)EcoreUtil.copy((EObject)inDtr);
        outDtr.getPayload().getNp().getTr().setName(UPDATE_RESULT_TYPE_NAME);
        result.setResponseMessage(outDtr);
        return result;
    }

    public static Operation createDeleteOperation(String opName) {
        Operation dop = TransformationHelpers.createOperationWithAtomicRequestAndResponse(opName, ID_ROLE, STRING_TYPE, true, BOOL_TYPE);
        TransformationHelpers.setAtomicParameterNames(dop, RESOURCE_ID, SUCCESS_FLAG);
        dop.getResponseMessage().getPayload().getNp().getAtomP().getRat().setRole(METADATA_ROLE);
        OperationTransformationHelpers.setResponsibilityOf(dop, "STATE_DELETION_OPERATION");
        return dop;
    }

    public static Operation createRetrievalOperation(String opName, TypeReference tref) {
        Operation rop = OperationTransformationHelpers.createReadOperation(opName, QUERY_FILTER, tref);
        return rop;
    }

    public static Operation createLookupOperation(TypeReference tref) {
        tref.setName(RESULT_SET);
        return OperationTransformationHelpers.createReadOperation(LOOKUP_OPERATION_NAME, RESOURCE_ID, tref);
    }

    public static Operation createReadOperation(String opName, String qpName, TypeReference tref) {
        Operation rop = OperationTransformationHelpers.createOperationWithAtomicDataRequestAndTypeReferenceResponse(opName, qpName, tref);
        if (tref.getCard() != null && (tref.getCard().getAtLeastOne() != null || tref.getCard().getZeroOrMore() != null)) {
            Cardinality zeroOrMore = ApiDescriptionFactory.eINSTANCE.createCardinality();
            zeroOrMore.setZeroOrMore("*");
            rop.getRequestMessage().getPayload().getNp().getAtomP().setCard(zeroOrMore);
        }
        OperationTransformationHelpers.setResponsibilityOf(rop, "RETRIEVAL_OPERATION");
        return rop;
    }

    static TypeReference findOrCreateTypeReference(ServiceSpecification ss, String name, ElementStructure es) {
        DataContract dt = DataTypeTransformations.findOrCreateDataType(ss, name, es);
        TypeReference tref = DataTypeTransformations.createTypeReference(dt);
        return tref;
    }

    private static Operation createOperationWithAtomicDataRequestAndTypeReferenceResponse(String opName, String inpName, TypeReference tref) {
        AtomicParameter inP = DataTypeTransformations.createAtomicDataParameter(inpName, ID_ROLE, INT_TYPE);
        Operation result = TransformationHelpers.createOperationWithAtomicParameterRequest(opName, inP);
        DataTransferRepresentation dtrDto = DataTypeTransformations.createDTRFromTypeReference(tref);
        result.setResponseMessage(dtrDto);
        return result;
    }

    private static Operation createDecoratedOperationWithGenericParameters(String opName, String operationResponsibility) {
        Operation sto = TransformationHelpers.createOperationWithGenericParameters(opName, null, null, true);
        OperationTransformationHelpers.setResponsibilityOf(sto, operationResponsibility);
        return sto;
    }

    private static void setResponsibilityOf(Operation sto, String operationResponsibility) throws MDSLException {
        OperationResponsibility ov = MAPDecoratorHelpers.setPrimaryResponsibility(operationResponsibility);
        sto.setResponsibility(ov);
    }

    private static Operation createComputationOperation(String opName, String inName, String outName) {
        Operation operation = TransformationHelpers.createOperationWithAtomicParameters(opName, DATA_ROLE, INT_TYPE, true, DATA_ROLE, LONG_TYPE);
        TransformationHelpers.setAtomicParameterNames(operation, inName, outName);
        return operation;
    }

    private static Operation createTransformationOperation(String opName, String inName, String outName) {
        Operation operation = TransformationHelpers.createOperationWithAtomicParameters(opName, DATA_ROLE, STRING_TYPE, true, DATA_ROLE, STRING_TYPE);
        TransformationHelpers.setAtomicParameterNames(operation, inName, outName);
        return operation;
    }

    private static Operation createValidationOperation(String opName, String inName, String outName) {
        Operation operation = TransformationHelpers.createOperationWithAtomicParameters(opName, DATA_ROLE, STRING_TYPE, true, DATA_ROLE, BOOL_TYPE);
        TransformationHelpers.setAtomicParameterNames(operation, inName, outName);
        return operation;
    }

    private static TypeReference createDataTypeReferenceWithAtomicParameter(ServiceSpecification ss, String name) {
        AtomicParameter newAP = DataTypeTransformations.createAtomicDataParameter(DataTypeTransformationHelpers.decapitalizeName(name), STRING_TYPE);
        ElementStructure es = DataTypeTransformations.wrapAtomicParameterAsElementStructure(newAP);
        DataContract dt = DataTypeTransformations.findOrCreateDataType(ss, name, es);
        TypeReference tref = DataTypeTransformations.createTypeReference(dt);
        return tref;
    }

    private static void setCardinalityOfTypeReferenceToZeroOrMore(TypeReference trefSet) {
        Cardinality card = ApiDescriptionFactory.eINSTANCE.createCardinality();
        card.setZeroOrMore("*");
        trefSet.setCard(card);
    }

    static class CollectionHelpers {
        private static final String NEW_ITEM_IDENTIFIER = "newItem";

        CollectionHelpers() {
        }

        public static Operation createCreateCollectionOperation(TypeReference tref) {
            Operation op = TransformationHelpers.createOperationWithAtomicParameters("createCollection", OperationTransformationHelpers.DATA_ROLE, OperationTransformationHelpers.VOID_TYPE, true, OperationTransformationHelpers.ID_ROLE, OperationTransformationHelpers.INT_TYPE);
            OperationTransformationHelpers.setResponsibilityOf(op, "STATE_CREATION_OPERATION");
            TransformationHelpers.setAtomicParameterNames(op, OperationTransformationHelpers.EMPTY_PAYLOAD, OperationTransformationHelpers.COLLECTION_ID);
            return op;
        }

        public static Operation createAddItemOperation(TypeReference tref) {
            AtomicParameter idp = DataTypeTransformations.createIDParameter(OperationTransformationHelpers.ITEM_ID);
            Operation op = TransformationHelpers.createOperationWithAtomicParameterResponse("addItem", idp);
            OperationTransformationHelpers.setResponsibilityOf(op, "STATE_TRANSITION_OPERATION");
            ParameterTree inTuple = ApiDescriptionFactory.eINSTANCE.createParameterTree();
            AtomicParameter collectionId = DataTypeTransformations.createIDParameter(OperationTransformationHelpers.COLLECTION_ID);
            inTuple.setFirst(DataTypeTransformations.wrapAtomicParameterAsTreeNode(collectionId));
            TreeNode itemDTO = DataTypeTransformations.wrapTypeReferenceAsTreeNode((TypeReference)EcoreUtil.copy((EObject)tref));
            itemDTO.getPn().getTr().setName(NEW_ITEM_IDENTIFIER);
            inTuple.getNexttn().add((Object)itemDTO);
            ElementStructure es1 = DataTypeTransformations.wrapParameterTreeAsElementStructure(inTuple);
            CollectionHelpers.createAndSetRequestPayload(op, es1);
            return op;
        }

        public static Operation createItemAtOperation(TypeReference tref) {
            Operation op = ApiDescriptionFactory.eINSTANCE.createOperation();
            String opName = DataTypeTransformationHelpers.decapitalizeName("getItem");
            op.setName(opName);
            OperationTransformationHelpers.setResponsibilityOf(op, "RETRIEVAL_OPERATION");
            ElementStructure es1 = CollectionHelpers.createCollectionItemIdTuple();
            CollectionHelpers.createAndSetRequestPayload(op, es1);
            DataTransferRepresentation outDtr = ApiDescriptionFactory.eINSTANCE.createDataTransferRepresentation();
            outDtr.setPayload(DataTypeTransformations.wrapTypeReferenceAsElementStructure((TypeReference)EcoreUtil.copy((EObject)tref)));
            op.setResponseMessage(outDtr);
            return op;
        }

        public static Operation createUpdateItemOperation(TypeReference tref) {
            Operation op = ApiDescriptionFactory.eINSTANCE.createOperation();
            String opName = DataTypeTransformationHelpers.decapitalizeName("updateItem");
            op.setName(opName);
            OperationTransformationHelpers.setResponsibilityOf(op, "STATE_TRANSITION_OPERATION");
            ElementStructure es1 = CollectionHelpers.createCollectionItemIdTuple();
            TreeNode itemDTO = DataTypeTransformations.wrapTypeReferenceAsTreeNode((TypeReference)EcoreUtil.copy((EObject)tref));
            itemDTO.getPn().getTr().setName(NEW_ITEM_IDENTIFIER);
            es1.getPt().getNexttn().add((Object)itemDTO);
            CollectionHelpers.createAndSetRequestPayload(op, es1);
            CollectionHelpers.createAndSetSuccessFlagAsResponsePayload(op);
            return op;
        }

        public static Operation createRemoveItemOperation() {
            Operation op = ApiDescriptionFactory.eINSTANCE.createOperation();
            String opName = DataTypeTransformationHelpers.decapitalizeName("removeItem");
            op.setName(opName);
            OperationTransformationHelpers.setResponsibilityOf(op, "STATE_DELETION_OPERATION");
            ElementStructure es1 = CollectionHelpers.createCollectionItemIdTuple();
            CollectionHelpers.createAndSetRequestPayload(op, es1);
            CollectionHelpers.createAndSetSuccessFlagAsResponsePayload(op);
            return op;
        }

        public static Operation createDeleteCollectionOperation() {
            Operation op = ApiDescriptionFactory.eINSTANCE.createOperation();
            String opName = DataTypeTransformationHelpers.decapitalizeName("deleteCollection");
            op.setName(opName);
            OperationTransformationHelpers.setResponsibilityOf(op, "STATE_DELETION_OPERATION");
            AtomicParameter collectionId = DataTypeTransformations.createIDParameter(OperationTransformationHelpers.COLLECTION_ID);
            ElementStructure es1 = DataTypeTransformations.wrapAtomicParameterAsElementStructure(collectionId);
            CollectionHelpers.createAndSetRequestPayload(op, es1);
            CollectionHelpers.createAndSetSuccessFlagAsResponsePayload(op);
            return op;
        }

        private static ElementStructure createCollectionItemIdTuple() {
            ParameterTree inTuple = ApiDescriptionFactory.eINSTANCE.createParameterTree();
            AtomicParameter collectionId = DataTypeTransformations.createIDParameter(OperationTransformationHelpers.COLLECTION_ID);
            inTuple.setFirst(DataTypeTransformations.wrapAtomicParameterAsTreeNode(collectionId));
            AtomicParameter itemId = DataTypeTransformations.createIDParameter(OperationTransformationHelpers.ITEM_ID);
            inTuple.getNexttn().add((Object)DataTypeTransformations.wrapAtomicParameterAsTreeNode(itemId));
            ElementStructure es1 = DataTypeTransformations.wrapParameterTreeAsElementStructure(inTuple);
            return es1;
        }

        private static void createAndSetRequestPayload(Operation op, ElementStructure es) {
            DataTransferRepresentation dtr = ApiDescriptionFactory.eINSTANCE.createDataTransferRepresentation();
            dtr.setPayload(es);
            op.setRequestMessage(dtr);
        }

        private static void createAndSetSuccessFlagAsResponsePayload(Operation op) {
            ElementStructure es = DataTypeTransformations.wrapAtomicParameterAsElementStructure(DataTypeTransformations.createMetadataParameter(OperationTransformationHelpers.SUCCESS_FLAG, OperationTransformationHelpers.BOOL_TYPE));
            DataTransferRepresentation dtr = ApiDescriptionFactory.eINSTANCE.createDataTransferRepresentation();
            dtr.setPayload(es);
            op.setResponseMessage(dtr);
        }
    }
}

