/*
 * Decompiled with CFR 0.152.
 */
package io.mdsl.transformations;

import io.mdsl.MDSLResource;
import io.mdsl.apiDescription.ApiDescriptionFactory;
import io.mdsl.apiDescription.AtomicParameter;
import io.mdsl.apiDescription.DataTransferRepresentation;
import io.mdsl.apiDescription.ElementStructure;
import io.mdsl.apiDescription.EndpointContract;
import io.mdsl.apiDescription.EndpointInstance;
import io.mdsl.apiDescription.HTTPOperationBinding;
import io.mdsl.apiDescription.HTTPResourceBinding;
import io.mdsl.apiDescription.Operation;
import io.mdsl.apiDescription.ParameterTree;
import io.mdsl.apiDescription.SecurityPolicies;
import io.mdsl.apiDescription.SecurityPolicy;
import io.mdsl.apiDescription.ServiceSpecification;
import io.mdsl.apiDescription.StatusReport;
import io.mdsl.apiDescription.StatusReports;
import io.mdsl.apiDescription.TreeNode;
import io.mdsl.dsl.ServiceSpecificationAdapter;
import io.mdsl.exception.MDSLException;
import io.mdsl.transformations.DataTypeTransformationHelpers;
import io.mdsl.transformations.DataTypeTransformations;
import io.mdsl.transformations.HTTPBindingTransformations;
import io.mdsl.transformations.MAPDecoratorHelpers;
import io.mdsl.transformations.OperationTransformationHelpers;
import io.mdsl.transformations.TransformationHelpers;
import io.mdsl.utils.MDSLSpecificationWrapper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.xtext.EcoreUtil2;

public class OperationTransformations {
    private static final String STATELESS_PROCESSING_RESOURCE = "STATELESS_PROCESSING_RESOURCE";
    private static final String TRANSFORMATION_RESOURCE = "TRANSFORMATION_RESOURCE";
    private static final String VALIDATION_RESOURCE = "VALIDATION_RESOURCE";
    private static final String LINK_LOOKUP_RESOURCE = "LINK_LOOKUP_RESOURCE";
    private static final String DATA_TRANSFER_RESOURCE = "DATA_TRANSFER_RESOURCE";
    private static final String REFERENCE_DATA_HOLDER = "REFERENCE_DATA_HOLDER";
    private static final String OPERATIONAL_DATA_HOLDER = "OPERATIONAL_DATA_HOLDER";
    private static final String MASTER_DATA_HOLDER = "MASTER_DATA_HOLDER";
    private static final String STATEFUL_PROCESSING_RESOURCE = "STATEFUL_PROCESSING_RESOURCE";
    private static final String OUTPUT = "output";
    private static final String INPUT = "input";
    private static final String PERFORM_ROLE_PREFIX = "performRole";

    public void addOperationsForRole(EndpointContract ec) {
        boolean foundMatchingRole = false;
        EList<String> otherRoles = ec.getOtherRoles();
        if (ec.getPrimaryRole() == null) {
            throw new MDSLException("Endpoint is not decorated with a primary role");
        }
        if (ec.getPrimaryRole().equals("PROCESSING_RESOURCE") || MAPDecoratorHelpers.alsoServesAs(otherRoles, "PROCESSING_RESOURCE")) {
            OperationTransformationHelpers.addProcessingResourceOperations(ec);
            foundMatchingRole = true;
        } else if (ec.getPrimaryRole().equals(STATEFUL_PROCESSING_RESOURCE) || MAPDecoratorHelpers.alsoServesAs(otherRoles, STATEFUL_PROCESSING_RESOURCE)) {
            OperationTransformationHelpers.addProcessingResourceOperations(ec);
            foundMatchingRole = true;
        }
        if (ec.getPrimaryRole().equals("INFORMATION_HOLDER_RESOURCE") || MAPDecoratorHelpers.alsoServesAs(otherRoles, "INFORMATION_HOLDER_RESOURCE")) {
            OperationTransformationHelpers.addInformationHolderOperations(ec);
            foundMatchingRole = true;
        } else if (ec.getPrimaryRole().equals(MASTER_DATA_HOLDER) || MAPDecoratorHelpers.alsoServesAs(otherRoles, MASTER_DATA_HOLDER)) {
            OperationTransformationHelpers.addInformationHolderOperations(ec);
            foundMatchingRole = true;
        } else if (ec.getPrimaryRole().equals(OPERATIONAL_DATA_HOLDER) || MAPDecoratorHelpers.alsoServesAs(otherRoles, OPERATIONAL_DATA_HOLDER)) {
            OperationTransformationHelpers.addInformationHolderOperations(ec);
            foundMatchingRole = true;
        } else if (ec.getPrimaryRole().equals(REFERENCE_DATA_HOLDER) || MAPDecoratorHelpers.alsoServesAs(otherRoles, REFERENCE_DATA_HOLDER)) {
            OperationTransformationHelpers.addInformationHolderOperations(ec);
            foundMatchingRole = true;
        }
        if (ec.getPrimaryRole().equals(DATA_TRANSFER_RESOURCE) || MAPDecoratorHelpers.alsoServesAs(otherRoles, DATA_TRANSFER_RESOURCE)) {
            OperationTransformationHelpers.addDataTransferResourceOperations(ec);
            foundMatchingRole = true;
        }
        if (ec.getPrimaryRole().equals(LINK_LOOKUP_RESOURCE) || MAPDecoratorHelpers.alsoServesAs(otherRoles, LINK_LOOKUP_RESOURCE)) {
            OperationTransformationHelpers.addLinkLookupOperations(ec);
            foundMatchingRole = true;
        }
        if (ec.getPrimaryRole().equals(VALIDATION_RESOURCE) || MAPDecoratorHelpers.alsoServesAs(otherRoles, VALIDATION_RESOURCE)) {
            OperationTransformationHelpers.addCheckOperation(ec);
            foundMatchingRole = true;
        }
        if (ec.getPrimaryRole().equals(TRANSFORMATION_RESOURCE) || MAPDecoratorHelpers.alsoServesAs(otherRoles, TRANSFORMATION_RESOURCE)) {
            OperationTransformationHelpers.addTransformationOperation(ec);
            foundMatchingRole = true;
        }
        if (MAPDecoratorHelpers.alsoServesAs(otherRoles, "COLLECTION_RESOURCE")) {
            OperationTransformationHelpers.addCollectionOperations(ec, false);
            foundMatchingRole = true;
        } else if (MAPDecoratorHelpers.alsoServesAs(otherRoles, "MUTABLE_COLLECTION_RESOURCE")) {
            OperationTransformationHelpers.addCollectionOperations(ec, true);
            foundMatchingRole = true;
        }
        if (ec.getPrimaryRole().equals(STATELESS_PROCESSING_RESOURCE) || MAPDecoratorHelpers.alsoServesAs(otherRoles, STATELESS_PROCESSING_RESOURCE)) {
            OperationTransformationHelpers.addRunOperation(ec);
            foundMatchingRole = true;
        }
        if (!foundMatchingRole) {
            Operation defaultOp = TransformationHelpers.createOperationWithGenericParameters(PERFORM_ROLE_PREFIX + TransformationHelpers.trimRoleName(ec.getPrimaryRole()), INPUT, OUTPUT, true);
            ec.getOps().add((Object)defaultOp);
        }
    }

    public void completeOperationWithCompensation(Operation operation, String opRefName) {
        EndpointContract ec = (EndpointContract)operation.eContainer();
        Operation opRef = TransformationHelpers.findOperationInContract(ec, opRefName);
        if (opRef != null) {
            operation.setUndo(opRef);
        } else {
            TransformationHelpers.reportError("Compensating operation " + opRefName + " not found in contract " + ec.getName());
        }
    }

    public void completeOperationWithErrorReport(Operation operation) {
        StatusReports srs = ApiDescriptionFactory.eINSTANCE.createStatusReports();
        StatusReport sr = ApiDescriptionFactory.eINSTANCE.createStatusReport();
        sr.setName("errorReport");
        AtomicParameter ap = DataTypeTransformations.createAtomicDataParameter("statusCode", "int");
        ElementStructure es = DataTypeTransformations.wrapAtomicParameterAsElementStructure(ap);
        sr.setReportData(es);
        srs.getReportList().add((Object)sr);
        operation.setReports(srs);
    }

    public void completeOperationWithSecurityPolicy(Operation operation) {
        SecurityPolicies sps = ApiDescriptionFactory.eINSTANCE.createSecurityPolicies();
        SecurityPolicy sp = ApiDescriptionFactory.eINSTANCE.createSecurityPolicy();
        sp.setName("accessControlRule");
        AtomicParameter ap = DataTypeTransformations.createAtomicDataParameter("policyData", "string");
        ElementStructure es = DataTypeTransformations.wrapAtomicParameterAsElementStructure(ap);
        sp.setSecurityObject(es);
        sps.getPolicyList().add((Object)sp);
        operation.setPolicies(sps);
    }

    public MDSLResource renameOperation(MDSLResource mdslResource, String opName, String opNameNew) {
        ServiceSpecification mdslSpecRoot = mdslResource.getServiceSpecification();
        boolean found = false;
        List operations = EcoreUtil2.eAllOfType((EObject)mdslSpecRoot, Operation.class);
        for (Operation nextOperation : operations) {
            if (!nextOperation.getName().equals(opName)) continue;
            found = true;
            nextOperation.setName(opNameNew);
        }
        if (!found) {
            throw new MDSLException("Operation " + opName + " not found.");
        }
        return mdslResource;
    }

    public MDSLResource moveOperation(Operation opToBeMoved, String targetEndpointName) {
        ServiceSpecification mdslSpecRoot = (ServiceSpecification)opToBeMoved.eContainer().eContainer();
        EndpointContract sourceEndpointType = (EndpointContract)opToBeMoved.eContainer();
        EndpointContract targetEndpointType = TransformationHelpers.findOrCreateEndpointType(mdslSpecRoot, targetEndpointName);
        if (TransformationHelpers.hasOperationOfName(targetEndpointType, opToBeMoved)) {
            throw new MDSLException("Target endpoint " + targetEndpointType.getName() + " already has an operation of this name.");
        }
        this.checkCompensationRelations(sourceEndpointType, opToBeMoved);
        targetEndpointType.getOps().add((Object)opToBeMoved);
        if (sourceEndpointType.getPrimaryRole() != null) {
            MAPDecoratorHelpers.addRole(targetEndpointType, sourceEndpointType.getPrimaryRole());
            if (sourceEndpointType.getOtherRoles() != null) {
                sourceEndpointType.getOtherRoles().forEach(secondaryRole -> MAPDecoratorHelpers.addRole(targetEndpointType, secondaryRole));
            }
        }
        if (sourceEndpointType.getScenario() != null && targetEndpointType.getScenario() == null) {
            targetEndpointType.setScenario(sourceEndpointType.getScenario());
        }
        if (sourceEndpointType.getFlow() != null && targetEndpointType.getFlow() == null) {
            targetEndpointType.setFlow(sourceEndpointType.getFlow());
        }
        TransformationHelpers.findAndAdjustHTTPResourceBindingOfOperation(mdslSpecRoot, sourceEndpointType, opToBeMoved, targetEndpointType);
        return new MDSLResource(targetEndpointType.eResource());
    }

    public void splitOperation(Operation opToBeSplit, boolean touchResponse) {
        String nameOfSplitOperation = opToBeSplit.getName();
        ElementStructure reqES = opToBeSplit.getRequestMessage().getPayload();
        if (reqES.getPt() == null) {
            throw new MDSLException("Split operation can only operate on operations with a Parameter Tree as request payload.");
        }
        EndpointContract ec = (EndpointContract)opToBeSplit.eContainer();
        this.checkCompensationRelations(ec, opToBeSplit);
        Collection<Operation> newOps = this.splitPayloadTree(reqES.getPt(), opToBeSplit.getResponseMessage());
        ec.getOps().remove((Object)opToBeSplit);
        ec.getOps().addAll(newOps);
        this.adjustHTTPBindingOfOperation(ec, nameOfSplitOperation, newOps);
    }

    private void checkCompensationRelations(EndpointContract ec, Operation opToBeSplit) {
        if (opToBeSplit.getUndo() != null) {
            TransformationHelpers.reportError(opToBeSplit.getName() + " has an undo/compensating operation specified: " + opToBeSplit.getUndo().getName() + ". This property would be lost during the split/move.");
        }
        for (Operation nextOp : ec.getOps()) {
            if (nextOp.getUndo() != opToBeSplit) continue;
            TransformationHelpers.reportError("Unable to split/move operation " + opToBeSplit.getName() + " because it undoes and compensates " + nextOp.getName());
        }
    }

    private void adjustHTTPBindingOfOperation(EndpointContract ec, String nameOfMovingOp, Collection<Operation> newOps) throws MDSLException {
        ServiceSpecification mdslSpecRoot = (ServiceSpecification)ec.eContainer();
        MDSLSpecificationWrapper msw = new MDSLSpecificationWrapper(new ServiceSpecificationAdapter(mdslSpecRoot));
        EndpointInstance httpb = msw.findFirstProviderAndHttpBindingFor(ec);
        if (httpb != null) {
            HTTPOperationBinding opBindingToBeSplit = HTTPBindingTransformations.findFirstOperationBindingInEndpointInstance(nameOfMovingOp, httpb);
            if (opBindingToBeSplit == null) {
                throw new MDSLException("No binding for " + nameOfMovingOp + " found in first/only HTTP resource. Others bindings not yet checked.");
            }
            HTTPResourceBinding currentResource = (HTTPResourceBinding)opBindingToBeSplit.eContainer();
            currentResource.getOpsB().remove((Object)opBindingToBeSplit);
            for (Operation nextOpToBeBound : newOps) {
                HTTPOperationBinding newBinding = (HTTPOperationBinding)EcoreUtil.copy((EObject)opBindingToBeSplit);
                newBinding.setBoundOperation(nextOpToBeBound.getName());
                newBinding.getParameterBindings().clear();
                currentResource.getOpsB().add((Object)newBinding);
            }
        }
    }

    private Collection<Operation> splitPayloadTree(ParameterTree treeToBeSplit, DataTransferRepresentation response) {
        ArrayList<Operation> result = new ArrayList<Operation>();
        TreeNode tn = treeToBeSplit.getFirst();
        result.add(OperationTransformations.createOperationWithRequestMessageFromTreeNode(tn, response));
        for (TreeNode next : treeToBeSplit.getNexttn()) {
            result.add(OperationTransformations.createOperationWithRequestMessageFromTreeNode(next, response));
        }
        return result;
    }

    public static Operation createOperationWithRequestMessageFromTreeNode(TreeNode node, DataTransferRepresentation response) {
        Operation newOp = ApiDescriptionFactory.eINSTANCE.createOperation();
        String nodeName = DataTypeTransformationHelpers.nameOf(node);
        String c1 = DataTypeTransformationHelpers.decapitalizeName(DataTypeTransformationHelpers.replaceSpacesWithUnderscores(nodeName));
        newOp.setName(c1);
        DataTransferRepresentation inDtr = ApiDescriptionFactory.eINSTANCE.createDataTransferRepresentation();
        ElementStructure esForNewOp = TransformationHelpers.findElementStructureOf(node);
        inDtr.setPayload(esForNewOp);
        newOp.setRequestMessage(inDtr);
        if (response != null) {
            newOp.setResponseMessage((DataTransferRepresentation)EcoreUtil.copy((EObject)response));
        }
        return newOp;
    }
}

