/*
 * Decompiled with CFR 0.152.
 */
package io.mdsl.utils;

import com.google.common.collect.Lists;
import io.mdsl.apiDescription.AtomicParameter;
import io.mdsl.apiDescription.Cardinality;
import io.mdsl.apiDescription.ElementStructure;
import io.mdsl.apiDescription.EndpointContract;
import io.mdsl.apiDescription.EndpointInstance;
import io.mdsl.apiDescription.EndpointList;
import io.mdsl.apiDescription.HTTPBinding;
import io.mdsl.apiDescription.HTTPOperationBinding;
import io.mdsl.apiDescription.HTTPResourceBinding;
import io.mdsl.apiDescription.Operation;
import io.mdsl.apiDescription.ParameterTree;
import io.mdsl.apiDescription.PatternStereotype;
import io.mdsl.apiDescription.ProtocolBinding;
import io.mdsl.apiDescription.Provider;
import io.mdsl.apiDescription.ReportBinding;
import io.mdsl.apiDescription.RoleAndType;
import io.mdsl.apiDescription.SecurityBinding;
import io.mdsl.apiDescription.SecurityPolicy;
import io.mdsl.apiDescription.ServiceSpecification;
import io.mdsl.apiDescription.TechnologyBinding;
import io.mdsl.apiDescription.TreeNode;
import io.mdsl.apiDescription.TypeReference;
import io.mdsl.dsl.ServiceSpecificationAdapter;
import io.mdsl.exception.MDSLException;
import io.mdsl.transformations.DataTypeTransformations;
import io.mdsl.utils.MAPLinkResolver;
import io.mdsl.utils.MDSLLogger;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.xtext.EcoreUtil2;

public class MDSLSpecificationWrapper {
    private static final String OAS_CODE_X_742 = "x-742";
    private static final String OAS_CODE_X_743 = "x-743";
    private static final String OPEN_ID_CONNECT_URL = "openIdConnectUrl";
    private static final String TOKEN_URL = "tokenUrl";
    private static final String AUTHORIZATION_URL = "authorizationUrl";
    private static final String SCOPE_PREFIX = "Scope";
    private ServiceSpecificationAdapter mdslSpecification;

    public MDSLSpecificationWrapper(ServiceSpecificationAdapter mdslSpecification) {
        this.mdslSpecification = mdslSpecification;
    }

    public ServiceSpecificationAdapter getSpecification() {
        return this.mdslSpecification;
    }

    public String getElementName(ElementStructure representationElement) {
        if (representationElement.getPt() != null) {
            return representationElement.getPt().getName();
        }
        if (representationElement.getNp() != null) {
            if (representationElement.getNp().getAtomP() != null) {
                return representationElement.getNp().getAtomP().getRat().getName();
            }
            if (representationElement.getNp().getTr() != null) {
                return representationElement.getNp().getTr().getName();
            }
            if (representationElement.getNp().getGenP() != null) {
                return representationElement.getNp().getGenP().getName();
            }
        }
        return "unnamedElement";
    }

    public boolean isSimplePayload(ElementStructure structure) {
        if (structure == null) {
            throw new MDSLException("Unexpected input for atomicity check: empty structure type");
        }
        if (structure.getApl() != null) {
            return !this.isMultiplicity(structure.getApl().getCard());
        }
        if (structure.getNp() != null) {
            if (structure.getNp().getAtomP() != null) {
                return !this.isMultiplicity(structure.getNp().getAtomP().getCard());
            }
            if (structure.getNp().getTr() != null) {
                if (this.isMultiplicity(structure.getNp().getTr().getCard())) {
                    return false;
                }
                MDSLLogger.reportInformation("Checking structure of type reference " + structure.getNp().getTr().getName());
                return true;
            }
            if (structure.getNp().getGenP() != null) {
                return true;
            }
            MDSLLogger.reportWarning("Unkown/unsupported single parameter node structure");
            return false;
        }
        if (structure.getPt() != null) {
            return this.isParameterTreeAtomic(structure.getPt());
        }
        if (structure.getPf() != null) {
            return false;
        }
        MDSLLogger.reportWarning("Unkown/unsupported structure");
        return false;
    }

    public boolean isParameterTreeAtomic(ParameterTree tree) {
        if (this.isMultiplicity(tree.getCard())) {
            return false;
        }
        List<TreeNode> nodes = this.collectTreeNodes(tree);
        for (TreeNode node : nodes) {
            if (node.getPn() != null && node.getPn().getAtomP() != null || node.getPn() != null && node.getPn().getGenP() != null) continue;
            if (node.getPn() != null && node.getPn().getTr() != null) {
                if (node.getPn().getTr().getDcref().getStructure().getNp() != null) {
                    if (node.getPn().getTr().getDcref().getStructure().getNp().getTr() == null) continue;
                    return false;
                }
                return false;
            }
            if (node.getApl() != null) continue;
            if (node.getChildren() != null) {
                return false;
            }
            MDSLLogger.reportWarning("Unknown/unexpected type of tree node");
        }
        return true;
    }

    private boolean isMultiplicity(Cardinality card) {
        if (card == null) {
            return false;
        }
        return card.getAtLeastOne() != null || card.getZeroOrMore() != null;
    }

    public boolean treeHasMultiplicity(ParameterTree pt) {
        if (pt == null || pt.getCard() == null) {
            return false;
        }
        return pt.getCard().getZeroOrOne() != null || pt.getCard().getAtLeastOne() != null || pt.getCard().getZeroOrMore() != null;
    }

    public boolean referenceHasMultiplicity(TypeReference tr) {
        if (tr == null || tr.getCard() == null) {
            return false;
        }
        return tr.getCard().getZeroOrOne() != null || tr.getCard().getAtLeastOne() != null || tr.getCard().getZeroOrMore() != null;
    }

    public boolean operationHasPayload(Operation mdslOperation) {
        return mdslOperation.getRequestMessage() != null && mdslOperation.getRequestMessage().getPayload() != null;
    }

    public boolean operationHasHeader(Operation mdslOperation) {
        return mdslOperation.getRequestMessage() != null && mdslOperation.getRequestMessage().getHeaders() != null;
    }

    public boolean operationHasReturnValue(Operation mdslOperation) {
        return mdslOperation.getResponseMessage() != null && mdslOperation.getResponseMessage().getPayload() != null;
    }

    public boolean operationHasReturnValueWithReports(Operation mdslOperation) {
        return mdslOperation.getResponseMessage() != null && mdslOperation.getResponseMessage().getPayload() != null && mdslOperation.getReports() != null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<AtomicParameter> extractAtomicElements(ElementStructure structure) {
        LinkedList atomicParameterList = Lists.newLinkedList();
        if (structure.getApl() != null) {
            atomicParameterList.add(structure.getApl().getFirst());
            atomicParameterList.addAll(structure.getApl().getNextap());
            return atomicParameterList;
        } else if (structure.getNp() != null && structure.getNp().getAtomP() != null) {
            atomicParameterList.add(structure.getNp().getAtomP());
            return atomicParameterList;
        } else {
            if (structure.getNp() != null && structure.getNp().getTr() != null) {
                return this.extractAtomicElements(structure.getNp().getTr().getDcref().getStructure());
            }
            if (structure.getPt() != null) {
                if (!this.isParameterTreeAtomic(structure.getPt())) throw new MDSLException("Cannot extract atoms from nested tree '");
                atomicParameterList.addAll(this.collectAtomicParameters(structure.getPt()));
                return atomicParameterList;
            } else {
                if (structure.getNp().getGenP() == null) throw new MDSLException("Cannot extract from this type of element.");
                String name = structure.getNp().getGenP().getName();
                MDSLLogger.reportInformation("Adding a surrogate ap for generic parameter " + name);
                AtomicParameter ap = DataTypeTransformations.createAtomicDataParameter(name, "string");
                atomicParameterList.add(ap);
            }
        }
        return atomicParameterList;
    }

    public List<AtomicParameter> collectAtomicParameters(ParameterTree tree) {
        LinkedList list = Lists.newLinkedList();
        List<TreeNode> nodes = this.collectTreeNodes(tree);
        for (TreeNode node : nodes) {
            if (node.getPn() != null && node.getPn().getAtomP() != null) {
                list.add(node.getPn().getAtomP());
            }
            if (node.getApl() == null) continue;
            list.add(node.getApl().getFirst());
            list.addAll(node.getApl().getNextap());
        }
        return list;
    }

    public List<TreeNode> collectTreeNodes(ParameterTree tree) {
        LinkedList nodes = Lists.newLinkedList();
        nodes.add(tree.getFirst());
        nodes.addAll(tree.getNexttn());
        return nodes;
    }

    public static String getClassifierAndElementStereotype(PatternStereotype classifier, RoleAndType roleAndType) {
        String result = "";
        if (classifier != null) {
            String patternDecorator = classifier.getPattern();
            if (patternDecorator != null && !patternDecorator.isEmpty()) {
                result = "<<" + patternDecorator + ">>";
            } else {
                patternDecorator = classifier.getEip();
                if (patternDecorator != null && !patternDecorator.isEmpty()) {
                    result = "<<" + patternDecorator + ">>";
                } else {
                    String otherStereotype = classifier.getName();
                    if (otherStereotype != null && !otherStereotype.isEmpty()) {
                        result = "<<" + otherStereotype + "_Role>>";
                    }
                }
            }
            result = result + " ";
        }
        result = result + MAPLinkResolver.mapParameterRoleAndType(roleAndType);
        return result;
    }

    public List<EndpointInstance> findProviderEndpointInstancesFor(EndpointContract endpointType) {
        List endpoints = EcoreUtil2.eAllOfType((EObject)this.mdslSpecification, EndpointList.class);
        ArrayList<EndpointInstance> result = new ArrayList<EndpointInstance>();
        for (int i = 0; i < endpoints.size(); ++i) {
            EndpointList nextEndpointList = (EndpointList)endpoints.get(i);
            if (!nextEndpointList.getContract().getName().equals(endpointType.getName())) continue;
            EList<EndpointInstance> endpointInstances = nextEndpointList.getEndpoints();
            for (int j = 0; j < endpointInstances.size(); ++j) {
                EndpointInstance nextEndpoint = (EndpointInstance)endpointInstances.get(j);
                EList<TechnologyBinding> tbs = nextEndpoint.getPb();
                for (int k = 0; k < tbs.size(); ++k) {
                    TechnologyBinding tb = (TechnologyBinding)tbs.get(k);
                    if (tb.getProtBinding().getHttp() != null) {
                        result.add(nextEndpoint);
                        continue;
                    }
                    MDSLSpecificationWrapper.logInformation("(EB]) Non-HTTP binding found for " + nextEndpointList.getContract().getName());
                }
            }
        }
        return result;
    }

    public EList<HTTPResourceBinding> getHTTPResourceBindings(EndpointInstance endpointInstance) {
        EList<TechnologyBinding> protocolBindings = endpointInstance.getPb();
        for (int i = 0; i < protocolBindings.size(); ++i) {
            ProtocolBinding pb = ((TechnologyBinding)endpointInstance.getPb().get(i)).getProtBinding();
            HTTPBinding httpb = pb.getHttp();
            if (httpb == null) continue;
            EList<HTTPResourceBinding> httprb = httpb.getEb();
            if (httprb == null) {
                return null;
            }
            return httprb;
        }
        return null;
    }

    public EndpointInstance findFirstProviderAndHttpBindingFor(EndpointContract endpointType) {
        EList<EObject> providers = ((ServiceSpecification)endpointType.eContainer()).getProviders();
        for (EObject provider : providers) {
            EndpointContract offeredContract;
            if (!(provider instanceof Provider)) continue;
            EList<EndpointList> epList = ((Provider)provider).getEpl();
            if (epList.size() == 0) {
                MDSLLogger.reportError("No endpoint provider found for " + endpointType.getName());
            }
            if (epList.size() >= 1) {
                MDSLLogger.reportWarning("More than one endpoint instance found, using first.");
            }
            if (!(offeredContract = ((EndpointList)epList.get(0)).getContract()).getName().equals(endpointType.getName())) continue;
            EList<EndpointInstance> eps = ((EndpointList)epList.get(0)).getEndpoints();
            if (eps.size() == 0) {
                MDSLLogger.reportWarning("No endpoint instance found for " + endpointType.getName());
                return null;
            }
            if (eps.size() > 1) {
                MDSLLogger.reportWarning("Provider for " + endpointType.getName() + " has multiple endpoint instances, using first one.");
            }
            return (EndpointInstance)eps.get(0);
        }
        MDSLSpecificationWrapper.logInformation("Endpoint instance in provider for " + endpointType.getName() + " does not have an endpoint provider.");
        return null;
    }

    public String findReportCodeInBinding(String operation, String reportNameInEndpointType, HTTPResourceBinding binding) {
        if (binding == null) {
            return OAS_CODE_X_742;
        }
        EList<HTTPOperationBinding> operationBindings = binding.getOpsB();
        for (int i = 0; i < operationBindings.size(); ++i) {
            HTTPOperationBinding opB = (HTTPOperationBinding)operationBindings.get(i);
            if (!opB.getBoundOperation().equals(operation)) continue;
            MDSLSpecificationWrapper.logInformation("Found an operation binding for " + operation + " in " + binding.getName() + ": " + opB.getMethod().getName());
            EList<ReportBinding> reports = opB.getReportBindings();
            for (int j = 0; j < reports.size(); ++j) {
                ReportBinding report = (ReportBinding)reports.get(j);
                MDSLSpecificationWrapper.logInformation("Processing a report binding: " + report.getName());
                if (!report.getName().equals(reportNameInEndpointType)) continue;
                MDSLSpecificationWrapper.logInformation("Report binding found for " + operation + " in " + binding.getName());
                return String.valueOf(report.getHttpStatusCode());
            }
        }
        MDSLSpecificationWrapper.logWarning("No report binding found for " + operation + " in " + binding.getName());
        return OAS_CODE_X_743;
    }

    public String findReportTextInBinding(String operation, String reportNameInEndpointType, HTTPResourceBinding binding) {
        if (binding == null) {
            return "null";
        }
        EList<HTTPOperationBinding> operationBindings = binding.getOpsB();
        for (int i = 0; i < operationBindings.size(); ++i) {
            HTTPOperationBinding opB = (HTTPOperationBinding)operationBindings.get(i);
            if (!opB.getBoundOperation().equals(operation)) continue;
            EList<ReportBinding> reports = opB.getReportBindings();
            for (int j = 0; j < reports.size(); ++j) {
                ReportBinding report = (ReportBinding)reports.get(j);
                if (!report.getName().equals(reportNameInEndpointType)) continue;
                return report.getDetails();
            }
        }
        MDSLSpecificationWrapper.logWarning("No report binding found for " + operation + " in " + binding.getName());
        return "n/a";
    }

    public SecurityBinding findPolicyInBinding(String operation, String policyNameInEndpointType, HTTPResourceBinding binding) {
        if (binding == null) {
            return null;
        }
        EList<HTTPOperationBinding> operationBindings = binding.getOpsB();
        for (int i = 0; i < operationBindings.size(); ++i) {
            HTTPOperationBinding opB = (HTTPOperationBinding)operationBindings.get(i);
            if (!opB.getBoundOperation().equals(operation)) continue;
            EList<SecurityBinding> policies = opB.getSecurityBindings();
            for (int j = 0; j < policies.size(); ++j) {
                SecurityBinding policy = (SecurityBinding)policies.get(j);
                if (!policy.getName().equals(policyNameInEndpointType)) continue;
                MDSLSpecificationWrapper.logInformation("(PB) Policy binding found for " + operation + " in " + binding.getName());
                return policy;
            }
        }
        MDSLSpecificationWrapper.logWarning("No policy binding found for " + operation + " in " + binding.getName() + ", skipping this one.");
        return null;
    }

    private String findKVPInPolicy(SecurityBinding spb, String key) {
        EList<String> keys = spb.getKeys();
        EList<String> values = spb.getValues();
        if (keys.contains((Object)key)) {
            int aurlPos = keys.indexOf((Object)key);
            return (String)values.get(aurlPos);
        }
        return null;
    }

    public String findAuthorizationUrlInPolicy(SecurityBinding spb) {
        return this.findKVPInPolicy(spb, AUTHORIZATION_URL);
    }

    public String findTokenUrlInPolicy(SecurityBinding spb) {
        return this.findKVPInPolicy(spb, TOKEN_URL);
    }

    public String findOIDUrlInPolicy(SecurityBinding spb) {
        return this.findKVPInPolicy(spb, OPEN_ID_CONNECT_URL);
    }

    public Map<String, String> findScopesInPolicyOrBinding(SecurityPolicy sp, SecurityBinding spb) {
        HashMap<String, String> result = new HashMap<String, String>();
        EList<String> keys = spb.getKeys();
        EList<String> values = spb.getValues();
        for (int i = 0; i < keys.size(); ++i) {
            if (!((String)keys.get(i)).startsWith(SCOPE_PREFIX)) continue;
            result.put((String)keys.get(i), (String)values.get(i));
        }
        return result;
    }

    public static void logError(String message) {
        MDSLLogger.reportError(message);
    }

    public static void logWarning(String message) {
        MDSLLogger.reportWarning(message);
    }

    public static void logInformation(String message) {
        MDSLLogger.reportInformation(message);
    }
}

