/*
 * Decompiled with CFR 0.152.
 */
package io.mdsl.validation;

import io.mdsl.apiDescription.ApiDescriptionPackage;
import io.mdsl.apiDescription.AtomicParameter;
import io.mdsl.apiDescription.AtomicParameterList;
import io.mdsl.apiDescription.DataContract;
import io.mdsl.apiDescription.DataTransferRepresentation;
import io.mdsl.apiDescription.ElementStructure;
import io.mdsl.apiDescription.GenericParameter;
import io.mdsl.apiDescription.ParameterForest;
import io.mdsl.apiDescription.ParameterTree;
import io.mdsl.apiDescription.RoleAndType;
import io.mdsl.apiDescription.SingleParameterNode;
import io.mdsl.apiDescription.TypeReference;
import io.mdsl.validation.AbstractMDSLValidator;
import java.util.ArrayList;
import java.util.Collection;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.EValidatorRegistrar;

public class DataTypeValidator
extends AbstractMDSLValidator {
    public static final String LOWER_CASE_NAME = "LOWER_CASE_NAME";
    public static final String TYPE_MISSING = "TYPE_MISSING";
    public static final String TYPE_STUCTURED = "TYPE_STUCTURED";
    public static final String APL_FOUND = "APL_FOUND";
    public static final String AP_FOUND = "AP_FOUND";
    public static final String TR_FOUND = "TR_FOUND";
    public static final String INLINED_TYPE_FOUND = "INLINED_TYPE_FOUND";
    public static final String TYPE_INCOMPLETE = "TYPE_INCOMPLETE";
    public static final String DECORATION_MISSING = "DECORATION_MISSING";

    public void register(EValidatorRegistrar registrar) {
    }

    @Check
    public void checkRoleAndType(RoleAndType rat) {
        String role = rat.getRole();
        String basicType = rat.getBtype();
        if (basicType == null || basicType.equals("")) {
            this.info("Incomplete specification: No type such as <string> or <int> specified yet.", rat, (EStructuralFeature)ApiDescriptionPackage.eINSTANCE.getRoleAndType_Btype(), TYPE_INCOMPLETE, new String[0]);
        } else if (basicType.equals("void")) {
            this.info("Imprecise specification: <void> only makes sense as sole element of a response message; you might want to remove the empty message from the specification.", rat, (EStructuralFeature)ApiDescriptionPackage.eINSTANCE.getRoleAndType_Btype());
        } else if (role.equals("ID") && !basicType.equals("int") && !basicType.equals("string")) {
            this.warning("The role-type combination ID<" + basicType + "> is somewhat unusual. Use ID<string> or ID<int> instead?", rat, (EStructuralFeature)ApiDescriptionPackage.eINSTANCE.getRoleAndType_Btype());
        } else if (role.equals("L") && !basicType.equals("int") && !basicType.equals("string")) {
            this.warning("The role-type combination L<" + basicType + "> is somewhat unusual. Use L<string> or L<int> instead?", rat, (EStructuralFeature)ApiDescriptionPackage.eINSTANCE.getRoleAndType_Btype());
        } else if (role.equals("MD") && basicType.equals("raw")) {
            this.warning("The role-type combination MD<raw> is somewhat unusual. Use MD<string> instead?", rat, (EStructuralFeature)ApiDescriptionPackage.eINSTANCE.getRoleAndType_Btype());
        }
    }

    @Check
    public void reportAtomicParameterList(AtomicParameterList apl) {
        if (apl.getName() != null) {
            this.info("\"" + apl.getName() + "\" is an atomic parameter list. You might want to introduce a DTO parameter tree instead.", apl, (EStructuralFeature)ApiDescriptionPackage.eINSTANCE.getAtomicParameterList_Name(), APL_FOUND, new String[0]);
        } else {
            this.warning("This is an atomic parameter list. You might want to introduce a DTO parameter tree instead.", apl, (EStructuralFeature)ApiDescriptionPackage.eINSTANCE.getAtomicParameterList_First(), APL_FOUND, new String[0]);
        }
    }

    @Check
    public void reportAtomicParameter(AtomicParameter ap) {
        if (ap.getRat().getName() != null) {
            this.info("\"" + ap.getRat().getName() + "\" is an atomic parameter. Do you want to wrap it?", ap, (EStructuralFeature)ApiDescriptionPackage.eINSTANCE.getAtomicParameter_Rat(), AP_FOUND, new String[0]);
        } else {
            this.info("This is an atomic parameter. Do you want to wrap it?", ap, (EStructuralFeature)ApiDescriptionPackage.eINSTANCE.getAtomicParameter_Rat(), AP_FOUND, new String[0]);
        }
    }

    @Check
    public void reportTypeReference(TypeReference tr) {
        if (tr.getName() != null) {
            this.info("\"" + tr.getName() + "\" is a data type reference. Do you want to wrap it in a DTO parameter tree?", tr, (EStructuralFeature)ApiDescriptionPackage.eINSTANCE.getTypeReference_Dcref(), TR_FOUND, new String[0]);
        } else {
            this.info("This is a data type reference. Do you want to wrap it in a DTO parameter tree?", tr, (EStructuralFeature)ApiDescriptionPackage.eINSTANCE.getTypeReference_Dcref(), TR_FOUND, new String[0]);
        }
    }

    @Check
    public void checkIncompleteTypeInformation(GenericParameter gp) {
        if (gp.getName() != null) {
            this.warning("\"" + gp.getName() + "\" is a generic parameter. You might want to provide a full identfier-role-type triple before invoking any generator.", gp, (EStructuralFeature)ApiDescriptionPackage.eINSTANCE.getGenericParameter_P(), TYPE_MISSING, new String[0]);
        } else {
            this.warning("This is a generic parameter. You might want to provide a full identfier-role-type triple. See MDSL documentation at https://microservice-api-patterns.github.io/MDSL-Specification/datacontract.", gp, (EStructuralFeature)ApiDescriptionPackage.eINSTANCE.getGenericParameter_P(), TYPE_MISSING, new String[0]);
        }
    }

    @Check
    public void checkInappropriateTypeName(DataContract dc) {
        if (!Character.isUpperCase(dc.getName().charAt(0))) {
            this.warning("Data type name should start with a capital", dc, (EStructuralFeature)ApiDescriptionPackage.eINSTANCE.getDataContract_Name(), LOWER_CASE_NAME, new String[0]);
        }
    }

    @Check
    public void reportTypeOfPayload(DataTransferRepresentation dtr) {
        if (dtr.getPayload() != null) {
            ElementStructure es = dtr.getPayload();
            if (es.getNp() != null) {
                SingleParameterNode spn = es.getNp();
                if (spn.getAtomP() != null || spn.getGenP() != null || spn.getTr() != null) {
                    this.info("Inlined/embedded data type definition", dtr, (EStructuralFeature)ApiDescriptionPackage.eINSTANCE.getDataTransferRepresentation_Payload(), INLINED_TYPE_FOUND, new String[0]);
                }
            } else if (es.getPt() != null) {
                ParameterTree pt = es.getPt();
                this.info("Inlined/embedded data type definition", dtr, (EStructuralFeature)ApiDescriptionPackage.eINSTANCE.getDataTransferRepresentation_Payload(), INLINED_TYPE_FOUND, new String[0]);
            }
        }
    }

    @Check
    public void checkParameterForestAsTuple(ParameterForest pf) {
        ArrayList<ParameterTree> trees = new ArrayList<ParameterTree>();
        trees.add(pf.getPtl().getFirst());
        trees.addAll((Collection<ParameterTree>)pf.getPtl().getNext());
        for (ParameterTree pt : trees) {
            if (pt.getName() == null) continue;
            this.info("ParameterForest are like tuples. Tuple item names are ignored.", pt, (EStructuralFeature)ApiDescriptionPackage.eINSTANCE.getParameterTree_Name());
        }
    }
}

