/*
 * Decompiled with CFR 0.152.
 */
package io.mdsl.validation;

import com.google.common.collect.Lists;
import io.mdsl.apiDescription.ApiDescriptionPackage;
import io.mdsl.apiDescription.AtomicParameter;
import io.mdsl.apiDescription.DataTransferRepresentation;
import io.mdsl.apiDescription.ElementStructure;
import io.mdsl.apiDescription.EndpointContract;
import io.mdsl.apiDescription.EndpointInstance;
import io.mdsl.apiDescription.EndpointList;
import io.mdsl.apiDescription.HTTPBinding;
import io.mdsl.apiDescription.HTTPGlobalParameterBinding;
import io.mdsl.apiDescription.HTTPOperationBinding;
import io.mdsl.apiDescription.HTTPParameter;
import io.mdsl.apiDescription.HTTPParameterBinding;
import io.mdsl.apiDescription.HTTPResourceBinding;
import io.mdsl.apiDescription.HTTPVerb;
import io.mdsl.apiDescription.Operation;
import io.mdsl.apiDescription.ReportBinding;
import io.mdsl.apiDescription.SecurityBinding;
import io.mdsl.apiDescription.SecurityPolicies;
import io.mdsl.apiDescription.SecurityPolicy;
import io.mdsl.apiDescription.StatusReport;
import io.mdsl.apiDescription.StatusReports;
import io.mdsl.apiDescription.TechnologyBinding;
import io.mdsl.apiDescription.TreeNode;
import io.mdsl.validation.AbstractMDSLValidator;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.EcoreUtil2;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.EValidatorRegistrar;

public class HTTPBindingValidator
extends AbstractMDSLValidator {
    public static final String RESOURCE_SHOULD_BE_SPLIT = "RESOURCE_SHOULD_BE_SPLIT";
    public static final String SECURITY_POLICY_UNBOUND = "SECURITY_POLICY_UNBOUND";
    public static final String SECURITY_POLICY_NOT_FOUND = "SECURITY_POLICY_NOT_FOUND";
    public static final String ERROR_REPORT_UNBOUND = "ERROR_REPORT_UNBOUND";
    public static final String ERROR_REPORT_NOT_FOUND = "ERROR_REPORT_NOT_FOUND";
    public static final String GLOBAL_PARAMETER_BINDING_FOUND = "GLOBAL_PARAMETER_BINDING_FOUND";
    public static final String URI_TEMPLATE_FOR_PATH_PARAM_MISSING = "URI_TEMPLATE_FOR_PATH_PARAM_MISSING";
    public static final String URI_TEMPLATE_MISSING_TEXT = "requires a URI template in resource URI";

    public void register(EValidatorRegistrar registrar) {
    }

    @Check
    void checkWhetherAllOperationsInContractAreBound(HTTPBinding httpBinding) {
        EndpointInstance ei;
        TechnologyBinding tp = (TechnologyBinding)httpBinding.eContainer().eContainer();
        EndpointList eil = null;
        if (tp.eContainer() instanceof EndpointInstance) {
            ei = (EndpointInstance)tp.eContainer();
            if (!(ei.eContainer() instanceof EndpointList)) {
                return;
            }
        } else {
            return;
        }
        eil = (EndpointList)ei.eContainer();
        EndpointContract ec = eil.getContract();
        for (Operation operation : ec.getOps()) {
            boolean found = false;
            for (HTTPResourceBinding resourceBinding : httpBinding.getEb()) {
                for (HTTPOperationBinding httpOperationBinding : resourceBinding.getOpsB()) {
                    if (!operation.getName().equals(httpOperationBinding.getBoundOperation())) continue;
                    found = true;
                }
            }
            if (found) continue;
            this.warning("Operation " + operation.getName() + " from contract " + ec.getName() + " not bound, default verb POST assumed by OAS generator.", httpBinding, (EStructuralFeature)ApiDescriptionPackage.eINSTANCE.getHTTPBinding_Eb());
        }
    }

    @Check
    void operationsActuallyDefinedInEndpointType(HTTPOperationBinding httpOperationBinding) {
        if (httpOperationBinding.getMethod() == HTTPVerb.TRACE || httpOperationBinding.getMethod() == HTTPVerb.HEAD || httpOperationBinding.getMethod() == HTTPVerb.OPTIONS) {
            this.warning("Operation " + httpOperationBinding.getBoundOperation() + " is bound to " + httpOperationBinding.getMethod().getName() + ", an HTTP verb that is not seen often in APIs. Prefer POST, PUT, PATCH, GET, DELETE", httpOperationBinding, (EStructuralFeature)ApiDescriptionPackage.eINSTANCE.getHTTPOperationBinding_Method());
        }
        this.checkWhetherAllBoundOperationsAppearInContract(httpOperationBinding);
        this.lookForErrorReportBindings(httpOperationBinding);
        this.lookForSecurityPolicyBindings(httpOperationBinding);
    }

    private void lookForSecurityPolicyBindings(HTTPOperationBinding httpOperationBinding) {
        EList<SecurityBinding> sbl = httpOperationBinding.getSecurityBindings();
        EndpointContract ec = this.findContract(httpOperationBinding);
        SecurityPolicies secPols = null;
        for (Operation operation : ec.getOps()) {
            if (!operation.getName().equals(httpOperationBinding.getBoundOperation())) continue;
            secPols = operation.getPolicies();
        }
        if (secPols == null && sbl != null && sbl.size() > 0) {
            this.error("No policy definitions found in endpoint type operation, but the operation binding has one or more.", httpOperationBinding, (EStructuralFeature)ApiDescriptionPackage.eINSTANCE.getHTTPOperationBinding_SecurityBindings(), SECURITY_POLICY_UNBOUND, new String[0]);
            return;
        }
        for (SecurityBinding sb : sbl) {
            boolean found = false;
            for (SecurityPolicy sp : secPols.getPolicyList()) {
                if (!sp.getName().equals(sb.getName())) continue;
                found = true;
            }
            if (found) continue;
            this.error("No policy definition for " + sb.getName() + " found in endpoint type operation.", httpOperationBinding, (EStructuralFeature)ApiDescriptionPackage.eINSTANCE.getHTTPOperationBinding_SecurityBindings(), SECURITY_POLICY_NOT_FOUND, new String[0]);
        }
    }

    private void lookForErrorReportBindings(HTTPOperationBinding httpOperationBinding) {
        EList<ReportBinding> rpl = httpOperationBinding.getReportBindings();
        EndpointContract ec = this.findContract(httpOperationBinding);
        StatusReports responseReports = null;
        for (Operation operation : ec.getOps()) {
            if (!operation.getName().equals(httpOperationBinding.getBoundOperation())) continue;
            responseReports = operation.getReports();
        }
        if (responseReports == null && rpl != null && rpl.size() > 0) {
            this.error("No report definitions found in endpoint type operation, but the operation binding has one or more.", httpOperationBinding, (EStructuralFeature)ApiDescriptionPackage.eINSTANCE.getHTTPOperationBinding_ReportBindings(), ERROR_REPORT_UNBOUND, new String[0]);
            return;
        }
        for (ReportBinding rp : rpl) {
            boolean found = false;
            for (StatusReport sr : responseReports.getReportList()) {
                if (!sr.getName().equals(rp.getName())) continue;
                found = true;
            }
            if (found) continue;
            this.error("No report definition for " + rp.getName() + " found in endpoint type operation.", httpOperationBinding, (EStructuralFeature)ApiDescriptionPackage.eINSTANCE.getHTTPOperationBinding_ReportBindings(), ERROR_REPORT_NOT_FOUND, new String[0]);
        }
    }

    private boolean checkWhetherAllBoundOperationsAppearInContract(HTTPOperationBinding httpOperationBinding) {
        EndpointContract ec = this.findContract(httpOperationBinding);
        if (ec == null) {
            System.err.println("No endpoint contract found, cannot check binding.");
            return true;
        }
        for (Operation operation : ec.getOps()) {
            if (!operation.getName().equals(httpOperationBinding.getBoundOperation())) continue;
            return true;
        }
        this.error("Bound operation " + httpOperationBinding.getBoundOperation() + " is not defined in the endpoint type " + ec.getName() + ". Add it there or delete binding here.", httpOperationBinding, (EStructuralFeature)ApiDescriptionPackage.eINSTANCE.getHTTPOperationBinding_BoundOperation());
        return false;
    }

    @Check
    void elementsActuallyDefinedInRequestPayload(HTTPParameterBinding parameterBinding) {
        HTTPOperationBinding httpOperationBinding = (HTTPOperationBinding)parameterBinding.eContainer();
        EndpointContract ec = this.findContract(httpOperationBinding);
        Operation op = this.findOperation(ec, httpOperationBinding.getBoundOperation());
        if (!this.isPresentInRequestPayload(parameterBinding.getBoundParameter(), op)) {
            this.error("Bound parameter " + parameterBinding.getBoundParameter() + " is not defined in the bound operation " + op.getName() + ". Add it there or delete binding here.", parameterBinding, (EStructuralFeature)ApiDescriptionPackage.eINSTANCE.getHTTPParameterBinding_BoundParameter());
        }
    }

    private boolean isPresentInRequestPayload(String boundParameter, Operation op) {
        DataTransferRepresentation rm = op.getRequestMessage();
        ElementStructure structure = rm.getPayload();
        if (structure == null) {
            return false;
        }
        return this.checkElements(structure, boundParameter);
    }

    private boolean checkElements(ElementStructure structure, String boundParameter) {
        LinkedList atomicParameterList = Lists.newLinkedList();
        if (structure.getApl() != null) {
            atomicParameterList.add(structure.getApl().getFirst());
            atomicParameterList.addAll(structure.getApl().getNextap());
        } else if (structure.getNp() != null && structure.getNp().getAtomP() != null) {
            atomicParameterList.add(structure.getNp().getAtomP());
        } else {
            if (structure.getNp() != null && structure.getNp().getTr() != null) {
                if (structure.getNp().getTr().getName() != null && structure.getNp().getTr().getName().equals(boundParameter)) {
                    return true;
                }
                return this.checkElements(structure.getNp().getTr().getDcref().getStructure(), boundParameter);
            }
            if (structure.getNp().getGenP() != null) {
                if (structure.getNp().getGenP().getName() != null && structure.getNp().getGenP().getName().equals(boundParameter)) {
                    return true;
                }
            } else if (structure.getPt() != null) {
                LinkedList nodes = Lists.newLinkedList();
                nodes.add(structure.getPt().getFirst());
                nodes.addAll(structure.getPt().getNexttn());
                for (TreeNode nextLevel1Node : nodes) {
                    if (nextLevel1Node.getPn() == null || nextLevel1Node.getPn().getAtomP() == null) continue;
                    atomicParameterList.add(nextLevel1Node.getPn().getAtomP());
                }
            }
        }
        for (AtomicParameter atomicParameter : atomicParameterList) {
            if (atomicParameter.getRat() == null || atomicParameter.getRat().getName() == null || !atomicParameter.getRat().getName().equals(boundParameter)) continue;
            return true;
        }
        return false;
    }

    @Check
    public void doNotAllowBODYMappingForGETsAndDELETEs(HTTPOperationBinding httpOperationBinding) {
        if (httpOperationBinding.getMethod() != HTTPVerb.GET && httpOperationBinding.getMethod() != HTTPVerb.DELETE) {
            return;
        }
        HTTPGlobalParameterBinding gb = httpOperationBinding.getGlobalBinding();
        if (gb != null && gb.getParameterMapping() == HTTPParameter.BODY && (httpOperationBinding.getMethod() == HTTPVerb.GET || httpOperationBinding.getMethod() == HTTPVerb.DELETE)) {
            this.error("HTTP operations using the verbs GET and DELETE must not contain BODY parameters.", gb, (EStructuralFeature)ApiDescriptionPackage.eINSTANCE.getHTTPGlobalParameterBinding_ParameterMapping());
        }
        for (HTTPParameterBinding parameterBinding : EcoreUtil2.eAllOfType((EObject)httpOperationBinding, HTTPParameterBinding.class).stream().filter(pb -> pb.getParameterMapping() != null && pb.getParameterMapping() != null && pb.getParameterMapping() == HTTPParameter.BODY).collect(Collectors.toList())) {
            this.error("HTTP operations with the verbs GET and DELETE do not support BODY parameters.", parameterBinding, (EStructuralFeature)ApiDescriptionPackage.eINSTANCE.getHTTPParameterBinding_ParameterMapping());
        }
    }

    @Check
    public void reportDifferentVerbBindings(HTTPResourceBinding httpResourceBinding) {
        HashMap<HTTPVerb, Integer> verbCountMap = new HashMap<HTTPVerb, Integer>();
        for (HTTPOperationBinding operationBinding : httpResourceBinding.getOpsB()) {
            Integer currentCount = (Integer)verbCountMap.get((Object)operationBinding.getMethod());
            if (currentCount == null) {
                currentCount = 0;
            }
            verbCountMap.put(operationBinding.getMethod(), currentCount + 1);
        }
        for (Map.Entry entry : verbCountMap.entrySet()) {
            if ((Integer)entry.getValue() <= 1) continue;
            this.warning("Resource binds multiple operations to the same HTTP verb. Split it or change the operation bindings.", httpResourceBinding, (EStructuralFeature)ApiDescriptionPackage.eINSTANCE.getHTTPResourceBinding_Name(), RESOURCE_SHOULD_BE_SPLIT, new String[0]);
        }
    }

    @Check
    public void reportMissingURITemplate(HTTPResourceBinding httpResourceBinding) {
        for (HTTPOperationBinding operationBinding : httpResourceBinding.getOpsB()) {
            HTTPGlobalParameterBinding gb = operationBinding.getGlobalBinding();
            if (gb != null) {
                if (!gb.getParameterMapping().toString().equals("PATH") || httpResourceBinding.getUri() != null && httpResourceBinding.getUri().matches(".*\\{.*\\}.*")) continue;
                this.error("PATH parameter(s) of " + operationBinding.getBoundOperation() + " " + URI_TEMPLATE_MISSING_TEXT + ": {id}", operationBinding, (EStructuralFeature)ApiDescriptionPackage.eINSTANCE.getHTTPOperationBinding_BoundOperation(), URI_TEMPLATE_FOR_PATH_PARAM_MISSING, new String[0]);
                continue;
            }
            for (HTTPParameterBinding parameterBinding : operationBinding.getParameterBindings()) {
                if (!parameterBinding.getParameterMapping().toString().equals("PATH") || httpResourceBinding.getUri() != null && httpResourceBinding.getUri().contains("{" + parameterBinding.getBoundParameter() + "}")) continue;
                this.error("PATH parameter of " + operationBinding.getBoundOperation() + " " + URI_TEMPLATE_MISSING_TEXT + ": {" + parameterBinding.getBoundParameter() + "}", operationBinding, (EStructuralFeature)ApiDescriptionPackage.eINSTANCE.getHTTPOperationBinding_BoundOperation(), URI_TEMPLATE_FOR_PATH_PARAM_MISSING, new String[0]);
            }
        }
    }

    @Check
    public void reportGlobalParameterBindingForOperation(HTTPGlobalParameterBinding globalParameterBinding) {
        this.info("All elements bound to same HTTP parameter type.", globalParameterBinding.eContainer(), (EStructuralFeature)ApiDescriptionPackage.eINSTANCE.getHTTPOperationBinding_BoundOperation(), GLOBAL_PARAMETER_BINDING_FOUND, new String[0]);
    }

    private EndpointContract findContract(HTTPOperationBinding httpOperationBinding) {
        TechnologyBinding tb = (TechnologyBinding)httpOperationBinding.eContainer().eContainer().eContainer().eContainer();
        if (tb.eContainer() instanceof EndpointInstance) {
            EndpointInstance ei = (EndpointInstance)tb.eContainer();
            if (ei.eContainer() instanceof EndpointList) {
                EndpointList eil = (EndpointList)ei.eContainer();
                return eil.getContract();
            }
            return null;
        }
        return null;
    }

    private Operation findOperation(EndpointContract ec, String boundOperation) {
        for (Operation operation : ec.getOps()) {
            if (!operation.getName().equals(boundOperation)) continue;
            return operation;
        }
        return null;
    }
}

