/*
 * Decompiled with CFR 0.152.
 */
package io.mdsl.validation;

import io.mdsl.apiDescription.ApiDescriptionPackage;
import io.mdsl.apiDescription.EndpointContract;
import io.mdsl.apiDescription.Operation;
import io.mdsl.apiDescription.OperationResponsibility;
import io.mdsl.validation.AbstractMDSLValidator;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.EValidatorRegistrar;

public class MAPDecoratorValidator
extends AbstractMDSLValidator {
    private static final String PROCESSING_RESOURCE = "PROCESSING_RESOURCE";
    private static final String INFORMATION_HOLDER_RESOURCE = "INFORMATION_HOLDER_RESOURCE";
    private static final String REFERENCE_DATA_HOLDER = "REFERENCE_DATA_HOLDER";
    private static final String MASTER_DATA_HOLDER = "MASTER_DATA_HOLDER";
    private static final String OPERATIONAL_DATA_HOLDER = "OPERATIONAL_DATA_HOLDER";
    private static final String DATA_TRANSFER_RESOURCE = "DATA_TRANSFER_RESOURCE";
    private static final String LINK_LOOKUP_RESOURCE = "LINK_LOOKUP_RESOURCE";
    private static final String STATELESS_PROCESSING_RESOURCE = "STATELESS_PROCESSING_RESOURCE";
    private static final String RETRIEVAL_OPERATION = "RETRIEVAL_OPERATION";
    private static final String COMPUTATION_FUNCTION = "COMPUTATION_FUNCTION";
    private static final String STATE_CREATION_OPERATION = "STATE_CREATION_OPERATION";
    private static final String STATE_DELETION_OPERATION = "STATE_DELETION_OPERATION";
    private static final String STATE_REPLACEMENT_OPERATION = "STATE_REPLACEMENT_OPERATION";
    private static final String STATE_TRANSITION_OPERATION = "STATE_TRANSITION_OPERATION";
    public static final String MAP_DECORATOR_FOUND = "MAP_DECORATOR_FOUND";
    public static final String MAP_DECORATOR_MISSING = "MAP_DECORATOR_MISSING";
    public static final String CQRS_ELIGIBLE = "CQRS_ELIGIBLE";

    public void register(EValidatorRegistrar registrar) {
    }

    @Check
    public void checkCQRSEligibility(EndpointContract endpoint) {
        boolean hasReadOperations = false;
        boolean hasOtherOperations = false;
        EList<Operation> opList = endpoint.getOps();
        for (Operation nextOp : opList) {
            if (RETRIEVAL_OPERATION.equals(this.getResponsibilityPattern(nextOp))) {
                hasReadOperations = true;
                continue;
            }
            hasOtherOperations = true;
        }
        if (hasReadOperations && hasOtherOperations) {
            this.info(endpoint.getName() + " can be CQRSed.", endpoint, (EStructuralFeature)ApiDescriptionPackage.eINSTANCE.getEndpointContract_Name(), CQRS_ELIGIBLE, new String[0]);
        }
    }

    @Check
    public void checkRoleResponsibilityPatternCombination(EndpointContract nextEndpoint) {
        EList<Operation> opList = nextEndpoint.getOps();
        String role1 = nextEndpoint.getPrimaryRole();
        if (role1 == null || role1.equals("")) {
            this.info(nextEndpoint.getName() + " has no responsibility.", nextEndpoint, (EStructuralFeature)ApiDescriptionPackage.eINSTANCE.getEndpointContract_Name(), MAP_DECORATOR_MISSING, new String[0]);
        } else {
            this.info(nextEndpoint.getName() + " has a responsibility.", nextEndpoint, (EStructuralFeature)ApiDescriptionPackage.eINSTANCE.getEndpointContract_Name(), MAP_DECORATOR_FOUND, new String[0]);
        }
        for (int i = 0; i < opList.size(); ++i) {
            Operation nextOp = (Operation)opList.get(i);
            String responsibility = this.getResponsibilityPattern(nextOp);
            if (responsibility == null || responsibility.equals("")) continue;
            this.checkOperationResponsibilitySemantics(nextOp, responsibility);
            this.checkOperationResponsibilityImpactOnState(nextOp, responsibility);
            if (role1.equals(PROCESSING_RESOURCE)) continue;
            if (role1.equals(INFORMATION_HOLDER_RESOURCE)) {
                this.checkCommonDataEndpointConstraint(nextEndpoint, nextOp, responsibility);
                continue;
            }
            if (role1.equals(MASTER_DATA_HOLDER) || role1.equals(OPERATIONAL_DATA_HOLDER) || role1.equals(DATA_TRANSFER_RESOURCE)) continue;
            if (role1.equals(REFERENCE_DATA_HOLDER)) {
                this.checkCommonDataEndpointConstraint(nextEndpoint, nextOp, responsibility);
                if (responsibility.equals(STATE_CREATION_OPERATION)) {
                    this.warning(nextOp.getName() + " creates state, somewhat unexpected in a reference data holder such as " + nextEndpoint.getName(), nextOp, (EStructuralFeature)ApiDescriptionPackage.eINSTANCE.getOperation_Name());
                }
                if (responsibility.equals(STATE_TRANSITION_OPERATION)) {
                    this.warning(nextOp.getName() + " updates state, somewhat unexpected in a reference data holder such as " + nextEndpoint.getName(), nextOp, (EStructuralFeature)ApiDescriptionPackage.eINSTANCE.getOperation_Name());
                }
                if (responsibility.equals(STATE_REPLACEMENT_OPERATION)) {
                    this.warning(nextOp.getName() + " replaces state, somewhat unexpected in a stateless processing resource such as " + nextEndpoint.getName(), nextOp, (EStructuralFeature)ApiDescriptionPackage.eINSTANCE.getOperation_Name());
                }
                if (!responsibility.equals(STATE_DELETION_OPERATION)) continue;
                this.warning(nextOp.getName() + " deletes state, somewhat unexpected in a stateless processing resource such as " + nextEndpoint.getName(), nextOp, (EStructuralFeature)ApiDescriptionPackage.eINSTANCE.getOperation_Name());
                continue;
            }
            if (role1.equals(LINK_LOOKUP_RESOURCE)) {
                this.checkCommonDataEndpointConstraint(nextEndpoint, nextOp, responsibility);
                if (responsibility.equals(STATE_TRANSITION_OPERATION)) {
                    this.warning(nextOp.getName() + " updates state, somewhat unexpected in a link lookup resource resource such as " + nextEndpoint.getName(), nextOp, (EStructuralFeature)ApiDescriptionPackage.eINSTANCE.getOperation_Name());
                }
                if (responsibility.equals(STATE_CREATION_OPERATION)) {
                    this.warning(nextOp.getName() + " creates state, somewhat unexpected in a link lookup resource such as " + nextEndpoint.getName(), nextOp, (EStructuralFeature)ApiDescriptionPackage.eINSTANCE.getOperation_Name());
                }
                if (responsibility.equals(STATE_REPLACEMENT_OPERATION)) {
                    this.warning(nextOp.getName() + " replaces state, somewhat unexpected in a link lookup resource such as " + nextEndpoint.getName(), nextOp, (EStructuralFeature)ApiDescriptionPackage.eINSTANCE.getOperation_Name());
                }
                if (!responsibility.equals(STATE_DELETION_OPERATION)) continue;
                this.warning(nextOp.getName() + " deletes state, somewhat unexpected in a link lookup resource such as " + nextEndpoint.getName(), nextOp, (EStructuralFeature)ApiDescriptionPackage.eINSTANCE.getOperation_Name());
                continue;
            }
            if (role1.equals(STATELESS_PROCESSING_RESOURCE)) {
                this.checkCommonDataEndpointConstraint(nextEndpoint, nextOp, responsibility);
                if (responsibility.equals(STATE_CREATION_OPERATION)) {
                    this.error(nextOp.getName() + " creates state, which is unexpected in a stateless processing resource such as " + nextEndpoint.getName(), nextOp, (EStructuralFeature)ApiDescriptionPackage.eINSTANCE.getOperation_Name());
                }
                if (responsibility.equals(STATE_TRANSITION_OPERATION)) {
                    this.error(nextOp.getName() + " updates state, which is unexpected in a stateless processing resource such as " + nextEndpoint.getName(), nextOp, (EStructuralFeature)ApiDescriptionPackage.eINSTANCE.getOperation_Name());
                }
                if (responsibility.equals(STATE_REPLACEMENT_OPERATION)) {
                    this.error(nextOp.getName() + " replaces state, which is unexpected in a stateless processing resource such as " + nextEndpoint.getName(), nextOp, (EStructuralFeature)ApiDescriptionPackage.eINSTANCE.getOperation_Name());
                }
                if (!responsibility.equals(STATE_DELETION_OPERATION)) continue;
                this.error(nextOp.getName() + " deletes state, which is unexpected in a stateless processing resource such as " + nextEndpoint.getName(), nextOp, (EStructuralFeature)ApiDescriptionPackage.eINSTANCE.getOperation_Name());
                continue;
            }
            this.info(nextEndpoint.getName() + " has unknown role " + role1, nextEndpoint, (EStructuralFeature)ApiDescriptionPackage.eINSTANCE.getEndpointContract_Name());
        }
    }

    private void checkOperationResponsibilitySemantics(Operation op, String responsibility) {
        if ((responsibility.equals(COMPUTATION_FUNCTION) || responsibility.equals(RETRIEVAL_OPERATION)) && (op.getResponseMessage() == null || op.getResponseMessage().getPayload() == null)) {
            this.error(op.getName() + " is specified to be a " + responsibility + " and should therefore deliver a response payload", op, (EStructuralFeature)ApiDescriptionPackage.eINSTANCE.getOperation_Name());
        }
    }

    private void checkOperationResponsibilityImpactOnState(Operation operation, String responsibility) {
        if (COMPUTATION_FUNCTION.equals(responsibility) && operation.getSt() != null) {
            this.error(operation.getName() + " is a " + COMPUTATION_FUNCTION + ", and should therefore not change state. Change the MAP decorator or remove the 'transitions' part.", operation, (EStructuralFeature)ApiDescriptionPackage.eINSTANCE.getOperation_Responsibility());
        } else if (RETRIEVAL_OPERATION.equals(responsibility) && operation.getSt() != null) {
            this.error(operation.getName() + " is a RETRIEVAL_OPERATION, and should therefore not change state. Change the MAP decorator or remove the 'transitions' part.", operation, (EStructuralFeature)ApiDescriptionPackage.eINSTANCE.getOperation_Responsibility());
        }
    }

    private void checkCommonDataEndpointConstraint(EndpointContract ep, Operation op, String responsibility) {
        if (responsibility.equals(COMPUTATION_FUNCTION)) {
            this.warning(op.getName() + " is a " + COMPUTATION_FUNCTION + ", somewhat unexpected in a data-oriented endpoint such as " + ep.getName(), op, (EStructuralFeature)ApiDescriptionPackage.eINSTANCE.getOperation_Name());
        }
    }

    private String getResponsibilityPattern(Operation mdslOperation) {
        OperationResponsibility responsibility = mdslOperation.getResponsibility();
        if (responsibility == null) {
            return "";
        }
        if (responsibility.getCf() != null) {
            return COMPUTATION_FUNCTION;
        }
        if (responsibility.getSco() != null) {
            return STATE_CREATION_OPERATION;
        }
        if (responsibility.getRo() != null) {
            return RETRIEVAL_OPERATION;
        }
        if (responsibility.getSto() != null) {
            return STATE_TRANSITION_OPERATION;
        }
        if (responsibility.getSro() != null) {
            return STATE_REPLACEMENT_OPERATION;
        }
        if (responsibility.getSdo() != null) {
            return STATE_DELETION_OPERATION;
        }
        if (responsibility.getOther() != null) {
            return responsibility.getOther();
        }
        return "";
    }
}

