/*
 * Decompiled with CFR 0.152.
 */
package io.mdsl.validation;

import io.mdsl.apiDescription.ApiDescriptionPackage;
import io.mdsl.apiDescription.DataTransferRepresentation;
import io.mdsl.apiDescription.EndpointContract;
import io.mdsl.apiDescription.Operation;
import io.mdsl.apiDescription.ParameterTree;
import io.mdsl.transformations.TransformationHelpers;
import io.mdsl.validation.AbstractMDSLValidator;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.xtext.validation.Check;
import org.eclipse.xtext.validation.EValidatorRegistrar;

public class OperationValidator
extends AbstractMDSLValidator {
    public static final String OPERATION_FOUND = "OPERATION_FOUND";
    public static final String NO_ERROR_REPORT = "NO_ERROR_REPORT";
    public static final String NO_SECURITY_POLICY = "NO_SECURITY_POLICY";
    public static final String NO_COMPENSATION = "NO_COMPENSATION";
    public static final String MAP_EXTRACT_IHR_POSSIBLE = "MAP_EXTRACT_IHR_POSSIBLE";
    private static final String PAGINATION_DECORATOR = "Pagination";
    public static final String MAP_PAGINATION_POSSIBLE = "MAP_PAGINATION_POSSIBLE";
    public static final String MAP_REQUEST_BUNDLE_POSSIBLE = "MAP_REQUEST_BUNDLE_POSSIBLE";
    public static final String MAP_RESPONSE_BUNDLE_POSSIBLE = "MAP_RESPONSE_BUNDLE_POSSIBLE";
    public static final String MAP_WISH_LIST_POSSIBLE = "MAP_WISH_LIST_POSSIBLE";
    public static final String MAP_WISH_LIST_DECORATED = "MAP_WISH_LIST_DECORATED";
    public static final String MAP_WISH_TEMPLATE_POSSIBLE = "MAP_WISH_TEMPLATE_POSSIBLE";
    public static final String LINKED_INFORMATION_HOLDER_FOUND_IN_REQUEST = "LINKED_INFORMATION_HOLDER_FOUND_IN_REQUEST";
    public static final String LINKED_INFORMATION_HOLDER_FOUND = "LINKED_INFORMATION_HOLDER_FOUND";
    public static final String EMBEDDED_ENTITY_DECORATOR = "Embedded_Entity";
    public static final String LINKED_INFORMATION_HOLDER_DECORATOR = "Linked_Information_Holder";
    public static final String EMBEDDED_ENTITY_FOUND_IN_REQUEST = "EMBEDDED_ENTITY_FOUND_IN_REQUEST";
    public static final String EMBEDDED_ENTITY_FOUND = "EMBEDDED_ENTITY_FOUND";
    public static final String REQUEST_IS_PARAMETER_TREE_WITH_OPTIONAL_NODES = "MAP_REQUEST_BUNDLE_POSSIBLE";

    public void register(EValidatorRegistrar registrar) {
    }

    @Check
    public void lookForOperationsToBeMoved(Operation operation) {
        EndpointContract ec = (EndpointContract)operation.eContainer();
        this.info(operation.getName() + " located in endpoint type " + ec.getName(), operation, (EStructuralFeature)ApiDescriptionPackage.eINSTANCE.getOperation_Name(), OPERATION_FOUND, new String[0]);
    }

    @Check
    public void validateMessagePresenceForExchangePattern(Operation nextOp) {
        String mep = nextOp.getMep();
        DataTransferRepresentation inDtr = nextOp.getRequestMessage();
        DataTransferRepresentation outDtr = nextOp.getResponseMessage();
        if (mep.equals("REQUEST_REPLY")) {
            if (inDtr == null) {
                this.error(nextOp.getName() + " is a REQUEST_REPLY operation, which expects a request message", nextOp, (EStructuralFeature)ApiDescriptionPackage.eINSTANCE.getOperation_Mep());
            }
            if (outDtr == null) {
                this.error(nextOp.getName() + " is a REQUEST_REPLY operation, which must deliver a response message", nextOp, (EStructuralFeature)ApiDescriptionPackage.eINSTANCE.getOperation_Mep());
            }
        } else if (mep.equals("ONE_WAY")) {
            if (inDtr == null) {
                this.error(nextOp.getName() + " is a ONE_WAY operation, which expects a request message", nextOp, (EStructuralFeature)ApiDescriptionPackage.eINSTANCE.getOperation_Mep());
            }
            if (outDtr != null) {
                this.error(nextOp.getName() + " is a ONE_WAY operation, which should not deliver a response message", nextOp, (EStructuralFeature)ApiDescriptionPackage.eINSTANCE.getOperation_Mep());
            }
        } else if (mep.equals("NOTIFICATION")) {
            if (inDtr != null) {
                this.error(nextOp.getName() + " is a NOTIFICATION operation, which should not expect a request message", nextOp, (EStructuralFeature)ApiDescriptionPackage.eINSTANCE.getOperation_Mep());
            }
            if (outDtr == null) {
                this.error(nextOp.getName() + " is a NOTIFICATION operation, which must deliver a response message", nextOp, (EStructuralFeature)ApiDescriptionPackage.eINSTANCE.getOperation_Mep());
            }
        }
    }

    @Check
    public void lookForStatusReports(Operation operation) {
        if (operation.getReports() == null) {
            this.info(operation.getName() + " does not define any reports to be returned", operation, (EStructuralFeature)ApiDescriptionPackage.eINSTANCE.getOperation_Name(), NO_ERROR_REPORT, new String[0]);
        }
    }

    @Check
    public void lookForSecurityPolicy(Operation operation) {
        if (operation.getPolicies() == null) {
            this.info(operation.getName() + " does not define any security policies to be enforced", operation, (EStructuralFeature)ApiDescriptionPackage.eINSTANCE.getOperation_Name(), NO_SECURITY_POLICY, new String[0]);
        }
    }

    @Check
    public void lookForCompensation(Operation operation) {
        if (operation.getUndo() == null) {
            this.info(operation.getName() + " does not define any compensating action", operation, (EStructuralFeature)ApiDescriptionPackage.eINSTANCE.getOperation_Name(), NO_COMPENSATION, new String[0]);
        }
    }

    @Check
    public void lookForWishListInRequestPayload(Operation operation) {
        ParameterTree pt;
        if (operation.getRequestMessage() != null && operation.getRequestMessage().getPayload() != null && (pt = operation.getRequestMessage().getPayload().getPt()) != null && TransformationHelpers.findStereotypeInTree(pt, "Wish_List") == null) {
            this.info(operation.getName() + " does not contain a Wish List yet", operation, (EStructuralFeature)ApiDescriptionPackage.eINSTANCE.getOperation_Name(), MAP_WISH_LIST_POSSIBLE, new String[0]);
        }
    }

    @Check
    public void lookForParameterTreeInRequestPayload(Operation operation) {
        if (operation.getRequestMessage().getPayload().getPt() != null) {
            this.info(operation.getName() + " expects a top-level parameter tree", operation, (EStructuralFeature)ApiDescriptionPackage.eINSTANCE.getOperation_Name(), "MAP_REQUEST_BUNDLE_POSSIBLE", new String[0]);
        }
    }

    @Check
    public void lookForParameterTreeInResponsePayload(Operation operation) {
        if (operation.getResponseMessage().getPayload().getPt() != null) {
            this.info(operation.getName() + " can be paginated", operation, (EStructuralFeature)ApiDescriptionPackage.eINSTANCE.getOperation_Name(), MAP_RESPONSE_BUNDLE_POSSIBLE, new String[0]);
        }
    }

    @Check
    public void lookForPaginationOpportunity(Operation operation) {
        ParameterTree pt = operation.getRequestMessage().getPayload().getPt();
        if (pt != null && TransformationHelpers.findStereotypeInTree(pt, PAGINATION_DECORATOR) == null && operation.getResponseMessage().getPayload().getPt() != null) {
            this.info(operation.getName() + " can be paginated", operation, (EStructuralFeature)ApiDescriptionPackage.eINSTANCE.getOperation_Name(), MAP_PAGINATION_POSSIBLE, new String[0]);
        }
    }

    @Check
    public void lookForLinkedInformationHolder(Operation operation) {
        ParameterTree pt = operation.getRequestMessage().getPayload().getPt();
        if (pt != null && TransformationHelpers.findStereotypeInTree(pt, LINKED_INFORMATION_HOLDER_DECORATOR) != null) {
            this.info(operation.getName() + " request contains a Linked Information Holder that can be extracted", operation, (EStructuralFeature)ApiDescriptionPackage.eINSTANCE.getOperation_Name(), LINKED_INFORMATION_HOLDER_FOUND_IN_REQUEST, new String[0]);
        }
        if ((pt = operation.getResponseMessage().getPayload().getPt()) != null && TransformationHelpers.findStereotypeInTree(pt, LINKED_INFORMATION_HOLDER_DECORATOR) != null) {
            this.info(operation.getName() + " contains a Linked Information Holder that can be extracted", operation, (EStructuralFeature)ApiDescriptionPackage.eINSTANCE.getOperation_Name(), LINKED_INFORMATION_HOLDER_FOUND, new String[0]);
        }
    }

    @Check
    public void lookForEmbeddedEntity(Operation operation) {
        ParameterTree pt = operation.getRequestMessage().getPayload().getPt();
        if (pt != null && TransformationHelpers.findStereotypeInTree(pt, EMBEDDED_ENTITY_DECORATOR) != null) {
            this.info(operation.getName() + " request contains an Embedded Entity that can be extracted", operation, (EStructuralFeature)ApiDescriptionPackage.eINSTANCE.getOperation_Name(), EMBEDDED_ENTITY_FOUND_IN_REQUEST, new String[0]);
        }
        if ((pt = operation.getResponseMessage().getPayload().getPt()) != null && TransformationHelpers.findStereotypeInTree(pt, EMBEDDED_ENTITY_DECORATOR) != null) {
            this.info(operation.getName() + " contains an Embedded Entity that can be extracted", operation, (EStructuralFeature)ApiDescriptionPackage.eINSTANCE.getOperation_Name(), EMBEDDED_ENTITY_FOUND, new String[0]);
        }
    }

    @Check
    public void wishTemplateCanBeAdded(Operation operation) {
        if (operation.getRequestMessage() == null || operation.getResponseMessage() == null) {
            return;
        }
        if (operation.getRequestMessage().getPayload() == null || operation.getResponseMessage().getPayload() == null) {
            return;
        }
        if (operation.getRequestMessage().getPayload().getPt() == null) {
            return;
        }
        this.info(operation.getName() + " can receive Wish Template", operation, (EStructuralFeature)ApiDescriptionPackage.eINSTANCE.getOperation_Name(), MAP_WISH_TEMPLATE_POSSIBLE, new String[0]);
    }
}

