/*
 * Decompiled with CFR 0.152.
 */
package io.github.microserviceapipatterns.protobufgen.model;

import io.github.microserviceapipatterns.protobufgen.exception.RootElementAlreadyExistsException;
import io.github.microserviceapipatterns.protobufgen.model.Enum;
import io.github.microserviceapipatterns.protobufgen.model.FullIdentifier;
import io.github.microserviceapipatterns.protobufgen.model.Identifiable;
import io.github.microserviceapipatterns.protobufgen.model.ImportStatement;
import io.github.microserviceapipatterns.protobufgen.model.Message;
import io.github.microserviceapipatterns.protobufgen.model.MessageField;
import io.github.microserviceapipatterns.protobufgen.model.Service;
import io.github.microserviceapipatterns.protobufgen.serializer.ProtoSpecSerializer;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class ProtoSpec {
    private String syntax;
    private List<Message> messages;
    private List<Enum> enums;
    private List<Service> services;
    private List<ImportStatement> importStatements;
    private FullIdentifier packageDef;
    private String comment;
    private ProtoSpecSerializer serializer = new ProtoSpecSerializer();

    private ProtoSpec() {
    }

    public List<Message> getMessages() {
        return new LinkedList<Message>(this.messages);
    }

    public List<Enum> getEnums() {
        return new LinkedList<Enum>(this.enums);
    }

    public List<Service> getServices() {
        return new LinkedList<Service>(this.services);
    }

    public String getSyntax() {
        return this.syntax;
    }

    public List<ImportStatement> getImportStatements() {
        return new LinkedList<ImportStatement>(this.importStatements);
    }

    public String getPackage() {
        return this.packageDef != null ? this.packageDef.toString() : "";
    }

    public String toString() {
        return this.serializer.serialize(this);
    }

    public void persistProto(File protoFile) throws IOException {
        this.serializer.writeToFile(this, protoFile);
    }

    public String getComment() {
        return this.comment;
    }

    public static class Builder {
        private final List<Message> messages = new LinkedList<Message>();
        private final List<Enum> enums = new LinkedList<Enum>();
        private final List<Service> services = new LinkedList<Service>();
        private final Set<Identifiable> allIdentifiableObjects = new HashSet<Identifiable>();
        private final List<ImportStatement> importStatements = new LinkedList<ImportStatement>();
        private FullIdentifier packageDef;
        private String comment = "";

        public Builder withMessage(Message message) {
            this.addIdentifiable(message);
            this.messages.add(message);
            return this;
        }

        public Builder withMessage(Message.Builder messageBuilder) {
            return this.withMessage(messageBuilder.build());
        }

        public Builder withEnum(Enum enumm) {
            this.addIdentifiable(enumm);
            this.enums.add(enumm);
            return this;
        }

        public Builder withEnum(Enum.Builder enumBuilder) {
            return this.withEnum(enumBuilder.build());
        }

        public Builder withService(Service service) {
            this.addIdentifiable(service);
            this.services.add(service);
            return this;
        }

        public Builder withService(Service.Builder serviceBuilder) {
            return this.withService(serviceBuilder.build());
        }

        public Builder withImport(ImportStatement importStatement) {
            this.importStatements.add(importStatement);
            return this;
        }

        public Builder withImport(String fileName) {
            return this.withImport(new ImportStatement(fileName));
        }

        public Builder withImport(String fileName, boolean publicImport) {
            return this.withImport(new ImportStatement(fileName, publicImport));
        }

        public Builder withPackage(FullIdentifier packageDef) {
            this.packageDef = packageDef;
            return this;
        }

        public Builder withPackage(String packageName) {
            return this.withPackage(new FullIdentifier(packageName));
        }

        public Builder withComment(String comment) {
            this.comment = comment;
            return this;
        }

        private void addIdentifiable(Identifiable identifiable) {
            if (this.allIdentifiableObjects.stream().anyMatch(m -> m.getIdentifier().equals(identifiable.getIdentifier()))) {
                throw new RootElementAlreadyExistsException(identifiable.getIdentifier().toString());
            }
            this.allIdentifiableObjects.add(identifiable);
        }

        public ProtoSpec build() {
            ProtoSpec spec = new ProtoSpec();
            spec.syntax = "proto3";
            spec.messages = new LinkedList<Message>(this.messages);
            spec.enums = new LinkedList<Enum>(this.enums);
            spec.services = new LinkedList<Service>(this.services);
            spec.packageDef = this.packageDef;
            spec.comment = this.comment;
            if (this.containsAnyType()) {
                this.addAnyTypeImport();
            }
            spec.importStatements = new LinkedList<ImportStatement>(this.importStatements);
            return spec;
        }

        private boolean containsAnyType() {
            for (Message message : this.messages) {
                if (!this.containsAnyType(message)) continue;
                return true;
            }
            return false;
        }

        private boolean containsAnyType(Message message) {
            for (MessageField field : message.getFields()) {
                if (!field.getType().equals("google.protobuf.Any")) continue;
                return true;
            }
            for (Message nested : message.getNestedMessages()) {
                if (!this.containsAnyType(nested)) continue;
                return true;
            }
            return false;
        }

        private void addAnyTypeImport() {
            if (!this.importStatements.stream().anyMatch(i -> i.getFileName().equals("google/protobuf/any.proto"))) {
                this.importStatements.add(new ImportStatement("google/protobuf/any.proto"));
            }
        }
    }
}

