/*
 * Decompiled with CFR 0.152.
 */
package io.github.microserviceapipatterns.protobufgen.serializer;

import freemarker.template.Configuration;
import freemarker.template.Template;
import io.github.microserviceapipatterns.protobufgen.exception.ProtoSerializationException;
import io.github.microserviceapipatterns.protobufgen.model.ProtoSpec;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;

public class ProtoSpecSerializer {
    public String serialize(ProtoSpec spec) {
        Configuration cfg = new Configuration(Configuration.VERSION_2_3_30);
        cfg.setClassLoaderForTemplateLoading(this.getClass().getClassLoader(), "template");
        cfg.setDefaultEncoding("UTF-8");
        try {
            Template template = cfg.getTemplate("proto.ftl");
            StringWriter writer = new StringWriter();
            template.process((Object)spec, (Writer)writer);
            return writer.toString();
        }
        catch (Exception e) {
            throw new ProtoSerializationException(e);
        }
    }

    public void writeToFile(ProtoSpec spec, File file) throws IOException {
        FileWriter writer = new FileWriter(file);
        writer.write(this.serialize(spec));
        writer.close();
    }
}

