/*
 * Decompiled with CFR 0.152.
 */
package io.mdsl.cli;

import io.mdsl.MDSLResource;
import io.mdsl.cli.MDSLGenerator;
import io.mdsl.generator.TextFileGenerator;
import io.mdsl.standalone.MDSLStandaloneAPI;
import io.mdsl.standalone.MDSLStandaloneSetup;
import java.io.File;
import java.util.Arrays;
import java.util.stream.Collectors;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xtext.generator.IGenerator2;

public class MDSLCommandLineInterface {
    private MDSLStandaloneAPI api;
    private String outputDir = "./";

    public static void main(String[] args) {
        new MDSLCommandLineInterface().run(args);
    }

    private void run(String[] args) {
        Options options = this.createOptions();
        DefaultParser commandLineParser = new DefaultParser();
        try {
            CommandLine cmd = commandLineParser.parse(options, args);
            if (cmd.hasOption("help")) {
                this.printHelp(options);
            }
            String inputPath = cmd.getOptionValue("input");
            this.validateInputFile(inputPath);
            this.api = MDSLStandaloneSetup.getStandaloneAPI();
            MDSLResource mdsl = this.readMDSLFile(inputPath);
            if (cmd.hasOption("standalone")) {
                this.generateInMemory(mdsl, cmd.getOptionValue("generator"), cmd);
            } else {
                this.setOutputDir(cmd.getOptionValue("outputDir"));
                this.generate(mdsl, cmd.getOptionValue("generator"), cmd);
            }
        }
        catch (ParseException e) {
            System.out.println(e.getMessage());
            this.printHelp(options);
        }
    }

    private void printHelp(Options options) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("mdsl", options);
        System.exit(1);
    }

    private Options createOptions() {
        Options options = new Options();
        Option input = new Option("i", "input", true, "Path to the MDSL file for which you want to generate output.");
        input.setRequired(true);
        options.addOption(input);
        Option generator = new Option("g", "generator", true, "The generator you want to call. Use one of the following values: " + String.join((CharSequence)", ", Arrays.asList(MDSLGenerator.values()).stream().map(g -> g.toString()).collect(Collectors.toList())));
        options.addOption(generator);
        Option outputDirectory = new Option("o", "outputDir", true, "The output directory into which the generated files shall be written. By default files are generated into the execution directory.");
        options.addOption(outputDirectory);
        Option freemarkerTemplate = new Option("t", "template", true, "Path to the Freemarker template you want to use. This parameter is only used if you pass 'text' to the 'generator' (-g) parameter.");
        options.addOption(freemarkerTemplate);
        Option outputFilename = new Option("f", "outputFile", true, "The name of the file that shall be generated. This parameter is only used if you pass 'text' to the 'generator' (-g) parameter because the Freemarker generator does not guess any file name extension).");
        options.addOption(outputFilename);
        Option standalone = new Option("s", "standalone", false, "Create output in main memory and write it to standard output console.");
        options.addOption(standalone);
        Option help = new Option("h", "help", false, "Prints this message.");
        options.addOption(help);
        return options;
    }

    private void validateInputFile(String inputPath) {
        File inputFile = new File(inputPath);
        if (!inputFile.exists()) {
            System.out.println("ERROR: The file '" + inputPath + "' does not exist.");
            System.exit(1);
        }
        if (!inputPath.endsWith(".mdsl")) {
            System.out.println("ERROR: Please provide a path to an MDSL (*.mdsl) file.");
            System.exit(1);
        }
    }

    private void setOutputDir(String outputDir) {
        if (outputDir == null || "".equals(outputDir)) {
            return;
        }
        File dir = new File(outputDir);
        if (dir.exists() && !dir.isDirectory()) {
            System.out.println("ERROR: '" + outputDir + "' is not a directory.");
            System.exit(1);
        }
        this.outputDir = outputDir;
    }

    private MDSLResource readMDSLFile(String filePath) {
        MDSLResource mdsl = this.api.loadMDSL(filePath);
        if (mdsl.getErrors().isEmpty()) {
            System.out.println("The MDSL file '" + filePath + "' has been compiled without errors.");
        } else {
            for (Resource.Diagnostic diagnostic : mdsl.getErrors()) {
                System.out.println("ERROR in " + diagnostic.getLocation() + " on line " + diagnostic.getLine() + ":" + diagnostic.getMessage());
            }
            System.exit(1);
        }
        for (Resource.Diagnostic diagnostic : mdsl.getWarnings()) {
            System.out.println("WARNING in " + diagnostic.getLocation() + " on line " + diagnostic.getLine() + ":" + diagnostic.getMessage());
        }
        return mdsl;
    }

    private void generate(MDSLResource resource, String generatorName, CommandLine cmd) {
        MDSLGenerator generator;
        if (generatorName == null) {
            System.out.println("Use -g to pass the generator you want to call.");
            System.exit(1);
        }
        if ((generator = MDSLGenerator.byName(generatorName)) == MDSLGenerator.ARBITRARY_TEXT_BY_TEMPLATE) {
            this.ensureTemplatePathIsSet(cmd.getOptionValue("template"));
            this.ensureFileNameIsSet(cmd.getOptionValue("outputFile"));
            TextFileGenerator freemarkerGen = (TextFileGenerator)generator.getGenerator();
            freemarkerGen.setFreemarkerTemplateFile(new File(cmd.getOptionValue("template")));
            freemarkerGen.setTargetFileName(cmd.getOptionValue("outputFile"));
            this.api.callGenerator(resource, (IGenerator2)freemarkerGen, this.outputDir);
        } else {
            this.api.callGenerator(resource, generator.getGenerator(), this.outputDir);
        }
        System.out.println("The output files have been generated into '" + this.outputDir + "'.");
    }

    private void generateInMemory(MDSLResource resource, String generatorName, CommandLine cmd) {
        String result;
        MDSLGenerator generator;
        if (generatorName == null) {
            System.out.println("Use -g to pass the generator you want to call.");
            System.exit(1);
        }
        if ((generator = MDSLGenerator.byName(generatorName)) == MDSLGenerator.ARBITRARY_TEXT_BY_TEMPLATE) {
            this.ensureTemplatePathIsSet(cmd.getOptionValue("template"));
            TextFileGenerator freemarkerGen = (TextFileGenerator)generator.getGenerator();
            freemarkerGen.setFreemarkerTemplateFile(new File(cmd.getOptionValue("template")));
            result = this.api.callGeneratorInMemory(resource, (IGenerator2)freemarkerGen);
        } else {
            IGenerator2 gg = generator.getGenerator();
            result = this.api.callGeneratorInMemory(resource, gg);
        }
        System.out.println("The conversion output has been generated in main memory:");
        System.out.println(result);
    }

    private void ensureTemplatePathIsSet(String pathToTemplate) {
        File ftlFile;
        if (pathToTemplate == null) {
            System.out.println("ERROR: Please set the path to the Freemarker template (-t).");
            System.exit(1);
        }
        if (!pathToTemplate.endsWith(".ftl")) {
            System.out.println("ERROR: Please provide a Freemarker template file ending with *.ftl (-t).");
            System.exit(1);
        }
        if (!(ftlFile = new File(pathToTemplate)).exists()) {
            System.out.println("ERROR: The Freemarker template file '" + pathToTemplate + "' does not exist.");
            System.exit(1);
        }
    }

    private void ensureFileNameIsSet(String filename) {
        if (filename == null || "".equals(filename)) {
            System.out.println("Please provide a file name (-f) for the file that shall be generated. In case you use the Freemarker generator, we cannot know the appropriate file extension.");
            System.exit(1);
        }
    }
}

