/*
 * Decompiled with CFR 0.152.
 */
package io.mdsl.cli;

import io.mdsl.generator.GenModelJSONExporter;
import io.mdsl.generator.GenModelYAMLExporter;
import io.mdsl.generator.GraphQLGenerator;
import io.mdsl.generator.JavaGenerator;
import io.mdsl.generator.JolieGenerator;
import io.mdsl.generator.OpenAPIGenerator;
import io.mdsl.generator.ProtocolBuffersGenerator;
import io.mdsl.generator.TextFileGenerator;
import org.eclipse.xtext.generator.IGenerator2;

public enum MDSLGenerator {
    OPEN_API_SPEC("oas", "OpenAPI Specification"),
    JOLIE("jolie", "Jolie"),
    ARBITRARY_TEXT_BY_TEMPLATE("text", "arbitrary text file by using a Freemarker template"),
    PROTOCOL_BUFFERS("proto", "Protocol Buffers"),
    GRAPHQL("graphql", "GraphQL Schemas"),
    JAVA("java", "Java Modulith"),
    GEN_MODEL_JSON_EXPORT("gen-model-json", "Generator model as JSON (exporter)"),
    GEN_MODEL_YAML_EXPORT("gen-model-yaml", "Generator model as YAML (exporter)");

    private String name;
    private String description;

    private MDSLGenerator(String name, String description) {
        this.name = name;
        this.description = description;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String toString() {
        return this.name + " (" + this.description + ")";
    }

    public static MDSLGenerator byName(String name) {
        if (name == null) {
            throw new RuntimeException("Please provide a name for the generator.");
        }
        for (MDSLGenerator generator : MDSLGenerator.values()) {
            if (!generator.getName().equals(name)) continue;
            return generator;
        }
        throw new RuntimeException("No generator found for the name '" + name + "'.");
    }

    public IGenerator2 getGenerator() {
        if (this == OPEN_API_SPEC) {
            return new OpenAPIGenerator();
        }
        if (this == JOLIE) {
            return new JolieGenerator();
        }
        if (this == PROTOCOL_BUFFERS) {
            return new ProtocolBuffersGenerator();
        }
        if (this == GRAPHQL) {
            return new GraphQLGenerator();
        }
        if (this == JAVA) {
            return new JavaGenerator();
        }
        if (this == GEN_MODEL_JSON_EXPORT) {
            return new GenModelJSONExporter();
        }
        if (this == GEN_MODEL_YAML_EXPORT) {
            return new GenModelYAMLExporter();
        }
        return new TextFileGenerator();
    }
}

