/*
 * Decompiled with CFR 0.152.
 */
package io.github.ningyu.jmeter.plugin.dubbo.gui;

import io.github.ningyu.jmeter.plugin.dubbo.gui.JAutoCompleteComboBox;
import io.github.ningyu.jmeter.plugin.dubbo.sample.MethodArgument;
import io.github.ningyu.jmeter.plugin.dubbo.sample.ProviderService;
import io.github.ningyu.jmeter.plugin.util.Constants;
import io.github.ningyu.jmeter.plugin.util.StringUtils;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.DefaultComboBoxModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.table.DefaultTableModel;
import org.apache.dubbo.common.URL;
import org.apache.jmeter.gui.util.HorizontalPanel;
import org.apache.jmeter.gui.util.VerticalPanel;
import org.apache.jmeter.testelement.TestElement;

public class DubboCommonPanel {
    private JComboBox<String> registryProtocolText;
    private JTextField addressText;
    private JTextField registryGroupText;
    private JTextField registryUserNameText;
    private JTextField registryPasswordText;
    private JTextField registryTimeoutText;
    private JComboBox configCenterProtocolText;
    private JTextField configCenterGroupText;
    private JTextField configCenterNamespaceText;
    private JTextField configCenterUserNameText;
    private JTextField configCenterPasswordText;
    private JTextField configCenterAddressText;
    private JTextField configCenterTimeoutText;
    private JComboBox<String> rpcProtocolText;
    private JTextField timeoutText;
    private JTextField versionText;
    private JTextField retriesText;
    private JTextField clusterText;
    private JTextField groupText;
    private JTextField connectionsText;
    private JComboBox<String> loadbalanceText;
    private JComboBox<String> asyncText;
    private JTextField interfaceText;
    private JTextField methodText;
    private DefaultTableModel model;
    private String[] columnNames = new String[]{"paramType", "paramValue"};
    private String[] tmpRow = new String[]{"", ""};
    private DefaultTableModel modelAttachment;
    private String[] columnNamesAttachment = new String[]{"key", "value"};
    private int textColumns = 2;
    private JAutoCompleteComboBox<String> interfaceList;
    private JAutoCompleteComboBox<String> methodList;
    private TestElement element;

    public void bundleElement(TestElement element) {
        this.element = element;
    }

    public JPanel drawRegistrySettingsPanel() {
        VerticalPanel registrySettings = new VerticalPanel();
        registrySettings.setBorder(BorderFactory.createTitledBorder("Registry Center"));
        HorizontalPanel ph = new HorizontalPanel();
        JLabel protocolLable = new JLabel("Protocol:", 4);
        this.registryProtocolText = new JComboBox<String>(new String[]{"", "none", "zookeeper", "nacos", "multicast", "redis", "simple"});
        this.registryProtocolText.setToolTipText("\"none\" is direct connection");
        protocolLable.setLabelFor(this.registryProtocolText);
        ph.add(protocolLable);
        ph.add(this.registryProtocolText);
        ph.add(this.makeHelper("Registry center address protocol, The 'none' is direct connection. "));
        JLabel registryGroupLable = new JLabel("Group:", 4);
        this.registryGroupText = new JTextField();
        registryGroupLable.setLabelFor(this.registryGroupText);
        ph.add(registryGroupLable);
        ph.add(this.registryGroupText);
        ph.add(this.makeHelper("Service registration grouping, cross-group services will not affect each other, and can not be called each other, suitable for environmental isolation."));
        JLabel registryUserNameLable = new JLabel("UserName:", 4);
        this.registryUserNameText = new JTextField();
        registryUserNameLable.setLabelFor(this.registryUserNameText);
        ph.add(registryUserNameLable);
        ph.add(this.registryUserNameText);
        ph.add(this.makeHelper("The usename of the registry. Do not set it if the registry doesn't need validation."));
        JLabel registryPasswordLable = new JLabel("Password:", 4);
        this.registryPasswordText = new JTextField();
        registryPasswordLable.setLabelFor(this.registryPasswordText);
        ph.add(registryPasswordLable);
        ph.add(this.registryPasswordText);
        ph.add(this.makeHelper("The password of the registry. Do not set it if the registry doesn't need validation."));
        registrySettings.add((Component)ph);
        HorizontalPanel ah = new HorizontalPanel();
        JLabel addressLable = new JLabel("Address:", 4);
        this.addressText = new JTextField(this.textColumns);
        addressLable.setLabelFor(this.addressText);
        ah.add(addressLable);
        ah.add(this.addressText);
        ah.add(this.makeHelper("Use the registry to allow multiple addresses, Use direct connection to allow only one address! Multiple address format: ip1:port1,ip2:port2 . Direct address format: ip:port . "));
        JLabel registryTimeoutLable = new JLabel("Timeout:", 4);
        this.registryTimeoutText = new JTextField();
        registryTimeoutLable.setLabelFor(this.registryTimeoutText);
        ah.add(registryTimeoutLable);
        ah.add(this.registryTimeoutText);
        ah.add(this.makeHelper("The timeout(ms) of the request to registry."));
        registrySettings.add((Component)ah);
        return registrySettings;
    }

    public JPanel drawConfigCenterSettingsPanel() {
        VerticalPanel configCenterSettings = new VerticalPanel();
        configCenterSettings.setBorder(BorderFactory.createTitledBorder("Config Center"));
        HorizontalPanel ph = new HorizontalPanel();
        JLabel protocolLable = new JLabel("Protocol:", 4);
        this.configCenterProtocolText = new JComboBox<String>(new String[]{"", "zookeeper", "nacos", "apollo"});
        protocolLable.setLabelFor(this.configCenterProtocolText);
        ph.add(protocolLable);
        ph.add(this.configCenterProtocolText);
        ph.add(this.makeHelper("Which configuration center to use: apollo, zookeeper, nacos, etc. 2.7.0+"));
        JLabel configCenterGroupLable = new JLabel("Group:", 4);
        this.configCenterGroupText = new JTextField();
        configCenterGroupLable.setLabelFor(this.configCenterGroupText);
        ph.add(configCenterGroupLable);
        ph.add(this.configCenterGroupText);
        ph.add(this.makeHelper("The meaning varies according to the configuration center selected. 2.7.0+"));
        JLabel configCenterNamespaceLable = new JLabel("Namespace:", 4);
        this.configCenterNamespaceText = new JTextField();
        configCenterNamespaceLable.setLabelFor(this.configCenterNamespaceText);
        ph.add(configCenterNamespaceLable);
        ph.add(this.configCenterNamespaceText);
        ph.add(this.makeHelper("Using for multi-tenant isolation generally, the actual meaning varies depending on the configuration center. 2.7.0+"));
        JLabel configCenterUserNameLable = new JLabel("UserName:", 4);
        this.configCenterUserNameText = new JTextField();
        configCenterUserNameLable.setLabelFor(this.configCenterUserNameText);
        ph.add(configCenterUserNameLable);
        ph.add(this.configCenterUserNameText);
        ph.add(this.makeHelper("the username if the configuration center requires validation, Apollo is not yet enabled. 2.7.0+"));
        JLabel configCenterPasswordLable = new JLabel("Password:", 4);
        this.configCenterPasswordText = new JTextField();
        configCenterPasswordLable.setLabelFor(this.configCenterPasswordText);
        ph.add(configCenterPasswordLable);
        ph.add(this.configCenterPasswordText);
        ph.add(this.makeHelper("password if configuration center needs to do check, Apollo is not yet enabled. 2.7.0+"));
        configCenterSettings.add((Component)ph);
        HorizontalPanel ah = new HorizontalPanel();
        JLabel configCenterAddressLable = new JLabel("Address:", 4);
        this.configCenterAddressText = new JTextField(this.textColumns);
        configCenterAddressLable.setLabelFor(this.configCenterAddressText);
        ah.add(configCenterAddressLable);
        ah.add(this.configCenterAddressText);
        ah.add(this.makeHelper("Configuration center address. 2.7.0+"));
        JLabel configCenterTimeoutLable = new JLabel("Timeout:", 4);
        this.configCenterTimeoutText = new JTextField();
        configCenterTimeoutLable.setLabelFor(this.configCenterTimeoutText);
        ah.add(configCenterTimeoutLable);
        ah.add(this.configCenterTimeoutText);
        ah.add(this.makeHelper("Gets the configured timeout. 2.7.0+ "));
        configCenterSettings.add((Component)ah);
        return configCenterSettings;
    }

    public JPanel drawProtocolSettingsPanel() {
        VerticalPanel protocolSettings = new VerticalPanel();
        protocolSettings.setBorder(BorderFactory.createTitledBorder("RPC Protocol"));
        HorizontalPanel rpcPh = new HorizontalPanel();
        JLabel rpcProtocolLable = new JLabel("Protocol:", 4);
        this.rpcProtocolText = new JComboBox<String>(new String[]{"dubbo://", "rmi://", "hessian://", "webservice://", "memcached://", "redis://"});
        rpcProtocolLable.setLabelFor(this.rpcProtocolText);
        rpcPh.add(rpcProtocolLable);
        rpcPh.add(this.rpcProtocolText);
        rpcPh.add(this.makeHelper("RPC protocol name."));
        protocolSettings.add((Component)rpcPh);
        return protocolSettings;
    }

    public JPanel drawConsumerSettingsPanel() {
        VerticalPanel consumerSettings = new VerticalPanel();
        consumerSettings.setBorder(BorderFactory.createTitledBorder("Consumer & Service"));
        HorizontalPanel h = new HorizontalPanel();
        JLabel timeoutLable = new JLabel(" Timeout:", 4);
        this.timeoutText = new JTextField(this.textColumns);
        this.timeoutText.setText("1000");
        timeoutLable.setLabelFor(this.timeoutText);
        h.add(timeoutLable);
        h.add(this.timeoutText);
        h.add(this.makeHelper("Invoking timeout(ms)"));
        JLabel versionLable = new JLabel("Version:", 4);
        this.versionText = new JTextField(this.textColumns);
        this.versionText.setText("1.0");
        versionLable.setLabelFor(this.versionText);
        h.add(versionLable);
        h.add(this.versionText);
        h.add(this.makeHelper("Service version."));
        JLabel retriesLable = new JLabel("Retries:", 4);
        this.retriesText = new JTextField(this.textColumns);
        this.retriesText.setText("0");
        retriesLable.setLabelFor(this.retriesText);
        h.add(retriesLable);
        h.add(this.retriesText);
        h.add(this.makeHelper("The retry count for RPC, not including the first invoke. Please set it to 0 if don't need to retry."));
        JLabel clusterLable = new JLabel("Cluster:", 4);
        this.clusterText = new JTextField(this.textColumns);
        this.clusterText.setText("failfast");
        clusterLable.setLabelFor(this.clusterText);
        h.add(clusterLable);
        h.add(this.clusterText);
        h.add(this.makeHelper("failover/failfast/failsafe/failback/forking are available."));
        JLabel groupLable = new JLabel("Group:", 4);
        this.groupText = new JTextField(this.textColumns);
        groupLable.setLabelFor(this.groupText);
        h.add(groupLable);
        h.add(this.groupText);
        h.add(this.makeHelper("The group of the service providers. It can distinguish services when it has multiple implements."));
        JLabel connectionsLable = new JLabel("Connections:", 4);
        this.connectionsText = new JTextField(this.textColumns);
        this.connectionsText.setText("100");
        connectionsLable.setLabelFor(this.connectionsText);
        h.add(connectionsLable);
        h.add(this.connectionsText);
        h.add(this.makeHelper("The maximum connections of every provider. For short connection such as rmi, http and hessian, it's connection limit, but for long connection such as dubbo, it's connection count."));
        consumerSettings.add((Component)h);
        HorizontalPanel hp1 = new HorizontalPanel();
        JLabel asyncLable = new JLabel("     Async:", 4);
        this.asyncText = new JComboBox<String>(new String[]{"sync", "async"});
        asyncLable.setLabelFor(this.asyncText);
        hp1.add(asyncLable);
        hp1.add(this.asyncText);
        hp1.add(this.makeHelper("Asynchronous execution, not reliable. It does not block the execution thread just only ignores the return value."));
        JLabel loadbalanceLable = new JLabel("Loadbalance:", 4);
        this.loadbalanceText = new JComboBox<String>(new String[]{"random", "roundrobin", "leastactive", "consistenthash"});
        loadbalanceLable.setLabelFor(this.loadbalanceText);
        hp1.add(loadbalanceLable);
        hp1.add(this.loadbalanceText);
        hp1.add(this.makeHelper("Strategy of load balance, random, roundrobin and leastactive are available."));
        consumerSettings.add((Component)hp1);
        return consumerSettings;
    }

    public JPanel drawInterfaceSettingsPanel() {
        VerticalPanel interfaceSettings = new VerticalPanel();
        interfaceSettings.setBorder(BorderFactory.createTitledBorder("Interface"));
        HorizontalPanel sh = new HorizontalPanel();
        JButton jButton = new JButton("Get Provider List");
        this.interfaceList = new JAutoCompleteComboBox(new DefaultComboBoxModel<String>(new String[0]), new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    DubboCommonPanel.this.doChange(e.getItem().toString());
                }
            }
        });
        this.interfaceList.addPropertyChangeListener("model", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (DubboCommonPanel.this.interfaceList.getSelectedItem() != null) {
                    DubboCommonPanel.this.doChange(DubboCommonPanel.this.interfaceList.getSelectedItem().toString());
                } else {
                    DubboCommonPanel.this.methodList.setModel(new DefaultComboBoxModel<String>(new String[0]));
                }
            }
        });
        jButton.addActionListener(new ActionListener((JPanel)interfaceSettings){
            final /* synthetic */ JPanel val$interfaceSettings;
            {
                this.val$interfaceSettings = jPanel;
            }

            @Override
            public void actionPerformed(ActionEvent e) {
                DubboCommonPanel.this.doConfirm(e, DubboCommonPanel.this.interfaceList, this.val$interfaceSettings);
            }
        });
        sh.add(jButton);
        sh.add(new JLabel("Interfaces:", 4));
        sh.add(this.interfaceList);
        sh.add(new JLabel("Methods:", 4));
        this.methodList = new JAutoCompleteComboBox(new DefaultComboBoxModel<String>(new String[0]), new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (e.getStateChange() == 1) {
                    DubboCommonPanel.this.methodText.setText(e.getItem().toString());
                }
            }
        });
        this.methodList.addPropertyChangeListener("model", new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent evt) {
                if (DubboCommonPanel.this.methodList.getSelectedItem() != null) {
                    DubboCommonPanel.this.methodText.setText(DubboCommonPanel.this.methodList.getSelectedItem().toString());
                }
            }
        });
        sh.add(this.methodList);
        interfaceSettings.add((Component)sh);
        HorizontalPanel ih = new HorizontalPanel();
        JLabel interfaceLable = new JLabel("Interface:", 4);
        this.interfaceText = new JTextField(this.textColumns);
        interfaceLable.setLabelFor(this.interfaceText);
        ih.add(interfaceLable);
        ih.add(this.interfaceText);
        ih.add(this.makeHelper("The service interface name."));
        interfaceSettings.add((Component)ih);
        HorizontalPanel mh = new HorizontalPanel();
        JLabel methodLable = new JLabel("   Method:", 4);
        this.methodText = new JTextField(this.textColumns);
        methodLable.setLabelFor(this.methodText);
        mh.add(methodLable);
        mh.add(this.methodText);
        mh.add(this.makeHelper("The service method name"));
        interfaceSettings.add((Component)mh);
        JTabbedPane tabbedPane = new JTabbedPane(1);
        HorizontalPanel tablePanel = new HorizontalPanel();
        this.model = new DefaultTableModel();
        this.model.setDataVector((Object[][])null, this.columnNames);
        final JTable table = new JTable(this.model);
        table.setRowHeight(40);
        table.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        JButton addBtn = new JButton("\u589e\u52a0");
        addBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                DubboCommonPanel.this.model.addRow(DubboCommonPanel.this.tmpRow);
            }
        });
        JButton delBtn = new JButton("\u5220\u9664");
        delBtn.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                int rowIndex = table.getSelectedRow();
                if (rowIndex != -1) {
                    DubboCommonPanel.this.model.removeRow(rowIndex);
                }
            }
        });
        JScrollPane scrollpane = new JScrollPane(table);
        tablePanel.add(scrollpane);
        tablePanel.add(addBtn);
        tablePanel.add(delBtn);
        tabbedPane.add("Args", (Component)tablePanel);
        HorizontalPanel tablePanelAttachment = new HorizontalPanel();
        this.modelAttachment = new DefaultTableModel();
        this.modelAttachment.setDataVector((Object[][])null, this.columnNamesAttachment);
        final JTable tableAttachment = new JTable(this.modelAttachment);
        tableAttachment.setRowHeight(40);
        tableAttachment.putClientProperty("terminateEditOnFocusLost", Boolean.TRUE);
        JButton addBtnAttachment = new JButton("\u589e\u52a0");
        addBtnAttachment.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                DubboCommonPanel.this.modelAttachment.addRow(DubboCommonPanel.this.tmpRow);
            }
        });
        JButton delBtnAttachment = new JButton("\u5220\u9664");
        delBtnAttachment.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                int rowIndex = tableAttachment.getSelectedRow();
                if (rowIndex != -1) {
                    DubboCommonPanel.this.modelAttachment.removeRow(rowIndex);
                }
            }
        });
        JScrollPane scrollpaneAttachment = new JScrollPane(tableAttachment);
        tablePanelAttachment.add(scrollpaneAttachment);
        tablePanelAttachment.add(addBtnAttachment);
        tablePanelAttachment.add(delBtnAttachment);
        tabbedPane.add("Attachment Args", (Component)tablePanelAttachment);
        interfaceSettings.add(tabbedPane);
        return interfaceSettings;
    }

    public void configureRegistry(TestElement element) {
        this.registryProtocolText.setSelectedItem(Constants.getRegistryProtocol(element));
        this.registryGroupText.setText(Constants.getRegistryGroup(element));
        this.registryUserNameText.setText(Constants.getRegistryUserName(element));
        this.registryPasswordText.setText(Constants.getRegistryPassword(element));
        this.addressText.setText(Constants.getAddress(element));
        this.registryTimeoutText.setText(Constants.getRegistryTimeout(element));
    }

    public void configureConfigCenter(TestElement element) {
        this.configCenterProtocolText.setSelectedItem(Constants.getConfigCenterProtocol(element));
        this.configCenterGroupText.setText(Constants.getConfigCenterGroup(element));
        this.configCenterNamespaceText.setText(Constants.getConfigCenterNamespace(element));
        this.configCenterUserNameText.setText(Constants.getConfigCenterUserName(element));
        this.configCenterPasswordText.setText(Constants.getConfigCenterPassword(element));
        this.configCenterAddressText.setText(Constants.getConfigCenterAddress(element));
        this.configCenterTimeoutText.setText(Constants.getConfigCenterTimeout(element));
    }

    public void configureProtocol(TestElement element) {
        this.rpcProtocolText.setSelectedItem(Constants.getRpcProtocol(element));
    }

    public void configureConsumer(TestElement element) {
        this.versionText.setText(Constants.getVersion(element));
        this.timeoutText.setText(Constants.getTimeout(element));
        this.retriesText.setText(Constants.getRetries(element));
        this.groupText.setText(Constants.getGroup(element));
        this.connectionsText.setText(Constants.getConnections(element));
        this.loadbalanceText.setSelectedItem(Constants.getLoadbalance(element));
        this.asyncText.setSelectedItem(Constants.getAsync(element));
        this.clusterText.setText(Constants.getCluster(element));
    }

    public void configureInterface(TestElement element) {
        this.interfaceText.setText(Constants.getInterface(element));
        this.methodText.setText(Constants.getMethod(element));
        Vector<String> columnNames = new Vector<String>();
        columnNames.add("paramType");
        columnNames.add("paramValue");
        this.model.setDataVector(this.paserMethodArgsData(Constants.getMethodArgs(element)), columnNames);
        Vector<String> columnNamesAttachment = new Vector<String>();
        columnNamesAttachment.add("key");
        columnNamesAttachment.add("value");
        this.modelAttachment.setDataVector(this.paserMethodArgsData(Constants.getAttachmentArgs(element)), columnNamesAttachment);
    }

    public void modifyRegistry(TestElement element) {
        Constants.setRegistryProtocol(this.registryProtocolText.getSelectedItem().toString(), element);
        Constants.setRegistryGroup(this.registryGroupText.getText(), element);
        Constants.setRegistryUserName(this.registryUserNameText.getText(), element);
        Constants.setRegistryPassword(this.registryPasswordText.getText(), element);
        Constants.setAddress(this.addressText.getText(), element);
        Constants.setRegistryTimeout(this.registryTimeoutText.getText(), element);
    }

    public void modifyConfigCenter(TestElement element) {
        Constants.setConfigCenterProtocol(this.configCenterProtocolText.getSelectedItem().toString(), element);
        Constants.setConfigCenterGroup(this.configCenterGroupText.getText(), element);
        Constants.setConfigCenterNamespace(this.configCenterNamespaceText.getText(), element);
        Constants.setConfigCenterUserName(this.configCenterUserNameText.getText(), element);
        Constants.setConfigCenterPassword(this.configCenterPasswordText.getText(), element);
        Constants.setConfigCenterAddress(this.configCenterAddressText.getText(), element);
        Constants.setConfigCenterTimeout(this.configCenterTimeoutText.getText(), element);
    }

    public void modifyProtocol(TestElement element) {
        Constants.setRpcProtocol(this.rpcProtocolText.getSelectedItem().toString(), element);
    }

    public void modifyConsumer(TestElement element) {
        Constants.setTimeout(this.timeoutText.getText(), element);
        Constants.setVersion(this.versionText.getText(), element);
        Constants.setRetries(this.retriesText.getText(), element);
        Constants.setGroup(this.groupText.getText(), element);
        Constants.setConnections(this.connectionsText.getText(), element);
        Constants.setLoadbalance(this.loadbalanceText.getSelectedItem().toString(), element);
        Constants.setAsync(this.asyncText.getSelectedItem().toString(), element);
        Constants.setCluster(this.clusterText.getText(), element);
    }

    public void modifyInterface(TestElement element) {
        Constants.setInterfaceName(this.interfaceText.getText(), element);
        Constants.setMethod(this.methodText.getText(), element);
        Constants.setMethodArgs(this.getMethodArgsData(this.model.getDataVector()), element);
        Constants.setAttachmentArgs(this.getMethodArgsData(this.modelAttachment.getDataVector()), element);
    }

    public void clearRegistry() {
        this.registryProtocolText.setSelectedIndex(0);
        this.registryGroupText.setText("");
        this.registryUserNameText.setText("");
        this.registryPasswordText.setText("");
        this.addressText.setText("");
        this.registryTimeoutText.setText("");
    }

    public void clearConfigCenter() {
        this.configCenterProtocolText.setSelectedIndex(0);
        this.configCenterGroupText.setText("");
        this.configCenterNamespaceText.setText("");
        this.configCenterUserNameText.setText("");
        this.configCenterPasswordText.setText("");
        this.configCenterAddressText.setText("");
        this.configCenterTimeoutText.setText("");
    }

    public void clearProtocol() {
        this.rpcProtocolText.setSelectedIndex(0);
    }

    public void clearConsumer() {
        this.timeoutText.setText("1000");
        this.versionText.setText("1.0");
        this.retriesText.setText("0");
        this.clusterText.setText("failfast");
        this.groupText.setText("");
        this.connectionsText.setText("100");
        this.loadbalanceText.setSelectedIndex(0);
        this.asyncText.setSelectedIndex(0);
    }

    public void clearInterface() {
        this.interfaceText.setText("");
        this.methodText.setText("");
        this.model.setDataVector((Object[][])null, this.columnNames);
        this.modelAttachment.setDataVector((Object[][])null, this.columnNamesAttachment);
    }

    private List<MethodArgument> getMethodArgsData(Vector<Vector<String>> data) {
        ArrayList<MethodArgument> params = new ArrayList<MethodArgument>();
        if (!data.isEmpty()) {
            for (Vector<String> param : data) {
                if (param.isEmpty()) continue;
                params.add(new MethodArgument(param.get(0), param.get(1)));
            }
        }
        return params;
    }

    private Vector<Vector<String>> paserMethodArgsData(List<MethodArgument> list) {
        Vector<Vector<String>> res = new Vector<Vector<String>>();
        for (MethodArgument args : list) {
            Vector<String> v = new Vector<String>();
            v.add(args.getParamType());
            v.add(args.getParamValue());
            res.add(v);
        }
        return res;
    }

    private void doChange(String key) {
        String address = StringUtils.isBlank(Constants.DEFAULT_PANEL_ADDRESS) ? this.addressText.getText() : Constants.DEFAULT_PANEL_ADDRESS;
        ProviderService providerService = ProviderService.get(address);
        Map<String, URL> provider = providerService.findByService(key);
        if (provider != null && !provider.isEmpty()) {
            URL url = new ArrayList<URL>(provider.values()).get(0);
            String group = url.getParameter("group");
            String version = url.getParameter("version");
            String timeout = url.getParameter("timeout");
            String protocol = url.getProtocol() + "://";
            String interfaceName = url.getServiceInterface();
            String method = url.getParameter("methods");
            this.groupText.setText(group);
            this.versionText.setText(version);
            this.timeoutText.setText(timeout);
            this.rpcProtocolText.setSelectedItem(protocol);
            this.interfaceText.setText(interfaceName);
            String[] items = method.split(",");
            this.methodList.setModel(new DefaultComboBoxModel<String>(items));
        } else {
            this.methodList.setModel(new DefaultComboBoxModel<String>(new String[0]));
        }
    }

    private void doConfirm(ActionEvent event, JAutoCompleteComboBox<String> interfaceList, JPanel gridPanel) {
        String group;
        String protocol = StringUtils.isBlank(Constants.DEFAULT_PANEL_PROTOCOLS) ? this.registryProtocolText.getSelectedItem().toString() : Constants.DEFAULT_PANEL_PROTOCOLS;
        String address = StringUtils.isBlank(Constants.DEFAULT_PANEL_ADDRESS) ? this.addressText.getText() : Constants.DEFAULT_PANEL_ADDRESS;
        String string = group = StringUtils.isBlank(Constants.DEFAULT_PANEL_GROUP) ? this.registryGroupText.getText() : Constants.DEFAULT_PANEL_GROUP;
        if (StringUtils.isBlank(address)) {
            JOptionPane.showMessageDialog(gridPanel.getParent(), "Address can't be empty!", "error", 0);
            return;
        }
        int result = JOptionPane.showConfirmDialog(gridPanel.getParent(), "Obtaining all the providers lists may cause jmeter to stop responding for a few seconds. Do you want to continue?", "warn", 1);
        if (result == 0) {
            List<Object> list = new ArrayList();
            try {
                list = ProviderService.get(address).getProviders(protocol, address, group);
                JOptionPane.showMessageDialog(gridPanel.getParent(), "Get provider list to finish! Check if the log has errors.", "info", 1);
            }
            catch (Exception e) {
                JOptionPane.showMessageDialog(gridPanel.getParent(), e.getMessage(), "error", 0);
                return;
            }
            String[] items = list.toArray(new String[0]);
            interfaceList.setModel(new DefaultComboBoxModel<String>(items));
        }
    }

    public JLabel makeHelper(String tooltip) {
        JLabel helpLable = new JLabel();
        helpLable.setIcon(new ImageIcon(this.getClass().getResource("/images/help.png")));
        helpLable.setToolTipText(tooltip);
        return helpLable;
    }
}

