/*
 * Decompiled with CFR 0.152.
 */
package io.github.ningyu.jmeter.plugin.util;

import java.util.List;
import org.apache.curator.CuratorZookeeperClient;
import org.apache.curator.RetryPolicy;
import org.apache.curator.retry.RetryNTimes;
import org.apache.dubbo.common.URL;
import org.apache.dubbo.config.ReferenceConfig;
import org.apache.dubbo.config.utils.ConfigValidationUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class CheckUtils {
    private static final Logger log = LoggingManager.getLoggerForClass();

    public static void checkZookeeper(ReferenceConfig<?> reference) throws Exception {
        if (!"zookeeper".equals(reference.getRegistry().getProtocol())) {
            return;
        }
        log.info("check zookeeper connect");
        List urls = ConfigValidationUtils.loadRegistries(reference, (boolean)false);
        if (urls.size() > 0) {
            URL url = (URL)urls.get(0);
            try (CuratorZookeeperClient client = new CuratorZookeeperClient(url.getBackupAddress(), 60000, 60000, null, (RetryPolicy)new RetryNTimes(0, 1000));){
                client.start();
                if (!client.blockUntilConnectedOrTimedOut()) {
                    client.close();
                    log.error("zookeeper not connected");
                    throw new IllegalStateException("zookeeper not connected");
                }
            }
        }
    }
}

