/*
 * Decompiled with CFR 0.152.
 */
package io.github.ningyu.jmeter.plugin.util;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import io.github.ningyu.jmeter.plugin.util.ClassUtils;
import java.lang.reflect.Type;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class JsonUtils {
    private static final Logger logger = LoggingManager.getLoggerForClass();
    private static final Gson gson = new GsonBuilder().setDateFormat("yyyy-MM-dd HH:mm:ss").setPrettyPrinting().disableHtmlEscaping().serializeNulls().registerTypeAdapter(Locale.class, (json, typeOfT, context) -> ClassUtils.parseLocale(json.getAsJsonPrimitive().getAsString())).registerTypeAdapter(LocalDateTime.class, (json, typeOfT, context) -> LocalDateTime.parse(json.getAsJsonPrimitive().getAsString(), DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"))).registerTypeAdapter(LocalDate.class, (json, typeOfT, context) -> {
        LocalDateTime localDateTime = LocalDateTime.parse(json.getAsJsonPrimitive().getAsString(), DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        return localDateTime.toLocalDate();
    }).registerTypeAdapter(LocalTime.class, (json, typeOfT, context) -> {
        LocalDateTime localDateTime = LocalDateTime.parse(json.getAsJsonPrimitive().getAsString(), DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
        return localDateTime.toLocalTime();
    }).create();

    public static String toJson(Object obj) {
        return gson.toJson(obj);
    }

    public static String toJson(Object obj, Type type) {
        return gson.toJson(obj, type);
    }

    public static <T> T fromJson(String json, Class<T> classOfT) {
        try {
            return (T)gson.fromJson(json, classOfT);
        }
        catch (JsonSyntaxException e) {
            logger.error("json to class[" + classOfT.getName() + "] is error!", (Throwable)e);
            return null;
        }
    }

    public static <T> T fromJson(String json, Type type) {
        try {
            return (T)gson.fromJson(json, type);
        }
        catch (JsonSyntaxException e) {
            logger.error("json to class[" + type.getClass().getName() + "] is error!", (Throwable)e);
            return null;
        }
    }
}

